;;; elatin-rules.scm -- key sequence tables for elatin.scm

;; Copyright (c) 2003-2008 uim Project http://code.google.com/p/uim/
;;
;; All rights reserved.

;; The translation tables in this file were derived from
;; the emacs-lisp source files latin-pre.el, latin-post.el, latin-alt.el
;; included in GNU Emacs.  The following is the original copyright notice
;; therein, with the name GNU Emacs replaced by "this program".

;; Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
;;   2006, 2007
;;   Free Software Foundation, Inc.
;; Copyright (C) 1997, 1998, 1999, 2000, 2001, 2002, 2003, 2004, 2005,
;;   2006, 2007
;;   National Institute of Advanced Industrial Science and Technology (AIST)
;;   Registration Number H14PRO021

;; This program is free software; you can redistribute it and/or modify
;; it under the terms of the GNU General Public License as published by
;; the Free Software Foundation; either version 2, or (at your option)
;; any later version.

;; This program is distributed in the hope that it will be useful,
;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;; GNU General Public License for more details.

;; You should have received a copy of the GNU General Public License
;; along with this program.  If not, write to the
;; Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
;; Boston, MA 02110-1301, USA.

;;; Commentary:

;; Key translation maps were originally copied from iso-acc.el.
;; latin-1-prefix: extra special characters added, adapted from the vim
;;                 digraphs (from J.H.M.Dassen <jdassen@wi.leidenuniv.nl>)
;;                 by R.F. Smith <rsmith@xs4all.nl>
;;
;; polish-slash:
;; Author: Włodek Bzyl <matwb@univ.gda.pl>
;; Maintainer: Włodek Bzyl <matwb@univ.gda.pl>
;;
;; latin-[89]-prefix: Dave Love <fx@gnu.org>

(define elatin-rules-latin-1-prefix '(
((("'" "A")) ("Á"))
((("'" "E")) ("É"))
((("'" "I")) ("Í"))
((("'" "O")) ("Ó"))
((("'" "U")) ("Ú"))
((("'" "Y")) ("Ý"))
((("'" "a")) ("á"))
((("'" "e")) ("é"))
((("'" "i")) ("í"))
((("'" "o")) ("ó"))
((("'" "u")) ("ú"))
((("'" "y")) ("ý"))
((("'" "'")) ("´"))
((("'" " ")) ("'"))
((("`" "A")) ("À"))
((("`" "E")) ("È"))
((("`" "I")) ("Ì"))
((("`" "O")) ("Ò"))
((("`" "U")) ("Ù"))
((("`" "a")) ("à"))
((("`" "e")) ("è"))
((("`" "i")) ("ì"))
((("`" "o")) ("ò"))
((("`" "u")) ("ù"))
((("`" "`")) ("`"))
((("`" " ")) ("`"))
((("^" "A")) ("Â"))
((("^" "E")) ("Ê"))
((("^" "I")) ("Î"))
((("^" "O")) ("Ô"))
((("^" "U")) ("Û"))
((("^" "a")) ("â"))
((("^" "e")) ("ê"))
((("^" "i")) ("î"))
((("^" "o")) ("ô"))
((("^" "u")) ("û"))
((("^" "^")) ("^"))
((("^" " ")) ("^"))
((("\"" "A")) ("Ä"))
((("\"" "E")) ("Ë"))
((("\"" "I")) ("Ï"))
((("\"" "O")) ("Ö"))
((("\"" "U")) ("Ü"))
((("\"" "a")) ("ä"))
((("\"" "e")) ("ë"))
((("\"" "i")) ("ï"))
((("\"" "o")) ("ö"))
((("\"" "s")) ("ß"))
((("\"" "u")) ("ü"))
((("\"" "y")) ("ÿ"))
((("\"" "\"")) ("¨"))
((("\"" " ")) ("\""))
((("~" "A")) ("Ã"))
((("~" "C")) ("Ç"))
((("~" "D")) ("Ð"))
((("~" "N")) ("Ñ"))
((("~" "O")) ("Õ"))
((("~" "T")) ("Þ"))
((("~" "a")) ("ã"))
((("~" "c")) ("ç"))
((("~" "d")) ("ð"))
((("~" "n")) ("ñ"))
((("~" "o")) ("õ"))
((("~" "t")) ("þ"))
((("~" ">")) ("»"))
((("~" "<")) ("«"))
((("~" "!")) ("¡"))
((("~" "?")) ("¿"))
((("~" "~")) ("¸"))
((("~" " ")) ("~"))
((("/" "A")) ("Å"))
((("/" "E")) ("Æ"))
((("/" "O")) ("Ø"))
((("/" "a")) ("å"))
((("/" "e")) ("æ"))
((("/" "o")) ("ø"))
((("/" "/")) ("°"))
((("/" " ")) ("/"))
((("_" "o")) ("º"))
((("_" "a")) ("ª"))
((("_" " ")) (" "))
((("_" "+")) ("±"))
((("_" "y")) ("¥"))
((("_" ":")) ("÷"))
((("_" "_")) ("_"))
((("/" "c")) ("¢"))
((("/" "\\")) ("×"))
((("/" "2")) ("½"))
((("/" "4")) ("¼"))
((("/" "3")) ("¾"))
((("~" "s")) ("§"))
((("~" "p")) ("¶"))
((("~" "x")) ("¤"))
((("~" ".")) ("·"))
((("~" "$")) ("£"))
((("~" "u")) ("µ"))
((("^" "r")) ("®"))
((("^" "c")) ("©"))
((("^" "1")) ("¹"))
((("^" "2")) ("²"))
((("^" "3")) ("³"))
((("~" "-")) ("­"))
((("~" "|")) ("¦"))
((("/" "=")) ("¬"))
((("~" "=")) ("¯"))
))

(define elatin-rules-catalan-prefix '(
((("'" "A")) ("Á"))
((("'" "E")) ("É"))
((("'" "I")) ("Í"))
((("'" "O")) ("Ó"))
((("'" "U")) ("Ú"))
((("'" "a")) ("á"))
((("'" "e")) ("é"))
((("'" "i")) ("í"))
((("'" "o")) ("ó"))
((("'" "u")) ("ú"))
((("'" " ")) ("'"))
((("`" "A")) ("À"))
((("`" "E")) ("È"))
((("`" "O")) ("Ò"))
((("`" "a")) ("à"))
((("`" "e")) ("è"))
((("`" "o")) ("ò"))
((("`" " ")) ("`"))
((("\"" "I")) ("Ï"))
((("\"" "U")) ("Ü"))
((("\"" "i")) ("ï"))
((("\"" "u")) ("ü"))
((("\"" " ")) ("\""))
((("~" "C")) ("Ç"))
((("~" "N")) ("Ñ"))
((("~" "c")) ("ç"))
((("~" "n")) ("ñ"))
((("~" ">")) ("»"))
((("~" "<")) ("«"))
((("~" "!")) ("¡"))
((("~" "?")) ("¿"))
((("~" " ")) ("~"))
))

(define elatin-rules-esperanto-prefix '(
((("^" "H")) ("Ĥ"))
((("^" "J")) ("Ĵ"))
((("^" "h")) ("ĥ"))
((("^" "j")) ("ĵ"))
((("^" "C")) ("Ĉ"))
((("^" "G")) ("Ĝ"))
((("^" "S")) ("Ŝ"))
((("^" "c")) ("ĉ"))
((("^" "g")) ("ĝ"))
((("^" "s")) ("ŝ"))
((("^" "^")) ("^"))
((("^" " ")) ("^"))
((("~" "U")) ("Ŭ"))
((("~" "u")) ("ŭ"))
((("~" " ")) ("~"))
))

(define elatin-rules-french-prefix '(
((("'" "E")) ("É"))
((("'" "C")) ("Ç"))
((("'" "e")) ("é"))
((("'" "c")) ("ç"))
((("'" " ")) ("'"))
((("`" "A")) ("À"))
((("`" "E")) ("È"))
((("`" "U")) ("Ù"))
((("`" "a")) ("à"))
((("`" "e")) ("è"))
((("`" "u")) ("ù"))
((("`" " ")) ("`"))
((("^" "A")) ("Â"))
((("^" "E")) ("Ê"))
((("^" "I")) ("Î"))
((("^" "O")) ("Ô"))
((("^" "U")) ("Û"))
((("^" "a")) ("â"))
((("^" "e")) ("ê"))
((("^" "i")) ("î"))
((("^" "o")) ("ô"))
((("^" "u")) ("û"))
((("^" " ")) ("^"))
((("\"" "E")) ("Ë"))
((("\"" "I")) ("Ï"))
((("\"" "e")) ("ë"))
((("\"" "i")) ("ï"))
((("\"" " ")) ("\""))
((("~" "<")) ("«"))
((("~" ">")) ("»"))
((("~" "C")) ("Ç"))
((("~" "c")) ("ç"))
((("~" " ")) ("~"))
((("," "C")) ("Ç"))
((("," "c")) ("ç"))
((("," " ")) (","))
))

(define elatin-rules-romanian-prefix '(
((("~" "A")) ("Ă"))
((("~" "a")) ("ă"))
((("^" "A")) ("Â"))
((("^" "a")) ("â"))
((("^" "I")) ("Î"))
((("^" "i")) ("î"))
((("," "S")) ("Ş"))
((("," "s")) ("ş"))
((("," "T")) ("Ţ"))
((("," "t")) ("ţ"))
((("^" "^")) ("^"))
((("~" "~")) ("~"))
((("," ",")) (","))
))

(define elatin-rules-romanian-alt-prefix '(
((("'" "A")) ("Ă"))
((("'" "a")) ("ă"))
((("\"" "A")) ("Â"))
((("\"" "a")) ("â"))
((("'" "I")) ("Î"))
((("'" "i")) ("î"))
((("'" "S")) ("Ş"))
((("'" "s")) ("ş"))
((("'" "T")) ("Ţ"))
((("'" "t")) ("ţ"))
((("'" "'")) ("'"))
((("\"" "\"")) ("\""))
))

(define elatin-rules-german-prefix '(
((("\"" "A")) ("Ä"))
((("\"" "O")) ("Ö"))
((("\"" "U")) ("Ü"))
((("\"" "a")) ("ä"))
((("\"" "o")) ("ö"))
((("\"" "u")) ("ü"))
((("\"" "s")) ("ß"))
((("\"" " ")) ("\""))
))

(define elatin-rules-irish-prefix '(
((("'" "A")) ("Á"))
((("'" "E")) ("É"))
((("'" "I")) ("Í"))
((("'" "O")) ("Ó"))
((("'" "U")) ("Ú"))
((("'" "a")) ("á"))
((("'" "e")) ("é"))
((("'" "i")) ("í"))
((("'" "o")) ("ó"))
((("'" "u")) ("ú"))
((("'" " ")) ("'"))
))

(define elatin-rules-portuguese-prefix '(
((("'" "A")) ("Á"))
((("'" "E")) ("É"))
((("'" "I")) ("Í"))
((("'" "O")) ("Ó"))
((("'" "U")) ("Ú"))
((("'" "C")) ("Ç"))
((("'" "a")) ("á"))
((("'" "e")) ("é"))
((("'" "i")) ("í"))
((("'" "o")) ("ó"))
((("'" "u")) ("ú"))
((("'" "c")) ("ç"))
((("'" " ")) ("'"))
((("`" "A")) ("À"))
((("`" "a")) ("à"))
((("`" " ")) ("`"))
((("^" "A")) ("Â"))
((("^" "E")) ("Ê"))
((("^" "O")) ("Ô"))
((("^" "a")) ("â"))
((("^" "e")) ("ê"))
((("^" "o")) ("ô"))
((("^" " ")) ("^"))
((("\"" "U")) ("Ü"))
((("\"" "u")) ("ü"))
((("\"" " ")) ("\""))
((("~" "A")) ("Ã"))
((("~" "O")) ("Õ"))
((("~" "a")) ("ã"))
((("~" "o")) ("õ"))
((("~" " ")) ("~"))
((("," "c")) ("ç"))
((("," "C")) ("Ç"))
((("," ",")) (","))
))

(define elatin-rules-spanish-prefix '(
((("'" "A")) ("Á"))
((("'" "E")) ("É"))
((("'" "I")) ("Í"))
((("'" "O")) ("Ó"))
((("'" "U")) ("Ú"))
((("'" "a")) ("á"))
((("'" "e")) ("é"))
((("'" "i")) ("í"))
((("'" "o")) ("ó"))
((("'" "u")) ("ú"))
((("'" " ")) ("'"))
((("\"" "U")) ("Ü"))
((("\"" "u")) ("ü"))
((("\"" " ")) ("\""))
((("~" "N")) ("Ñ"))
((("~" "n")) ("ñ"))
((("~" ">")) ("»"))
((("~" "<")) ("«"))
((("~" "!")) ("¡"))
((("~" "?")) ("¿"))
((("~" " ")) ("~"))
))

(define elatin-rules-latin-2-prefix '(
((("'" "A")) ("Á"))
((("'" "C")) ("Ć"))
((("'" "D")) ("Đ"))
((("'" "E")) ("É"))
((("'" "I")) ("Í"))
((("'" "L")) ("Ĺ"))
((("'" "N")) ("Ń"))
((("'" "O")) ("Ó"))
((("'" "R")) ("Ŕ"))
((("'" "S")) ("Ś"))
((("'" "U")) ("Ú"))
((("'" "Y")) ("Ý"))
((("'" "Z")) ("Ź"))
((("'" "a")) ("á"))
((("'" "c")) ("ć"))
((("'" "d")) ("đ"))
((("'" "e")) ("é"))
((("'" "i")) ("í"))
((("'" "l")) ("ĺ"))
((("'" "n")) ("ń"))
((("'" "o")) ("ó"))
((("'" "r")) ("ŕ"))
((("'" "s")) ("ś"))
((("'" "u")) ("ú"))
((("'" "y")) ("ý"))
((("'" "z")) ("ź"))
((("'" "'")) ("´"))
((("'" " ")) ("'"))
((("`" "A")) ("Ą"))
((("`" "C")) ("Ç"))
((("`" "E")) ("Ę"))
((("`" "L")) ("Ł"))
((("`" "S")) ("Ş"))
((("`" "T")) ("Ţ"))
((("`" "Z")) ("Ż"))
((("`" "a")) ("ą"))
((("`" "l")) ("ł"))
((("`" "c")) ("ç"))
((("`" "e")) ("ę"))
((("`" "s")) ("ş"))
((("`" "t")) ("ţ"))
((("`" "z")) ("ż"))
((("`" "`")) ("Ş"))
((("`" ".")) ("˙"))
((("`" " ")) ("`"))
((("^" "A")) ("Â"))
((("^" "I")) ("Î"))
((("^" "O")) ("Ô"))
((("^" "a")) ("â"))
((("^" "i")) ("î"))
((("^" "o")) ("ô"))
((("^" "^")) ("^"))
((("^" " ")) ("^"))
((("\"" "A")) ("Ä"))
((("\"" "E")) ("Ë"))
((("\"" "O")) ("Ö"))
((("\"" "U")) ("Ü"))
((("\"" "a")) ("ä"))
((("\"" "e")) ("ë"))
((("\"" "o")) ("ö"))
((("\"" "s")) ("ß"))
((("\"" "u")) ("ü"))
((("\"" "\"")) ("¨"))
((("\"" " ")) ("\""))
((("~" "A")) ("Ă"))
((("~" "C")) ("Č"))
((("~" "D")) ("Ď"))
((("~" "E")) ("Ě"))
((("~" "L")) ("Ľ"))
((("~" "N")) ("Ň"))
((("~" "O")) ("Ő"))
((("~" "R")) ("Ř"))
((("~" "S")) ("Š"))
((("~" "T")) ("Ť"))
((("~" "U")) ("Ű"))
((("~" "Z")) ("Ž"))
((("~" "a")) ("ă"))
((("~" "c")) ("č"))
((("~" "d")) ("ď"))
((("~" "e")) ("ě"))
((("~" "l")) ("ľ"))
((("~" "n")) ("ň"))
((("~" "o")) ("ő"))
((("~" "r")) ("ř"))
((("~" "s")) ("š"))
((("~" "t")) ("ť"))
((("~" "u")) ("ű"))
((("~" "z")) ("ž"))
((("~" "v")) ("˘"))
((("~" "~")) ("˘"))
((("~" ".")) ("¸"))
((("~" " ")) ("~"))
))

(define elatin-rules-latin-3-prefix '(
((("'" "A")) ("Á"))
((("'" "E")) ("É"))
((("'" "I")) ("Í"))
((("'" "O")) ("Ó"))
((("'" "U")) ("Ú"))
((("'" "a")) ("á"))
((("'" "e")) ("é"))
((("'" "i")) ("í"))
((("'" "o")) ("ó"))
((("'" "u")) ("ú"))
((("'" "'")) ("´"))
((("'" " ")) ("'"))
((("`" "A")) ("À"))
((("`" "E")) ("È"))
((("`" "I")) ("Ì"))
((("`" "O")) ("Ò"))
((("`" "U")) ("Ù"))
((("`" "a")) ("à"))
((("`" "e")) ("è"))
((("`" "i")) ("ì"))
((("`" "o")) ("ò"))
((("`" "u")) ("ù"))
((("`" "`")) ("`"))
((("`" " ")) ("`"))
((("^" "A")) ("Â"))
((("^" "C")) ("Ĉ"))
((("^" "E")) ("Ê"))
((("^" "G")) ("Ĝ"))
((("^" "H")) ("Ĥ"))
((("^" "I")) ("Î"))
((("^" "J")) ("Ĵ"))
((("^" "O")) ("Ô"))
((("^" "S")) ("Ŝ"))
((("^" "U")) ("Û"))
((("^" "a")) ("â"))
((("^" "c")) ("ĉ"))
((("^" "e")) ("ê"))
((("^" "g")) ("ĝ"))
((("^" "h")) ("ĥ"))
((("^" "i")) ("î"))
((("^" "j")) ("ĵ"))
((("^" "o")) ("ô"))
((("^" "s")) ("ŝ"))
((("^" "u")) ("û"))
((("^" "^")) ("^"))
((("^" " ")) ("^"))
((("\"" "A")) ("Ä"))
((("\"" "E")) ("Ë"))
((("\"" "I")) ("Ï"))
((("\"" "O")) ("Ö"))
((("\"" "U")) ("Ü"))
((("\"" "a")) ("ä"))
((("\"" "e")) ("ë"))
((("\"" "i")) ("ï"))
((("\"" "o")) ("ö"))
((("\"" "u")) ("ü"))
((("\"" "s")) ("ß"))
((("\"" "\"")) ("¨"))
((("\"" " ")) ("\""))
((("~" "C")) ("Ç"))
((("~" "N")) ("Ñ"))
((("~" "c")) ("ç"))
((("~" "n")) ("ñ"))
((("~" "S")) ("Ş"))
((("~" "s")) ("ş"))
((("~" "G")) ("Ğ"))
((("~" "g")) ("ğ"))
((("~" "U")) ("Ŭ"))
((("~" "u")) ("ŭ"))
((("~" "`")) ("˘"))
((("~" "~")) ("¸"))
((("~" " ")) ("~"))
((("/" "C")) ("Ċ"))
((("/" "G")) ("Ġ"))
((("/" "H")) ("Ħ"))
((("/" "I")) ("İ"))
((("/" "Z")) ("Ż"))
((("/" "c")) ("ċ"))
((("/" "g")) ("ġ"))
((("/" "h")) ("ħ"))
((("/" "i")) ("ı"))
((("/" "z")) ("ż"))
((("/" ".")) ("˙"))
((("/" "#")) ("£"))
((("/" "$")) ("¤"))
((("/" "/")) ("°"))
((("/" " ")) ("/"))
((("." "C")) ("Ċ"))
((("." "G")) ("Ġ"))
((("." "I")) ("İ"))
((("." "Z")) ("Ż"))
((("." "c")) ("ċ"))
((("." "g")) ("ġ"))
((("." "z")) ("ż"))
))

(define elatin-rules-polish-slash '(
((("/" "/")) ("/"))
((("/" "a")) ("ą"))
((("/" "c")) ("ć"))
((("/" "e")) ("ę"))
((("/" "l")) ("ł"))
((("/" "n")) ("ń"))
((("/" "o")) ("ó"))
((("/" "s")) ("ś"))
((("/" "x")) ("ź"))
((("/" "z")) ("ż"))
((("/" "A")) ("Ą"))
((("/" "C")) ("Ć"))
((("/" "E")) ("Ę"))
((("/" "L")) ("Ł"))
((("/" "N")) ("Ń"))
((("/" "O")) ("Ó"))
((("/" "S")) ("Ś"))
((("/" "X")) ("Ź"))
((("/" "Z")) ("Ż"))
))

(define elatin-rules-latin-9-prefix '(
((("'" "A")) ("Á"))
((("'" "E")) ("É"))
((("'" "I")) ("Í"))
((("'" "O")) ("Ó"))
((("'" "U")) ("Ú"))
((("'" "Y")) ("Ý"))
((("'" "a")) ("á"))
((("'" "e")) ("é"))
((("'" "i")) ("í"))
((("'" "o")) ("ó"))
((("'" "u")) ("ú"))
((("'" "y")) ("ý"))
((("'" " ")) ("'"))
((("`" "A")) ("À"))
((("`" "E")) ("È"))
((("`" "I")) ("Ì"))
((("`" "O")) ("Ò"))
((("`" "U")) ("Ù"))
((("`" "a")) ("à"))
((("`" "e")) ("è"))
((("`" "i")) ("ì"))
((("`" "o")) ("ò"))
((("`" "u")) ("ù"))
((("`" "`")) ("`"))
((("`" " ")) ("`"))
((("^" "A")) ("Â"))
((("^" "E")) ("Ê"))
((("^" "I")) ("Î"))
((("^" "O")) ("Ô"))
((("^" "U")) ("Û"))
((("^" "a")) ("â"))
((("^" "e")) ("ê"))
((("^" "i")) ("î"))
((("^" "o")) ("ô"))
((("^" "u")) ("û"))
((("^" "^")) ("^"))
((("^" " ")) ("^"))
((("\"" "A")) ("Ä"))
((("\"" "E")) ("Ë"))
((("\"" "I")) ("Ï"))
((("\"" "O")) ("Ö"))
((("\"" "U")) ("Ü"))
((("\"" "a")) ("ä"))
((("\"" "e")) ("ë"))
((("\"" "i")) ("ï"))
((("\"" "o")) ("ö"))
((("\"" "s")) ("ß"))
((("\"" "u")) ("ü"))
((("\"" "y")) ("ÿ"))
((("\"" " ")) ("\""))
((("~" "A")) ("Ã"))
((("~" "C")) ("Ç"))
((("~" "D")) ("Ð"))
((("~" "N")) ("Ñ"))
((("~" "O")) ("Õ"))
((("~" "S")) ("Š"))
((("~" "T")) ("Þ"))
((("~" "Z")) ("Ž"))
((("~" "a")) ("ã"))
((("~" "c")) ("ç"))
((("~" "d")) ("ð"))
((("~" "n")) ("ñ"))
((("~" "o")) ("õ"))
((("~" "s")) ("š"))
((("~" "t")) ("þ"))
((("~" "z")) ("ž"))
((("~" ">")) ("»"))
((("~" "<")) ("«"))
((("~" "!")) ("¡"))
((("~" "?")) ("¿"))
((("~" " ")) ("~"))
((("/" "A")) ("Å"))
((("/" "E")) ("Æ"))
((("/" "O")) ("Ø"))
((("/" "a")) ("å"))
((("/" "e")) ("æ"))
((("/" "o")) ("ø"))
((("/" "/")) ("°"))
((("/" " ")) ("/"))
((("_" "o")) ("º"))
((("_" "a")) ("ª"))
((("_" "+")) ("±"))
((("_" "y")) ("¥"))
((("_" ":")) ("÷"))
((("_" " ")) (" "))
((("_" "_")) ("_"))
((("/" "c")) ("¢"))
((("/" "\\")) ("×"))
((("/" "o")) ("œ"))
((("/" "O")) ("Œ"))
((("\"" "Y")) ("Ÿ"))
((("~" "s")) ("§"))
((("~" "p")) ("¶"))
((("~" "e")) ("€"))
((("~" ".")) ("·"))
((("~" "$")) ("£"))
((("~" "u")) ("µ"))
((("^" "r")) ("®"))
((("^" "c")) ("©"))
((("^" "1")) ("¹"))
((("^" "2")) ("²"))
((("^" "3")) ("³"))
((("~" "-")) ("­"))
((("~" "=")) ("¯"))
((("/" "=")) ("¬"))
))

(define elatin-rules-latin-8-prefix '(
((("." "B")) ("Ḃ"))
((("." "b")) ("ḃ"))
((("." "c")) ("ċ"))
((("." "C")) ("Ċ"))
((("." "D")) ("Ḋ"))
((("." "d")) ("ḋ"))
((("." "f")) ("ḟ"))
((("." "F")) ("Ḟ"))
((("." "g")) ("ġ"))
((("." "G")) ("Ġ"))
((("." "m")) ("ṁ"))
((("." "M")) ("Ṁ"))
((("." "p")) ("ṗ"))
((("." "P")) ("Ṗ"))
((("." "s")) ("ṡ"))
((("." "S")) ("Ṡ"))
((("." "t")) ("ṫ"))
((("." "T")) ("Ṫ"))
((("'" "A")) ("Á"))
((("'" "E")) ("É"))
((("'" "I")) ("Í"))
((("'" "O")) ("Ó"))
((("'" "U")) ("Ú"))
((("'" "Y")) ("Ý"))
((("'" "W")) ("Ẃ"))
((("'" "a")) ("á"))
((("'" "e")) ("é"))
((("'" "i")) ("í"))
((("'" "o")) ("ó"))
((("'" "u")) ("ú"))
((("'" "w")) ("ẃ"))
((("'" "y")) ("ý"))
((("'" " ")) ("'"))
((("`" "A")) ("À"))
((("`" "E")) ("È"))
((("`" "I")) ("Ì"))
((("`" "O")) ("Ò"))
((("`" "U")) ("Ù"))
((("`" "W")) ("Ẁ"))
((("`" "Y")) ("Ỳ"))
((("`" "a")) ("à"))
((("`" "e")) ("è"))
((("`" "i")) ("ì"))
((("`" "o")) ("ò"))
((("`" "u")) ("ù"))
((("`" "w")) ("ẁ"))
((("`" "y")) ("ỳ"))
((("`" "`")) ("`"))
((("`" " ")) ("`"))
((("^" "A")) ("Â"))
((("^" "E")) ("Ê"))
((("^" "I")) ("Î"))
((("^" "O")) ("Ô"))
((("^" "U")) ("Û"))
((("^" "a")) ("â"))
((("^" "e")) ("ê"))
((("^" "i")) ("î"))
((("^" "o")) ("ô"))
((("^" "u")) ("û"))
((("^" "w")) ("ŵ"))
((("^" "W")) ("Ŵ"))
((("^" "y")) ("ŷ"))
((("^" "Y")) ("Ŷ"))
((("^" "^")) ("^"))
((("^" " ")) ("^"))
((("\"" "A")) ("Ä"))
((("\"" "E")) ("Ë"))
((("\"" "I")) ("Ï"))
((("\"" "O")) ("Ö"))
((("\"" "U")) ("Ü"))
((("\"" "a")) ("ä"))
((("\"" "e")) ("ë"))
((("\"" "i")) ("ï"))
((("\"" "o")) ("ö"))
((("\"" "s")) ("ß"))
((("\"" "u")) ("ü"))
((("\"" "w")) ("ẅ"))
((("\"" "W")) ("Ẅ"))
((("\"" "y")) ("ÿ"))
((("\"" "Y")) ("Ÿ"))
((("\"" " ")) ("\""))
((("~" "A")) ("Ã"))
((("~" "C")) ("Ç"))
((("~" "N")) ("Ñ"))
((("~" "O")) ("Õ"))
((("~" "a")) ("ã"))
((("~" "c")) ("ç"))
((("~" "n")) ("ñ"))
((("~" "o")) ("õ"))
((("~" " ")) ("~"))
((("/" "A")) ("Å"))
((("/" "E")) ("Æ"))
((("/" "O")) ("Ø"))
((("/" "a")) ("å"))
((("/" "e")) ("æ"))
((("/" "o")) ("ø"))
((("/" " ")) ("/"))
((("~" "p")) ("¶"))
((("~" "s")) ("§"))
((("~" "$")) ("£"))
((("^" "r")) ("®"))
((("^" "c")) ("©"))
))

(define elatin-rules-latin-prefix '(
((("'" " ")) ("'"))
((("'" "'")) ("´"))
((("'" "A")) ("Á"))
((("'" "E")) ("É"))
((("'" "I")) ("Í"))
((("'" "O")) ("Ó"))
((("'" "U")) ("Ú"))
((("'" "W")) ("Ẃ"))
((("'" "Y")) ("Ý"))
((("'" "a")) ("á"))
((("'" "e")) ("é"))
((("'" "i")) ("í"))
((("'" "o")) ("ó"))
((("'" "u")) ("ú"))
((("'" "w")) ("ẃ"))
((("'" "y")) ("ý"))
((("." "B")) ("Ḃ"))
((("." "C")) ("Ċ"))
((("." "D")) ("Ḋ"))
((("." "F")) ("Ḟ"))
((("." "G")) ("Ġ"))
((("." "I")) ("İ"))
((("." "M")) ("Ṁ"))
((("." "P")) ("Ṗ"))
((("." "S")) ("Ṡ"))
((("." "T")) ("Ṫ"))
((("." "Z")) ("Ż"))
((("." "b")) ("ḃ"))
((("." "c")) ("ċ"))
((("." "d")) ("ḋ"))
((("." "f")) ("ḟ"))
((("." "g")) ("ġ"))
((("." "m")) ("ṁ"))
((("." "p")) ("ṗ"))
((("." "s")) ("ṡ"))
((("." "t")) ("ṫ"))
((("." "z")) ("ż"))
((("/" " ")) ("/"))
((("/" "#")) ("£"))
((("/" "$")) ("¤"))
((("/" ".")) ("˙"))
((("/" "/")) ("°"))
((("/" "2")) ("½"))
((("/" "3")) ("¾"))
((("/" "4")) ("¼"))
((("/" "=")) ("¬"))
((("/" "A")) ("Å"))
((("/" "C")) ("Ċ"))
((("/" "E")) ("Æ"))
((("/" "G")) ("Ġ"))
((("/" "H")) ("Ħ"))
((("/" "I")) ("İ"))
((("/" "O")) ("Ø"))
((("/" "O")) ("Œ"))
((("/" "Z")) ("Ż"))
((("/" "\\")) ("×"))
((("/" "a")) ("å"))
((("/" "c")) ("¢"))
((("/" "c")) ("ċ"))
((("/" "e")) ("æ"))
((("/" "g")) ("ġ"))
((("/" "h")) ("ħ"))
((("/" "i")) ("ı"))
((("/" "o")) ("ø"))
((("/" "o")) ("œ"))
((("/" "z")) ("ż"))
((("\"" " ")) ("\""))
((("\"" "A")) ("Ä"))
((("\"" "E")) ("Ë"))
((("\"" "I")) ("Ï"))
((("\"" "O")) ("Ö"))
((("\"" "U")) ("Ü"))
((("\"" "W")) ("Ẅ"))
((("\"" "Y")) ("Ÿ"))
((("\"" "\"")) ("¨"))
((("\"" "a")) ("ä"))
((("\"" "e")) ("ë"))
((("\"" "i")) ("ï"))
((("\"" "o")) ("ö"))
((("\"" "s")) ("ß"))
((("\"" "u")) ("ü"))
((("\"" "w")) ("ẅ"))
((("\"" "y")) ("ÿ"))
((("^" " ")) ("^"))
((("^" "1")) ("¹"))
((("^" "2")) ("²"))
((("^" "3")) ("³"))
((("^" "A")) ("Â"))
((("^" "C")) ("Ĉ"))
((("^" "E")) ("Ê"))
((("^" "G")) ("Ĝ"))
((("^" "H")) ("Ĥ"))
((("^" "I")) ("Î"))
((("^" "J")) ("Ĵ"))
((("^" "O")) ("Ô"))
((("^" "S")) ("Ŝ"))
((("^" "U")) ("Û"))
((("^" "W")) ("Ŵ"))
((("^" "Y")) ("Ŷ"))
((("^" "^")) ("^"))
((("^" "a")) ("â"))
((("^" "c")) ("©"))
((("^" "c")) ("ĉ"))
((("^" "e")) ("ê"))
((("^" "g")) ("ĝ"))
((("^" "h")) ("ĥ"))
((("^" "i")) ("î"))
((("^" "j")) ("ĵ"))
((("^" "o")) ("ô"))
((("^" "r")) ("®"))
((("^" "s")) ("ŝ"))
((("^" "u")) ("û"))
((("^" "w")) ("ŵ"))
((("^" "y")) ("ŷ"))
((("_" "+")) ("±"))
((("_" ":")) ("÷"))
((("_" "a")) ("ª"))
((("_" "o")) ("º"))
((("_" "y")) ("¥"))
((("_" " ")) (" "))
((("`" " ")) ("`"))
((("`" "A")) ("À"))
((("`" "E")) ("È"))
((("`" "I")) ("Ì"))
((("`" "O")) ("Ò"))
((("`" "U")) ("Ù"))
((("`" "W")) ("Ẁ"))
((("`" "Y")) ("Ỳ"))
((("`" "`")) ("`"))
((("`" "a")) ("à"))
((("`" "e")) ("è"))
((("`" "i")) ("ì"))
((("`" "o")) ("ò"))
((("`" "u")) ("ù"))
((("`" "w")) ("ẁ"))
((("`" "y")) ("ỳ"))
((("~" " ")) ("~"))
((("~" "!")) ("¡"))
((("~" "$")) ("£"))
((("~" "-")) ("­"))
((("~" ".")) ("·"))
((("~" "<")) ("«"))
((("~" "=")) ("¯"))
((("~" ">")) ("»"))
((("~" "?")) ("¿"))
((("~" "A")) ("Ã"))
((("~" "C")) ("Ç"))
((("~" "D")) ("Ð"))
((("~" "G")) ("Ğ"))
((("~" "N")) ("Ñ"))
((("~" "O")) ("Õ"))
((("~" "O")) ("Ġ"))
((("~" "S")) ("Ş"))
((("~" "S")) ("Š"))
((("~" "T")) ("Þ"))
((("~" "U")) ("Ŭ"))
((("~" "Z")) ("Ž"))
((("~" "`")) ("˘"))
((("~" "a")) ("ã"))
((("~" "c")) ("ç"))
((("~" "d")) ("ð"))
((("~" "e")) ("€"))
((("~" "g")) ("ğ"))
((("~" "n")) ("ñ"))
((("~" "o")) ("õ"))
((("~" "o")) ("ġ"))
((("~" "p")) ("¶"))
((("~" "s")) ("§"))
((("~" "s")) ("ş"))
((("~" "s")) ("š"))
((("~" "t")) ("þ"))
((("~" "u")) ("µ"))
((("~" "u")) ("ŭ"))
((("~" "x")) ("¤"))
((("~" "z")) ("ž"))
((("~" "|")) ("¦"))
((("~" "~")) ("¸"))
))

(define elatin-rules-latin-1-postfix '(
((("A" "`")) ("À"))
((("A" "'")) ("Á"))
((("A" "^")) ("Â"))
((("A" "~")) ("Ã"))
((("A" "\"")) ("Ä"))
((("A" "/")) ("Å"))
((("a" "`")) ("à"))
((("a" "'")) ("á"))
((("a" "^")) ("â"))
((("a" "~")) ("ã"))
((("a" "\"")) ("ä"))
((("a" "/")) ("å"))
((("E" "`")) ("È"))
((("E" "'")) ("É"))
((("E" "^")) ("Ê"))
((("E" "\"")) ("Ë"))
((("E" "/")) ("Æ"))
((("e" "`")) ("è"))
((("e" "'")) ("é"))
((("e" "^")) ("ê"))
((("e" "\"")) ("ë"))
((("e" "/")) ("æ"))
((("I" "`")) ("Ì"))
((("i" "`")) ("ì"))
((("I" "'")) ("Í"))
((("i" "'")) ("í"))
((("I" "^")) ("Î"))
((("i" "^")) ("î"))
((("I" "\"")) ("Ï"))
((("i" "\"")) ("ï"))
((("O" "`")) ("Ò"))
((("o" "`")) ("ò"))
((("O" "'")) ("Ó"))
((("o" "'")) ("ó"))
((("O" "^")) ("Ô"))
((("o" "^")) ("ô"))
((("O" "~")) ("Õ"))
((("o" "~")) ("õ"))
((("O" "\"")) ("Ö"))
((("o" "\"")) ("ö"))
((("O" "/")) ("Ø"))
((("o" "/")) ("ø"))
((("U" "`")) ("Ù"))
((("u" "`")) ("ù"))
((("U" "'")) ("Ú"))
((("u" "'")) ("ú"))
((("U" "^")) ("Û"))
((("u" "^")) ("û"))
((("U" "\"")) ("Ü"))
((("u" "\"")) ("ü"))
((("Y" "'")) ("Ý"))
((("y" "'")) ("ý"))
((("y" "\"")) ("ÿ"))
((("D" "/")) ("Ð"))
((("d" "/")) ("ð"))
((("T" "/")) ("Þ"))
((("t" "/")) ("þ"))
((("s" "/")) ("ß"))
((("C" ",")) ("Ç"))
((("c" ",")) ("ç"))
((("N" "~")) ("Ñ"))
((("n" "~")) ("ñ"))
((("?" "/")) ("¿"))
((("!" "/")) ("¡"))
((("<" "<")) ("«"))
(((">" ">")) ("»"))
((("o" "_")) ("º"))
((("a" "_")) ("ª"))
((("/" "/")) ("°"))
((("A" "`" "`")) ("A`"))
((("A" "'" "'")) ("A'"))
((("A" "^" "^")) ("A^"))
((("A" "~" "~")) ("A~"))
((("A" "\"" "\"")) ("A\""))
((("A" "/" "/")) ("A/"))
((("a" "`" "`")) ("a`"))
((("a" "'" "'")) ("a'"))
((("a" "^" "^")) ("a^"))
((("a" "~" "~")) ("a~"))
((("a" "\"" "\"")) ("a\""))
((("a" "/" "/")) ("a/"))
((("E" "`" "`")) ("E`"))
((("E" "'" "'")) ("E'"))
((("E" "^" "^")) ("E^"))
((("E" "\"" "\"")) ("E\""))
((("E" "/" "/")) ("E/"))
((("e" "`" "`")) ("e`"))
((("e" "'" "'")) ("e'"))
((("e" "^" "^")) ("e^"))
((("e" "\"" "\"")) ("e\""))
((("e" "/" "/")) ("e/"))
((("I" "`" "`")) ("I`"))
((("i" "`" "`")) ("i`"))
((("I" "'" "'")) ("I'"))
((("i" "'" "'")) ("i'"))
((("I" "^" "^")) ("I^"))
((("i" "^" "^")) ("i^"))
((("I" "\"" "\"")) ("I\""))
((("i" "\"" "\"")) ("i\""))
((("O" "`" "`")) ("O`"))
((("o" "`" "`")) ("o`"))
((("O" "'" "'")) ("O'"))
((("o" "'" "'")) ("o'"))
((("O" "^" "^")) ("O^"))
((("o" "^" "^")) ("o^"))
((("O" "~" "~")) ("O~"))
((("o" "~" "~")) ("o~"))
((("O" "\"" "\"")) ("O\""))
((("o" "\"" "\"")) ("o\""))
((("O" "/" "/")) ("O/"))
((("o" "/" "/")) ("o/"))
((("U" "`" "`")) ("U`"))
((("u" "`" "`")) ("u`"))
((("U" "'" "'")) ("U'"))
((("u" "'" "'")) ("u'"))
((("U" "^" "^")) ("U^"))
((("u" "^" "^")) ("u^"))
((("U" "\"" "\"")) ("U\""))
((("u" "\"" "\"")) ("u\""))
((("Y" "'" "'")) ("Y'"))
((("y" "'" "'")) ("y'"))
((("y" "\"" "\"")) ("y\""))
((("D" "/" "/")) ("D/"))
((("d" "/" "/")) ("d/"))
((("T" "/" "/")) ("T/"))
((("t" "/" "/")) ("t/"))
((("s" "/" "/")) ("s/"))
((("C" "," ",")) ("C,"))
((("c" "," ",")) ("c,"))
((("N" "~" "~")) ("N~"))
((("n" "~" "~")) ("n~"))
((("?" "/" "/")) ("?/"))
((("!" "/" "/")) ("!/"))
((("<" "<" "<")) ("<<"))
(((">" ">" ">")) (">>"))
((("o" "_" "_")) ("o_"))
((("a" "_" "_")) ("a_"))
((("/" "/" "/")) ("//"))
))

(define elatin-rules-latin-2-postfix '(
((("A" "'")) ("Á"))
((("A" ",")) ("Ą"))
((("A" "\"")) ("Ä"))
((("A" "^")) ("Â"))
((("A" "~")) ("Ă"))
((("C" "'")) ("Ć"))
((("C" ",")) ("Ç"))
((("C" "~")) ("Č"))
((("D" "/")) ("Đ"))
((("D" "~")) ("Ď"))
((("E" "'")) ("É"))
((("E" ",")) ("Ę"))
((("E" "\"")) ("Ë"))
((("E" "~")) ("Ě"))
((("I" "'")) ("Í"))
((("I" "^")) ("Î"))
((("L" "'")) ("Ĺ"))
((("L" "/")) ("Ł"))
((("L" "~")) ("Ľ"))
((("N" "'")) ("Ń"))
((("N" "~")) ("Ň"))
((("O" "'")) ("Ó"))
((("O" ":")) ("Ő"))
((("O" "\"")) ("Ö"))
((("O" "^")) ("Ô"))
((("R" "'")) ("Ŕ"))
((("R" "~")) ("Ř"))
((("S" "'")) ("Ś"))
((("S" ",")) ("Ş"))
((("S" "~")) ("Š"))
((("T" ",")) ("Ţ"))
((("T" "~")) ("Ť"))
((("U" "'")) ("Ú"))
((("U" ":")) ("Ű"))
((("U" "\"")) ("Ü"))
((("U" ".")) ("Ů"))
((("Y" "'")) ("Ý"))
((("Z" "'")) ("Ź"))
((("Z" ".")) ("Ż"))
((("Z" "~")) ("Ž"))
((("a" "'")) ("á"))
((("a" ",")) ("ą"))
((("a" "\"")) ("ä"))
((("a" "^")) ("â"))
((("a" "~")) ("ă"))
((("c" "'")) ("ć"))
((("c" ",")) ("ç"))
((("c" "~")) ("č"))
((("d" "/")) ("đ"))
((("d" "~")) ("ď"))
((("e" "'")) ("é"))
((("e" ",")) ("ę"))
((("e" "\"")) ("ë"))
((("e" "~")) ("ě"))
((("i" "'")) ("í"))
((("i" "^")) ("î"))
((("l" "'")) ("ĺ"))
((("l" "/")) ("ł"))
((("l" "~")) ("ľ"))
((("n" "'")) ("ń"))
((("n" "~")) ("ň"))
((("o" "'")) ("ó"))
((("o" ":")) ("ő"))
((("o" "\"")) ("ö"))
((("o" "^")) ("ô"))
((("r" "'")) ("ŕ"))
((("r" "~")) ("ř"))
((("s" "'")) ("ś"))
((("s" ",")) ("ş"))
((("s" "/")) ("ß"))
((("s" "~")) ("š"))
((("t" ",")) ("ţ"))
((("t" "~")) ("ť"))
((("u" "'")) ("ú"))
((("u" ":")) ("ű"))
((("u" "\"")) ("ü"))
((("u" ".")) ("ů"))
((("y" "'")) ("ý"))
((("z" "'")) ("ź"))
((("z" ".")) ("ż"))
((("z" "~")) ("ž"))
((("A" "'" "'")) ("A'"))
((("A" "," ",")) ("A,"))
((("A" "\"" "\"")) ("A\""))
((("A" "^" "^")) ("A^"))
((("A" "~" "~")) ("A~"))
((("C" "'" "'")) ("C'"))
((("C" "," ",")) ("C,"))
((("C" "~" "~")) ("C~"))
((("D" "/" "/")) ("D/"))
((("D" "~" "~")) ("D~"))
((("E" "'" "'")) ("E'"))
((("E" "," ",")) ("E,"))
((("E" "\"" "\"")) ("E\""))
((("E" "~" "~")) ("E~"))
((("I" "'" "'")) ("I'"))
((("I" "^" "^")) ("I^"))
((("L" "'" "'")) ("L'"))
((("L" "/" "/")) ("L/"))
((("L" "~" "~")) ("L~"))
((("N" "'" "'")) ("N'"))
((("N" "~" "~")) ("N~"))
((("O" "'" "'")) ("O'"))
((("O" ":" ":")) ("O:"))
((("O" "\"" "\"")) ("O\""))
((("O" "^" "^")) ("O^"))
((("R" "'" "'")) ("R'"))
((("R" "~" "~")) ("R~"))
((("S" "'" "'")) ("S'"))
((("S" "," ",")) ("S,"))
((("S" "~" "~")) ("S~"))
((("T" "," ",")) ("T,"))
((("T" "~" "~")) ("T~"))
((("U" "'" "'")) ("U'"))
((("U" ":" ":")) ("U:"))
((("U" "\"" "\"")) ("U\""))
((("U" "." ".")) ("U."))
((("Y" "'" "'")) ("Y'"))
((("Z" "'" "'")) ("Z'"))
((("Z" "." ".")) ("Z."))
((("Z" "~" "~")) ("Z~"))
((("a" "'" "'")) ("a'"))
((("a" "," ",")) ("a,"))
((("a" "\"" "\"")) ("a\""))
((("a" "^" "^")) ("a^"))
((("a" "~" "~")) ("a~"))
((("c" "'" "'")) ("c'"))
((("c" "," ",")) ("c,"))
((("c" "~" "~")) ("c~"))
((("d" "/" "/")) ("d/"))
((("d" "~" "~")) ("d~"))
((("e" "'" "'")) ("e'"))
((("e" "," ",")) ("e,"))
((("e" "\"" "\"")) ("e\""))
((("e" "~" "~")) ("e~"))
((("i" "'" "'")) ("i'"))
((("i" "^" "^")) ("i^"))
((("l" "'" "'")) ("l'"))
((("l" "/" "/")) ("l/"))
((("l" "~" "~")) ("l~"))
((("n" "'" "'")) ("n'"))
((("n" "~" "~")) ("n~"))
((("o" "'" "'")) ("o'"))
((("o" ":" ":")) ("o:"))
((("o" "\"" "\"")) ("o\""))
((("o" "^" "^")) ("o^"))
((("r" "'" "'")) ("r'"))
((("r" "~" "~")) ("r~"))
((("s" "'" "'")) ("s'"))
((("s" "," ",")) ("s,"))
((("s" "/" "/")) ("s/"))
((("s" "~" "~")) ("s~"))
((("t" "," ",")) ("t,"))
((("t" "~" "~")) ("t~"))
((("u" "'" "'")) ("u'"))
((("u" ":" ":")) ("u:"))
((("u" "\"" "\"")) ("u\""))
((("u" "." ".")) ("u."))
((("y" "'" "'")) ("y'"))
((("z" "'" "'")) ("z'"))
((("z" "." ".")) ("z."))
((("z" "~" "~")) ("z~"))
))

(define elatin-rules-latin-3-postfix '(
((("A" "`")) ("À"))
((("A" "'")) ("Á"))
((("A" "^")) ("Â"))
((("A" "\"")) ("Ä"))
((("C" ".")) ("Ċ"))
((("C" "^")) ("Ĉ"))
((("C" ",")) ("Ç"))
((("E" "`")) ("È"))
((("E" "'")) ("É"))
((("E" "^")) ("Ê"))
((("E" "\"")) ("Ë"))
((("G" "~")) ("Ğ"))
((("G" ".")) ("Ġ"))
((("G" "^")) ("Ĝ"))
((("H" "/")) ("Ħ"))
((("H" "^")) ("Ĥ"))
((("I" ".")) ("İ"))
((("I" "`")) ("Ì"))
((("I" "'")) ("Í"))
((("I" "^")) ("Î"))
((("I" "\"")) ("Ï"))
((("J" "^")) ("Ĵ"))
((("N" "~")) ("Ñ"))
((("O" "`")) ("Ò"))
((("O" "'")) ("Ó"))
((("O" "^")) ("Ô"))
((("O" "\"")) ("Ö"))
((("S" ",")) ("Ş"))
((("S" "^")) ("Ŝ"))
((("U" "`")) ("Ù"))
((("U" "'")) ("Ú"))
((("U" "^")) ("Û"))
((("U" "\"")) ("Ü"))
((("U" "~")) ("Ŭ"))
((("Z" ".")) ("Ż"))
((("a" "`")) ("à"))
((("a" "'")) ("á"))
((("a" "^")) ("â"))
((("a" "\"")) ("ä"))
((("c" ".")) ("ċ"))
((("c" "^")) ("ĉ"))
((("c" ",")) ("ç"))
((("e" "`")) ("è"))
((("e" "'")) ("é"))
((("e" "^")) ("ê"))
((("e" "\"")) ("ë"))
((("g" "~")) ("ğ"))
((("g" ".")) ("ġ"))
((("g" "^")) ("ĝ"))
((("h" "/")) ("ħ"))
((("h" "^")) ("ĥ"))
((("i" ".")) ("ı"))
((("i" "`")) ("ì"))
((("i" "'")) ("í"))
((("i" "^")) ("î"))
((("i" "\"")) ("ï"))
((("j" "^")) ("ĵ"))
((("n" "~")) ("ñ"))
((("o" "`")) ("ò"))
((("o" "'")) ("ó"))
((("o" "^")) ("ô"))
((("o" "\"")) ("ö"))
((("s" ",")) ("ş"))
((("s" "/")) ("ß"))
((("s" "^")) ("ŝ"))
((("u" "`")) ("ù"))
((("u" "'")) ("ú"))
((("u" "^")) ("û"))
((("u" "\"")) ("ü"))
((("u" "~")) ("ŭ"))
((("z" ".")) ("ż"))
((("A" "`" "`")) ("A`"))
((("A" "'" "'")) ("A'"))
((("A" "^" "^")) ("A^"))
((("A" "\"" "\"")) ("A\""))
((("C" "." ".")) ("C."))
((("C" "^" "^")) ("C^"))
((("C" "," ",")) ("C,"))
((("E" "`" "`")) ("E`"))
((("E" "'" "'")) ("E'"))
((("E" "^" "^")) ("E^"))
((("E" "\"" "\"")) ("E\""))
((("G" "~" "~")) ("G~"))
((("G" "." ".")) ("G."))
((("G" "^" "^")) ("G^"))
((("H" "/" "/")) ("H/"))
((("H" "^" "^")) ("H^"))
((("I" "." ".")) ("I."))
((("I" "`" "`")) ("I`"))
((("I" "'" "'")) ("I'"))
((("I" "^" "^")) ("I^"))
((("I" "\"" "\"")) ("I\""))
((("J" "^" "^")) ("J^"))
((("N" "~" "~")) ("N~"))
((("O" "`" "`")) ("O`"))
((("O" "'" "'")) ("O'"))
((("O" "^" "^")) ("O^"))
((("O" "\"" "\"")) ("O\""))
((("S" "," ",")) ("S,"))
((("S" "^" "^")) ("S^"))
((("U" "`" "`")) ("U`"))
((("U" "'" "'")) ("U'"))
((("U" "^" "^")) ("U^"))
((("U" "\"" "\"")) ("U\""))
((("U" "~" "~")) ("U~"))
((("Z" "." ".")) ("Z."))
((("a" "`" "`")) ("a`"))
((("a" "'" "'")) ("a'"))
((("a" "^" "^")) ("a^"))
((("a" "\"" "\"")) ("a\""))
((("c" "." ".")) ("c."))
((("c" "^" "^")) ("c^"))
((("c" "," ",")) ("c,"))
((("e" "`" "`")) ("e`"))
((("e" "'" "'")) ("e'"))
((("e" "^" "^")) ("e^"))
((("e" "\"" "\"")) ("e\""))
((("g" "~" "~")) ("g~"))
((("g" "." ".")) ("g."))
((("g" "^" "^")) ("g^"))
((("h" "/" "/")) ("h/"))
((("h" "^" "^")) ("h^"))
((("i" "." ".")) ("i."))
((("i" "`" "`")) ("i`"))
((("i" "'" "'")) ("i'"))
((("i" "^" "^")) ("i^"))
((("i" "\"" "\"")) ("i\""))
((("j" "^" "^")) ("j^"))
((("n" "~" "~")) ("n~"))
((("o" "`" "`")) ("o`"))
((("o" "'" "'")) ("o'"))
((("o" "^" "^")) ("o^"))
((("o" "\"" "\"")) ("o\""))
((("s" "," ",")) ("s,"))
((("s" "/" "/")) ("s/"))
((("s" "^" "^")) ("s^"))
((("u" "`" "`")) ("u`"))
((("u" "'" "'")) ("u'"))
((("u" "^" "^")) ("u^"))
((("u" "\"" "\"")) ("u\""))
((("u" "~" "~")) ("u~"))
((("z" "." ".")) ("z."))
))

(define elatin-rules-latin-4-postfix '(
((("A" ",")) ("Ą"))
((("A" "-")) ("Ā"))
((("A" "'")) ("Á"))
((("A" "^")) ("Â"))
((("A" "~")) ("Ã"))
((("A" "\"")) ("Ä"))
((("A" "/")) ("Å"))
((("C" "~")) ("Č"))
((("D" "/")) ("Đ"))
((("E" "/")) ("Æ"))
((("E" "-")) ("Ē"))
((("E" "'")) ("É"))
((("E" ",")) ("Ę"))
((("E" "\"")) ("Ë"))
((("E" ".")) ("Ė"))
((("G" ",")) ("Ģ"))
((("I" "~")) ("Ĩ"))
((("I" ",")) ("Į"))
((("I" "'")) ("Í"))
((("I" "^")) ("Î"))
((("I" "-")) ("Ī"))
((("K" ",")) ("Ķ"))
((("L" ",")) ("Ļ"))
((("N" "/")) ("Ŋ"))
((("N" ",")) ("Ņ"))
((("O" "-")) ("Ō"))
((("O" "^")) ("Ô"))
((("O" "~")) ("Õ"))
((("O" "\"")) ("Ö"))
((("O" "/")) ("Ø"))
((("R" ",")) ("Ŗ"))
((("S" "~")) ("Š"))
((("T" "/")) ("Ŧ"))
((("U" ",")) ("Ų"))
((("U" "'")) ("Ú"))
((("U" "^")) ("Û"))
((("U" "\"")) ("Ü"))
((("U" "~")) ("Ũ"))
((("U" "-")) ("Ū"))
((("Z" "~")) ("Ž"))
((("a" ",")) ("ą"))
((("a" "-")) ("ā"))
((("a" "'")) ("á"))
((("a" "^")) ("â"))
((("a" "~")) ("ã"))
((("a" "\"")) ("ä"))
((("a" "/")) ("å"))
((("c" "~")) ("č"))
((("d" "/")) ("đ"))
((("e" "/")) ("æ"))
((("e" "-")) ("ē"))
((("e" "'")) ("é"))
((("e" ",")) ("ę"))
((("e" "\"")) ("ë"))
((("e" ".")) ("ė"))
((("g" ",")) ("ģ"))
((("i" "~")) ("ĩ"))
((("i" ",")) ("į"))
((("i" "'")) ("í"))
((("i" "^")) ("î"))
((("i" "-")) ("ī"))
((("k" "/")) ("ĸ"))
((("k" ",")) ("ķ"))
((("l" ",")) ("ļ"))
((("n" "/")) ("ŋ"))
((("n" ",")) ("ņ"))
((("o" "-")) ("ō"))
((("o" "^")) ("ô"))
((("o" "~")) ("õ"))
((("o" "\"")) ("ö"))
((("o" "/")) ("ø"))
((("r" ",")) ("ŗ"))
((("s" "/")) ("ß"))
((("s" "~")) ("š"))
((("t" "/")) ("ŧ"))
((("u" ",")) ("ų"))
((("u" "'")) ("ú"))
((("u" "^")) ("û"))
((("u" "\"")) ("ü"))
((("u" "~")) ("ũ"))
((("u" "-")) ("ū"))
((("z" "~")) ("ž"))
((("A" "," ",")) ("A,"))
((("A" "-" "-")) ("A-"))
((("A" "'" "'")) ("A'"))
((("A" "^" "^")) ("A^"))
((("A" "~" "~")) ("A~"))
((("A" "\"" "\"")) ("A\""))
((("A" "/" "/")) ("A/"))
((("C" "~" "~")) ("C~"))
((("D" "/" "/")) ("D/"))
((("E" "/" "/")) ("E/"))
((("E" "-" "-")) ("E-"))
((("E" "'" "'")) ("E'"))
((("E" "," ",")) ("E,"))
((("E" "\"" "\"")) ("E\""))
((("E" "." ".")) ("E."))
((("G" "," ",")) ("G,"))
((("I" "~" "~")) ("I~"))
((("I" "," ",")) ("I,"))
((("I" "'" "'")) ("I'"))
((("I" "^" "^")) ("I^"))
((("I" "-" "-")) ("I-"))
((("K" "," ",")) ("K,"))
((("L" "," ",")) ("L,"))
((("N" "/" "/")) ("N/"))
((("N" "," ",")) ("N,"))
((("O" "-" "-")) ("O-"))
((("O" "^" "^")) ("O^"))
((("O" "~" "~")) ("O~"))
((("O" "\"" "\"")) ("O\""))
((("O" "/" "/")) ("O/"))
((("R" "," ",")) ("R,"))
((("S" "~" "~")) ("S~"))
((("T" "/" "/")) ("T/"))
((("U" "," ",")) ("U,"))
((("U" "'" "'")) ("U'"))
((("U" "^" "^")) ("U^"))
((("U" "\"" "\"")) ("U\""))
((("U" "~" "~")) ("U~"))
((("U" "-" "-")) ("U-"))
((("Z" "~" "~")) ("Z~"))
((("a" "," ",")) ("a,"))
((("a" "-" "-")) ("a-"))
((("a" "'" "'")) ("a'"))
((("a" "^" "^")) ("a^"))
((("a" "~" "~")) ("a~"))
((("a" "\"" "\"")) ("a\""))
((("a" "/" "/")) ("a/"))
((("c" "~" "~")) ("c~"))
((("d" "/" "/")) ("d/"))
((("e" "/" "/")) ("e/"))
((("e" "-" "-")) ("e-"))
((("e" "'" "'")) ("e'"))
((("e" "," ",")) ("e,"))
((("e" "\"" "\"")) ("e\""))
((("e" "." ".")) ("e."))
((("g" "," ",")) ("g,"))
((("i" "~" "~")) ("i~"))
((("i" "," ",")) ("i,"))
((("i" "'" "'")) ("i'"))
((("i" "^" "^")) ("i^"))
((("i" "-" "-")) ("i-"))
((("k" "/" "/")) ("k/"))
((("k" "," ",")) ("k,"))
((("l" "," ",")) ("l,"))
((("n" "/" "/")) ("n/"))
((("n" "," ",")) ("n,"))
((("o" "-" "-")) ("o-"))
((("o" "^" "^")) ("o^"))
((("o" "~" "~")) ("o~"))
((("o" "\"" "\"")) ("o\""))
((("o" "/" "/")) ("o/"))
((("r" "," ",")) ("r,"))
((("s" "/" "/")) ("s/"))
((("s" "~" "~")) ("s~"))
((("t" "/" "/")) ("t/"))
((("u" "," ",")) ("u,"))
((("u" "'" "'")) ("u'"))
((("u" "^" "^")) ("u^"))
((("u" "\"" "\"")) ("u\""))
((("u" "~" "~")) ("u~"))
((("u" "-" "-")) ("u-"))
((("z" "~" "~")) ("z~"))
))

(define elatin-rules-latin-5-postfix '(
((("A" "'")) ("Á"))
((("A" "/")) ("Å"))
((("A" "\"")) ("Ä"))
((("A" "^")) ("Â"))
((("A" "`")) ("À"))
((("A" "~")) ("Ã"))
((("C" ",")) ("Ç"))
((("E" "'")) ("É"))
((("E" "/")) ("Æ"))
((("E" "\"")) ("Ë"))
((("E" "^")) ("Ê"))
((("E" "`")) ("È"))
((("G" "~")) ("Ğ"))
((("I" "'")) ("Í"))
((("I" ".")) ("İ"))
((("I" "\"")) ("Ï"))
((("I" "^")) ("Î"))
((("I" "`")) ("Ì"))
((("N" "~")) ("Ñ"))
((("O" "'")) ("Ó"))
((("O" "/")) ("Ø"))
((("O" "\"")) ("Ö"))
((("O" "^")) ("Ô"))
((("O" "`")) ("Ò"))
((("O" "~")) ("Õ"))
((("S" ",")) ("Ş"))
((("U" "'")) ("Ú"))
((("U" "\"")) ("Ü"))
((("U" "^")) ("Û"))
((("U" "`")) ("Ù"))
((("a" "'")) ("á"))
((("a" "/")) ("å"))
((("a" "\"")) ("ä"))
((("a" "^")) ("â"))
((("a" "`")) ("à"))
((("a" "~")) ("ã"))
((("c" ",")) ("ç"))
((("e" "'")) ("é"))
((("e" "/")) ("æ"))
((("e" "\"")) ("ë"))
((("e" "^")) ("ê"))
((("e" "`")) ("è"))
((("g" "~")) ("ğ"))
((("i" "'")) ("í"))
((("i" ".")) ("ı"))
((("i" "\"")) ("ï"))
((("i" "^")) ("î"))
((("i" "`")) ("ì"))
((("n" "~")) ("ñ"))
((("o" "'")) ("ó"))
((("o" "/")) ("ø"))
((("o" "\"")) ("ö"))
((("o" "^")) ("ô"))
((("o" "`")) ("ò"))
((("o" "~")) ("õ"))
((("s" ",")) ("ş"))
((("s" "/")) ("ß"))
((("u" "'")) ("ú"))
((("u" "\"")) ("ü"))
((("u" "^")) ("û"))
((("u" "`")) ("ù"))
((("y" "\"")) ("ÿ"))
((("A" "'" "'")) ("A'"))
((("A" "/" "/")) ("A/"))
((("A" "\"" "\"")) ("A\""))
((("A" "^" "^")) ("A^"))
((("A" "`" "`")) ("A`"))
((("A" "~" "~")) ("A~"))
((("C" "," ",")) ("C,"))
((("E" "'" "'")) ("E'"))
((("E" "/" "/")) ("E/"))
((("E" "\"" "\"")) ("E\""))
((("E" "^" "^")) ("E^"))
((("E" "`" "`")) ("E`"))
((("G" "~" "~")) ("G~"))
((("I" "'" "'")) ("I'"))
((("I" "." ".")) ("I."))
((("I" "\"" "\"")) ("I\""))
((("I" "^" "^")) ("I^"))
((("I" "`" "`")) ("I`"))
((("N" "~" "~")) ("N~"))
((("O" "'" "'")) ("O'"))
((("O" "/" "/")) ("O/"))
((("O" "\"" "\"")) ("O\""))
((("O" "^" "^")) ("O^"))
((("O" "`" "`")) ("O`"))
((("O" "~" "~")) ("O~"))
((("S" "," ",")) ("S,"))
((("U" "'" "'")) ("U'"))
((("U" "\"" "\"")) ("U\""))
((("U" "^" "^")) ("U^"))
((("U" "`" "`")) ("U`"))
((("a" "'" "'")) ("a'"))
((("a" "/" "/")) ("a/"))
((("a" "\"" "\"")) ("a\""))
((("a" "^" "^")) ("a^"))
((("a" "`" "`")) ("a`"))
((("a" "~" "~")) ("a~"))
((("c" "," ",")) ("c,"))
((("e" "'" "'")) ("e'"))
((("e" "/" "/")) ("e/"))
((("e" "\"" "\"")) ("e\""))
((("e" "^" "^")) ("e^"))
((("e" "`" "`")) ("e`"))
((("g" "~" "~")) ("g~"))
((("i" "'" "'")) ("i'"))
((("i" "." ".")) ("i."))
((("i" "\"" "\"")) ("i\""))
((("i" "^" "^")) ("i^"))
((("i" "`" "`")) ("i`"))
((("n" "~" "~")) ("n~"))
((("o" "'" "'")) ("o'"))
((("o" "/" "/")) ("o/"))
((("o" "\"" "\"")) ("o\""))
((("o" "^" "^")) ("o^"))
((("o" "`" "`")) ("o`"))
((("o" "~" "~")) ("o~"))
((("s" "," ",")) ("s,"))
((("s" "/" "/")) ("s/"))
((("u" "'" "'")) ("u'"))
((("u" "\"" "\"")) ("u\""))
((("u" "^" "^")) ("u^"))
((("u" "`" "`")) ("u`"))
((("y" "\"" "\"")) ("y\""))
))

(define elatin-rules-danish-postfix '(
((("A" "E")) ("Æ"))
((("a" "e")) ("æ"))
((("O" "E")) ("Ø"))
((("o" "e")) ("ø"))
((("A" "A")) ("Å"))
((("a" "a")) ("å"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("A" "A" "A")) ("AA"))
((("a" "a" "a")) ("aa"))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
))

(define elatin-rules-esperanto-postfix '(
((("C" "x")) ("Ĉ"))
((("C" "^")) ("Ĉ"))
((("c" "x")) ("ĉ"))
((("c" "^")) ("ĉ"))
((("G" "x")) ("Ĝ"))
((("G" "^")) ("Ĝ"))
((("g" "x")) ("ĝ"))
((("g" "^")) ("ĝ"))
((("H" "x")) ("Ĥ"))
((("H" "^")) ("Ĥ"))
((("h" "x")) ("ĥ"))
((("h" "^")) ("ĥ"))
((("J" "x")) ("Ĵ"))
((("J" "^")) ("Ĵ"))
((("j" "x")) ("ĵ"))
((("j" "^")) ("ĵ"))
((("S" "x")) ("Ŝ"))
((("S" "^")) ("Ŝ"))
((("s" "x")) ("ŝ"))
((("s" "^")) ("ŝ"))
((("U" "x")) ("Ŭ"))
((("U" "^")) ("Ŭ"))
((("u" "x")) ("ŭ"))
((("u" "^")) ("ŭ"))
((("C" "x" "x")) ("Cx"))
((("C" "^" "^")) ("C^"))
((("c" "x" "x")) ("cx"))
((("c" "^" "^")) ("c^"))
((("G" "x" "x")) ("Gx"))
((("G" "^" "^")) ("G^"))
((("g" "x" "x")) ("gx"))
((("g" "^" "^")) ("g^"))
((("H" "x" "x")) ("Hx"))
((("H" "^" "^")) ("H^"))
((("h" "x" "x")) ("hx"))
((("h" "^" "^")) ("h^"))
((("J" "x" "x")) ("Jx"))
((("J" "^" "^")) ("J^"))
((("j" "x" "x")) ("jx"))
((("j" "^" "^")) ("j^"))
((("S" "x" "x")) ("Sx"))
((("S" "^" "^")) ("S^"))
((("s" "x" "x")) ("sx"))
((("s" "^" "^")) ("s^"))
((("U" "x" "x")) ("Ux"))
((("U" "^" "^")) ("U^"))
((("u" "x" "x")) ("ux"))
((("u" "^" "^")) ("u^"))
))

(define elatin-rules-finnish-postfix '(
((("A" "E")) ("Ä"))
((("a" "e")) ("ä"))
((("O" "E")) ("Ö"))
((("o" "e")) ("ö"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
))

(define elatin-rules-french-postfix '(
((("A" "`")) ("À"))
((("A" "^")) ("Â"))
((("a" "`")) ("à"))
((("a" "^")) ("â"))
((("E" "`")) ("È"))
((("E" "'")) ("É"))
((("E" "^")) ("Ê"))
((("E" "\"")) ("Ë"))
((("e" "`")) ("è"))
((("e" "'")) ("é"))
((("e" "^")) ("ê"))
((("e" "\"")) ("ë"))
((("I" "^")) ("Î"))
((("I" "\"")) ("Ï"))
((("i" "^")) ("î"))
((("i" "\"")) ("ï"))
((("O" "^")) ("Ô"))
((("o" "^")) ("ô"))
((("U" "`")) ("Ù"))
((("U" "^")) ("Û"))
((("U" "\"")) ("Ü"))
((("u" "`")) ("ù"))
((("u" "^")) ("û"))
((("u" "\"")) ("ü"))
((("C" ",")) ("Ç"))
((("c" ",")) ("ç"))
((("<" "<")) ("«"))
(((">" ">")) ("»"))
((("A" "`" "`")) ("A`"))
((("A" "^" "^")) ("A^"))
((("a" "`" "`")) ("a`"))
((("a" "^" "^")) ("a^"))
((("E" "`" "`")) ("E`"))
((("E" "'" "'")) ("E'"))
((("E" "^" "^")) ("E^"))
((("E" "\"" "\"")) ("E\""))
((("e" "`" "`")) ("e`"))
((("e" "'" "'")) ("e'"))
((("e" "^" "^")) ("e^"))
((("e" "\"" "\"")) ("e\""))
((("I" "^" "^")) ("I^"))
((("I" "\"" "\"")) ("I\""))
((("i" "^" "^")) ("i^"))
((("i" "\"" "\"")) ("i\""))
((("O" "^" "^")) ("O^"))
((("o" "^" "^")) ("o^"))
((("U" "`" "`")) ("U`"))
((("U" "^" "^")) ("U^"))
((("U" "\"" "\"")) ("U\""))
((("u" "`" "`")) ("u`"))
((("u" "^" "^")) ("u^"))
((("u" "\"" "\"")) ("u\""))
((("C" "," ",")) ("C,"))
((("c" "," ",")) ("c,"))
((("<" "<" "<")) ("<<"))
(((">" ">" ">")) (">>"))
))

(define elatin-rules-german-postfix '(
((("A" "E")) ("Ä"))
((("a" "e")) ("ä"))
((("O" "E")) ("Ö"))
((("o" "e")) ("ö"))
((("U" "E")) ("Ü"))
((("u" "e")) ("ü"))
((("s" "z")) ("ß"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("U" "E" "E")) ("UE"))
((("u" "e" "e")) ("ue"))
((("s" "z" "z")) ("sz"))
))

(define elatin-rules-icelandic-postfix '(
((("A" "'")) ("Á"))
((("a" "'")) ("á"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("I" "'")) ("Í"))
((("i" "'")) ("í"))
((("O" "'")) ("Ó"))
((("o" "'")) ("ó"))
((("U" "'")) ("Ú"))
((("u" "'")) ("ú"))
((("Y" "'")) ("Ý"))
((("y" "'")) ("ý"))
((("A" "E")) ("Æ"))
((("a" "e")) ("æ"))
((("O" "E")) ("Ö"))
((("o" "e")) ("ö"))
((("D" "/")) ("Ð"))
((("d" "/")) ("ð"))
((("T" "/")) ("Þ"))
((("t" "/")) ("þ"))
((("A" "'" "'")) ("A'"))
((("a" "'" "'")) ("a'"))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
((("I" "'" "'")) ("I'"))
((("i" "'" "'")) ("i'"))
((("O" "'" "'")) ("O'"))
((("o" "'" "'")) ("o'"))
((("U" "'" "'")) ("U'"))
((("u" "'" "'")) ("u'"))
((("Y" "'" "'")) ("Y'"))
((("y" "'" "'")) ("y'"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("D" "/" "/")) ("D/"))
((("d" "/" "/")) ("d/"))
((("T" "/" "/")) ("T/"))
((("t" "/" "/")) ("t/"))
))

(define elatin-rules-italian-postfix '(
((("A" "`")) ("À"))
((("a" "`")) ("à"))
((("E" "`")) ("È"))
((("E" "'")) ("É"))
((("e" "`")) ("è"))
((("e" "'")) ("é"))
((("I" "`")) ("Ì"))
((("i" "`")) ("ì"))
((("O" "`")) ("Ò"))
((("o" "`")) ("ò"))
((("U" "`")) ("Ù"))
((("u" "`")) ("ù"))
((("<" "<")) ("«"))
(((">" ">")) ("»"))
((("o" "_")) ("º"))
((("a" "_")) ("ª"))
((("A" "`" "`")) ("A`"))
((("a" "`" "`")) ("a`"))
((("E" "`" "`")) ("E`"))
((("E" "'" "'")) ("E'"))
((("e" "`" "`")) ("e`"))
((("e" "'" "'")) ("e'"))
((("I" "`" "`")) ("I`"))
((("i" "`" "`")) ("i`"))
((("O" "`" "`")) ("O`"))
((("o" "`" "`")) ("o`"))
((("U" "`" "`")) ("U`"))
((("u" "`" "`")) ("u`"))
((("<" "<" "<")) ("<<"))
(((">" ">" ">")) (">>"))
((("o" "_" "_")) ("o_"))
((("a" "_" "_")) ("a_"))
))

(define elatin-rules-norwegian-postfix '(
((("A" "E")) ("Æ"))
((("a" "e")) ("æ"))
((("O" "E")) ("Ø"))
((("o" "e")) ("ø"))
((("A" "A")) ("Å"))
((("a" "a")) ("å"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("A" "A" "A")) ("AA"))
((("a" "a" "a")) ("aa"))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
))

(define elatin-rules-scandinavian-postfix '(
((("A" "E")) ("Æ"))
((("a" "e")) ("æ"))
((("O" "E")) ("Ø"))
((("o" "e")) ("ø"))
((("A" "A")) ("Å"))
((("a" "a")) ("å"))
((("A" "\"")) ("Ä"))
((("a" "\"")) ("ä"))
((("O" "\"")) ("Ö"))
((("o" "\"")) ("ö"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("A" "A" "A")) ("AA"))
((("a" "a" "a")) ("aa"))
((("A" "\"" "\"")) ("A\""))
((("a" "\"" "\"")) ("a\""))
((("O" "\"" "\"")) ("O\""))
((("o" "\"" "\"")) ("o\""))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
))

(define elatin-rules-spanish-postfix '(
((("A" "'")) ("Á"))
((("a" "'")) ("á"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("I" "'")) ("Í"))
((("i" "'")) ("í"))
((("O" "'")) ("Ó"))
((("o" "'")) ("ó"))
((("U" "'")) ("Ú"))
((("u" "'")) ("ú"))
((("U" "\"")) ("Ü"))
((("u" "\"")) ("ü"))
((("N" "~")) ("Ñ"))
((("n" "~")) ("ñ"))
((("?" "/")) ("¿"))
((("!" "/")) ("¡"))
((("A" "'" "'")) ("A'"))
((("a" "'" "'")) ("a'"))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
((("I" "'" "'")) ("I'"))
((("i" "'" "'")) ("i'"))
((("O" "'" "'")) ("O'"))
((("o" "'" "'")) ("o'"))
((("U" "'" "'")) ("U'"))
((("u" "'" "'")) ("u'"))
((("U" "\"")) ("U\""))
((("u" "\"")) ("U\""))
((("N" "~" "~")) ("N~"))
((("n" "~" "~")) ("n~"))
((("?" "/" "/")) ("?/"))
((("!" "/" "/")) ("!/"))
))

(define elatin-rules-swedish-postfix '(
((("A" "A")) ("Å"))
((("a" "a")) ("å"))
((("A" "E")) ("Ä"))
((("a" "e")) ("ä"))
((("O" "E")) ("Ö"))
((("o" "e")) ("ö"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("A" "A" "A")) ("AA"))
((("a" "a" "a")) ("aa"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
))

(define elatin-rules-turkish-latin-3-postfix '(
((("A" "^")) ("Â"))
((("a" "^")) ("â"))
((("C" ",")) ("Ç"))
((("c" ",")) ("ç"))
((("G" "^")) ("Ğ"))
((("g" "^")) ("ğ"))
((("I" ".")) ("İ"))
((("i")) ("ı"))
((("i" ".")) ("i"))
((("O" "\"")) ("Ö"))
((("o" "\"")) ("ö"))
((("S" ",")) ("Ş"))
((("s" ",")) ("ş"))
((("U" "\"")) ("Ü"))
((("u" "\"")) ("ü"))
((("U" "^")) ("Û"))
((("u" "^")) ("û"))
((("A" "^" "^")) ("A^"))
((("a" "^" "^")) ("a^"))
((("C" "," ",")) ("C,"))
((("c" "," ",")) ("c,"))
((("G" "^" "^")) ("G^"))
((("g" "^" "^")) ("g^"))
((("I" "." ".")) ("I."))
((("i")) ("i"))
((("i" "." ".")) ("i."))
((("O" "\"" "\"")) ("O\""))
((("o" "\"" "\"")) ("o\""))
((("S" "," ",")) ("S,"))
((("s" "," ",")) ("s,"))
((("U" "\"" "\"")) ("U\""))
((("u" "\"" "\"")) ("u\""))
((("U" "^" "^")) ("U^"))
((("u" "^" "^")) ("u^"))
))

(define elatin-rules-turkish-postfix '(
((("A" "^")) ("Â"))
((("a" "^")) ("â"))
((("C" ",")) ("Ç"))
((("c" ",")) ("ç"))
((("G" "^")) ("Ğ"))
((("g" "^")) ("ğ"))
((("I" ".")) ("İ"))
((("i")) ("ı"))
((("i" ".")) ("i"))
((("O" "\"")) ("Ö"))
((("o" "\"")) ("ö"))
((("S" ",")) ("Ş"))
((("s" ",")) ("ş"))
((("U" "\"")) ("Ü"))
((("u" "\"")) ("ü"))
((("U" "^")) ("Û"))
((("u" "^")) ("û"))
((("A" "^" "^")) ("A^"))
((("a" "^" "^")) ("a^"))
((("C" "," ",")) ("C,"))
((("c" "," ",")) ("c,"))
((("G" "^" "^")) ("G^"))
((("g" "^" "^")) ("g^"))
((("I" "." ".")) ("I."))
((("i")) ("i"))
((("i" "." ".")) ("i."))
((("O" "\"" "\"")) ("O\""))
((("o" "\"" "\"")) ("o\""))
((("S" "," ",")) ("S,"))
((("s" "," ",")) ("s,"))
((("U" "\"" "\"")) ("U\""))
((("u" "\"" "\"")) ("u\""))
((("U" "^" "^")) ("U^"))
((("u" "^" "^")) ("u^"))
))

(define elatin-rules-british '(
((("#")) ("£" "#"))
))

(define elatin-rules-french-keyboard '(
((("1")) ("ê"))
((("2")) ("é"))
((("3")) ("è"))
((("4")) ("ô"))
((("5")) ("î"))
((("6")) ("ï"))
((("7")) ("â"))
((("8")) ("û"))
((("9")) ("ù"))
((("0")) ("à"))
((("=")) ("ë"))
((("[")) ("ç"))
((("]")) ("ü"))
((("!")) ("1"))
((("@")) ("2"))
((("#")) ("3"))
((("$")) ("4"))
((("%")) ("5"))
((("^")) ("6"))
((("&")) ("7"))
((("*")) ("8"))
((("(")) ("9"))
(((")")) ("0"))
((("{")) ("Ç"))
((("}")) ("&"))
((("<")) ("("))
(((">")) (")"))
))

(define elatin-rules-french-azerty '(
((("1")) ("&"))
((("2")) ("é"))
((("3")) ("\""))
((("4")) ("'"))
((("5")) ("("))
((("6")) ("§"))
((("7")) ("è"))
((("8")) ("!"))
((("9")) ("ç"))
((("0")) ("à"))
((("-")) (")"))
((("=")) ("-"))
((("`")) ("@"))
((("q")) ("a"))
((("w")) ("z"))
((("e")) ("e"))
((("r")) ("r"))
((("t")) ("t"))
((("y")) ("y"))
((("u")) ("u"))
((("i")) ("i"))
((("o")) ("o"))
((("p")) ("p"))
((("[")) ("^"))
((("]")) ("`"))
((("a")) ("q"))
((("s")) ("s"))
((("d")) ("d"))
((("f")) ("f"))
((("g")) ("g"))
((("h")) ("h"))
((("j")) ("j"))
((("k")) ("k"))
((("l")) ("l"))
(((";")) ("m"))
((("'")) ("ù"))
((("\\")) ("*"))
((("z")) ("w"))
((("x")) ("x"))
((("c")) ("c"))
((("v")) ("v"))
((("b")) ("b"))
((("n")) ("n"))
((("m")) (","))
(((",")) (";"))
(((".")) (":"))
((("/")) ("="))
((("!")) ("1"))
((("@")) ("2"))
((("#")) ("3"))
((("$")) ("4"))
((("%")) ("5"))
((("^")) ("6"))
((("&")) ("7"))
((("*")) ("8"))
((("(")) ("9"))
(((")")) ("0"))
((("_")) ("°"))
((("+")) ("_"))
((("~")) ("~"))
((("Q")) ("A"))
((("W")) ("Z"))
((("E")) ("E"))
((("R")) ("R"))
((("T")) ("T"))
((("Y")) ("Y"))
((("U")) ("U"))
((("I")) ("I"))
((("O")) ("O"))
((("P")) ("P"))
((("{")) ("¨"))
((("}")) ("$"))
((("A")) ("Q"))
((("S")) ("S"))
((("D")) ("D"))
((("F")) ("F"))
((("G")) ("G"))
((("H")) ("H"))
((("J")) ("J"))
((("K")) ("K"))
((("L")) ("L"))
(((":")) ("M"))
((("\"")) ("%"))
((("|")) ("|"))
((("Z")) ("W"))
((("X")) ("X"))
((("C")) ("C"))
((("V")) ("V"))
((("B")) ("B"))
((("N")) ("N"))
((("M")) ("?"))
((("<")) ("."))
(((">")) ("/"))
((("?")) ("+"))
((("[" "q")) ("â"))
((("[" "e")) ("ê"))
((("[" "i")) ("î"))
((("[" "o")) ("ô"))
((("[" "u")) ("û"))
((("{" "e")) ("ë"))
((("{" "i")) ("ï"))
((("{" "u")) ("ü"))
((("[" "[")) ("^"))
((("{" "{")) ("¨"))
))

(define elatin-rules-icelandic-keyboard '(
((("-")) ("ö"))
((("=")) ("-"))
((("[")) ("ð"))
((("]")) ("'"))
(((";")) ("æ"))
((("'")) ("´"))
((("\\")) ("+"))
((("/")) ("þ"))
((("@")) ("\""))
((("_")) ("Ö"))
((("+")) ("_"))
((("{")) ("Ð"))
((("}")) ("?"))
(((":")) ("Æ"))
((("\"")) ("´"))
((("|")) ("*"))
((("<")) (";"))
(((">")) (":"))
((("?")) ("Þ"))
((("'" "a")) ("á"))
((("'" "e")) ("é"))
((("'" "i")) ("í"))
((("'" "o")) ("ó"))
((("'" "u")) ("ú"))
((("'" "y")) ("ý"))
((("'" "A")) ("Á"))
((("'" "E")) ("É"))
((("'" "I")) ("Í"))
((("'" "O")) ("Ó"))
((("'" "U")) ("Ú"))
((("'" "Y")) ("Ý"))
((("'" "'")) ("´"))
))

(define elatin-rules-danish-keyboard '(
((("-")) ("+"))
((("=")) ("½"))
((("`")) ("~"))
((("[")) ("å"))
((("]")) ("é"))
(((";")) ("æ"))
((("'")) ("ø"))
((("\\")) ("'"))
((("/")) ("-"))
((("@")) ("\""))
((("$")) ("¤"))
((("^")) ("&"))
((("&")) ("/"))
((("*")) ("("))
((("(")) (")"))
(((")")) ("="))
((("_")) ("?"))
((("+")) ("§"))
((("~")) ("^"))
((("{")) ("Å"))
((("}")) ("É"))
(((":")) ("Æ"))
((("\"")) ("Ø"))
((("|")) ("*"))
((("<")) (";"))
(((">")) (":"))
((("?")) ("_"))
))

(define elatin-rules-norwegian-keyboard '(
((("-")) ("+"))
((("=")) ("|"))
((("`")) ("~"))
((("[")) ("å"))
((("]")) ("é"))
(((";")) ("ø"))
((("'")) ("æ"))
((("\\")) ("'"))
((("/")) ("-"))
((("!")) ("!"))
((("@")) ("\""))
((("$")) ("¤"))
((("^")) ("&"))
((("&")) ("/"))
((("*")) ("("))
((("(")) (")"))
(((")")) ("="))
((("_")) ("?"))
((("+")) ("§"))
((("~")) ("^"))
((("{")) ("Å"))
((("}")) ("É"))
(((":")) ("Ø"))
((("\"")) ("Æ"))
((("|")) ("*"))
((("<")) (";"))
(((">")) (":"))
((("?")) ("_"))
))

(define elatin-rules-swedish-keyboard '(
((("-")) ("+"))
((("=")) ("§"))
((("`")) ("~"))
((("[")) ("å"))
((("]")) ("é"))
(((";")) ("ö"))
((("'")) ("ä"))
((("\\")) ("'"))
((("/")) ("-"))
((("@")) ("\""))
((("$")) ("¤"))
((("^")) ("&"))
((("&")) ("/"))
((("*")) ("("))
((("(")) (")"))
(((")")) ("="))
((("_")) ("?"))
((("+")) ("½"))
((("~")) ("^"))
((("{")) ("Å"))
((("}")) ("É"))
(((":")) ("Ö"))
((("\"")) ("Ä"))
((("|")) ("*"))
((("<")) (";"))
(((">")) (":"))
((("?")) ("_"))
))

(define elatin-rules-finnish-keyboard '(
((("-")) ("+"))
((("=")) ("§"))
((("`")) ("~"))
((("[")) ("å"))
((("]")) ("é"))
(((";")) ("ö"))
((("'")) ("ä"))
((("\\")) ("'"))
((("/")) ("-"))
((("@")) ("\""))
((("$")) ("¤"))
((("^")) ("&"))
((("&")) ("/"))
((("*")) ("("))
((("(")) (")"))
(((")")) ("="))
((("_")) ("?"))
((("+")) ("½"))
((("~")) ("^"))
((("{")) ("Å"))
((("}")) ("É"))
(((":")) ("Ö"))
((("\"")) ("Ä"))
((("|")) ("*"))
((("<")) (";"))
(((">")) (":"))
((("?")) ("_"))
))

(define elatin-rules-german '(
((("-")) ("ß"))
((("=")) ("["))
((("`")) ("]"))
((("y")) ("z"))
((("[")) ("ü"))
((("]")) ("+"))
(((";")) ("ö"))
((("'")) ("ä"))
((("\\")) ("#"))
((("z")) ("y"))
((("/")) ("-"))
((("@")) ("\""))
((("#")) ("§"))
((("^")) ("&"))
((("&")) ("/"))
((("*")) ("("))
((("Y")) ("Z"))
((("(")) (")"))
(((")")) ("="))
((("_")) ("?"))
((("+")) ("{"))
((("~")) ("}"))
((("{")) ("Ü"))
((("}")) ("*"))
(((":")) ("Ö"))
((("\"")) ("Ä"))
((("|")) ("^"))
((("Z")) ("Y"))
((("<")) (";"))
(((">")) (":"))
((("?")) ("_"))
))

(define elatin-rules-italian-keyboard '(
((("-")) ("'"))
((("=")) ("ì"))
((("[")) ("è"))
((("]")) ("+"))
(((";")) ("ò"))
((("'")) ("à"))
((("\\")) ("ù"))
((("/")) ("-"))
((("@")) ("\""))
((("#")) ("£"))
((("^")) ("&"))
((("&")) ("/"))
((("*")) ("("))
((("(")) (")"))
(((")")) ("="))
((("_")) ("?"))
((("+")) ("^"))
((("~")) ("~"))
((("{")) ("é"))
((("}")) ("*"))
(((":")) ("ç"))
((("\"")) ("°"))
((("|")) ("§"))
((("<")) (";"))
(((">")) (":"))
((("?")) ("_"))
))

(define elatin-rules-spanish-keyboard '(
((("-")) ("'"))
((("=")) ("¡"))
((("`")) ("í"))
((("[")) ("é"))
((("]")) ("ó"))
(((";")) ("ñ"))
((("'")) ("á"))
((("\\")) ("ú"))
((("/")) ("-"))
((("@")) ("\""))
((("#")) ("·"))
((("^")) ("&"))
((("&")) ("/"))
((("*")) ("("))
((("(")) (")"))
(((")")) ("="))
((("_")) ("?"))
((("+")) ("¿"))
((("~")) ("Í"))
((("{")) ("É"))
((("}")) ("Ó"))
(((":")) ("Ñ"))
((("\"")) ("Á"))
((("|")) ("Ú"))
((("<")) (";"))
(((">")) (":"))
((("?")) ("_"))
))

(define elatin-rules-english-dvorak '(
((("-")) ("["))
((("=")) ("]"))
((("`")) ("`"))
((("q")) ("'"))
((("w")) (","))
((("e")) ("."))
((("r")) ("p"))
((("t")) ("y"))
((("y")) ("f"))
((("u")) ("g"))
((("i")) ("c"))
((("o")) ("r"))
((("p")) ("l"))
((("[")) ("/"))
((("]")) ("="))
((("a")) ("a"))
((("s")) ("o"))
((("d")) ("e"))
((("f")) ("u"))
((("g")) ("i"))
((("h")) ("d"))
((("j")) ("h"))
((("k")) ("t"))
((("l")) ("n"))
(((";")) ("s"))
((("'")) ("-"))
((("\\")) ("\\"))
((("z")) (";"))
((("x")) ("q"))
((("c")) ("j"))
((("v")) ("k"))
((("b")) ("x"))
((("n")) ("b"))
((("m")) ("m"))
(((",")) ("w"))
(((".")) ("v"))
((("/")) ("z"))
((("_")) ("{"))
((("+")) ("}"))
((("~")) ("~"))
((("Q")) ("\""))
((("W")) ("<"))
((("E")) (">"))
((("R")) ("P"))
((("T")) ("Y"))
((("Y")) ("F"))
((("U")) ("G"))
((("I")) ("C"))
((("O")) ("R"))
((("P")) ("L"))
((("{")) ("?"))
((("}")) ("+"))
((("A")) ("A"))
((("S")) ("O"))
((("D")) ("E"))
((("F")) ("U"))
((("G")) ("I"))
((("H")) ("D"))
((("J")) ("H"))
((("K")) ("T"))
((("L")) ("N"))
(((":")) ("S"))
((("\"")) ("_"))
((("|")) ("|"))
((("Z")) (":"))
((("X")) ("Q"))
((("C")) ("J"))
((("V")) ("K"))
((("B")) ("X"))
((("N")) ("B"))
((("M")) ("M"))
((("<")) ("W"))
(((">")) ("V"))
((("?")) ("Z"))
))

(define elatin-rules-latin-postfix '(
(((" " "_")) (" "))
((("!" "/")) ("¡"))
((("/" "/")) ("°"))
((("<" "<")) ("«"))
(((">" ">")) ("»"))
((("?" "/")) ("¿"))
((("$" "/")) ("£"))
((("$" "/")) ("¤"))
((("A" "'")) ("Á"))
((("A" ",")) ("Ą"))
((("A" "-")) ("Ā"))
((("A" "/")) ("Å"))
((("A" "\"")) ("Ä"))
((("A" "^")) ("Â"))
((("A" "`")) ("À"))
((("A" "~")) ("Ã"))
((("A" "~")) ("Ă"))
((("C" "'")) ("Ć"))
((("C" ",")) ("Ç"))
((("C" ".")) ("Ċ"))
((("C" "^")) ("Ĉ"))
((("C" "~")) ("Č"))
((("D" "/")) ("Ð"))
((("D" "/")) ("Đ"))
((("D" "~")) ("Ď"))
((("E" "'")) ("É"))
((("E" ",")) ("Ę"))
((("E" "-")) ("Ē"))
((("E" ".")) ("Ė"))
((("E" "/")) ("Æ"))
((("E" "\"")) ("Ë"))
((("E" "^")) ("Ê"))
((("E" "`")) ("È"))
((("E" "~")) ("Ě"))
((("G" ",")) ("Ģ"))
((("G" ".")) ("Ġ"))
((("G" "^")) ("Ĝ"))
((("G" "~")) ("Ğ"))
((("H" "/")) ("Ħ"))
((("H" "^")) ("Ĥ"))
((("I" "'")) ("Í"))
((("I" ",")) ("Į"))
((("I" "-")) ("Ī"))
((("I" ".")) ("İ"))
((("I" "\"")) ("Ï"))
((("I" "^")) ("Î"))
((("I" "`")) ("Ì"))
((("I" "~")) ("Ĩ"))
((("J" "^")) ("Ĵ"))
((("K" ",")) ("Ķ"))
((("L" "'")) ("Ĺ"))
((("L" ",")) ("Ļ"))
((("L" "/")) ("Ł"))
((("L" "~")) ("Ľ"))
((("N" "'")) ("Ń"))
((("N" ",")) ("Ņ"))
((("N" "/")) ("Ŋ"))
((("N" "~")) ("Ñ"))
((("N" "~")) ("Ň"))
((("O" "'")) ("Ó"))
((("O" "-")) ("Ō"))
((("O" "/")) ("Ø"))
((("O" "/")) ("Œ"))
((("O" ":")) ("Ő"))
((("O" "\"")) ("Ö"))
((("O" "^")) ("Ô"))
((("O" "`")) ("Ò"))
((("O" "~")) ("Õ"))
((("R" "'")) ("Ŕ"))
((("R" ",")) ("Ŗ"))
((("R" "~")) ("Ř"))
((("S" "'")) ("Ś"))
((("S" ",")) ("Ş"))
((("S" "^")) ("Ŝ"))
((("S" "~")) ("Š"))
((("T" ",")) ("Ţ"))
((("T" "/")) ("Þ"))
((("T" "/")) ("Ŧ"))
((("T" "~")) ("Ť"))
((("U" "'")) ("Ú"))
((("U" ",")) ("Ų"))
((("U" "-")) ("Ū"))
((("U" ".")) ("Ů"))
((("U" ":")) ("Ű"))
((("U" "\"")) ("Ü"))
((("U" "^")) ("Û"))
((("U" "`")) ("Ù"))
((("U" "~")) ("Ũ"))
((("U" "~")) ("Ŭ"))
((("Y" "'")) ("Ý"))
((("Y" "\"")) ("Ÿ"))
((("Y" "=")) ("¥"))
((("Z" "'")) ("Ź"))
((("Z" ".")) ("Ż"))
((("Z" "~")) ("Ž"))
((("a" "'")) ("á"))
((("a" ",")) ("ą"))
((("a" "-")) ("ā"))
((("a" "/")) ("å"))
((("a" "\"")) ("ä"))
((("a" "^")) ("â"))
((("a" "_")) ("ª"))
((("a" "`")) ("à"))
((("a" "~")) ("ã"))
((("a" "~")) ("ă"))
((("c" "'")) ("ć"))
((("c" ",")) ("ç"))
((("c" ".")) ("ċ"))
((("c" "^")) ("ĉ"))
((("c" "~")) ("č"))
((("c" "/")) ("¢"))
((("d" "/")) ("ð"))
((("d" "/")) ("đ"))
((("d" "~")) ("ď"))
((("e" "'")) ("é"))
((("e" ",")) ("ę"))
((("e" "-")) ("ē"))
((("e" ".")) ("ė"))
((("e" "/")) ("æ"))
((("e" "\"")) ("ë"))
((("e" "^")) ("ê"))
((("e" "`")) ("è"))
((("e" "~")) ("ě"))
((("e" "=")) ("€"))
((("g" ",")) ("ģ"))
((("g" ".")) ("ġ"))
((("g" "^")) ("ĝ"))
((("g" "~")) ("ğ"))
((("h" "/")) ("ħ"))
((("h" "^")) ("ĥ"))
((("i" "'")) ("í"))
((("i" ",")) ("į"))
((("i" "-")) ("ī"))
((("i" ".")) ("ı"))
((("i" "\"")) ("ï"))
((("i" "^")) ("î"))
((("i" "`")) ("ì"))
((("i" "~")) ("ĩ"))
((("j" "^")) ("ĵ"))
((("k" ",")) ("ķ"))
((("k" "/")) ("ĸ"))
((("l" "'")) ("ĺ"))
((("l" ",")) ("ļ"))
((("l" "/")) ("ł"))
((("l" "~")) ("ľ"))
((("n" "'")) ("ń"))
((("n" ",")) ("ņ"))
((("n" "/")) ("ŋ"))
((("n" "~")) ("ñ"))
((("n" "~")) ("ň"))
((("o" "'")) ("ó"))
((("o" "-")) ("ō"))
((("o" "/")) ("ø"))
((("o" "/")) ("œ"))
((("o" ":")) ("ő"))
((("o" "\"")) ("ö"))
((("o" "^")) ("ô"))
((("o" "_")) ("º"))
((("o" "`")) ("ò"))
((("o" "~")) ("õ"))
((("r" "'")) ("ŕ"))
((("r" ",")) ("ŗ"))
((("r" "~")) ("ř"))
((("s" "'")) ("ś"))
((("s" ",")) ("ş"))
((("s" "/")) ("ß"))
((("s" "^")) ("ŝ"))
((("s" "~")) ("š"))
((("t" ",")) ("ţ"))
((("t" "/")) ("þ"))
((("t" "/")) ("ŧ"))
((("t" "~")) ("ť"))
((("u" "'")) ("ú"))
((("u" ",")) ("ų"))
((("u" "-")) ("ū"))
((("u" ".")) ("ů"))
((("u" ":")) ("ű"))
((("u" "\"")) ("ü"))
((("u" "^")) ("û"))
((("u" "`")) ("ù"))
((("u" "~")) ("ũ"))
((("u" "~")) ("ŭ"))
((("y" "'")) ("ý"))
((("y" "\"")) ("ÿ"))
((("z" "'")) ("ź"))
((("z" ".")) ("ż"))
((("z" "~")) ("ž"))
((("!" "/" "/")) ("!/"))
((("/" "/" "/")) ("//"))
((("<" "<" "<")) ("<<"))
(((">" ">" ">")) (">>"))
((("?" "/" "/")) ("?/"))
((("$" "/" "/")) ("$/"))
((("A" "'" "'")) ("A'"))
((("A" "," ",")) ("A,"))
((("A" "-" "-")) ("A-"))
((("A" "/" "/")) ("A/"))
((("A" "\"" "\"")) ("A\""))
((("A" "^" "^")) ("A^"))
((("A" "`" "`")) ("A`"))
((("A" "~" "~")) ("A~"))
((("C" "'" "'")) ("C'"))
((("C" "," ",")) ("C,"))
((("C" "." ".")) ("C."))
((("C" "^" "^")) ("C^"))
((("C" "~" "~")) ("C~"))
((("D" "/" "/")) ("D/"))
((("D" "~" "~")) ("D~"))
((("E" "'" "'")) ("E'"))
((("E" "," ",")) ("E,"))
((("E" "-" "-")) ("E-"))
((("E" "." ".")) ("E."))
((("E" "/" "/")) ("E/"))
((("E" "\"" "\"")) ("E\""))
((("E" "^" "^")) ("E^"))
((("E" "`" "`")) ("E`"))
((("E" "~" "~")) ("E~"))
((("G" "," ",")) ("G,"))
((("G" "." ".")) ("G."))
((("G" "^" "^")) ("G^"))
((("G" "~" "~")) ("G~"))
((("H" "/" "/")) ("H/"))
((("H" "^" "^")) ("H^"))
((("I" "'" "'")) ("I'"))
((("I" "," ",")) ("I,"))
((("I" "-" "-")) ("I-"))
((("I" "." ".")) ("I."))
((("I" "\"" "\"")) ("I\""))
((("I" "^" "^")) ("I^"))
((("I" "`" "`")) ("I`"))
((("I" "~" "~")) ("I~"))
((("J" "^" "^")) ("J^"))
((("K" "," ",")) ("K,"))
((("L" "'" "'")) ("L'"))
((("L" "," ",")) ("L,"))
((("L" "/" "/")) ("L/"))
((("L" "~" "~")) ("L~"))
((("N" "'" "'")) ("N'"))
((("N" "," ",")) ("N,"))
((("N" "/" "/")) ("N/"))
((("N" "~" "~")) ("N~"))
((("O" "'" "'")) ("O'"))
((("O" "-" "-")) ("O-"))
((("O" "/" "/")) ("O/"))
((("O" ":" ":")) ("O:"))
((("O" "\"" "\"")) ("O\""))
((("O" "^" "^")) ("O^"))
((("O" "`" "`")) ("O`"))
((("O" "~" "~")) ("O~"))
((("R" "'" "'")) ("R'"))
((("R" "," ",")) ("R,"))
((("R" "~" "~")) ("R~"))
((("S" "'" "'")) ("S'"))
((("S" "," ",")) ("S,"))
((("S" "^" "^")) ("S^"))
((("S" "~" "~")) ("S~"))
((("T" "," ",")) ("T,"))
((("T" "/" "/")) ("T/"))
((("T" "~" "~")) ("T~"))
((("U" "'" "'")) ("U'"))
((("U" "," ",")) ("U,"))
((("U" "-" "-")) ("U-"))
((("U" "." ".")) ("U."))
((("U" ":" ":")) ("U:"))
((("U" "\"" "\"")) ("U\""))
((("U" "^" "^")) ("U^"))
((("U" "`" "`")) ("U`"))
((("U" "~" "~")) ("U~"))
((("Y" "'" "'")) ("Y'"))
((("Y" "\"" "\"")) ("Y\""))
((("Y" "=" "=")) ("Y="))
((("Z" "'" "'")) ("Z'"))
((("Z" "." ".")) ("Z."))
((("Z" "~" "~")) ("Z~"))
((("a" "'" "'")) ("a'"))
((("a" "," ",")) ("a,"))
((("a" "-" "-")) ("a-"))
((("a" "/" "/")) ("a/"))
((("a" "\"" "\"")) ("a\""))
((("a" "^" "^")) ("a^"))
((("a" "_" "_")) ("a_"))
((("a" "`" "`")) ("a`"))
((("a" "~" "~")) ("a~"))
((("c" "'" "'")) ("c'"))
((("c" "," ",")) ("c,"))
((("c" "." ".")) ("c."))
((("c" "^" "^")) ("c^"))
((("c" "~" "~")) ("c~"))
((("c" "/" "/")) ("c/"))
((("d" "/" "/")) ("d/"))
((("d" "~" "~")) ("d~"))
((("e" "'" "'")) ("e'"))
((("e" "," ",")) ("e,"))
((("e" "-" "-")) ("e-"))
((("e" "." ".")) ("e."))
((("e" "/" "/")) ("e/"))
((("e" "\"" "\"")) ("e\""))
((("e" "^" "^")) ("e^"))
((("e" "`" "`")) ("e`"))
((("e" "=" "=")) ("e="))
((("e" "~" "~")) ("e~"))
((("g" "," ",")) ("g,"))
((("g" "." ".")) ("g."))
((("g" "^" "^")) ("g^"))
((("g" "~" "~")) ("g~"))
((("h" "/" "/")) ("h/"))
((("h" "^" "^")) ("h^"))
((("i" "'" "'")) ("i'"))
((("i" "," ",")) ("i,"))
((("i" "-" "-")) ("i-"))
((("i" "." ".")) ("i."))
((("i" "\"" "\"")) ("i\""))
((("i" "^" "^")) ("i^"))
((("i" "`" "`")) ("i`"))
((("i" "~" "~")) ("i~"))
((("j" "^" "^")) ("j^"))
((("k" "," ",")) ("k,"))
((("k" "/" "/")) ("k/"))
((("l" "'" "'")) ("l'"))
((("l" "," ",")) ("l,"))
((("l" "/" "/")) ("l/"))
((("l" "~" "~")) ("l~"))
((("n" "'" "'")) ("n'"))
((("n" "," ",")) ("n,"))
((("n" "/" "/")) ("n/"))
((("n" "~" "~")) ("n~"))
((("o" "'" "'")) ("o'"))
((("o" "-" "-")) ("o-"))
((("o" "/" "/")) ("o/"))
((("o" ":" ":")) ("o:"))
((("o" "\"" "\"")) ("o\""))
((("o" "^" "^")) ("o^"))
((("o" "_" "_")) ("o_"))
((("o" "`" "`")) ("o`"))
((("o" "~" "~")) ("o~"))
((("r" "'" "'")) ("r'"))
((("r" "," ",")) ("r,"))
((("r" "~" "~")) ("r~"))
((("s" "'" "'")) ("s'"))
((("s" "," ",")) ("s,"))
((("s" "/" "/")) ("s/"))
((("s" "^" "^")) ("s^"))
((("s" "~" "~")) ("s~"))
((("t" "," ",")) ("t,"))
((("t" "/" "/")) ("t/"))
((("t" "~" "~")) ("t~"))
((("u" "'" "'")) ("u'"))
((("u" "," ",")) ("u,"))
((("u" "-" "-")) ("u-"))
((("u" "." ".")) ("u."))
((("u" ":" ":")) ("u:"))
((("u" "\"" "\"")) ("u\""))
((("u" "^" "^")) ("u^"))
((("u" "`" "`")) ("u`"))
((("u" "~" "~")) ("u~"))
((("y" "'" "'")) ("y'"))
((("y" "\"" "\"")) ("y\""))
((("z" "'" "'")) ("z'"))
((("z" "." ".")) ("z."))
((("z" "~" "~")) ("z~"))
))

(define elatin-rules-slovenian '(
((("C" "<")) ("Č"))
((("C" "'")) ("Ć"))
((("D" ";")) ("Đ"))
((("S" "<")) ("Š"))
((("Z" "<")) ("Ž"))
((("c" "<")) ("č"))
((("c" "'")) ("ć"))
((("d" ";")) ("đ"))
((("s" "<")) ("š"))
((("z" "<")) ("ž"))
))

(define elatin-rules-latin-1-alt-postfix '(
((("A" "`")) ("À"))
((("A" "'")) ("Á"))
((("A" "^")) ("Â"))
((("A" "~")) ("Ã"))
((("A" "\"")) ("Ä"))
((("A" "/")) ("Å"))
((("a" "`")) ("à"))
((("a" "'")) ("á"))
((("a" "^")) ("â"))
((("a" "~")) ("ã"))
((("a" "\"")) ("ä"))
((("a" "/")) ("å"))
((("E" "`")) ("È"))
((("E" "'")) ("É"))
((("E" "^")) ("Ê"))
((("E" "\"")) ("Ë"))
((("E" "/")) ("Æ"))
((("e" "`")) ("è"))
((("e" "'")) ("é"))
((("e" "^")) ("ê"))
((("e" "\"")) ("ë"))
((("e" "/")) ("æ"))
((("I" "`")) ("Ì"))
((("i" "`")) ("ì"))
((("I" "'")) ("Í"))
((("i" "'")) ("í"))
((("I" "^")) ("Î"))
((("i" "^")) ("î"))
((("I" "\"")) ("Ï"))
((("i" "\"")) ("ï"))
((("O" "`")) ("Ò"))
((("o" "`")) ("ò"))
((("O" "'")) ("Ó"))
((("o" "'")) ("ó"))
((("O" "^")) ("Ô"))
((("o" "^")) ("ô"))
((("O" "~")) ("Õ"))
((("o" "~")) ("õ"))
((("O" "\"")) ("Ö"))
((("o" "\"")) ("ö"))
((("O" "/")) ("Ø"))
((("o" "/")) ("ø"))
((("U" "`")) ("Ù"))
((("u" "`")) ("ù"))
((("U" "'")) ("Ú"))
((("u" "'")) ("ú"))
((("U" "^")) ("Û"))
((("u" "^")) ("û"))
((("U" "\"")) ("Ü"))
((("u" "\"")) ("ü"))
((("Y" "'")) ("Ý"))
((("y" "'")) ("ý"))
((("y" "\"")) ("ÿ"))
((("D" "/")) ("Ð"))
((("d" "/")) ("ð"))
((("T" "/")) ("Þ"))
((("t" "/")) ("þ"))
((("s" "/")) ("ß"))
((("C" "/")) ("Ç"))
((("c" "/")) ("ç"))
((("N" "~")) ("Ñ"))
((("n" "~")) ("ñ"))
((("?" "/")) ("¿"))
((("!" "/")) ("¡"))
((("<" "<")) ("«"))
(((">" ">")) ("»"))
((("o" "_")) ("º"))
((("a" "_")) ("ª"))
((("A" "`" "`")) ("A`"))
((("A" "'" "'")) ("A'"))
((("A" "^" "^")) ("A^"))
((("A" "~" "~")) ("A~"))
((("A" "\"" "\"")) ("A\""))
((("A" "/" "/")) ("A/"))
((("a" "`" "`")) ("a`"))
((("a" "'" "'")) ("a'"))
((("a" "^" "^")) ("a^"))
((("a" "~" "~")) ("a~"))
((("a" "\"" "\"")) ("a\""))
((("a" "/" "/")) ("a/"))
((("E" "`" "`")) ("E`"))
((("E" "'" "'")) ("E'"))
((("E" "^" "^")) ("E^"))
((("E" "\"" "\"")) ("E\""))
((("E" "/" "/")) ("E/"))
((("e" "`" "`")) ("e`"))
((("e" "'" "'")) ("e'"))
((("e" "^" "^")) ("e^"))
((("e" "\"" "\"")) ("e\""))
((("e" "/" "/")) ("e/"))
((("I" "`" "`")) ("I`"))
((("i" "`" "`")) ("i`"))
((("I" "'" "'")) ("I'"))
((("i" "'" "'")) ("i'"))
((("I" "^" "^")) ("I^"))
((("i" "^" "^")) ("i^"))
((("I" "\"" "\"")) ("I\""))
((("i" "\"" "\"")) ("i\""))
((("O" "`" "`")) ("O`"))
((("o" "`" "`")) ("o`"))
((("O" "'" "'")) ("O'"))
((("o" "'" "'")) ("o'"))
((("O" "^" "^")) ("O^"))
((("o" "^" "^")) ("o^"))
((("O" "~" "~")) ("O~"))
((("o" "~" "~")) ("o~"))
((("O" "\"" "\"")) ("O\""))
((("o" "\"" "\"")) ("o\""))
((("O" "/" "/")) ("O/"))
((("o" "/" "/")) ("o/"))
((("U" "`" "`")) ("U`"))
((("u" "`" "`")) ("u`"))
((("U" "'" "'")) ("U'"))
((("u" "'" "'")) ("u'"))
((("U" "^" "^")) ("U^"))
((("u" "^" "^")) ("u^"))
((("U" "\"" "\"")) ("U\""))
((("u" "\"" "\"")) ("u\""))
((("Y" "'" "'")) ("Y'"))
((("y" "'" "'")) ("y'"))
((("y" "\"" "\"")) ("y\""))
((("D" "/" "/")) ("D/"))
((("d" "/" "/")) ("d/"))
((("T" "/" "/")) ("T/"))
((("t" "/" "/")) ("t/"))
((("s" "/" "/")) ("s/"))
((("C" "/" "/")) ("C/"))
((("c" "/" "/")) ("c/"))
((("N" "~" "~")) ("N~"))
((("n" "~" "~")) ("n~"))
((("?" "/" "/")) ("?/"))
((("!" "/" "/")) ("!/"))
((("<" "<" "<")) ("<<"))
(((">" ">" ">")) (">>"))
((("o" "_" "_")) ("o_"))
((("a" "_" "_")) ("a_"))
))

(define elatin-rules-latin-2-alt-postfix '(
((("A" "'")) ("Á"))
((("A" "`")) ("Ą"))
((("A" "\"")) ("Ä"))
((("A" "^")) ("Â"))
((("A" "~")) ("Ă"))
((("C" "'")) ("Ć"))
((("C" "`")) ("Ç"))
((("C" "~")) ("Č"))
((("D" "/")) ("Đ"))
((("D" "~")) ("Ď"))
((("E" "'")) ("É"))
((("E" "`")) ("Ę"))
((("E" "\"")) ("Ë"))
((("E" "~")) ("Ě"))
((("I" "'")) ("Í"))
((("I" "^")) ("Î"))
((("L" "'")) ("Ĺ"))
((("L" "/")) ("Ł"))
((("L" "~")) ("Ľ"))
((("N" "'")) ("Ń"))
((("N" "~")) ("Ň"))
((("O" "'")) ("Ó"))
((("O" ":")) ("Ő"))
((("O" "\"")) ("Ö"))
((("O" "^")) ("Ô"))
((("R" "'")) ("Ŕ"))
((("R" "~")) ("Ř"))
((("S" "'")) ("Ś"))
((("S" "`")) ("Ş"))
((("S" "~")) ("Š"))
((("T" "`")) ("Ţ"))
((("T" "~")) ("Ť"))
((("U" "'")) ("Ú"))
((("U" ":")) ("Ű"))
((("U" "\"")) ("Ü"))
((("U" "`")) ("Ů"))
((("Y" "'")) ("Ý"))
((("Z" "'")) ("Ź"))
((("Z" "`")) ("Ż"))
((("Z" "~")) ("Ž"))
((("a" "'")) ("á"))
((("a" "`")) ("ą"))
((("a" "\"")) ("ä"))
((("a" "^")) ("â"))
((("a" "~")) ("ă"))
((("c" "'")) ("ć"))
((("c" "`")) ("ç"))
((("c" "~")) ("č"))
((("d" "/")) ("đ"))
((("d" "~")) ("ď"))
((("e" "'")) ("é"))
((("e" "`")) ("ę"))
((("e" "\"")) ("ë"))
((("e" "~")) ("ě"))
((("i" "'")) ("í"))
((("i" "^")) ("î"))
((("l" "'")) ("ĺ"))
((("l" "/")) ("ł"))
((("l" "~")) ("ľ"))
((("n" "'")) ("ń"))
((("n" "~")) ("ň"))
((("o" "'")) ("ó"))
((("o" ":")) ("ő"))
((("o" "\"")) ("ö"))
((("o" "^")) ("ô"))
((("r" "'")) ("ŕ"))
((("r" "~")) ("ř"))
((("s" "'")) ("ś"))
((("s" "`")) ("ş"))
((("s" "/")) ("ß"))
((("s" "~")) ("š"))
((("t" "`")) ("ţ"))
((("t" "~")) ("ť"))
((("u" "'")) ("ú"))
((("u" ":")) ("ű"))
((("u" "\"")) ("ü"))
((("u" "`")) ("ů"))
((("y" "'")) ("ý"))
((("z" "'")) ("ź"))
((("z" "`")) ("ż"))
((("z" "~")) ("ž"))
((("A" "'" "'")) ("A'"))
((("A" "`" "`")) ("A`"))
((("A" "\"" "\"")) ("A\""))
((("A" "^" "^")) ("A^"))
((("A" "~" "~")) ("A~"))
((("C" "'" "'")) ("C'"))
((("C" "`" "`")) ("C`"))
((("C" "~" "~")) ("C~"))
((("D" "/" "/")) ("D/"))
((("D" "~" "~")) ("D~"))
((("E" "'" "'")) ("E'"))
((("E" "`" "`")) ("E`"))
((("E" "\"" "\"")) ("E\""))
((("E" "~" "~")) ("E~"))
((("I" "'" "'")) ("I'"))
((("I" "^" "^")) ("I^"))
((("L" "'" "'")) ("L'"))
((("L" "/" "/")) ("L/"))
((("L" "~" "~")) ("L~"))
((("N" "'" "'")) ("N'"))
((("N" "~" "~")) ("N~"))
((("O" "'" "'")) ("O'"))
((("O" ":" ":")) ("O:"))
((("O" "\"" "\"")) ("O\""))
((("O" "^" "^")) ("O^"))
((("R" "'" "'")) ("R'"))
((("R" "~" "~")) ("R~"))
((("S" "'" "'")) ("S'"))
((("S" "`" "`")) ("S`"))
((("S" "~" "~")) ("S~"))
((("T" "`" "`")) ("T`"))
((("T" "~" "~")) ("T~"))
((("U" "'" "'")) ("U'"))
((("U" ":" ":")) ("U:"))
((("U" "\"" "\"")) ("U\""))
((("U" "`" "`")) ("U`"))
((("Y" "'" "'")) ("Y'"))
((("Z" "'" "'")) ("Z'"))
((("Z" "`" "`")) ("Z`"))
((("Z" "~" "~")) ("Z~"))
((("a" "'" "'")) ("a'"))
((("a" "`" "`")) ("a`"))
((("a" "\"" "\"")) ("a\""))
((("a" "^" "^")) ("a^"))
((("a" "~" "~")) ("a~"))
((("c" "'" "'")) ("c'"))
((("c" "`" "`")) ("c`"))
((("c" "~" "~")) ("c~"))
((("d" "/" "/")) ("d/"))
((("d" "~" "~")) ("d~"))
((("e" "'" "'")) ("e'"))
((("e" "`" "`")) ("e`"))
((("e" "\"" "\"")) ("e\""))
((("e" "~" "~")) ("e~"))
((("i" "'" "'")) ("i'"))
((("i" "^" "^")) ("i^"))
((("l" "'" "'")) ("l'"))
((("l" "/" "/")) ("l/"))
((("l" "~" "~")) ("l~"))
((("n" "'" "'")) ("n'"))
((("n" "~" "~")) ("n~"))
((("o" "'" "'")) ("o'"))
((("o" ":" ":")) ("o:"))
((("o" "\"" "\"")) ("o\""))
((("o" "^" "^")) ("o^"))
((("r" "'" "'")) ("r'"))
((("r" "~" "~")) ("r~"))
((("s" "'" "'")) ("s'"))
((("s" "`" "`")) ("s`"))
((("s" "/" "/")) ("s/"))
((("s" "~" "~")) ("s~"))
((("t" "`" "`")) ("t`"))
((("t" "~" "~")) ("t~"))
((("u" "'" "'")) ("u'"))
((("u" ":" ":")) ("u:"))
((("u" "\"" "\"")) ("u\""))
((("u" "`" "`")) ("u`"))
((("y" "'" "'")) ("y'"))
((("z" "'" "'")) ("z'"))
((("z" "`" "`")) ("z`"))
((("z" "~" "~")) ("z~"))
))

(define elatin-rules-latin-3-alt-postfix '(
((("A" "`")) ("À"))
((("A" "'")) ("Á"))
((("A" "^")) ("Â"))
((("A" "\"")) ("Ä"))
((("C" "/")) ("Ċ"))
((("C" "^")) ("Ĉ"))
((("C" "`")) ("Ç"))
((("E" "`")) ("È"))
((("E" "'")) ("É"))
((("E" "^")) ("Ê"))
((("E" "\"")) ("Ë"))
((("G" "~")) ("Ğ"))
((("G" "/")) ("Ġ"))
((("G" "^")) ("Ĝ"))
((("H" "/")) ("Ħ"))
((("H" "^")) ("Ĥ"))
((("I" "/")) ("İ"))
((("I" "`")) ("Ì"))
((("I" "'")) ("Í"))
((("I" "^")) ("Î"))
((("I" "\"")) ("Ï"))
((("J" "^")) ("Ĵ"))
((("N" "~")) ("Ñ"))
((("O" "`")) ("Ò"))
((("O" "'")) ("Ó"))
((("O" "^")) ("Ô"))
((("O" "\"")) ("Ö"))
((("S" "`")) ("Ş"))
((("S" "^")) ("Ŝ"))
((("U" "`")) ("Ù"))
((("U" "'")) ("Ú"))
((("U" "^")) ("Û"))
((("U" "\"")) ("Ü"))
((("U" "~")) ("Ŭ"))
((("Z" "/")) ("Ż"))
((("a" "`")) ("à"))
((("a" "'")) ("á"))
((("a" "^")) ("â"))
((("a" "\"")) ("ä"))
((("c" "/")) ("ċ"))
((("c" "^")) ("ĉ"))
((("c" "`")) ("ç"))
((("e" "`")) ("è"))
((("e" "'")) ("é"))
((("e" "^")) ("ê"))
((("e" "\"")) ("ë"))
((("g" "~")) ("ğ"))
((("g" "/")) ("ġ"))
((("g" "^")) ("ĝ"))
((("h" "/")) ("ħ"))
((("h" "^")) ("ĥ"))
((("i" "/")) ("ı"))
((("i" "`")) ("ì"))
((("i" "'")) ("í"))
((("i" "^")) ("î"))
((("i" "\"")) ("ï"))
((("j" "^")) ("ĵ"))
((("n" "~")) ("ñ"))
((("o" "`")) ("ò"))
((("o" "'")) ("ó"))
((("o" "^")) ("ô"))
((("o" "\"")) ("ö"))
((("s" "`")) ("ş"))
((("s" "/")) ("ß"))
((("s" "^")) ("ŝ"))
((("u" "`")) ("ù"))
((("u" "'")) ("ú"))
((("u" "^")) ("û"))
((("u" "\"")) ("ü"))
((("u" "~")) ("ŭ"))
((("z" "/")) ("ż"))
((("A" "`" "`")) ("A`"))
((("A" "'" "'")) ("A'"))
((("A" "^" "^")) ("A^"))
((("A" "\"" "\"")) ("A\""))
((("C" "/" "/")) ("C/"))
((("C" "^" "^")) ("C^"))
((("C" "`" "`")) ("C`"))
((("E" "`" "`")) ("E`"))
((("E" "'" "'")) ("E'"))
((("E" "^" "^")) ("E^"))
((("E" "\"" "\"")) ("E\""))
((("G" "~" "~")) ("G~"))
((("G" "/" "/")) ("G/"))
((("G" "^" "^")) ("G^"))
((("H" "/" "/")) ("H/"))
((("H" "^" "^")) ("H^"))
((("I" "/" "/")) ("I/"))
((("I" "`" "`")) ("I`"))
((("I" "'" "'")) ("I'"))
((("I" "^" "^")) ("I^"))
((("I" "\"" "\"")) ("I\""))
((("J" "^" "^")) ("J^"))
((("N" "~" "~")) ("N~"))
((("O" "`" "`")) ("O`"))
((("O" "'" "'")) ("O'"))
((("O" "^" "^")) ("O^"))
((("O" "\"" "\"")) ("O\""))
((("S" "`" "`")) ("S`"))
((("S" "^" "^")) ("S^"))
((("U" "`" "`")) ("U`"))
((("U" "'" "'")) ("U'"))
((("U" "^" "^")) ("U^"))
((("U" "\"" "\"")) ("U\""))
((("U" "~" "~")) ("U~"))
((("Z" "/" "/")) ("Z/"))
((("a" "`" "`")) ("a`"))
((("a" "'" "'")) ("a'"))
((("a" "^" "^")) ("a^"))
((("a" "\"" "\"")) ("a\""))
((("c" "/" "/")) ("c/"))
((("c" "^" "^")) ("c^"))
((("c" "`" "`")) ("c`"))
((("e" "`" "`")) ("e`"))
((("e" "'" "'")) ("e'"))
((("e" "^" "^")) ("e^"))
((("e" "\"" "\"")) ("e\""))
((("g" "~" "~")) ("g~"))
((("g" "/" "/")) ("g/"))
((("g" "^" "^")) ("g^"))
((("h" "/" "/")) ("h/"))
((("h" "^" "^")) ("h^"))
((("i" "/" "/")) ("i/"))
((("i" "`" "`")) ("i`"))
((("i" "'" "'")) ("i'"))
((("i" "^" "^")) ("i^"))
((("i" "\"" "\"")) ("i\""))
((("j" "^" "^")) ("j^"))
((("n" "~" "~")) ("n~"))
((("o" "`" "`")) ("o`"))
((("o" "'" "'")) ("o'"))
((("o" "^" "^")) ("o^"))
((("o" "\"" "\"")) ("o\""))
((("s" "`" "`")) ("s`"))
((("s" "/" "/")) ("s/"))
((("s" "^" "^")) ("s^"))
((("u" "`" "`")) ("u`"))
((("u" "'" "'")) ("u'"))
((("u" "^" "^")) ("u^"))
((("u" "\"" "\"")) ("u\""))
((("u" "~" "~")) ("u~"))
((("z" "/" "/")) ("z/"))
))

(define elatin-rules-latin-4-alt-postfix '(
((("A" "`")) ("Ą"))
((("A" "-")) ("Ā"))
((("A" "'")) ("Á"))
((("A" "^")) ("Â"))
((("A" "~")) ("Ã"))
((("A" "\"")) ("Ä"))
((("A" "/")) ("Å"))
((("C" "~")) ("Č"))
((("D" "/")) ("Đ"))
((("E" "/")) ("Æ"))
((("E" "-")) ("Ē"))
((("E" "'")) ("É"))
((("E" "`")) ("Ę"))
((("E" "\"")) ("Ë"))
((("E" "~")) ("Ė"))
((("G" "`")) ("Ģ"))
((("I" "~")) ("Ĩ"))
((("I" "`")) ("Į"))
((("I" "'")) ("Í"))
((("I" "^")) ("Î"))
((("I" "-")) ("Ī"))
((("K" "`")) ("Ķ"))
((("L" "`")) ("Ļ"))
((("N" "/")) ("Ŋ"))
((("N" "`")) ("Ņ"))
((("O" "-")) ("Ō"))
((("O" "^")) ("Ô"))
((("O" "~")) ("Õ"))
((("O" "\"")) ("Ö"))
((("O" "/")) ("Ø"))
((("R" "`")) ("Ŗ"))
((("S" "~")) ("Š"))
((("T" "/")) ("Ŧ"))
((("U" "`")) ("Ų"))
((("U" "'")) ("Ú"))
((("U" "^")) ("Û"))
((("U" "\"")) ("Ü"))
((("U" "~")) ("Ũ"))
((("U" "-")) ("Ū"))
((("Z" "~")) ("Ž"))
((("a" "`")) ("ą"))
((("a" "-")) ("ā"))
((("a" "'")) ("á"))
((("a" "^")) ("â"))
((("a" "~")) ("ã"))
((("a" "\"")) ("ä"))
((("a" "/")) ("å"))
((("c" "~")) ("č"))
((("d" "/")) ("đ"))
((("e" "/")) ("æ"))
((("e" "-")) ("ē"))
((("e" "'")) ("é"))
((("e" "`")) ("ę"))
((("e" "\"")) ("ë"))
((("e" "~")) ("ė"))
((("g" "`")) ("ģ"))
((("i" "~")) ("ĩ"))
((("i" "`")) ("į"))
((("i" "'")) ("í"))
((("i" "^")) ("î"))
((("i" "-")) ("ī"))
((("k" "/")) ("ĸ"))
((("k" "`")) ("ķ"))
((("l" "`")) ("ļ"))
((("n" "/")) ("ŋ"))
((("n" "`")) ("ņ"))
((("o" "-")) ("ō"))
((("o" "^")) ("ô"))
((("o" "~")) ("õ"))
((("o" "\"")) ("ö"))
((("o" "/")) ("ø"))
((("r" "`")) ("ŗ"))
((("s" "/")) ("ß"))
((("s" "~")) ("š"))
((("t" "/")) ("ŧ"))
((("u" "`")) ("ų"))
((("u" "'")) ("ú"))
((("u" "^")) ("û"))
((("u" "\"")) ("ü"))
((("u" "~")) ("ũ"))
((("u" "-")) ("ū"))
((("z" "~")) ("ž"))
((("A" "`" "`")) ("A`"))
((("A" "-" "-")) ("A-"))
((("A" "'" "'")) ("A'"))
((("A" "^" "^")) ("A^"))
((("A" "~" "~")) ("A~"))
((("A" "\"" "\"")) ("A\""))
((("A" "/" "/")) ("A/"))
((("C" "~" "~")) ("C~"))
((("D" "/" "/")) ("D/"))
((("E" "/" "/")) ("E/"))
((("E" "-" "-")) ("E-"))
((("E" "'" "'")) ("E'"))
((("E" "`" "`")) ("E`"))
((("E" "\"" "\"")) ("E\""))
((("E" "~" "~")) ("E~"))
((("G" "`" "`")) ("G`"))
((("I" "~" "~")) ("I~"))
((("I" "`" "`")) ("I`"))
((("I" "'" "'")) ("I'"))
((("I" "^" "^")) ("I^"))
((("I" "-" "-")) ("I-"))
((("K" "`" "`")) ("K`"))
((("L" "`" "`")) ("L`"))
((("N" "/" "/")) ("N/"))
((("N" "`" "`")) ("N`"))
((("O" "-" "-")) ("O-"))
((("O" "^" "^")) ("O^"))
((("O" "~" "~")) ("O~"))
((("O" "\"" "\"")) ("O\""))
((("O" "/" "/")) ("O/"))
((("R" "`" "`")) ("R`"))
((("S" "~" "~")) ("S~"))
((("T" "/" "/")) ("T/"))
((("U" "`" "`")) ("U`"))
((("U" "'" "'")) ("U'"))
((("U" "^" "^")) ("U^"))
((("U" "\"" "\"")) ("U\""))
((("U" "~" "~")) ("U~"))
((("U" "-" "-")) ("U-"))
((("Z" "~" "~")) ("Z~"))
((("a" "`" "`")) ("a`"))
((("a" "-" "-")) ("a-"))
((("a" "'" "'")) ("a'"))
((("a" "^" "^")) ("a^"))
((("a" "~" "~")) ("a~"))
((("a" "\"" "\"")) ("a\""))
((("a" "/" "/")) ("a/"))
((("c" "~" "~")) ("c~"))
((("d" "/" "/")) ("d/"))
((("e" "/" "/")) ("e/"))
((("e" "-" "-")) ("e-"))
((("e" "'" "'")) ("e'"))
((("e" "`" "`")) ("e`"))
((("e" "\"" "\"")) ("e\""))
((("e" "~" "~")) ("e~"))
((("g" "`" "`")) ("g`"))
((("i" "~" "~")) ("i~"))
((("i" "`" "`")) ("i`"))
((("i" "'" "'")) ("i'"))
((("i" "^" "^")) ("i^"))
((("i" "-" "-")) ("i-"))
((("k" "/" "/")) ("k/"))
((("k" "`" "`")) ("k`"))
((("l" "`" "`")) ("l`"))
((("n" "/" "/")) ("n/"))
((("n" "`" "`")) ("n`"))
((("o" "-" "-")) ("o-"))
((("o" "^" "^")) ("o^"))
((("o" "~" "~")) ("o~"))
((("o" "\"" "\"")) ("o\""))
((("o" "/" "/")) ("o/"))
((("r" "`" "`")) ("r`"))
((("s" "/" "/")) ("s/"))
((("s" "~" "~")) ("s~"))
((("t" "/" "/")) ("t/"))
((("u" "`" "`")) ("u`"))
((("u" "'" "'")) ("u'"))
((("u" "^" "^")) ("u^"))
((("u" "\"" "\"")) ("u\""))
((("u" "~" "~")) ("u~"))
((("u" "-" "-")) ("u-"))
((("z" "~" "~")) ("z~"))
))

(define elatin-rules-latin-5-alt-postfix '(
((("A" "'")) ("Á"))
((("A" "/")) ("Å"))
((("A" "\"")) ("Ä"))
((("A" "^")) ("Â"))
((("A" "`")) ("À"))
((("A" "~")) ("Ã"))
((("C" "`")) ("Ç"))
((("E" "'")) ("É"))
((("E" "/")) ("Æ"))
((("E" "\"")) ("Ë"))
((("E" "^")) ("Ê"))
((("E" "`")) ("È"))
((("G" "~")) ("Ğ"))
((("I" "'")) ("Í"))
((("I" "/")) ("İ"))
((("I" "\"")) ("Ï"))
((("I" "^")) ("Î"))
((("I" "`")) ("Ì"))
((("N" "~")) ("Ñ"))
((("O" "'")) ("Ó"))
((("O" "/")) ("Ø"))
((("O" "\"")) ("Ö"))
((("O" "^")) ("Ô"))
((("O" "`")) ("Ò"))
((("O" "~")) ("Õ"))
((("S" "`")) ("Ş"))
((("U" "'")) ("Ú"))
((("U" "\"")) ("Ü"))
((("U" "^")) ("Û"))
((("U" "`")) ("Ù"))
((("a" "'")) ("á"))
((("a" "/")) ("å"))
((("a" "\"")) ("ä"))
((("a" "^")) ("â"))
((("a" "`")) ("à"))
((("a" "~")) ("ã"))
((("c" "`")) ("ç"))
((("e" "'")) ("é"))
((("e" "/")) ("æ"))
((("e" "\"")) ("ë"))
((("e" "^")) ("ê"))
((("e" "`")) ("è"))
((("g" "~")) ("ğ"))
((("i" "'")) ("í"))
((("i" "/")) ("ı"))
((("i" "\"")) ("ï"))
((("i" "^")) ("î"))
((("i" "`")) ("ì"))
((("n" "~")) ("ñ"))
((("o" "'")) ("ó"))
((("o" "/")) ("ø"))
((("o" "\"")) ("ö"))
((("o" "^")) ("ô"))
((("o" "`")) ("ò"))
((("o" "~")) ("õ"))
((("s" "`")) ("ş"))
((("s" "/")) ("ß"))
((("u" "'")) ("ú"))
((("u" "\"")) ("ü"))
((("u" "^")) ("û"))
((("u" "`")) ("ù"))
((("y" "\"")) ("ÿ"))
((("A" "'" "'")) ("A'"))
((("A" "/" "/")) ("A/"))
((("A" "\"" "\"")) ("A\""))
((("A" "^" "^")) ("A^"))
((("A" "`" "`")) ("A`"))
((("A" "~" "~")) ("A~"))
((("C" "`" "`")) ("C`"))
((("E" "'" "'")) ("E'"))
((("E" "/" "/")) ("E/"))
((("E" "\"" "\"")) ("E\""))
((("E" "^" "^")) ("E^"))
((("E" "`" "`")) ("E`"))
((("G" "~" "~")) ("G~"))
((("I" "'" "'")) ("I'"))
((("I" "/" "/")) ("I/"))
((("I" "\"" "\"")) ("I\""))
((("I" "^" "^")) ("I^"))
((("I" "`" "`")) ("I`"))
((("N" "~" "~")) ("N~"))
((("O" "'" "'")) ("O'"))
((("O" "/" "/")) ("O/"))
((("O" "\"" "\"")) ("O\""))
((("O" "^" "^")) ("O^"))
((("O" "`" "`")) ("O`"))
((("O" "~" "~")) ("O~"))
((("S" "`" "`")) ("S`"))
((("U" "'" "'")) ("U'"))
((("U" "\"" "\"")) ("U\""))
((("U" "^" "^")) ("U^"))
((("U" "`" "`")) ("U`"))
((("a" "'" "'")) ("a'"))
((("a" "/" "/")) ("a/"))
((("a" "\"" "\"")) ("a\""))
((("a" "^" "^")) ("a^"))
((("a" "`" "`")) ("a`"))
((("a" "~" "~")) ("a~"))
((("c" "`" "`")) ("c`"))
((("e" "'" "'")) ("e'"))
((("e" "/" "/")) ("e/"))
((("e" "\"" "\"")) ("e\""))
((("e" "^" "^")) ("e^"))
((("e" "`" "`")) ("e`"))
((("g" "~" "~")) ("g~"))
((("i" "'" "'")) ("i'"))
((("i" "/" "/")) ("i/"))
((("i" "\"" "\"")) ("i\""))
((("i" "^" "^")) ("i^"))
((("i" "`" "`")) ("i`"))
((("n" "~" "~")) ("n~"))
((("o" "'" "'")) ("o'"))
((("o" "/" "/")) ("o/"))
((("o" "\"" "\"")) ("o\""))
((("o" "^" "^")) ("o^"))
((("o" "`" "`")) ("o`"))
((("o" "~" "~")) ("o~"))
((("s" "`" "`")) ("s`"))
((("s" "/" "/")) ("s/"))
((("u" "'" "'")) ("u'"))
((("u" "\"" "\"")) ("u\""))
((("u" "^" "^")) ("u^"))
((("u" "`" "`")) ("u`"))
((("y" "\"" "\"")) ("y\""))
))

(define elatin-rules-danish-alt-postfix '(
((("A" "E")) ("Æ"))
((("a" "e")) ("æ"))
((("O" "E")) ("Ø"))
((("o" "e")) ("ø"))
((("A" "A")) ("Å"))
((("a" "a")) ("å"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("A" "A" "A")) ("AA"))
((("a" "a" "a")) ("aa"))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
))

(define elatin-rules-esperanto-alt-postfix '(
((("C" "x")) ("Ĉ"))
((("C" "^")) ("Ĉ"))
((("c" "x")) ("ĉ"))
((("c" "^")) ("ĉ"))
((("G" "x")) ("Ĝ"))
((("G" "^")) ("Ĝ"))
((("g" "x")) ("ĝ"))
((("g" "^")) ("ĝ"))
((("H" "x")) ("Ĥ"))
((("H" "^")) ("Ĥ"))
((("h" "x")) ("ĥ"))
((("h" "^")) ("ĥ"))
((("J" "x")) ("Ĵ"))
((("J" "^")) ("Ĵ"))
((("j" "x")) ("ĵ"))
((("j" "^")) ("ĵ"))
((("S" "x")) ("Ŝ"))
((("S" "^")) ("Ŝ"))
((("s" "x")) ("ŝ"))
((("s" "^")) ("ŝ"))
((("U" "x")) ("Ŭ"))
((("U" "^")) ("Ŭ"))
((("u" "x")) ("ŭ"))
((("u" "^")) ("ŭ"))
((("C" "x" "x")) ("Cx"))
((("C" "^" "^")) ("C^"))
((("c" "x" "x")) ("cx"))
((("c" "^" "^")) ("c^"))
((("G" "x" "x")) ("Gx"))
((("G" "^" "^")) ("G^"))
((("g" "x" "x")) ("gx"))
((("g" "^" "^")) ("g^"))
((("H" "x" "x")) ("Hx"))
((("H" "^" "^")) ("H^"))
((("h" "x" "x")) ("hx"))
((("h" "^" "^")) ("h^"))
((("J" "x" "x")) ("Jx"))
((("J" "^" "^")) ("J^"))
((("j" "x" "x")) ("jx"))
((("j" "^" "^")) ("j^"))
((("S" "x" "x")) ("Sx"))
((("S" "^" "^")) ("S^"))
((("s" "x" "x")) ("sx"))
((("s" "^" "^")) ("s^"))
((("U" "x" "x")) ("Ux"))
((("U" "^" "^")) ("U^"))
((("u" "x" "x")) ("ux"))
((("u" "^" "^")) ("u^"))
))

(define elatin-rules-finnish-alt-postfix '(
((("A" "E")) ("Ä"))
((("a" "e")) ("ä"))
((("O" "E")) ("Ö"))
((("o" "e")) ("ö"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
))

(define elatin-rules-french-alt-postfix '(
((("A" "`")) ("À"))
((("A" "^")) ("Â"))
((("a" "`")) ("à"))
((("a" "^")) ("â"))
((("E" "`")) ("È"))
((("E" "'")) ("É"))
((("E" "^")) ("Ê"))
((("E" "\"")) ("Ë"))
((("e" "`")) ("è"))
((("e" "'")) ("é"))
((("e" "^")) ("ê"))
((("e" "\"")) ("ë"))
((("I" "^")) ("Î"))
((("I" "\"")) ("Ï"))
((("i" "^")) ("î"))
((("i" "\"")) ("ï"))
((("O" "^")) ("Ô"))
((("o" "^")) ("ô"))
((("U" "`")) ("Ù"))
((("U" "^")) ("Û"))
((("U" "\"")) ("Ü"))
((("u" "`")) ("ù"))
((("u" "^")) ("û"))
((("u" "\"")) ("ü"))
((("C" "/")) ("Ç"))
((("c" "/")) ("ç"))
((("<" "<")) ("«"))
(((">" ">")) ("»"))
((("A" "`" "`")) ("A`"))
((("A" "^" "^")) ("A^"))
((("a" "`" "`")) ("a`"))
((("a" "^" "^")) ("a^"))
((("E" "`" "`")) ("E`"))
((("E" "'" "'")) ("E'"))
((("E" "^" "^")) ("E^"))
((("E" "\"" "\"")) ("E\""))
((("e" "`" "`")) ("e`"))
((("e" "'" "'")) ("e'"))
((("e" "^" "^")) ("e^"))
((("e" "\"" "\"")) ("e\""))
((("I" "^" "^")) ("I^"))
((("I" "\"" "\"")) ("I\""))
((("i" "^" "^")) ("i^"))
((("i" "\"" "\"")) ("i\""))
((("O" "^" "^")) ("O^"))
((("o" "^" "^")) ("o^"))
((("U" "`" "`")) ("U`"))
((("U" "^" "^")) ("U^"))
((("U" "\"" "\"")) ("U\""))
((("u" "`" "`")) ("u`"))
((("u" "^" "^")) ("u^"))
((("u" "\"" "\"")) ("u\""))
((("C" "/" "/")) ("C/"))
((("c" "/" "/")) ("c/"))
((("<" "<" "<")) ("<<"))
(((">" ">" ">")) (">>"))
))

(define elatin-rules-german-alt-postfix '(
((("A" "E")) ("Ä"))
((("a" "e")) ("ä"))
((("O" "E")) ("Ö"))
((("o" "e")) ("ö"))
((("U" "E")) ("Ü"))
((("u" "e")) ("ü"))
((("s" "z")) ("ß"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("U" "E" "E")) ("UE"))
((("u" "e" "e")) ("ue"))
((("s" "z" "z")) ("sz"))
))

(define elatin-rules-icelandic-alt-postfix '(
((("A" "'")) ("Á"))
((("a" "'")) ("á"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("I" "'")) ("Í"))
((("i" "'")) ("í"))
((("O" "'")) ("Ó"))
((("o" "'")) ("ó"))
((("U" "'")) ("Ú"))
((("u" "'")) ("ú"))
((("Y" "'")) ("Ý"))
((("y" "'")) ("ý"))
((("A" "E")) ("Æ"))
((("a" "e")) ("æ"))
((("O" "E")) ("Ö"))
((("o" "e")) ("ö"))
((("D" "/")) ("Ð"))
((("d" "/")) ("ð"))
((("T" "/")) ("Þ"))
((("t" "/")) ("þ"))
((("A" "'" "'")) ("A'"))
((("a" "'" "'")) ("a'"))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
((("I" "'" "'")) ("I'"))
((("i" "'" "'")) ("i'"))
((("O" "'" "'")) ("O'"))
((("o" "'" "'")) ("o'"))
((("U" "'" "'")) ("U'"))
((("u" "'" "'")) ("u'"))
((("Y" "'" "'")) ("Y'"))
((("y" "'" "'")) ("y'"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("D" "/" "/")) ("D/"))
((("d" "/" "/")) ("d/"))
((("T" "/" "/")) ("T/"))
((("t" "/" "/")) ("t/"))
))

(define elatin-rules-italian-alt-postfix '(
((("A" "`")) ("À"))
((("A" "'")) ("Á"))
((("a" "`")) ("à"))
((("a" "'")) ("á"))
((("E" "`")) ("È"))
((("E" "'")) ("É"))
((("e" "`")) ("è"))
((("e" "'")) ("é"))
((("I" "`")) ("Ì"))
((("i" "`")) ("ì"))
((("I" "'")) ("Í"))
((("i" "'")) ("í"))
((("I" "^")) ("Î"))
((("i" "^")) ("î"))
((("O" "`")) ("Ò"))
((("o" "`")) ("ò"))
((("O" "'")) ("Ó"))
((("o" "'")) ("ó"))
((("U" "`")) ("Ù"))
((("u" "`")) ("ù"))
((("U" "'")) ("Ú"))
((("u" "'")) ("ú"))
((("<" "<")) ("«"))
(((">" ">")) ("»"))
((("o" "_")) ("º"))
((("a" "_")) ("ª"))
((("A" "`" "`")) ("A`"))
((("A" "'" "'")) ("A'"))
((("a" "`" "`")) ("a`"))
((("a" "'" "'")) ("a'"))
((("E" "`" "`")) ("E`"))
((("E" "'" "'")) ("E'"))
((("e" "`" "`")) ("e`"))
((("e" "'" "'")) ("e'"))
((("I" "`" "`")) ("I`"))
((("i" "`" "`")) ("i`"))
((("I" "'" "'")) ("I'"))
((("i" "'" "'")) ("i'"))
((("I" "^" "^")) ("I^"))
((("i" "^" "^")) ("i^"))
((("O" "`" "`")) ("O`"))
((("o" "`" "`")) ("o`"))
((("O" "'" "'")) ("O'"))
((("o" "'" "'")) ("o'"))
((("U" "`" "`")) ("U`"))
((("u" "`" "`")) ("u`"))
((("U" "'" "'")) ("U'"))
((("u" "'" "'")) ("u'"))
((("<" "<" "<")) ("<<"))
(((">" ">" ">")) (">>"))
((("o" "_" "_")) ("o_"))
((("a" "_" "_")) ("a_"))
))

(define elatin-rules-norwegian-alt-postfix '(
((("A" "E")) ("Æ"))
((("a" "e")) ("æ"))
((("O" "E")) ("Ø"))
((("o" "e")) ("ø"))
((("A" "A")) ("Å"))
((("a" "a")) ("å"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("A" "A" "A")) ("AA"))
((("a" "a" "a")) ("aa"))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
))

(define elatin-rules-scandinavian-alt-postfix '(
((("A" "E")) ("Æ"))
((("a" "e")) ("æ"))
((("O" "E")) ("Ø"))
((("o" "e")) ("ø"))
((("A" "A")) ("Å"))
((("a" "a")) ("å"))
((("A" "\"")) ("Ä"))
((("a" "\"")) ("ä"))
((("O" "\"")) ("Ö"))
((("o" "\"")) ("ö"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("A" "A" "A")) ("AA"))
((("a" "a" "a")) ("aa"))
((("A" "\"" "\"")) ("A\""))
((("a" "\"" "\"")) ("a\""))
((("O" "\"" "\"")) ("O\""))
((("o" "\"" "\"")) ("o\""))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
))

(define elatin-rules-spanish-alt-postfix '(
((("A" "'")) ("Á"))
((("a" "'")) ("á"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("I" "'")) ("Í"))
((("i" "'")) ("í"))
((("O" "'")) ("Ó"))
((("o" "'")) ("ó"))
((("U" "'")) ("Ú"))
((("u" "'")) ("ú"))
((("N" "~")) ("Ñ"))
((("n" "~")) ("ñ"))
((("?" "/")) ("¿"))
((("!" "/")) ("¡"))
((("A" "'" "'")) ("A'"))
((("a" "'" "'")) ("a'"))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
((("I" "'" "'")) ("I'"))
((("i" "'" "'")) ("i'"))
((("O" "'" "'")) ("O'"))
((("o" "'" "'")) ("o'"))
((("U" "'" "'")) ("U'"))
((("u" "'" "'")) ("u'"))
((("N" "~" "~")) ("N~"))
((("n" "~" "~")) ("n~"))
((("?" "/" "/")) ("?/"))
((("!" "/" "/")) ("!/"))
))

(define elatin-rules-swedish-alt-postfix '(
((("A" "A")) ("Å"))
((("a" "a")) ("å"))
((("A" "E")) ("Ä"))
((("a" "e")) ("ä"))
((("O" "E")) ("Ö"))
((("o" "e")) ("ö"))
((("E" "'")) ("É"))
((("e" "'")) ("é"))
((("A" "A" "A")) ("AA"))
((("a" "a" "a")) ("aa"))
((("A" "E" "E")) ("AE"))
((("a" "e" "e")) ("ae"))
((("O" "E" "E")) ("OE"))
((("o" "e" "e")) ("oe"))
((("E" "'" "'")) ("E'"))
((("e" "'" "'")) ("e'"))
))

(define elatin-rules-turkish-latin-3-alt-postfix '(
((("A" "^")) ("Â"))
((("a" "^")) ("â"))
((("C" "`")) ("Ç"))
((("c" "`")) ("ç"))
((("G" "^")) ("Ğ"))
((("g" "^")) ("ğ"))
((("I" "/")) ("İ"))
((("i")) ("ı"))
((("i" "/")) ("i"))
((("O" "\"")) ("Ö"))
((("o" "\"")) ("ö"))
((("S" "`")) ("Ş"))
((("s" "`")) ("ş"))
((("U" "\"")) ("Ü"))
((("u" "\"")) ("ü"))
((("U" "^")) ("Û"))
((("u" "^")) ("û"))
((("A" "^" "^")) ("A^"))
((("a" "^" "^")) ("a^"))
((("C" "`" "`")) ("C`"))
((("c" "`" "`")) ("c`"))
((("G" "^" "^")) ("G^"))
((("g" "^" "^")) ("g^"))
((("I" "/" "/")) ("I/"))
((("i")) ("i"))
((("i" "/" "/")) ("i/"))
((("O" "\"" "\"")) ("O\""))
((("o" "\"" "\"")) ("o\""))
((("S" "`" "`")) ("S`"))
((("s" "`" "`")) ("s`"))
((("U" "\"" "\"")) ("U\""))
((("u" "\"" "\"")) ("u\""))
((("U" "^" "^")) ("U^"))
((("u" "^" "^")) ("u^"))
))

(define elatin-rules-turkish-alt-postfix '(
((("A" "^")) ("Â"))
((("a" "^")) ("â"))
((("C" "`")) ("Ç"))
((("c" "`")) ("ç"))
((("G" "^")) ("Ğ"))
((("g" "^")) ("ğ"))
((("I" "/")) ("İ"))
((("i")) ("ı"))
((("i" "/")) ("i"))
((("O" "\"")) ("Ö"))
((("o" "\"")) ("ö"))
((("S" "`")) ("Ş"))
((("s" "`")) ("ş"))
((("U" "\"")) ("Ü"))
((("u" "\"")) ("ü"))
((("U" "^")) ("Û"))
((("u" "^")) ("û"))
((("A" "^" "^")) ("A^"))
((("a" "^" "^")) ("a^"))
((("C" "`" "`")) ("C`"))
((("c" "`" "`")) ("c`"))
((("G" "^" "^")) ("G^"))
((("g" "^" "^")) ("g^"))
((("I" "/" "/")) ("I/"))
((("i")) ("i"))
((("i" "/" "/")) ("i/"))
((("O" "\"" "\"")) ("O\""))
((("o" "\"" "\"")) ("o\""))
((("S" "`" "`")) ("S`"))
((("s" "`" "`")) ("s`"))
((("U" "\"" "\"")) ("U\""))
((("u" "\"" "\"")) ("u\""))
((("U" "^" "^")) ("U^"))
((("u" "^" "^")) ("u^"))
))

(define elatin-rules-dutch '(
((("f" "l" ".")) ("ƒ"))
((("e" "u" "r" ".")) ("€"))
((("i" "j")) ("ĳ"))
((("I" "J")) ("Ĳ"))
((("\"" "a")) ("ä"))
((("\"" "e")) ("ë"))
((("\"" "i")) ("ï"))
((("\"" "o")) ("ö"))
((("\"" "u")) ("ü"))
((("\"" "A")) ("Ä"))
((("\"" "E")) ("Ë"))
((("\"" "I")) ("Ï"))
((("\"" "O")) ("Ö"))
((("\"" "U")) ("Ü"))
((("a" "'")) ("á"))
((("e" "'")) ("é"))
((("i" "'")) ("í"))
((("o" "'")) ("ó"))
((("u" "'")) ("ú"))
((("A" "'")) ("Á"))
((("E" "'")) ("É"))
((("I" "'")) ("Í"))
((("O" "'")) ("Ó"))
((("U" "'")) ("Ú"))
((("a" "`")) ("à"))
((("e" "`")) ("è"))
((("i" "`")) ("ì"))
((("o" "`")) ("ò"))
((("u" "`")) ("ù"))
((("A" "`")) ("À"))
((("E" "`")) ("È"))
((("I" "`")) ("Ì"))
((("O" "`")) ("Ò"))
((("U" "`")) ("Ù"))
((("c" ",")) ("ç"))
((("C" ",")) ("Ç"))
((("a" "^")) ("â"))
((("e" "^")) ("ê"))
((("i" "^")) ("î"))
((("o" "^")) ("ô"))
((("u" "^")) ("û"))
((("A" "^")) ("Â"))
((("E" "^")) ("Ê"))
((("I" "^")) ("Î"))
((("O" "^")) ("Ô"))
((("U" "^")) ("Û"))
((("i" "/")) ("ı"))
((("s" ",")) ("ş"))
((("g" "^")) ("ğ"))
((("I" "/")) ("İ"))
((("S" ",")) ("Ş"))
((("G" "^")) ("Ğ"))
))

(define elatin-rules-lithuanian-numeric '(
((("1")) ("ą"))
((("2")) ("č"))
((("3")) ("ę"))
((("4")) ("ė"))
((("5")) ("į"))
((("6")) ("š"))
((("7")) ("ų"))
((("8")) ("ū"))
((("9")) ("„"))
((("0")) ("“"))
((("=")) ("ž"))
((("!")) ("Ą"))
((("@")) ("Č"))
((("#")) ("Ę"))
((("$")) ("Ė"))
((("%")) ("Į"))
((("^")) ("Š"))
((("&")) ("Ų"))
((("*")) ("Ū"))
((("+")) ("Ž"))
))

(define elatin-rules-lithuanian-keyboard '(
((("1")) ("ą"))
((("!")) ("Ą"))
((("2")) ("č"))
((("@")) ("Č"))
((("#")) ("Ę"))
((("4")) ("ė"))
((("$")) ("Ė"))
((("5")) ("į"))
((("%")) ("Į"))
((("6")) ("š"))
((("^")) ("Š"))
((("7")) ("ų"))
((("&")) ("Ų"))
((("9")) ("„"))
((("0")) ("“"))
((("=")) ("ž"))
((("+")) ("Ž"))
))

(define elatin-rules-latvian-keyboard '(
((("4")) ("€"))
((("$")) ("¢"))
((("e")) ("ē"))
((("E")) ("Ē"))
((("r")) ("ŗ"))
((("R")) ("Ŗ"))
((("u")) ("ū"))
((("U")) ("Ū"))
((("i")) ("ī"))
((("I")) ("Ī"))
((("o")) ("ō"))
((("O")) ("Ō"))
((("a")) ("ā"))
((("A")) ("Ā"))
((("s")) ("š"))
((("S")) ("Š"))
((("g")) ("ģ"))
((("G")) ("Ģ"))
((("k")) ("ķ"))
((("K")) ("Ķ"))
((("l")) ("ļ"))
((("L")) ("Ļ"))
((("'")) ("“"))
((("\"")) ("„"))
((("z")) ("ž"))
((("Z")) ("Ž"))
((("c")) ("č"))
((("C")) ("Č"))
((("n")) ("ņ"))
((("N")) ("Ņ"))
))

(define elatin-rules-latin-alt-postfix '(
(((" " "_")) (" "))
((("!" "/")) ("¡"))
((("/" "/")) ("°"))
((("<" "<")) ("«"))
(((">" ">")) ("»"))
((("?" "/")) ("¿"))
((("$" "/")) ("£"))
((("$" "/")) ("¤"))
((("A" "'")) ("Á"))
((("A" "-")) ("Ā"))
((("A" "/")) ("Å"))
((("A" "\"")) ("Ä"))
((("A" "^")) ("Â"))
((("A" "`")) ("À"))
((("A" "`")) ("Ą"))
((("A" "~")) ("Ã"))
((("A" "~")) ("Ă"))
((("C" "'")) ("Ć"))
((("C" "/")) ("Ç"))
((("C" "/")) ("Ċ"))
((("C" "^")) ("Ĉ"))
((("C" "`")) ("Ç"))
((("C" "~")) ("Č"))
((("D" "/")) ("Ð"))
((("D" "/")) ("Đ"))
((("D" "~")) ("Ď"))
((("E" "'")) ("É"))
((("E" "-")) ("Ē"))
((("E" "/")) ("Æ"))
((("E" "\"")) ("Ë"))
((("E" "^")) ("Ê"))
((("E" "`")) ("È"))
((("E" "`")) ("Ę"))
((("E" "~")) ("Ė"))
((("E" "~")) ("Ě"))
((("G" "/")) ("Ġ"))
((("G" "^")) ("Ĝ"))
((("G" "`")) ("Ģ"))
((("G" "~")) ("Ğ"))
((("H" "/")) ("Ħ"))
((("H" "^")) ("Ĥ"))
((("I" "'")) ("Í"))
((("I" "-")) ("Ī"))
((("I" "/")) ("İ"))
((("I" "\"")) ("Ï"))
((("I" "^")) ("Î"))
((("I" "`")) ("Ì"))
((("I" "`")) ("Į"))
((("I" "~")) ("Ĩ"))
((("J" "^")) ("Ĵ"))
((("K" "`")) ("Ķ"))
((("L" "'")) ("Ĺ"))
((("L" "/")) ("Ł"))
((("L" "`")) ("Ļ"))
((("L" "~")) ("Ľ"))
((("N" "'")) ("Ń"))
((("N" "/")) ("Ŋ"))
((("N" "`")) ("Ņ"))
((("N" "~")) ("Ñ"))
((("N" "~")) ("Ň"))
((("O" "'")) ("Ó"))
((("O" "-")) ("Ō"))
((("O" "/")) ("Ø"))
((("O" ":")) ("Ő"))
((("O" "\"")) ("Ö"))
((("O" "^")) ("Ô"))
((("O" "`")) ("Ò"))
((("O" "~")) ("Õ"))
((("R" "'")) ("Ŕ"))
((("R" "`")) ("Ŗ"))
((("R" "~")) ("Ř"))
((("S" "'")) ("Ś"))
((("S" "^")) ("Ŝ"))
((("S" "`")) ("Ş"))
((("S" "~")) ("Š"))
((("T" "/")) ("Þ"))
((("T" "/")) ("Ŧ"))
((("T" "`")) ("Ţ"))
((("T" "~")) ("Ť"))
((("U" "'")) ("Ú"))
((("U" "-")) ("Ū"))
((("U" ":")) ("Ű"))
((("U" "\"")) ("Ü"))
((("U" "^")) ("Û"))
((("U" "`")) ("Ù"))
((("U" "`")) ("Ů"))
((("U" "`")) ("Ų"))
((("U" "~")) ("Ũ"))
((("U" "~")) ("Ŭ"))
((("Y" "'")) ("Ý"))
((("Y" "\"")) ("Ÿ"))
((("Y" "=")) ("¥"))
((("Z" "'")) ("Ź"))
((("Z" "/")) ("Ż"))
((("Z" "`")) ("Ż"))
((("Z" "~")) ("Ž"))
((("a" "'")) ("á"))
((("a" "-")) ("ā"))
((("a" "/")) ("å"))
((("a" "\"")) ("ä"))
((("a" "^")) ("â"))
((("a" "_")) ("ª"))
((("a" "`")) ("à"))
((("a" "`")) ("ą"))
((("a" "~")) ("ã"))
((("a" "~")) ("ă"))
((("c" "'")) ("ć"))
((("c" "/")) ("ç"))
((("c" "/")) ("ċ"))
((("c" "/")) ("¢"))
((("c" "^")) ("ĉ"))
((("c" "`")) ("ç"))
((("c" "~")) ("č"))
((("d" "/")) ("ð"))
((("d" "/")) ("đ"))
((("d" "~")) ("ď"))
((("e" "'")) ("é"))
((("e" "-")) ("ē"))
((("e" "/")) ("æ"))
((("e" "\"")) ("ë"))
((("e" "^")) ("ê"))
((("e" "`")) ("è"))
((("e" "`")) ("ę"))
((("e" "~")) ("ė"))
((("e" "~")) ("ě"))
((("e" "=")) ("€"))
((("g" "/")) ("ġ"))
((("g" "^")) ("ĝ"))
((("g" "`")) ("ģ"))
((("g" "~")) ("ğ"))
((("h" "/")) ("ħ"))
((("h" "^")) ("ĥ"))
((("i" "'")) ("í"))
((("i" "-")) ("ī"))
((("i" "/")) ("ı"))
((("i" "\"")) ("ï"))
((("i" "^")) ("î"))
((("i" "`")) ("ì"))
((("i" "`")) ("į"))
((("i" "~")) ("ĩ"))
((("j" "^")) ("ĵ"))
((("k" "/")) ("ĸ"))
((("k" "`")) ("ķ"))
((("l" "'")) ("ĺ"))
((("l" "/")) ("ł"))
((("l" "`")) ("ļ"))
((("l" "~")) ("ľ"))
((("n" "'")) ("ń"))
((("n" "/")) ("ŋ"))
((("n" "`")) ("ņ"))
((("n" "~")) ("ñ"))
((("n" "~")) ("ň"))
((("o" "'")) ("ó"))
((("o" "-")) ("ō"))
((("o" "/")) ("ø"))
((("o" ":")) ("ő"))
((("o" "\"")) ("ö"))
((("o" "^")) ("ô"))
((("o" "_")) ("º"))
((("o" "`")) ("ò"))
((("o" "~")) ("õ"))
((("r" "'")) ("ŕ"))
((("r" "`")) ("ŗ"))
((("r" "~")) ("ř"))
((("s" "'")) ("ś"))
((("s" "/")) ("ß"))
((("s" "^")) ("ŝ"))
((("s" "`")) ("ş"))
((("s" "~")) ("š"))
((("t" "/")) ("þ"))
((("t" "/")) ("ŧ"))
((("t" "`")) ("ţ"))
((("t" "~")) ("ť"))
((("u" "'")) ("ú"))
((("u" "-")) ("ū"))
((("u" ":")) ("ű"))
((("u" "\"")) ("ü"))
((("u" "^")) ("û"))
((("u" "`")) ("ù"))
((("u" "`")) ("ů"))
((("u" "`")) ("ų"))
((("u" "~")) ("ũ"))
((("u" "~")) ("ŭ"))
((("y" "'")) ("ý"))
((("y" "\"")) ("ÿ"))
((("z" "'")) ("ź"))
((("z" "/")) ("ż"))
((("z" "`")) ("ż"))
((("z" "~")) ("ž"))
(((" " "_" "_")) (" _"))
((("!" "/" "/")) ("!/"))
((("<" "<" "<")) ("<<"))
(((">" ">" ">")) (">>"))
((("?" "/" "/")) ("?/"))
((("/" "/" "/")) ("//"))
((("$" "/" "/")) ("$/"))
((("A" "'" "'")) ("A'"))
((("A" "-" "-")) ("A-"))
((("A" "/" "/")) ("A/"))
((("A" "\"" "\"")) ("A\""))
((("A" "^" "^")) ("A^"))
((("A" "`" "`")) ("A`"))
((("A" "~" "~")) ("A~"))
((("C" "'" "'")) ("C'"))
((("C" "/" "/")) ("C/"))
((("C" "^" "^")) ("C^"))
((("C" "`" "`")) ("C`"))
((("C" "~" "~")) ("C~"))
((("D" "/" "/")) ("D/"))
((("D" "~" "~")) ("D~"))
((("E" "'" "'")) ("E'"))
((("E" "-" "-")) ("E-"))
((("E" "/" "/")) ("E/"))
((("E" "\"" "\"")) ("E\""))
((("E" "^" "^")) ("E^"))
((("E" "`" "`")) ("E`"))
((("E" "~" "~")) ("E~"))
((("G" "/" "/")) ("G/"))
((("G" "^" "^")) ("G^"))
((("G" "`" "`")) ("G`"))
((("G" "~" "~")) ("G~"))
((("H" "/" "/")) ("H/"))
((("H" "^" "^")) ("H^"))
((("I" "'" "'")) ("I'"))
((("I" "-" "-")) ("I-"))
((("I" "/" "/")) ("I/"))
((("I" "\"" "\"")) ("I\""))
((("I" "^" "^")) ("I^"))
((("I" "`" "`")) ("I`"))
((("I" "~" "~")) ("I~"))
((("J" "^" "^")) ("J^"))
((("K" "`" "`")) ("K`"))
((("L" "'" "'")) ("L'"))
((("L" "/" "/")) ("L/"))
((("L" "`" "`")) ("L`"))
((("L" "~" "~")) ("L~"))
((("N" "'" "'")) ("N'"))
((("N" "/" "/")) ("N/"))
((("N" "`" "`")) ("N`"))
((("N" "~" "~")) ("N~"))
((("O" "'" "'")) ("O'"))
((("O" "-" "-")) ("O-"))
((("O" "/" "/")) ("O/"))
((("O" ":" ":")) ("O:"))
((("O" "\"" "\"")) ("O\""))
((("O" "^" "^")) ("O^"))
((("O" "`" "`")) ("O`"))
((("O" "~" "~")) ("O~"))
((("R" "'" "'")) ("R'"))
((("R" "`" "`")) ("R`"))
((("R" "~" "~")) ("R~"))
((("S" "'" "'")) ("S'"))
((("S" "^" "^")) ("S^"))
((("S" "`" "`")) ("S`"))
((("S" "~" "~")) ("S~"))
((("T" "/" "/")) ("T/"))
((("T" "`" "`")) ("T`"))
((("T" "~" "~")) ("T~"))
((("U" "'" "'")) ("U'"))
((("U" "-" "-")) ("U-"))
((("U" ":" ":")) ("U:"))
((("U" "\"" "\"")) ("U\""))
((("U" "^" "^")) ("U^"))
((("U" "`" "`")) ("U`"))
((("U" "~" "~")) ("U~"))
((("Y" "'" "'")) ("Y'"))
((("Z" "'" "'")) ("Z'"))
((("Z" "/" "/")) ("Z/"))
((("Z" "`" "`")) ("Z`"))
((("Z" "~" "~")) ("Z~"))
((("a" "'" "'")) ("a'"))
((("a" "-" "-")) ("a-"))
((("a" "/" "/")) ("a/"))
((("a" "\"" "\"")) ("a\""))
((("a" "^" "^")) ("a^"))
((("a" "_" "_")) ("a_"))
((("a" "`" "`")) ("a`"))
((("a" "~" "~")) ("a~"))
((("c" "'" "'")) ("c'"))
((("c" "/" "/")) ("c/"))
((("c" "^" "^")) ("c^"))
((("c" "`" "`")) ("c`"))
((("c" "~" "~")) ("c~"))
((("d" "/" "/")) ("d/"))
((("d" "~" "~")) ("d~"))
((("e" "'" "'")) ("e'"))
((("e" "-" "-")) ("e-"))
((("e" "/" "/")) ("e/"))
((("e" "\"" "\"")) ("e\""))
((("e" "^" "^")) ("e^"))
((("e" "`" "`")) ("e`"))
((("e" "~" "~")) ("e~"))
((("e" "=" "=")) ("e="))
((("g" "/" "/")) ("g/"))
((("g" "^" "^")) ("g^"))
((("g" "`" "`")) ("g`"))
((("g" "~" "~")) ("g~"))
((("h" "/" "/")) ("h/"))
((("h" "^" "^")) ("h^"))
((("i" "'" "'")) ("i'"))
((("i" "-" "-")) ("i-"))
((("i" "/" "/")) ("i/"))
((("i" "\"" "\"")) ("i\""))
((("i" "^" "^")) ("i^"))
((("i" "`" "`")) ("i`"))
((("i" "~" "~")) ("i~"))
((("j" "^" "^")) ("j^"))
((("k" "/" "/")) ("k/"))
((("k" "`" "`")) ("k`"))
((("l" "'" "'")) ("l'"))
((("l" "/" "/")) ("l/"))
((("l" "`" "`")) ("l`"))
((("l" "~" "~")) ("l~"))
((("n" "'" "'")) ("n'"))
((("n" "/" "/")) ("n/"))
((("n" "`" "`")) ("n`"))
((("n" "~" "~")) ("n~"))
((("o" "'" "'")) ("o'"))
((("o" "-" "-")) ("o-"))
((("o" "/" "/")) ("o/"))
((("o" ":" ":")) ("o:"))
((("o" "\"" "\"")) ("o\""))
((("o" "^" "^")) ("o^"))
((("o" "_" "_")) ("o_"))
((("o" "`" "`")) ("o`"))
((("o" "~" "~")) ("o~"))
((("r" "'" "'")) ("r'"))
((("r" "`" "`")) ("r`"))
((("r" "~" "~")) ("r~"))
((("s" "'" "'")) ("s'"))
((("s" "/" "/")) ("s/"))
((("s" "^" "^")) ("s^"))
((("s" "`" "`")) ("s`"))
((("s" "~" "~")) ("s~"))
((("t" "/" "/")) ("t/"))
((("t" "`" "`")) ("t`"))
((("t" "~" "~")) ("t~"))
((("u" "'" "'")) ("u'"))
((("u" "-" "-")) ("u-"))
((("u" ":" ":")) ("u:"))
((("u" "\"" "\"")) ("u\""))
((("u" "^" "^")) ("u^"))
((("u" "`" "`")) ("u`"))
((("u" "~" "~")) ("u~"))
((("y" "'" "'")) ("y'"))
((("y" "\"" "\"")) ("y\""))
((("z" "'" "'")) ("z'"))
((("z" "/" "/")) ("z/"))
((("z" "`" "`")) ("z`"))
((("z" "~" "~")) ("z~"))
))

;; Local Variables:
;; mode: scheme
;; coding: utf-8
;; End:
