# LaTeX::Encode character encoding table

package LaTeX::Encode::EncodingTable;

use strict;
use warnings;
use vars qw(@EXPORT %latex_encoding $encoded_char_re);
use base 'Exporter';

@EXPORT = qw(%latex_encoding $encoded_char_re);

%latex_encoding = (
  chr(0x23)  => '\\#',                          # # - &#35;
  chr(0x24)  => '\\$',                          # $ - &#36;
  chr(0x25)  => '\\%',                          # % - &#37;
  chr(0x26)  => '\\&',                          # & - &amp;
  chr(0x5c)  => '\\textbackslash',              # \ - &#92;
  chr(0x5e)  => '\\^{ }',                       # ^ - &#94;
  chr(0x5f)  => '\\_',                          # _ - &#95;
  chr(0x7b)  => '\\{',                          # { - &#123;
  chr(0x7d)  => '\\}',                          # } - &#125;
  chr(0x7e)  => '\\texttildelow',               # ~ - &#126;
  chr(0xa0)  => '~',                            #  - &nbsp;
  chr(0xa1)  => '\\textexclamdown',             #  - &iexcl;
  chr(0xa2)  => '\\textcent',                   #  - &cent;
  chr(0xa3)  => '\\textsterling',               #  - &pound;
  chr(0xa4)  => '\\textcurrency',               #  - &curren;
  chr(0xa5)  => '\\textyen',                    #  - &yen;
  chr(0xa6)  => '\\textbrokenbar',              #  - &brvbar;
  chr(0xa7)  => '\\textsection',                #  - &sect;
  chr(0xa8)  => '\\textasciidieresis',          #  - &uml;
  chr(0xa9)  => '\\textcopyright',              #  - &copy;
  chr(0xaa)  => '\\textordfeminine',            #  - &ordf;
  chr(0xab)  => '\\guillemotleft',              #  - &laquo;
  chr(0xac)  => '\\textlnot',                   #  - &not;
  chr(0xad)  => '\\-',                          #  - &shy;
  chr(0xae)  => '\\textregistered',             #  - &reg;
  chr(0xaf)  => '\\textasciimacron',            #  - &macr;
  chr(0xb0)  => '\\textdegree',                 #  - &deg;
  chr(0xb1)  => '\\textpm',                     #  - &plusmn;
  chr(0xb2)  => '\\texttwosuperior',            #  - &sup2;
  chr(0xb3)  => '\\textthreesuperior',          #  - &sup3;
  chr(0xb4)  => '\\textasciiacute',             #  - &acute;
  chr(0xb5)  => '\\textmu',                     #  - &micro;
  chr(0xb6)  => '\\textparagraph',              #  - &para;
  chr(0xb7)  => '\\textperiodcentered',         #  - &middot;
  chr(0xb8)  => '\\c{}',                          #  - &cedil;
  chr(0xb9)  => '\\textonesuperior',            #  - &sup1;
  chr(0xba)  => '\\textordmasculine',           #  - &ordm;
  chr(0xbb)  => '\\guillemotright',             #  - &raquo;
  chr(0xbc)  => '\\textonequarter',             #  - &frac14;
  chr(0xbd)  => '\\textonehalf',                #  - &frac12;
  chr(0xbe)  => '\\textthreequarters',          #  - &frac34;
  chr(0xbf)  => '\\textquestiondown',           #  - &iquest;
  chr(0xc0)  => '\\`A',                         #  - &Agrave;
  chr(0xc1)  => '\\\'A',                        #  - &Aacute;
  chr(0xc2)  => '\\^A',                         #  - &Acirc;
  chr(0xc3)  => '\\~A',                         #  - &Atilde;
  chr(0xc4)  => '\\"A',                         #  - &Auml;
  chr(0xc5)  => '\\AA',                         #  - &Aring;
  chr(0xc6)  => '\\AE',                         #  - &AElig;
  chr(0xc7)  => '\\c{C}',                       #  - &Ccedil;
  chr(0xc8)  => '\\`E',                         #  - &Egrave;
  chr(0xc9)  => '\\\'E',                        #  - &Eacute;
  chr(0xca)  => '\\^E',                         #  - &Ecirc;
  chr(0xcb)  => '\\"E',                         #  - &Euml;
  chr(0xcc)  => '\\`I',                         #  - &Igrave;
  chr(0xcd)  => '\\\'I',                        #  - &Iacute;
  chr(0xce)  => '\\^I',                         #  - &Icirc;
  chr(0xcf)  => '\\"I',                         #  - &Iuml;
  chr(0xd0)  => '\\DH',                         #  - &ETH;
  chr(0xd1)  => '\\~N',                         #  - &Ntilde;
  chr(0xd2)  => '\\`O',                         #  - &Ograve;
  chr(0xd3)  => '\\\'O',                        #  - &Oacute;
  chr(0xd4)  => '\\^O',                         #  - &Ocirc;
  chr(0xd5)  => '\\~O',                         #  - &Otilde;
  chr(0xd6)  => '\\"O',                         #  - &Ouml;
  chr(0xd7)  => '\\texttimes',                  #  - &times;
  chr(0xd8)  => '\\O',                          #  - &Oslash;
  chr(0xd9)  => '\\`U',                         #  - &Ugrave;
  chr(0xda)  => '\\\'U',                        #  - &Uacute;
  chr(0xdb)  => '\\^U',                         #  - &Ucirc;
  chr(0xdc)  => '\\"U',                         #  - &Uuml;
  chr(0xdd)  => '\\\'Y',                        #  - &Yacute;
  chr(0xde)  => '\\TH',                         #  - &THORN;
  chr(0xdf)  => '\\ss',                         #  - &szlig;
  chr(0xe0)  => '\\`a',                         #  - &agrave;
  chr(0xe1)  => '\\\'a',                        #  - &aacute;
  chr(0xe2)  => '\\^a',                         #  - &acirc;
  chr(0xe3)  => '\\~a',                         #  - &atilde;
  chr(0xe4)  => '\\"a',                         #  - &auml;
  chr(0xe5)  => '\\aa',                         #  - &aring;
  chr(0xe6)  => '\\ae',                         #  - &aelig;
  chr(0xe7)  => '\\c{c}',                       #  - &ccedil;
  chr(0xe8)  => '\\`e',                         #  - &egrave;
  chr(0xe9)  => '\\\'e',                        #  - &eacute;
  chr(0xea)  => '\\^e',                         #  - &ecirc;
  chr(0xeb)  => '\\"e',                         #  - &euml;
  chr(0xec)  => '\\`i',                         #  - &igrave;
  chr(0xed)  => '\\\'i',                        #  - &iacute;
  chr(0xee)  => '\\^i',                         #  - &icirc;
  chr(0xef)  => '\\"i',                         #  - &iuml;
  chr(0xf0)  => '\\dh',                         #  - &eth;
  chr(0xf1)  => '\\~n',                         #  - &ntilde;
  chr(0xf2)  => '\\`o',                         #  - &ograve;
  chr(0xf3)  => '\\\'o',                        #  - &oacute;
  chr(0xf4)  => '\\^o',                         #  - &ocirc;
  chr(0xf5)  => '\\~o',                         #  - &otilde;
  chr(0xf6)  => '\\"o',                         #  - &ouml;
  chr(0xf7)  => '\\textdiv',                    #  - &divide;
  chr(0xf8)  => '\\o',                          #  - &oslash;
  chr(0xf9)  => '\\`u',                         #  - &ugrave;
  chr(0xfa)  => '\\\'u',                        #  - &uacute;
  chr(0xfb)  => '\\^u',                         #  - &ucirc;
  chr(0xfc)  => '\\"u',                         #  - &uuml;
  chr(0xfd)  => '\\\'y',                        #  - &yacute;
  chr(0xfe)  => '\\th',                         #  - &thorn;
  chr(0xff)  => '\\"y',                         #  - &yuml;
  chr(0x152) => '\\OE',                         #  - &OElig;
  chr(0x153) => '\\oe',                         #  - &oelig;
  chr(0x160) => '\\v{S}',                       #  - &Scaron;
  chr(0x161) => '\\v{s}',                       #  - &scaron;
  chr(0x178) => '\\"Y',                         #  - &Yuml;
  chr(0x192) => '\\textflorin',                 #  - &fnof;
  chr(0x2c6) => '\\textasciicircum',            #  - &circ;
  chr(0x2dc) => '\\textasciitilde',             #  - &tilde;
  chr(0x391) => '$\\mathrm{A}$',                #  - &Alpha;
  chr(0x392) => '$\\mathrm{B}$',                #  - &Beta;
  chr(0x393) => '$\\Gamma$',                    #  - &Gamma;
  chr(0x394) => '$\\Delta$',                    #  - &Delta;
  chr(0x395) => '$\\mathrm{E}$',                #  - &Epsilon;
  chr(0x396) => '$\\mathrm{Z}$',                #  - &Zeta;
  chr(0x397) => '$\\mathrm{H}$',                #  - &Eta;
  chr(0x398) => '$\\Theta$',                    #  - &Theta;
  chr(0x399) => '$\\mathrm{I}$',                #  - &Iota;
  chr(0x39a) => '$\\mathrm{K}$',                #  - &Kappa;
  chr(0x39b) => '$\\Lambda$',                   #  - &Lambda;
  chr(0x39c) => '$\\mathrm{M}$',                #  - &Mu;
  chr(0x39d) => '$\\mathrm{N}$',                #  - &Nu;
  chr(0x39e) => '$\\Xi$',                       #  - &Xi;
  chr(0x39f) => '$\\mathrm{O}$',                #  - &Omicron;
  chr(0x3a0) => '$\\Pi$',                       #  - &Pi;
  chr(0x3a1) => '$\\mathrm{R}$',                #  - &Rho;
  chr(0x3a3) => '$\\Sigma$',                    #  - &Sigma;
  chr(0x3a4) => '$\\mathrm{T}$',                #  - &Tau;
  chr(0x3a5) => '$\\Upsilon$',                  #  - &Upsilon;
  chr(0x3a6) => '$\\Phi$',                      #  - &Phi;
  chr(0x3a7) => '$\\mathrm{X}$',                #  - &Chi;
  chr(0x3a8) => '$\\Psi$',                      #  - &Psi;
  chr(0x3a9) => '$\\Omega$',                    #  - &Omega;
  chr(0x3b1) => '$\\alpha$',                    #  - &alpha;
  chr(0x3b2) => '$\\beta$',                     #  - &beta;
  chr(0x3b3) => '$\\gamma$',                    #  - &gamma;
  chr(0x3b4) => '$\\delta$',                    #  - &delta;
  chr(0x3b5) => '$\\epsilon$',                  #  - &epsilon;
  chr(0x3b6) => '$\\zeta$',                     #  - &zeta;
  chr(0x3b7) => '$\\eta$',                      #  - &eta;
  chr(0x3b8) => '$\\theta$',                    #  - &theta;
  chr(0x3b9) => '$\\iota$',                     #  - &iota;
  chr(0x3ba) => '$\\kappa$',                    #  - &kappa;
  chr(0x3bb) => '$\\lambda$',                   #  - &lambda;
  chr(0x3bc) => '$\\mu$',                       #  - &mu;
  chr(0x3bd) => '$\\nu$',                       #  - &nu;
  chr(0x3be) => '$\\xi$',                       #  - &xi;
  chr(0x3bf) => '$o$',                          #  - &omicron;
  chr(0x3c0) => '$\\pi$',                       #  - &pi;
  chr(0x3c1) => '$\\rho$',                      #  - &rho;
  chr(0x3c3) => '$\\sigma$',                    #  - &sigma;
  chr(0x3c4) => '$\\tau$',                      #  - &tau;
  chr(0x3c5) => '$\\upsilon$',                  #  - &upsilon;
  chr(0x3c6) => '$\\phi$',                      #  - &phi;
  chr(0x3c7) => '$\\chi$',                      #  - &chi;
  chr(0x3c8) => '$\\psi$',                      #  - &psi;
  chr(0x3c9) => '$\\omega$',                    #  - &omega;
  chr(0x2002) => '\\phantom{n}',                 #  - &ensp;
  chr(0x2003) => '\\hspace{1em}',                #  - &emsp;
  chr(0x2009) => '\\,',                          #  - &thinsp;
  chr(0x200c) => '<undef>',                      #  - &zwnj;
  chr(0x2013) => '--',                           #  - &ndash;
  chr(0x2014) => '---',                          #  - &mdash;
  chr(0x2018) => '\\textquoteleft',              #  - &lsquo;
  chr(0x2019) => '\\textquoteright',             #  - &rsquo;
  chr(0x201a) => '\\quotesinglbase',             #  - &sbquo;
  chr(0x201c) => '\\textquotedblleft',           #  - &ldquo;
  chr(0x201d) => '\\textquotedblright',          #  - &rdquo;
  chr(0x201e) => '\\quotedblbase',               #  - &bdquo;
  chr(0x2020) => '\\textdagger',                 #  - &dagger;
  chr(0x2021) => '\\textdaggerdbl',              #  - &Dagger;
  chr(0x2022) => '\\textbullet',                 #  - &bull;
  chr(0x2026) => '\\textellipsis',               #  - &hellip;
  chr(0x2030) => '\\textperthousand',            #  - &permil;
  chr(0x2032) => '\\textquotesingle',            #  - &prime;
  chr(0x2033) => '\\textquotedbl',               #  - &Prime;
  chr(0x2039) => '\\guilsinglleft',              #  - &lsaquo;
  chr(0x203a) => '\\guilsinglright',             #  - &rsaquo;
  chr(0x203e) => '\\textasciimacron',            #  - &oline;
  chr(0x2044) => '\\textfractionsolidus',        #  - &frasl;
  chr(0x20ac) => '\\texteuro',                   #  - &euro;
  chr(0x2111) => '$\\Re$',                       #  - &image;
  chr(0x2118) => '$\\wp$',                       #  - &weierp;
  chr(0x211c) => '$\\Im$',                       #  - &real;
  chr(0x2122) => '\\texttrademark',              #  - &trade;
  chr(0x2190) => '\\textleftarrow',              #  - &larr;
  chr(0x2191) => '\\textuparrow',                #  - &uarr;
  chr(0x2192) => '\\textrightarrow',             #  - &rarr;
  chr(0x2193) => '\\textdownarrow',              #  - &darr;
  chr(0x2194) => '$\\leftrightarrow$',           #  - &harr;
  chr(0x21d0) => '$\\Leftarrow$',                #  - &lArr;
  chr(0x21d1) => '$\\Uparrow$',                  #  - &uArr;
  chr(0x21d2) => '$\\Rightarrow$',               #  - &rArr;
  chr(0x21d3) => '$\\Downarrow$',                #  - &dArr;
  chr(0x21d4) => '$\\Leftrightarrow$',           #  - &hArr;
  chr(0x2200) => '$\\forall$',                   #  - &forall;
  chr(0x2202) => '$\\partial$',                  #  - &part;
  chr(0x2203) => '$\\exists$',                   #  - &exist;
  chr(0x2205) => '$\\emptyset$',                 #  - &empty;
  chr(0x2207) => '$\\nabla$',                    #  - &nabla;
  chr(0x2208) => '$\\in$',                       #  - &isin;
  chr(0x2209) => '$\\notin$',                    #  - &notin;
  chr(0x220b) => '$\\ni$',                       #  - &ni;
  chr(0x220f) => '$\\prod$',                     #  - &prod;
  chr(0x2211) => '$\\sum$',                      #  - &sum;
  chr(0x2212) => '$-$',                          #  - &minus;
  chr(0x2217) => '$\\ast$',                      #  - &lowast;
  chr(0x221a) => '$\\surd$',                     #  - &radic;
  chr(0x221d) => '$\\propto$',                   #  - &prop;
  chr(0x221e) => '$\\infty$',                    #  - &infin;
  chr(0x2220) => '$\\angle$',                    #  - &ang;
  chr(0x2227) => '$\\wedge$',                    #  - &and;
  chr(0x2228) => '$\\vee$',                      #  - &or;
  chr(0x2229) => '$\\cap$',                      #  - &cap;
  chr(0x222a) => '$\\cup$',                      #  - &cup;
  chr(0x222b) => '$\\int$',                      #  - &int;
#  chr(0x2234) => '$\\therefore$',                #  - &there4;
  chr(0x223c) => '$\\sim$',                      #  - &sim;
  chr(0x2245) => '$\\cong$',                     #  - &cong;
  chr(0x2248) => '$\\asymp$',                    #  - &asymp;
  chr(0x2260) => '$\\neq$',                      #  - &ne;
  chr(0x2261) => '$\\equiv$',                    #  - &equiv;
  chr(0x2264) => '$\\leq$',                      #  - &le;
  chr(0x2265) => '$\\geq$',                      #  - &ge;
  chr(0x2282) => '$\\subset$',                   #  - &sub;
  chr(0x2283) => '$\\supset$',                   #  - &sup;
  chr(0x2284) => '$\\not\\subset$',              #  - &nsub;
  chr(0x2286) => '$\\subseteq$',                 #  - &sube;
  chr(0x2287) => '$\\supseteq$',                 #  - &supe;
  chr(0x2295) => '$\\oplus$',                    #  - &oplus;
  chr(0x2297) => '$\\otimes$',                   #  - &otimes;
  chr(0x22a5) => '$\\perp$',                     #  - &perp;
  chr(0x22c5) => '$\\cdot$',                     #  - &sdot;
  chr(0x2308) => '$\\lceil$',                    #  - &lceil;
  chr(0x2309) => '$\\rceil$',                    #  - &rceil;
  chr(0x230a) => '$\\lfloor$',                   #  - &lfloor;
  chr(0x230b) => '$\\rfloor$',                   #  - &rfloor;
  chr(0x2329) => '$\\langle$',                   #  - &lang;
  chr(0x232a) => '$\\rangle$',                   #  - &rang;
#  chr(0x25ca) => '$\\lozenge$',                  #  - &loz;
  chr(0x2660) => '$\\spadesuit$',                #  - &spades;
  chr(0x2663) => '$\\clubsuit$',                 #  - &clubs;
  chr(0x2665) => '$\\heartsuit$',                #  - &hearts;
  chr(0x2666) => '$\\diamondsuit$',              #  - &diams;
);

$encoded_char_re = join('', sort keys %latex_encoding);
$encoded_char_re =~ s/\\/\\\\/;
$encoded_char_re = qr{ [$encoded_char_re] }x;

1;
