/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.x509.ext;

import gnu.java.security.der.DERReader;
import gnu.java.security.der.DERValue;
import gnu.java.security.x509.ext.GeneralName;
import java.io.IOException;
import java.math.BigInteger;

public class GeneralSubtree {
    private final GeneralName base;
    private final int minimum;
    private final int maximum;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GeneralSubtree(byte[] encoded) throws IOException {
        int len;
        DERReader reader = new DERReader(encoded);
        DERValue generalSubtree = reader.read();
        if (!generalSubtree.isConstructed()) {
            throw new IOException("malformed GeneralSubtree");
        }
        DERValue generalName = reader.read();
        this.base = new GeneralName(generalName.getEncoded());
        if (generalName.isConstructed()) {
            reader.skip(generalName.getLength());
        }
        if ((len = generalName.getEncodedLength()) < generalSubtree.getLength()) {
            DERValue distance = reader.read();
            if (distance.getTag() == 0) {
                this.minimum = ((BigInteger)distance.getValue()).intValue();
                if ((len += distance.getEncodedLength()) < generalSubtree.getLength()) {
                    distance = reader.read();
                    if (distance.getTag() != 1) {
                        throw new IOException("unexpected tag " + distance.getTag() + " (expected 1 for GeneralSubtree maximum distance)");
                    }
                    this.maximum = ((BigInteger)distance.getValue()).intValue();
                    return;
                } else {
                    this.maximum = -1;
                }
                return;
            } else {
                if (distance.getTag() != 1) throw new IOException("unexpected tag " + distance.getTag() + " (expected 0 or 1 for GeneralSubtree distance)");
                this.minimum = 1;
                this.maximum = ((BigInteger)distance.getValue()).intValue();
            }
            return;
        } else {
            this.minimum = 0;
            this.maximum = -1;
        }
    }

    public GeneralName base() {
        return this.base;
    }

    public int minimum() {
        return this.minimum;
    }

    public int maximum() {
        return this.maximum;
    }

    public String toString() {
        return String.valueOf(GeneralSubtree.class.getName()) + " [ base=" + this.base + "; minimum=" + this.minimum + "; maximim=" + this.maximum + " ]";
    }
}

