/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.rmi.server;

import gnu.java.rmi.dgc.DGCImpl;
import gnu.java.rmi.server.ActivatableServerRef;
import gnu.java.rmi.server.ProtocolConstants;
import gnu.java.rmi.server.RMIObjectOutputStream;
import gnu.java.rmi.server.RMIVoidValue;
import gnu.java.rmi.server.UnicastConnection;
import gnu.java.rmi.server.UnicastServerRef;
import gnu.java.util.WeakIdentityHashMap;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.ServerError;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.server.ObjID;
import java.rmi.server.UID;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.WeakHashMap;

public class UnicastServer
implements ProtocolConstants {
    private static Map objects = Collections.synchronizedMap(new WeakHashMap());
    private static Map refcache = Collections.synchronizedMap(new WeakIdentityHashMap());
    public static Map actIds = new Hashtable();
    private static DGCImpl dgc;

    public static void exportObject(UnicastServerRef obj) {
        UnicastServer.startDGC();
        objects.put(obj.objid, obj);
        refcache.put(obj.myself, obj);
        obj.manager.startServer();
    }

    public static void registerActivatable(ActivatableServerRef ref) {
        actIds.put(ref.actId, ref);
    }

    public static void exportActivatableObject(ActivatableServerRef ref) {
        UnicastServer.startDGC();
        objects.put(ref.objid, ref);
        ref.manager.startServer();
        actIds.put(ref.actId, ref);
    }

    public static ActivatableServerRef getActivatableRef(ActivationID id) throws ActivationException {
        ActivatableServerRef ref = (ActivatableServerRef)actIds.get(id);
        if (ref == null) {
            throw new ActivationException(id + " was not registered with this server");
        }
        return ref;
    }

    public static void unregisterActivatable(ActivationID id) {
        actIds.remove(id);
    }

    public static boolean unexportObject(UnicastServerRef obj, boolean force) {
        objects.remove(obj.objid);
        refcache.remove(obj.myself);
        obj.manager.stopServer();
        if (obj instanceof ActivatableServerRef) {
            ActivationID id = ((ActivatableServerRef)obj).actId;
            UnicastServer.unregisterActivatable(id);
        }
        return true;
    }

    public static UnicastServerRef getExportedRef(Remote remote) {
        return (UnicastServerRef)refcache.get(remote);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection getExported(Object id) {
        Map map = objects;
        synchronized (map) {
            ArrayList list2 = new ArrayList();
            for (Map.Entry e : objects.entrySet()) {
                Object key = e.getKey();
                if (key == null || !key.equals(id)) continue;
                list2.add(e.getValue());
            }
            return list2;
        }
    }

    private static synchronized void startDGC() {
        if (dgc == null) {
            try {
                dgc = new DGCImpl();
                dgc.exportObject(dgc);
            }
            catch (RemoteException e) {
                e.printStackTrace();
            }
        }
    }

    public static void dispatch(UnicastConnection conn) throws Exception {
        switch (conn.getDataInputStream().readUnsignedByte()) {
            case 80: {
                UnicastServer.incomingMessageCall(conn);
                break;
            }
            case 82: {
                DataOutputStream out = conn.getDataOutputStream();
                out.writeByte(83);
                out.flush();
                break;
            }
            default: {
                throw new Exception("bad method type");
            }
        }
    }

    private static void incomingMessageCall(UnicastConnection conn) throws IOException {
        Object returnval;
        ObjectInputStream in = conn.startObjectInputStream();
        ObjID objid = ObjID.read(in);
        int method = in.readInt();
        long hash = in.readLong();
        UnicastServerRef uref = (UnicastServerRef)objects.get(objid);
        int returncode = 1;
        Class returncls = null;
        if (uref != null) {
            try {
                returnval = uref.incomingMessageCall(conn, method, hash);
                returncls = uref.getMethodReturnType(method, hash);
            }
            catch (Exception e) {
                returnval = e;
                returncode = 2;
            }
            catch (Error e) {
                returnval = new ServerError("Server error, ObjID: " + objid + ", method: " + method + ", hash: " + hash, e);
                returncode = 2;
            }
        } else {
            returnval = new NoSuchObjectException("ObjID: " + objid);
            returncode = 2;
        }
        conn.getDataOutputStream().writeByte(81);
        ObjectOutputStream out = conn.startObjectOutputStream();
        out.writeByte(returncode);
        new UID().write(out);
        if (returnval != null && returncls != null) {
            ((RMIObjectOutputStream)out).writeValue(returnval, returncls);
        } else if (!(returnval instanceof RMIVoidValue) && returncls != Void.TYPE) {
            out.writeObject(returnval);
        }
        out.flush();
    }
}

