/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.AWTEvent;
import java.awt.AWTEventMulticaster;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.peer.ScrollbarPeer;
import java.util.EventListener;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.accessibility.AccessibleValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Scrollbar
extends Component
implements Accessible,
Adjustable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private static final long serialVersionUID = 8451667562882310543L;
    private int lineIncrement;
    private int pageIncrement;
    private int maximum;
    private int minimum;
    private int orientation;
    private int value;
    private int visibleAmount;
    private AdjustmentListener adjustment_listeners;
    private transient boolean valueIsAdjusting = false;
    private static transient long next_scrollbar_number;

    public Scrollbar() {
        this(1);
    }

    public Scrollbar(int orientation) throws IllegalArgumentException {
        this(orientation, 0, 10, 0, 100);
    }

    public Scrollbar(int orientation, int value, int visibleAmount, int minimum, int maximum) throws IllegalArgumentException {
        if (GraphicsEnvironment.isHeadless()) {
            throw new HeadlessException();
        }
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Bad orientation value: " + orientation);
        }
        this.orientation = orientation;
        this.setValues(value, visibleAmount, minimum, maximum);
        this.lineIncrement = 1;
        this.pageIncrement = 10;
    }

    @Override
    public int getOrientation() {
        return this.orientation;
    }

    public void setOrientation(int orientation) {
        if (orientation != 0 && orientation != 1) {
            throw new IllegalArgumentException("Bad orientation value: " + orientation);
        }
        this.orientation = orientation;
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public void setValue(int value) {
        this.setValues(value, this.visibleAmount, this.minimum, this.maximum);
    }

    @Override
    public int getMaximum() {
        return this.maximum;
    }

    @Override
    public void setMaximum(int maximum) {
        this.setValues(this.value, this.visibleAmount, this.minimum, maximum);
    }

    @Override
    public int getMinimum() {
        return this.minimum;
    }

    @Override
    public void setMinimum(int minimum) {
        this.setValues(this.value, this.visibleAmount, minimum, this.maximum);
    }

    @Override
    public int getVisibleAmount() {
        return this.getVisible();
    }

    public int getVisible() {
        return this.visibleAmount;
    }

    @Override
    public void setVisibleAmount(int visibleAmount) {
        this.setValues(this.value, visibleAmount, this.minimum, this.maximum);
    }

    public synchronized void setValues(int value, int visibleAmount, int minimum, int maximum) {
        ScrollbarPeer peer;
        if (visibleAmount <= 0) {
            visibleAmount = 1;
        }
        if (maximum <= minimum) {
            maximum = minimum + 1;
        }
        if (value < minimum) {
            value = minimum;
        }
        if (visibleAmount > maximum - minimum) {
            visibleAmount = maximum - minimum;
        }
        if (value > maximum - visibleAmount) {
            value = maximum - visibleAmount;
        }
        if ((peer = (ScrollbarPeer)this.getPeer()) != null && (this.value != value || this.visibleAmount != visibleAmount || this.minimum != minimum || this.maximum != maximum)) {
            peer.setValues(value, visibleAmount, minimum, maximum);
        }
        this.value = value;
        this.visibleAmount = visibleAmount;
        this.minimum = minimum;
        this.maximum = maximum;
    }

    @Override
    public int getUnitIncrement() {
        return this.getLineIncrement();
    }

    public int getLineIncrement() {
        return this.lineIncrement;
    }

    @Override
    public synchronized void setUnitIncrement(int unitIncrement) {
        this.setLineIncrement(unitIncrement);
    }

    public void setLineIncrement(int lineIncrement) {
        if (lineIncrement < 0) {
            throw new IllegalArgumentException("Unit increment less than zero.");
        }
        if (lineIncrement == 0) {
            lineIncrement = 1;
        }
        if (lineIncrement == this.lineIncrement) {
            return;
        }
        this.lineIncrement = lineIncrement;
        ScrollbarPeer peer = (ScrollbarPeer)this.getPeer();
        if (peer != null) {
            peer.setLineIncrement(this.lineIncrement);
        }
    }

    @Override
    public int getBlockIncrement() {
        return this.getPageIncrement();
    }

    public int getPageIncrement() {
        return this.pageIncrement;
    }

    @Override
    public synchronized void setBlockIncrement(int blockIncrement) {
        this.setPageIncrement(blockIncrement);
    }

    public void setPageIncrement(int pageIncrement) {
        if (pageIncrement < 0) {
            throw new IllegalArgumentException("Block increment less than zero.");
        }
        if (pageIncrement == 0) {
            pageIncrement = 1;
        }
        if (pageIncrement == this.pageIncrement) {
            return;
        }
        this.pageIncrement = pageIncrement;
        ScrollbarPeer peer = (ScrollbarPeer)this.getPeer();
        if (peer != null) {
            peer.setPageIncrement(this.pageIncrement);
        }
    }

    @Override
    public synchronized void addNotify() {
        if (this.peer == null) {
            this.peer = this.getToolkit().createScrollbar(this);
        }
        super.addNotify();
    }

    @Override
    public synchronized void addAdjustmentListener(AdjustmentListener listener) {
        this.adjustment_listeners = AWTEventMulticaster.add(this.adjustment_listeners, listener);
        this.enableEvents(256L);
    }

    @Override
    public synchronized void removeAdjustmentListener(AdjustmentListener listener) {
        this.adjustment_listeners = AWTEventMulticaster.remove(this.adjustment_listeners, listener);
    }

    @Override
    protected void processEvent(AWTEvent event) {
        if (event instanceof AdjustmentEvent) {
            this.processAdjustmentEvent((AdjustmentEvent)event);
        } else {
            super.processEvent(event);
        }
    }

    protected void processAdjustmentEvent(AdjustmentEvent event) {
        this.value = event.getValue();
        if (this.adjustment_listeners != null) {
            this.adjustment_listeners.adjustmentValueChanged(event);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    void dispatchEventImpl(AWTEvent e) {
        if (e.id <= 601 && e.id >= 601) {
            AdjustmentEvent ae = (AdjustmentEvent)e;
            boolean adjusting = ae.getValueIsAdjusting();
            if (adjusting) {
                this.setValueIsAdjusting(true);
            }
            try {
                this.setValue(((AdjustmentEvent)e).getValue());
                if (this.adjustment_listeners == null && (this.eventMask & 0x100L) == 0L) return;
                this.processEvent(e);
                return;
            }
            finally {
                if (adjusting) {
                    this.setValueIsAdjusting(false);
                }
            }
        } else {
            super.dispatchEventImpl(e);
        }
    }

    @Override
    protected String paramString() {
        return "value=" + this.getValue() + ",visibleAmount=" + this.getVisibleAmount() + ",minimum=" + this.getMinimum() + ",maximum=" + this.getMaximum() + ",pageIncrement=" + this.pageIncrement + ",lineIncrement=" + this.lineIncrement + ",orientation=" + (this.orientation == 0 ? "HORIZONTAL" : "VERTICAL") + super.paramString();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> listenerType) {
        if (listenerType == AdjustmentListener.class) {
            return AWTEventMulticaster.getListeners((EventListener)this.adjustment_listeners, listenerType);
        }
        return super.getListeners(listenerType);
    }

    public AdjustmentListener[] getAdjustmentListeners() {
        return (AdjustmentListener[])this.getListeners(AdjustmentListener.class);
    }

    public boolean getValueIsAdjusting() {
        return this.valueIsAdjusting;
    }

    public void setValueIsAdjusting(boolean valueIsAdjusting) {
        this.valueIsAdjusting = valueIsAdjusting;
    }

    @Override
    String generateName() {
        return "scrollbar" + Scrollbar.getUniqueLong();
    }

    private static synchronized long getUniqueLong() {
        return next_scrollbar_number++;
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTScrollBar();
        }
        return this.accessibleContext;
    }

    protected class AccessibleAWTScrollBar
    extends Component.AccessibleAWTComponent
    implements AccessibleValue {
        private static final long serialVersionUID = -344337268523697807L;

        protected AccessibleAWTScrollBar() {
            super(Scrollbar.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SCROLL_BAR;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (Scrollbar.this.getOrientation() == 0) {
                states.add(AccessibleState.HORIZONTAL);
            } else {
                states.add(AccessibleState.VERTICAL);
            }
            if (Scrollbar.this.getValueIsAdjusting()) {
                states.add(AccessibleState.BUSY);
            }
            return states;
        }

        public AccessibleValue getAccessibleValue() {
            return this;
        }

        public Number getCurrentAccessibleValue() {
            return new Integer(Scrollbar.this.getValue());
        }

        public boolean setCurrentAccessibleValue(Number number) {
            Scrollbar.this.setValue(number.intValue());
            return true;
        }

        public Number getMinimumAccessibleValue() {
            return new Integer(Scrollbar.this.getMinimum());
        }

        public Number getMaximumAccessibleValue() {
            return new Integer(Scrollbar.this.getMaximum());
        }
    }
}

