/***************************************************************************
                          clisten.h  -  description
                             -------------------
    begin                : Fri Mar 22 2002
    copyright            : (C) 2002-2003 by Mathias Kster
    email                : mathen@users.berlios.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CLISTEN_H
#define CLISTEN_H

 /**
  *@author Mathias Kster
  */

#include <dclib/dcos.h>
#include <dclib/core/csocket.h>
#include <dclib/core/cthread.h>
#include <dclib/core/ccallback.h>

class CListen;

#ifdef WIN32
template class DLL_EXPORT CCallback<CListen>;
#endif

class DLL_EXPORT CListen : public CSocket {
public:
	/** */
	CListen();
	/** */
	virtual ~CListen();

	/** */
	int StartListen( int port, CString ip = "", bool manager = TRUE );
	/** */
	void StopListen();

	/** callback function */
	virtual int DC_ListenCallBack( int ) { return -1; };

	/** */
	void SetCallBackFunction( _CCallback * callback );

	/** */
	int Callback( CObject *, CObject * );

private:
	/** */
	CThread m_Thread;
	/** */
	_CCallback * m_pListenCallback;
	/** */
	_CCallback * m_pCallback;
};

/** */
inline void CListen::SetCallBackFunction( _CCallback * callback )
{ m_Thread.Lock(); if ( m_pListenCallback ) delete m_pListenCallback; m_pListenCallback = callback; m_Thread.UnLock(); };

#endif
