<?php
/**
 * Internationalisation file for the Asirra module of the ConfirmEdit
 * extension.
 *
 * @file
 * @ingroup Extensions
 */

$messages = array();

/* English */
$messages['en'] = array(
	'asirra-desc' => 'Asirra module for ConfirmEdit',
	'asirra-edit' => 'To help protect against automated edit spam, please select just the cat photos in the box below:', 
	'asirra-addurl' => 'Your edit includes new external links. To help protect against automated spam, please select just the cat photos in the box below:',
	'asirra-badpass' => 'To help protect against automated password cracking, please select just the cat photos in the box below:',
	'asirra-createaccount' => 'To help protect against automated account creation, please select just the cat photos in the box below:',
	'asirra-createaccount-fail' => "Please correctly identify the cats.",
	'asirra-create' => 'To help protect against automated page creation, please select just the cat photos in the box below:', 
	'asirra-nojs' => '\'\'\'Please enable JavaScript and resubmit the page.\'\'\'',
	'asirra-failed' => 'Please identify all cat images',
);

/** Belarusian (Taraškievica orthography) (‪Беларуская (тарашкевіца)‬)
 * @author EugeneZelenko
 * @author Jim-by
 * @author Wizardist
 */
$messages['be-tarask'] = array(
	'asirra-desc' => 'Модуль Asirra для ConfirmEdit',
	'asirra-edit' => 'Для абароны супраць спаму, калі ласка, выберыце толькі фота з катом ў полі ніжэй:',
	'asirra-addurl' => 'Вашае рэдагаваньне ўтрымлівае новыя вонкавыя спасылкі. Для абароны супраць спаму, калі ласка, выберыце толькі фота з катом ў полі ніжэй:',
	'asirra-badpass' => 'Для абароны супраць аўтаматычнага падбору паролю, калі ласка, выберыце толькі фота з катом ў полі ніжэй:',
	'asirra-createaccount' => 'Для абароны супраць аўтаматычнага стварэньня рахункаў, калі ласка, выберыце толькі фота з катом ў полі ніжэй:',
	'asirra-createaccount-fail' => 'Калі ласка, слушна выберыце катоў.',
	'asirra-create' => 'Для абароны супраць аўтаматычнага стварэньня старонак, калі ласка, выберыце толькі фота з катом ў полі ніжэй:',
	'asirra-nojs' => "'''Калі ласка, дазвольце JavaScript і дашліце старонку зноў.'''",
	'asirra-failed' => 'Калі ласка, вызначце ўсе выявы з катамі',
);

/** German (Deutsch)
 * @author Kghbln
 */
$messages['de'] = array(
	'asirra-desc' => 'Ermöglicht die Nutzung des Anti-Spam-Moduls Asirra',
	'asirra-edit' => 'Zum Schutz vor automatisiertem Spam bitten wir dich, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-addurl' => 'Deine Bearbeitung enthält neue externe Links. Zum Schutz vor automatisiertem Spam bitten wir dich, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-badpass' => 'Zum Schutz gegen automatisiertes Knacken von Passwörtern bitten wir dich, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-createaccount' => 'Zum Schutz gegen automatisiertes Erstellen von Benutzerkonten bitten wir dich, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-createaccount-fail' => 'Bitte wähle nur die Fotos mit Katzen aus.',
	'asirra-create' => 'Zum Schutz gegen automatisiertes Erstellen von Seiten bitten wir dich, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-nojs' => "'''Bitte JavaScript aktivieren und die Seiten nochmals Speichern.'''",
	'asirra-failed' => 'Bitte wähle nur die Fotos mit Katzen aus.',
);

/** German (formal address) (‪Deutsch (Sie-Form)‬)
 * @author Kghbln
 */
$messages['de-formal'] = array(
	'asirra-addurl' => 'Ihre Bearbeitung enthält neue externe Links. Zum Schutz vor automatisiertem Spam bitten wir Sie, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-badpass' => 'Zum Schutz gegen automatisiertes Knacken von Passwörtern bitten wir Sie, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-createaccount' => 'Zum Schutz gegen automatisiertes Erstellen von Benutzerkonten bitten wir Sie, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-createaccount-fail' => 'Bitte wählen Sie nur die Fotos mit Katzen aus.',
	'asirra-create' => 'Zum Schutz gegen automatisiertes Erstellen von Seiten bitten wir Sie, nur die Fotos mit Katzen im untenstehenden Feld auszuwählen:',
	'asirra-failed' => 'Bitte wählen Sie nur die Fotos mit Katzen aus.',
);

/** French (Français)
 * @author Seb35
 */
$messages['fr'] = array(
	'asirra-desc' => 'Module Asirra pour ConfirmEdit',
	'asirra-edit' => 'Pour aider à nous protéger contre le spam d’édition automatique, veuillez sélectionner uniquement les photos de chats dans la boîte ci-dessous :',
	'asirra-addurl' => 'Votre édition contient des liens externes. Pour nous aider à nous protéger contre le spam automatique, veuillez sélectionner uniquement les photos de chats dans la boîte ci-dessous :',
	'asirra-badpass' => 'Pour nous aider à nous protéger des essais automatiques de cassage de mot de passe, veuillez sélectionner uniquement les photos de chats dans la boîte ci-dessous :',
	'asirra-createaccount' => 'Pour nous aider à nous protéger contre la création automatique de comptes, veuillez sélectionner uniquement les photos de chats dans la boîte ci-dessous :',
	'asirra-createaccount-fail' => 'Veuillez identifier correctement les chats.',
	'asirra-create' => 'Pour nous aider à nous protéger contre la création automatique de pages, veuillez sélectionner uniquement les photos de chats dans la boîte ci-dessous :',
	'asirra-nojs' => "'''Veuillez activer le JavaScript et re-soumettre la page.'''",
);

/** Galician (Galego)
 * @author Toliño
 */
$messages['gl'] = array(
	'asirra-desc' => 'Módulo Asirra para ConfirmEdit',
	'asirra-edit' => 'Para axudarnos á protección contra o spam, seleccione só as fotos de gatos na caixa:',
	'asirra-addurl' => 'A súa edición inclúe novas ligazóns externas. Para axudar na protección contra o spam automático, seleccione só as fotos de gatos na caixa:',
	'asirra-badpass' => 'Para axudarnos á protección contra o roubo de contrasinais, seleccione só as fotos de gatos na caixa:',
	'asirra-createaccount' => 'Para axudarnos á protección contra a creación automática de contas, seleccione só as fotos de gatos na caixa:',
	'asirra-createaccount-fail' => 'Identifique correctamente os gatos.',
	'asirra-create' => 'Para axudarnos á protección contra a creación automática de páxinas, seleccione só as fotos de gatos na caixa:',
	'asirra-nojs' => "'''Active o JavaScript e volva enviar a páxina.'''",
	'asirra-failed' => 'Identifique todas as fotos de gatos',
);

/** Upper Sorbian (Hornjoserbsce)
 * @author Michawiki
 */
$messages['hsb'] = array(
	'asirra-desc' => 'Modul Asirra za ConfirmEdit',
	'asirra-edit' => 'Za škit přećiwo awtomatizowanemu spamej, prošu wubjer jenož fota kóčkow w slědowacym polu:',
	'asirra-addurl' => 'Twoja změna wobsahuje nowe eksterne wotkazy. Za škit přećiwo awtomatizowanemu spamej, prošu wubjer jenož fota kóčkow w slědowacym polu:',
	'asirra-badpass' => 'Za škit přećiwo awtomatizowanemu złamanju hesłow, prošu wubjer jenož fota kóčkow w slědowacym polu:',
	'asirra-createaccount' => 'Za škit přećiwo awtomatiskemu wutworjenju konta, prošu wubjer jenož fota kóčkow w slědowacym polu:',
	'asirra-createaccount-fail' => 'Prošu identifikuj kóčki.',
	'asirra-create' => 'Za škit přećiwo awtomatiskemu wutworjenju strony, prošu wubjer jenož fota kóčkow w slědowacym polu:',
	'asirra-nojs' => "'''Prošu zmóžń JavaScript a składuj stronu hišće raz.'''",
	'asirra-failed' => 'Prošu identifikuj wšě wobrazy z kóčkami',
);

/** Interlingua (Interlingua)
 * @author McDutchie
 */
$messages['ia'] = array(
	'asirra-desc' => 'Modulo de Asirra pro ConfirmEdit',
	'asirra-edit' => 'Pro adjutar a proteger nos contra le spam automatisate, per favor selige solmente le photos de cattos in le quadro sequente:',
	'asirra-addurl' => 'Iste modification include nove ligamines externe. Pro adjutar a proteger nos contra le spam automatisate, per favor selige solmente le photos de cattos in le quadro sequente:',
	'asirra-badpass' => 'Pro adjutar a proteger nos contra le furto automatisate de contrasignos, per favor selige solmente le photos de catto in le quadro sequente:',
	'asirra-createaccount' => 'Pro adjutar a proteger nos contra le creation automatisate de contos, per favor selige solmente le photos de cattos in le quadro sequente:',
	'asirra-createaccount-fail' => 'Per favor identifica correctemente le cattos.',
	'asirra-create' => 'Pro adjutar a proteger nos contra le creation automatisate de paginas, per favor selige solmente le photos de cattos in le quadro sequente:',
	'asirra-nojs' => "'''Per favor activa JavaScript e resubmitte le pagina.'''",
	'asirra-failed' => 'Per favor identifica tote le imagines de cattos',
);

/** Luxembourgish (Lëtzebuergesch)
 * @author Robby
 */
$messages['lb'] = array(
	'asirra-desc' => 'Asirra-Modul fir ConfirmEdit',
	'asirra-addurl' => "An Ärer Ännerung sinn nei extern Linken. Fir ze hëllefe géint automatiséierte Spam virzegoen, sicht w.e.g. d'Kategorie vun de Fotoen an der Këscht ënnendrënner eraus:",
	'asirra-createaccount-fail' => "Identifizéiert d'Kaze w.e.g. richteg.",
	'asirra-nojs' => "'''Aktivéiert w.e.g. JavaScript a schéckt d'Säit nachemol.'''",
	'asirra-failed' => 'Identifizéiert w.e.g. all Biller wou Kazen drop sinn',
);

/** Macedonian (Македонски)
 * @author Bjankuloski06
 */
$messages['mk'] = array(
	'asirra-desc' => 'Asirra-модул за ПотврдиУредување',
	'asirra-edit' => 'Како заштитна мерка против автоматизиран спам, изберете ги само сликите со мачка прикажани во полето:',
	'asirra-addurl' => 'Во вашите измени има нови надворешни врски. Како заштитна мерка против автоматизиран спам, изберете ги само сликите со мачка прикажани во полето:',
	'asirra-badpass' => 'Како заштитна мерка против автоматизирано провалување на лозинки, изберете ги само сликите со мачка прикажани во полето:',
	'asirra-createaccount' => 'Како заштитна мерка против автоматизирано создавање на сметки, изберете ги само сликите со мачка прикажани во полето:',
	'asirra-createaccount-fail' => 'Посочете кои од следниве се мачки.',
	'asirra-create' => 'Како заштитна мерка против автоматизирано создавање на страници, изберете ги само сликите со мачка прикажани во полето:',
	'asirra-nojs' => "'''Овозможете JavaScript и поднесете ја страницата повторно.'''",
	'asirra-failed' => 'Изберете ги сликите што имаат мачка',
);

/** Norwegian (bokmål)‬ (‪Norsk (bokmål)‬)
 * @author Event
 */
$messages['nb'] = array(
	'asirra-desc' => 'Assirra-modulen for ConfirmEdit',
	'asirra-edit' => 'Som beskyttelse mot automatisk redigert spam, vennligst velg kun kattebildene i boksen under:',
	'asirra-addurl' => 'Din redigering inneholder nye eksterne lenker. Som beskyttelse mot automatisk redigert spam, vennligst velg kun kattebildene i boksen under:',
	'asirra-badpass' => 'Som beskyttelse mot automatisk passordknekking, vennligst velg kun kattebildene i boksen under:',
	'asirra-createaccount' => 'Som beskyttelse mot automatisk opprettelse av brukerkonto, vennligst velg kun kattebildene i boksen under:',
	'asirra-createaccount-fail' => 'Vennligst angi hva som er katter.',
	'asirra-create' => 'Som beskyttelse mot automatisk opprettelse av sider, vennligst velg kun kattebildene i boksen under:',
	'asirra-nojs' => "'''Vennligst åpne for JavaScript og lagre siden en gang til.'''",
);

/** Dutch (Nederlands)
 * @author SPQRobin
 * @author Siebrand
 */
$messages['nl'] = array(
	'asirra-desc' => 'Asirra-module voor ConfirmEdit',
	'asirra-edit' => 'Kies ter bescherming tegen geautomatiseerde spam de afbeeldingen met een poes in het onderstaande venster:',
	'asirra-addurl' => "Uw bewerking bevat nieuwe externe verwijzingen. Om te helpen beschermen tegen geautomatiseerde spam, selecteer de foto's van katten in het vak hieronder:",
	'asirra-badpass' => 'Kies ter bescherming tegen het automatisch kraken van wachtwoorden de afbeeldingen met een poes in het onderstaande venster:',
	'asirra-createaccount' => 'Kies om het automatisch aanmaken van gebruikers tegen te gaan de afbeeldingen met een poes in het onderstaande venster:',
	'asirra-createaccount-fail' => 'Identificeer de katten juist.',
	'asirra-create' => "Kies om het automatisch aanmaken van pagina's tegen te gaan de afbeeldingen met een poes in het onderstaande venster:",
	'asirra-nojs' => "'''Schakel JavaScript in en probeer de pagina opnieuw op te slaan.'''",
	'asirra-failed' => 'Identificeer alle afbeeldingen van katten.',
);

/** Piedmontese (Piemontèis)
 * @author Borichèt
 * @author Dragonòt
 */
$messages['pms'] = array(
	'asirra-desc' => 'Mòdul Asirra për ConfirmEdit',
	'asirra-edit' => "Për giuté a protege contra la rumenta dle modìfiche automàtiche, për piasì ch'a selession-a mach le fòto ëd gat ant ël quàder sì-sota:",
	'asirra-addurl' => "Soa modìfica a conten dle liure esterne neuve. Për giuté a protege contra la rumenta dle modìfiche automàtiche, për piasì ch'a selession-a mach le fòto ëd gat ant ël quàder sì-sota:",
	'asirra-badpass' => "Për giuté a protege contra la forsadura automatisà ëd le ciav, për piasì ch'a selession-a mach la fòto dël gat ant ël quàder sì-sota:",
	'asirra-createaccount' => "Për giuté a protege contra la creassion automatisà ëd cont, për piasì ch'a selession-a mach la fòto dël gat ant ël quàder sì-sota:",
	'asirra-createaccount-fail' => 'Për piasì identifica coretament ij gat.',
	'asirra-create' => "Për giuté a protege contra la creassion automatisà ëd pàgine, për piasì ch'a selession-a mach le fòto ëd gat ant ël quàder sì-sota:",
	'asirra-nojs' => "'''Për piasì, ch'a abìlita JavaScript e ch'a spedissa torna la pàgina.'''",
	'asirra-failed' => 'Për piasì identìfica tute le figure ëd gat',
);

/** Portuguese (Português)
 * @author Hamilton Abreu
 */
$messages['pt'] = array(
	'asirra-desc' => 'Módulo Asirra para o ConfirmEdit',
	'asirra-edit' => "Como prevenção contra sistemas automatizados de inserção de ''spam'', seleccione só as fotografias de gatos na caixa abaixo:",
	'asirra-addurl' => "A sua edição contém links externos novos. Como prevenção contra sistemas automatizados de inserção de ''spam'', seleccione só as fotografias de gatos na caixa abaixo:",
	'asirra-badpass' => 'Como prevenção com sistemas automatizados de descoberta de palavras-chave, seleccione só as fotografias de gatos na caixa abaixo:',
	'asirra-createaccount' => 'Como prevenção contra sistemas automatizados de criação de contas, seleccione só as fotografias de gatos na caixa abaixo:',
	'asirra-createaccount-fail' => 'Identifique correctamente os gatos, por favor.',
	'asirra-create' => 'Como prevenção contra sistemas automatizados de criação de páginas, seleccione só as fotografias de gatos na caixa abaixo:',
	'asirra-nojs' => "'''Possibilite o uso de JavaScript e reenvie a página, por favor.'''",
);

/** Simplified Chinese (‪中文(简体)‬)
 * @author Hzy980512
 */
$messages['zh-hans'] = array(
	'asirra-desc' => 'ConfirmEdit的Asirra模块',
	'asirra-edit' => '为了防止垃圾编辑攻击，请在下面的方框中选出猫的图片：',
	'asirra-addurl' => '您的编辑包含新的外部链接。为了帮助防止自动垃圾邮件，请在下面的方框中选出猫的图片：',
	'asirra-badpass' => '为防止自动程序破解密码，请在下面的方框中选出猫的图片：',
	'asirra-createaccount' => '为了防止自动程序创建帐户，请在下面的方框中选出猫的图片：',
	'asirra-createaccount-fail' => '请正确辨认出猫的图片。',
	'asirra-create' => '为了防止自动程序创建页面，请在下面的方框中选出猫的图片：',
	'asirra-nojs' => "'''请启动JavaScript后再提交页面。'''",
	'asirra-failed' => '请选出所有猫的图片',
);

