# -*- coding: utf8 -*-

# LaTeX math to Unicode symbols translation dictionaries.
# Generated with ``write_tex2unichar.py`` from the data in
# http://milde.users.sourceforge.net/LUCR/Math/

# Includes commands from: wasysym, stmaryrd, mathdots, mathabx, esint, bbold, amsxtra, amsmath, amssymb, standard LaTeX

mathaccent = {
    'acute': u'\u0301', # x́ COMBINING ACUTE ACCENT
    'bar': u'\u0304', # x̄ COMBINING MACRON
    'breve': u'\u0306', # x̆ COMBINING BREVE
    'check': u'\u030c', # x̌ COMBINING CARON
    'ddddot': u'\u20dc', # x⃜ COMBINING FOUR DOTS ABOVE
    'dddot': u'\u20db', # x⃛ COMBINING THREE DOTS ABOVE
    'ddot': u'\u0308', # ẍ COMBINING DIAERESIS
    'dot': u'\u0307', # ẋ COMBINING DOT ABOVE
    'grave': u'\u0300', # x̀ COMBINING GRAVE ACCENT
    'hat': u'\u0302', # x̂ COMBINING CIRCUMFLEX ACCENT
    'mathring': u'\u030a', # x̊ COMBINING RING ABOVE
    'not': u'\u0338', # x̸ COMBINING LONG SOLIDUS OVERLAY
    'overleftarrow': u'\u20d6', # x⃖ COMBINING LEFT ARROW ABOVE
    'overleftrightarrow': u'\u20e1', # x⃡ COMBINING LEFT RIGHT ARROW ABOVE
    'overline': u'\u0305', # x̅ COMBINING OVERLINE
    'overrightarrow': u'\u20d7', # x⃗ COMBINING RIGHT ARROW ABOVE
    'tilde': u'\u0303', # x̃ COMBINING TILDE
    'underbar': u'\u0331', # x̱ COMBINING MACRON BELOW
    'underleftarrow': u'\u20ee', # x⃮ COMBINING LEFT ARROW BELOW
    'underline': u'\u0332', # x̲ COMBINING LOW LINE
    'underrightarrow': u'\u20ef', # x⃯ COMBINING RIGHT ARROW BELOW
    'vec': u'\u20d7', # x⃗ COMBINING RIGHT ARROW ABOVE
    'widehat': u'\u0302', # x̂ COMBINING CIRCUMFLEX ACCENT
    'widetilde': u'\u0303', # x̃ COMBINING TILDE
    }
mathalpha = {
    'Bbbk': u'\U0001d55c', # 𝕜 MATHEMATICAL DOUBLE-STRUCK SMALL K
    'Delta': u'\u0394', # Δ GREEK CAPITAL LETTER DELTA
    'Gamma': u'\u0393', # Γ GREEK CAPITAL LETTER GAMMA
    'Im': u'\u2111', # ℑ BLACK-LETTER CAPITAL I
    'Lambda': u'\u039b', # Λ GREEK CAPITAL LETTER LAMDA
    'Omega': u'\u03a9', # Ω GREEK CAPITAL LETTER OMEGA
    'Phi': u'\u03a6', # Φ GREEK CAPITAL LETTER PHI
    'Pi': u'\u03a0', # Π GREEK CAPITAL LETTER PI
    'Psi': u'\u03a8', # Ψ GREEK CAPITAL LETTER PSI
    'Re': u'\u211c', # ℜ BLACK-LETTER CAPITAL R
    'Sigma': u'\u03a3', # Σ GREEK CAPITAL LETTER SIGMA
    'Theta': u'\u0398', # Θ GREEK CAPITAL LETTER THETA
    'Upsilon': u'\u03a5', # Υ GREEK CAPITAL LETTER UPSILON
    'Xi': u'\u039e', # Ξ GREEK CAPITAL LETTER XI
    'aleph': u'\u2135', # ℵ ALEF SYMBOL
    'alpha': u'\u03b1', # α GREEK SMALL LETTER ALPHA
    'beta': u'\u03b2', # β GREEK SMALL LETTER BETA
    'beth': u'\u2136', # ℶ BET SYMBOL
    'chi': u'\u03c7', # χ GREEK SMALL LETTER CHI
    'daleth': u'\u2138', # ℸ DALET SYMBOL
    'delta': u'\u03b4', # δ GREEK SMALL LETTER DELTA
    'digamma': u'\u03dc', # Ϝ GREEK LETTER DIGAMMA
    'ell': u'\u2113', # ℓ SCRIPT SMALL L
    'epsilon': u'\u03f5', # ϵ GREEK LUNATE EPSILON SYMBOL
    'eta': u'\u03b7', # η GREEK SMALL LETTER ETA
    'eth': u'\xf0', # ð LATIN SMALL LETTER ETH
    'gamma': u'\u03b3', # γ GREEK SMALL LETTER GAMMA
    'gimel': u'\u2137', # ℷ GIMEL SYMBOL
    'hbar': u'\u210f', # ℏ PLANCK CONSTANT OVER TWO PI
    'hslash': u'\u210f', # ℏ PLANCK CONSTANT OVER TWO PI
    'imath': u'\u0131', # ı LATIN SMALL LETTER DOTLESS I
    'iota': u'\u03b9', # ι GREEK SMALL LETTER IOTA
    'jmath': u'\u0237', # ȷ LATIN SMALL LETTER DOTLESS J
    'kappa': u'\u03ba', # κ GREEK SMALL LETTER KAPPA
    'lambda': u'\u03bb', # λ GREEK SMALL LETTER LAMDA
    'mu': u'\u03bc', # μ GREEK SMALL LETTER MU
    'nu': u'\u03bd', # ν GREEK SMALL LETTER NU
    'omega': u'\u03c9', # ω GREEK SMALL LETTER OMEGA
    'phi': u'\u03d5', # ϕ GREEK PHI SYMBOL
    'pi': u'\u03c0', # π GREEK SMALL LETTER PI
    'psi': u'\u03c8', # ψ GREEK SMALL LETTER PSI
    'rho': u'\u03c1', # ρ GREEK SMALL LETTER RHO
    'sigma': u'\u03c3', # σ GREEK SMALL LETTER SIGMA
    'tau': u'\u03c4', # τ GREEK SMALL LETTER TAU
    'theta': u'\u03b8', # θ GREEK SMALL LETTER THETA
    'upsilon': u'\u03c5', # υ GREEK SMALL LETTER UPSILON
    'varDelta': u'\U0001d6e5', # 𝛥 MATHEMATICAL ITALIC CAPITAL DELTA
    'varGamma': u'\U0001d6e4', # 𝛤 MATHEMATICAL ITALIC CAPITAL GAMMA
    'varLambda': u'\U0001d6ec', # 𝛬 MATHEMATICAL ITALIC CAPITAL LAMDA
    'varOmega': u'\U0001d6fa', # 𝛺 MATHEMATICAL ITALIC CAPITAL OMEGA
    'varPhi': u'\U0001d6f7', # 𝛷 MATHEMATICAL ITALIC CAPITAL PHI
    'varPi': u'\U0001d6f1', # 𝛱 MATHEMATICAL ITALIC CAPITAL PI
    'varPsi': u'\U0001d6f9', # 𝛹 MATHEMATICAL ITALIC CAPITAL PSI
    'varSigma': u'\U0001d6f4', # 𝛴 MATHEMATICAL ITALIC CAPITAL SIGMA
    'varTheta': u'\U0001d6e9', # 𝛩 MATHEMATICAL ITALIC CAPITAL THETA
    'varUpsilon': u'\U0001d6f6', # 𝛶 MATHEMATICAL ITALIC CAPITAL UPSILON
    'varXi': u'\U0001d6ef', # 𝛯 MATHEMATICAL ITALIC CAPITAL XI
    'varepsilon': u'\u03b5', # ε GREEK SMALL LETTER EPSILON
    'varkappa': u'\U0001d718', # 𝜘 MATHEMATICAL ITALIC KAPPA SYMBOL
    'varphi': u'\u03c6', # φ GREEK SMALL LETTER PHI
    'varpi': u'\u03d6', # ϖ GREEK PI SYMBOL
    'varrho': u'\u03f1', # ϱ GREEK RHO SYMBOL
    'varsigma': u'\u03c2', # ς GREEK SMALL LETTER FINAL SIGMA
    'vartheta': u'\u03d1', # ϑ GREEK THETA SYMBOL
    'wp': u'\u2118', # ℘ SCRIPT CAPITAL P
    'xi': u'\u03be', # ξ GREEK SMALL LETTER XI
    'zeta': u'\u03b6', # ζ GREEK SMALL LETTER ZETA
    }
mathbin = {
    'Cap': u'\u22d2', # ⋒ DOUBLE INTERSECTION
    'Circle': u'\u25cb', # ○ WHITE CIRCLE
    'Cup': u'\u22d3', # ⋓ DOUBLE UNION
    'LHD': u'\u25c0', # ◀ BLACK LEFT-POINTING TRIANGLE
    'RHD': u'\u25b6', # ▶ BLACK RIGHT-POINTING TRIANGLE
    'amalg': u'\u2a3f', # ⨿ AMALGAMATION OR COPRODUCT
    'ast': u'\u2217', # ∗ ASTERISK OPERATOR
    'barwedge': u'\u22bc', # ⊼ NAND
    'bigtriangledown': u'\u25bd', # ▽ WHITE DOWN-POINTING TRIANGLE
    'bigtriangleup': u'\u25b3', # △ WHITE UP-POINTING TRIANGLE
    'bindnasrepma': u'\u214b', # ⅋ TURNED AMPERSAND
    'blacklozenge': u'\u29eb', # ⧫ BLACK LOZENGE
    'blacktriangledown': u'\u25be', # ▾ BLACK DOWN-POINTING SMALL TRIANGLE
    'blacktriangleleft': u'\u25c2', # ◂ BLACK LEFT-POINTING SMALL TRIANGLE
    'blacktriangleright': u'\u25b8', # ▸ BLACK RIGHT-POINTING SMALL TRIANGLE
    'blacktriangleup': u'\u25b4', # ▴ BLACK UP-POINTING SMALL TRIANGLE
    'boxast': u'\u29c6', # ⧆ SQUARED ASTERISK
    'boxbar': u'\u25eb', # ◫ WHITE SQUARE WITH VERTICAL BISECTING LINE
    'boxbox': u'\u29c8', # ⧈ SQUARED SQUARE
    'boxbslash': u'\u29c5', # ⧅ SQUARED FALLING DIAGONAL SLASH
    'boxcircle': u'\u29c7', # ⧇ SQUARED SMALL CIRCLE
    'boxdot': u'\u22a1', # ⊡ SQUARED DOT OPERATOR
    'boxminus': u'\u229f', # ⊟ SQUARED MINUS
    'boxplus': u'\u229e', # ⊞ SQUARED PLUS
    'boxslash': u'\u29c4', # ⧄ SQUARED RISING DIAGONAL SLASH
    'boxtimes': u'\u22a0', # ⊠ SQUARED TIMES
    'bullet': u'\u2219', # ∙ BULLET OPERATOR
    'cap': u'\u2229', # ∩ INTERSECTION
    'cdot': u'\u22c5', # ⋅ DOT OPERATOR
    'circ': u'\u2218', # ∘ RING OPERATOR
    'circledast': u'\u229b', # ⊛ CIRCLED ASTERISK OPERATOR
    'circledcirc': u'\u229a', # ⊚ CIRCLED RING OPERATOR
    'circleddash': u'\u229d', # ⊝ CIRCLED DASH
    'cup': u'\u222a', # ∪ UNION
    'curlyvee': u'\u22ce', # ⋎ CURLY LOGICAL OR
    'curlywedge': u'\u22cf', # ⋏ CURLY LOGICAL AND
    'dagger': u'\u2020', # † DAGGER
    'ddagger': u'\u2021', # ‡ DOUBLE DAGGER
    'diamond': u'\u22c4', # ⋄ DIAMOND OPERATOR
    'div': u'\xf7', # ÷ DIVISION SIGN
    'divideontimes': u'\u22c7', # ⋇ DIVISION TIMES
    'dotplus': u'\u2214', # ∔ DOT PLUS
    'doublebarwedge': u'\u2a5e', # ⩞ LOGICAL AND WITH DOUBLE OVERBAR
    'intercal': u'\u22ba', # ⊺ INTERCALATE
    'interleave': u'\u2af4', # ⫴ TRIPLE VERTICAL BAR BINARY RELATION
    'land': u'\u2227', # ∧ LOGICAL AND
    'leftthreetimes': u'\u22cb', # ⋋ LEFT SEMIDIRECT PRODUCT
    'lhd': u'\u25c1', # ◁ WHITE LEFT-POINTING TRIANGLE
    'lor': u'\u2228', # ∨ LOGICAL OR
    'ltimes': u'\u22c9', # ⋉ LEFT NORMAL FACTOR SEMIDIRECT PRODUCT
    'mp': u'\u2213', # ∓ MINUS-OR-PLUS SIGN
    'odot': u'\u2299', # ⊙ CIRCLED DOT OPERATOR
    'ominus': u'\u2296', # ⊖ CIRCLED MINUS
    'oplus': u'\u2295', # ⊕ CIRCLED PLUS
    'oslash': u'\u2298', # ⊘ CIRCLED DIVISION SLASH
    'otimes': u'\u2297', # ⊗ CIRCLED TIMES
    'pm': u'\xb1', # ± PLUS-MINUS SIGN
    'rhd': u'\u25b7', # ▷ WHITE RIGHT-POINTING TRIANGLE
    'rightthreetimes': u'\u22cc', # ⋌ RIGHT SEMIDIRECT PRODUCT
    'rtimes': u'\u22ca', # ⋊ RIGHT NORMAL FACTOR SEMIDIRECT PRODUCT
    'setminus': u'\u29f5', # ⧵ REVERSE SOLIDUS OPERATOR
    'slash': u'\u2215', # ∕ DIVISION SLASH
    'smallsetminus': u'\u2216', # ∖ SET MINUS
    'smalltriangledown': u'\u25bf', # ▿ WHITE DOWN-POINTING SMALL TRIANGLE
    'smalltriangleleft': u'\u25c3', # ◃ WHITE LEFT-POINTING SMALL TRIANGLE
    'smalltriangleright': u'\u25b9', # ▹ WHITE RIGHT-POINTING SMALL TRIANGLE
    'smalltriangleup': u'\u25b5', # ▵ WHITE UP-POINTING SMALL TRIANGLE
    'sqcap': u'\u2293', # ⊓ SQUARE CAP
    'sqcup': u'\u2294', # ⊔ SQUARE CUP
    'sslash': u'\u2afd', # ⫽ DOUBLE SOLIDUS OPERATOR
    'star': u'\u22c6', # ⋆ STAR OPERATOR
    'talloblong': u'\u2afe', # ⫾ WHITE VERTICAL BAR
    'times': u'\xd7', # × MULTIPLICATION SIGN
    'triangle': u'\u25b3', # △ WHITE UP-POINTING TRIANGLE
    'triangledown': u'\u25bf', # ▿ WHITE DOWN-POINTING SMALL TRIANGLE
    'triangleleft': u'\u25c3', # ◃ WHITE LEFT-POINTING SMALL TRIANGLE
    'triangleright': u'\u25b9', # ▹ WHITE RIGHT-POINTING SMALL TRIANGLE
    'uplus': u'\u228e', # ⊎ MULTISET UNION
    'vartriangle': u'\u25b3', # △ WHITE UP-POINTING TRIANGLE
    'vee': u'\u2228', # ∨ LOGICAL OR
    'veebar': u'\u22bb', # ⊻ XOR
    'wedge': u'\u2227', # ∧ LOGICAL AND
    'wr': u'\u2240', # ≀ WREATH PRODUCT
    }
mathclose = {
    'Rbag': u'\u27c6', # ⟆ RIGHT S-SHAPED BAG DELIMITER
    'lrcorner': u'\u231f', # ⌟ BOTTOM RIGHT CORNER
    'rangle': u'\u27e9', # ⟩ MATHEMATICAL RIGHT ANGLE BRACKET
    'rbag': u'\u27c6', # ⟆ RIGHT S-SHAPED BAG DELIMITER
    'rbrace': u'}', # } RIGHT CURLY BRACKET
    'rbrack': u']', # ] RIGHT SQUARE BRACKET
    'rceil': u'\u2309', # ⌉ RIGHT CEILING
    'rfloor': u'\u230b', # ⌋ RIGHT FLOOR
    'rgroup': u'\u27ef', # ⟯ MATHEMATICAL RIGHT FLATTENED PARENTHESIS
    'rrbracket': u'\u27e7', # ⟧ MATHEMATICAL RIGHT WHITE SQUARE BRACKET
    'rrparenthesis': u'\u2988', # ⦈ Z NOTATION RIGHT IMAGE BRACKET
    'urcorner': u'\u231d', # ⌝ TOP RIGHT CORNER
    '}': u'}', # } RIGHT CURLY BRACKET
    }
mathfence = {
    'Vert': u'\u2016', # ‖ DOUBLE VERTICAL LINE
    'vert': u'|', # | VERTICAL LINE
    '|': u'\u2016', # ‖ DOUBLE VERTICAL LINE
    }
mathop = {
    'Join': u'\u2a1d', # ⨝ JOIN
    'bigcap': u'\u22c2', # ⋂ N-ARY INTERSECTION
    'bigcup': u'\u22c3', # ⋃ N-ARY UNION
    'biginterleave': u'\u2afc', # ⫼ LARGE TRIPLE VERTICAL BAR OPERATOR
    'bigodot': u'\u2a00', # ⨀ N-ARY CIRCLED DOT OPERATOR
    'bigoplus': u'\u2a01', # ⨁ N-ARY CIRCLED PLUS OPERATOR
    'bigotimes': u'\u2a02', # ⨂ N-ARY CIRCLED TIMES OPERATOR
    'bigsqcup': u'\u2a06', # ⨆ N-ARY SQUARE UNION OPERATOR
    'biguplus': u'\u2a04', # ⨄ N-ARY UNION OPERATOR WITH PLUS
    'bigvee': u'\u22c1', # ⋁ N-ARY LOGICAL OR
    'bigwedge': u'\u22c0', # ⋀ N-ARY LOGICAL AND
    'coprod': u'\u2210', # ∐ N-ARY COPRODUCT
    'fatsemi': u'\u2a1f', # ⨟ Z NOTATION SCHEMA COMPOSITION
    'fint': u'\u2a0f', # ⨏ INTEGRAL AVERAGE WITH SLASH
    'iiiint': u'\u2a0c', # ⨌ QUADRUPLE INTEGRAL OPERATOR
    'iiint': u'\u222d', # ∭ TRIPLE INTEGRAL
    'iint': u'\u222c', # ∬ DOUBLE INTEGRAL
    'int': u'\u222b', # ∫ INTEGRAL
    'oiint': u'\u222f', # ∯ SURFACE INTEGRAL
    'oint': u'\u222e', # ∮ CONTOUR INTEGRAL
    'ointctrclockwise': u'\u2233', # ∳ ANTICLOCKWISE CONTOUR INTEGRAL
    'prod': u'\u220f', # ∏ N-ARY PRODUCT
    'sqint': u'\u2a16', # ⨖ QUATERNION INTEGRAL OPERATOR
    'sum': u'\u2211', # ∑ N-ARY SUMMATION
    'varointclockwise': u'\u2232', # ∲ CLOCKWISE CONTOUR INTEGRAL
    }
mathopen = {
    'Lbag': u'\u27c5', # ⟅ LEFT S-SHAPED BAG DELIMITER
    'langle': u'\u27e8', # ⟨ MATHEMATICAL LEFT ANGLE BRACKET
    'lbag': u'\u27c5', # ⟅ LEFT S-SHAPED BAG DELIMITER
    'lbrace': u'{', # { LEFT CURLY BRACKET
    'lbrack': u'[', # [ LEFT SQUARE BRACKET
    'lceil': u'\u2308', # ⌈ LEFT CEILING
    'lfloor': u'\u230a', # ⌊ LEFT FLOOR
    'lgroup': u'\u27ee', # ⟮ MATHEMATICAL LEFT FLATTENED PARENTHESIS
    'llbracket': u'\u27e6', # ⟦ MATHEMATICAL LEFT WHITE SQUARE BRACKET
    'llcorner': u'\u231e', # ⌞ BOTTOM LEFT CORNER
    'llparenthesis': u'\u2987', # ⦇ Z NOTATION LEFT IMAGE BRACKET
    'ulcorner': u'\u231c', # ⌜ TOP LEFT CORNER
    '{': u'{', # { LEFT CURLY BRACKET
    }
mathord = {
    '#': u'#', # # NUMBER SIGN
    '$': u'$', # $ DOLLAR SIGN
    '%': u'%', # % PERCENT SIGN
    '&': u'&', # & AMPERSAND
    'AC': u'\u223f', # ∿ SINE WAVE
    'APLcomment': u'\u235d', # ⍝ APL FUNCTIONAL SYMBOL UP SHOE JOT
    'APLdownarrowbox': u'\u2357', # ⍗ APL FUNCTIONAL SYMBOL QUAD DOWNWARDS ARROW
    'APLinput': u'\u235e', # ⍞ APL FUNCTIONAL SYMBOL QUOTE QUAD
    'APLinv': u'\u2339', # ⌹ APL FUNCTIONAL SYMBOL QUAD DIVIDE
    'APLleftarrowbox': u'\u2347', # ⍇ APL FUNCTIONAL SYMBOL QUAD LEFTWARDS ARROW
    'APLlog': u'\u235f', # ⍟ APL FUNCTIONAL SYMBOL CIRCLE STAR
    'APLrightarrowbox': u'\u2348', # ⍈ APL FUNCTIONAL SYMBOL QUAD RIGHTWARDS ARROW
    'APLuparrowbox': u'\u2350', # ⍐ APL FUNCTIONAL SYMBOL QUAD UPWARDS ARROW
    'Aries': u'\u2648', # ♈ ARIES
    'CIRCLE': u'\u25cf', # ● BLACK CIRCLE
    'CheckedBox': u'\u2611', # ☑ BALLOT BOX WITH CHECK
    'Diamond': u'\u25c7', # ◇ WHITE DIAMOND
    'Finv': u'\u2132', # Ⅎ TURNED CAPITAL F
    'Game': u'\u2141', # ⅁ TURNED SANS-SERIF CAPITAL G
    'Gemini': u'\u264a', # ♊ GEMINI
    'Jupiter': u'\u2643', # ♃ JUPITER
    'LEFTCIRCLE': u'\u25d6', # ◖ LEFT HALF BLACK CIRCLE
    'LEFTcircle': u'\u25d0', # ◐ CIRCLE WITH LEFT HALF BLACK
    'Leo': u'\u264c', # ♌ LEO
    'Libra': u'\u264e', # ♎ LIBRA
    'Mars': u'\u2642', # ♂ MALE SIGN
    'Mercury': u'\u263f', # ☿ MERCURY
    'Neptune': u'\u2646', # ♆ NEPTUNE
    'Pluto': u'\u2647', # ♇ PLUTO
    'RIGHTCIRCLE': u'\u25d7', # ◗ RIGHT HALF BLACK CIRCLE
    'RIGHTcircle': u'\u25d1', # ◑ CIRCLE WITH RIGHT HALF BLACK
    'Saturn': u'\u2644', # ♄ SATURN
    'Scorpio': u'\u264f', # ♏ SCORPIUS
    'Square': u'\u2610', # ☐ BALLOT BOX
    'Sun': u'\u2609', # ☉ SUN
    'Taurus': u'\u2649', # ♉ TAURUS
    'Uranus': u'\u2645', # ♅ URANUS
    'Venus': u'\u2640', # ♀ FEMALE SIGN
    'XBox': u'\u2612', # ☒ BALLOT BOX WITH X
    'Yup': u'\u2144', # ⅄ TURNED SANS-SERIF CAPITAL Y
    '_': u'_', # _ LOW LINE
    'angle': u'\u2220', # ∠ ANGLE
    'aquarius': u'\u2652', # ♒ AQUARIUS
    'aries': u'\u2648', # ♈ ARIES
    'ast': u'*', # * ASTERISK
    'backepsilon': u'\u03f6', # ϶ GREEK REVERSED LUNATE EPSILON SYMBOL
    'backprime': u'\u2035', # ‵ REVERSED PRIME
    'backslash': u'\\', # \ REVERSE SOLIDUS
    'because': u'\u2235', # ∵ BECAUSE
    'bigstar': u'\u2605', # ★ BLACK STAR
    'binampersand': u'&', # & AMPERSAND
    'blacklozenge': u'\u2b27', # ⬧ BLACK MEDIUM LOZENGE
    'blacksmiley': u'\u263b', # ☻ BLACK SMILING FACE
    'blacksquare': u'\u25fc', # ◼ BLACK MEDIUM SQUARE
    'bot': u'\u22a5', # ⊥ UP TACK
    'boy': u'\u2642', # ♂ MALE SIGN
    'cancer': u'\u264b', # ♋ CANCER
    'capricornus': u'\u2651', # ♑ CAPRICORN
    'cdots': u'\u22ef', # ⋯ MIDLINE HORIZONTAL ELLIPSIS
    'cent': u'\xa2', # ¢ CENT SIGN
    'centerdot': u'\u2b1d', # ⬝ BLACK VERY SMALL SQUARE
    'checkmark': u'\u2713', # ✓ CHECK MARK
    'circlearrowleft': u'\u21ba', # ↺ ANTICLOCKWISE OPEN CIRCLE ARROW
    'circlearrowright': u'\u21bb', # ↻ CLOCKWISE OPEN CIRCLE ARROW
    'circledR': u'\xae', # ® REGISTERED SIGN
    'circledcirc': u'\u25ce', # ◎ BULLSEYE
    'clubsuit': u'\u2663', # ♣ BLACK CLUB SUIT
    'complement': u'\u2201', # ∁ COMPLEMENT
    'dasharrow': u'\u21e2', # ⇢ RIGHTWARDS DASHED ARROW
    'dashleftarrow': u'\u21e0', # ⇠ LEFTWARDS DASHED ARROW
    'dashrightarrow': u'\u21e2', # ⇢ RIGHTWARDS DASHED ARROW
    'diameter': u'\u2300', # ⌀ DIAMETER SIGN
    'diamondsuit': u'\u2662', # ♢ WHITE DIAMOND SUIT
    'earth': u'\u2641', # ♁ EARTH
    'exists': u'\u2203', # ∃ THERE EXISTS
    'female': u'\u2640', # ♀ FEMALE SIGN
    'flat': u'\u266d', # ♭ MUSIC FLAT SIGN
    'forall': u'\u2200', # ∀ FOR ALL
    'fourth': u'\u2057', # ⁗ QUADRUPLE PRIME
    'frownie': u'\u2639', # ☹ WHITE FROWNING FACE
    'gemini': u'\u264a', # ♊ GEMINI
    'girl': u'\u2640', # ♀ FEMALE SIGN
    'heartsuit': u'\u2661', # ♡ WHITE HEART SUIT
    'infty': u'\u221e', # ∞ INFINITY
    'invneg': u'\u2310', # ⌐ REVERSED NOT SIGN
    'jupiter': u'\u2643', # ♃ JUPITER
    'ldots': u'\u2026', # … HORIZONTAL ELLIPSIS
    'leftmoon': u'\u263e', # ☾ LAST QUARTER MOON
    'leftturn': u'\u21ba', # ↺ ANTICLOCKWISE OPEN CIRCLE ARROW
    'leo': u'\u264c', # ♌ LEO
    'libra': u'\u264e', # ♎ LIBRA
    'lnot': u'\xac', # ¬ NOT SIGN
    'lozenge': u'\u25ca', # ◊ LOZENGE
    'male': u'\u2642', # ♂ MALE SIGN
    'maltese': u'\u2720', # ✠ MALTESE CROSS
    'mathdollar': u'$', # $ DOLLAR SIGN
    'measuredangle': u'\u2221', # ∡ MEASURED ANGLE
    'mercury': u'\u263f', # ☿ MERCURY
    'mho': u'\u2127', # ℧ INVERTED OHM SIGN
    'nabla': u'\u2207', # ∇ NABLA
    'natural': u'\u266e', # ♮ MUSIC NATURAL SIGN
    'neg': u'\xac', # ¬ NOT SIGN
    'neptune': u'\u2646', # ♆ NEPTUNE
    'nexists': u'\u2204', # ∄ THERE DOES NOT EXIST
    'notbackslash': u'\u2340', # ⍀ APL FUNCTIONAL SYMBOL BACKSLASH BAR
    'partial': u'\u2202', # ∂ PARTIAL DIFFERENTIAL
    'pisces': u'\u2653', # ♓ PISCES
    'pluto': u'\u2647', # ♇ PLUTO
    'pounds': u'\xa3', # £ POUND SIGN
    'prime': u'\u2032', # ′ PRIME
    'quarternote': u'\u2669', # ♩ QUARTER NOTE
    'rightmoon': u'\u263d', # ☽ FIRST QUARTER MOON
    'rightturn': u'\u21bb', # ↻ CLOCKWISE OPEN CIRCLE ARROW
    'sagittarius': u'\u2650', # ♐ SAGITTARIUS
    'saturn': u'\u2644', # ♄ SATURN
    'scorpio': u'\u264f', # ♏ SCORPIUS
    'second': u'\u2033', # ″ DOUBLE PRIME
    'sharp': u'\u266f', # ♯ MUSIC SHARP SIGN
    'sim': u'~', # ~ TILDE
    'slash': u'/', # / SOLIDUS
    'smiley': u'\u263a', # ☺ WHITE SMILING FACE
    'spadesuit': u'\u2660', # ♠ BLACK SPADE SUIT
    'spddot': u'\xa8', # ¨ DIAERESIS
    'sphat': u'^', # ^ CIRCUMFLEX ACCENT
    'sphericalangle': u'\u2222', # ∢ SPHERICAL ANGLE
    'sptilde': u'~', # ~ TILDE
    'square': u'\u25fb', # ◻ WHITE MEDIUM SQUARE
    'sun': u'\u263c', # ☼ WHITE SUN WITH RAYS
    'taurus': u'\u2649', # ♉ TAURUS
    'therefore': u'\u2234', # ∴ THEREFORE
    'third': u'\u2034', # ‴ TRIPLE PRIME
    'top': u'\u22a4', # ⊤ DOWN TACK
    'triangleleft': u'\u25c5', # ◅ WHITE LEFT-POINTING POINTER
    'triangleright': u'\u25bb', # ▻ WHITE RIGHT-POINTING POINTER
    'twonotes': u'\u266b', # ♫ BEAMED EIGHTH NOTES
    'uranus': u'\u2645', # ♅ URANUS
    'varEarth': u'\u2641', # ♁ EARTH
    'varnothing': u'\u2205', # ∅ EMPTY SET
    'virgo': u'\u264d', # ♍ VIRGO
    'wasylozenge': u'\u2311', # ⌑ SQUARE LOZENGE
    'wasytherefore': u'\u2234', # ∴ THEREFORE
    'yen': u'\xa5', # ¥ YEN SIGN
    }
mathover = {
    'overbrace': u'\u23de', # ⏞ TOP CURLY BRACKET
    'wideparen': u'\u23dc', # ⏜ TOP PARENTHESIS
    }
mathradical = {
    'sqrt': u'\u221a', # √ SQUARE ROOT
    'sqrt[3]': u'\u221b', # ∛ CUBE ROOT
    'sqrt[4]': u'\u221c', # ∜ FOURTH ROOT
    }
mathrel = {
    'Bumpeq': u'\u224e', # ≎ GEOMETRICALLY EQUIVALENT TO
    'Doteq': u'\u2251', # ≑ GEOMETRICALLY EQUAL TO
    'Downarrow': u'\u21d3', # ⇓ DOWNWARDS DOUBLE ARROW
    'Leftarrow': u'\u21d0', # ⇐ LEFTWARDS DOUBLE ARROW
    'Leftrightarrow': u'\u21d4', # ⇔ LEFT RIGHT DOUBLE ARROW
    'Lleftarrow': u'\u21da', # ⇚ LEFTWARDS TRIPLE ARROW
    'Longleftarrow': u'\u27f8', # ⟸ LONG LEFTWARDS DOUBLE ARROW
    'Longleftrightarrow': u'\u27fa', # ⟺ LONG LEFT RIGHT DOUBLE ARROW
    'Longmapsfrom': u'\u27fd', # ⟽ LONG LEFTWARDS DOUBLE ARROW FROM BAR
    'Longmapsto': u'\u27fe', # ⟾ LONG RIGHTWARDS DOUBLE ARROW FROM BAR
    'Longrightarrow': u'\u27f9', # ⟹ LONG RIGHTWARDS DOUBLE ARROW
    'Lsh': u'\u21b0', # ↰ UPWARDS ARROW WITH TIP LEFTWARDS
    'Mapsfrom': u'\u2906', # ⤆ LEFTWARDS DOUBLE ARROW FROM BAR
    'Mapsto': u'\u2907', # ⤇ RIGHTWARDS DOUBLE ARROW FROM BAR
    'Rightarrow': u'\u21d2', # ⇒ RIGHTWARDS DOUBLE ARROW
    'Rrightarrow': u'\u21db', # ⇛ RIGHTWARDS TRIPLE ARROW
    'Rsh': u'\u21b1', # ↱ UPWARDS ARROW WITH TIP RIGHTWARDS
    'Subset': u'\u22d0', # ⋐ DOUBLE SUBSET
    'Supset': u'\u22d1', # ⋑ DOUBLE SUPERSET
    'Uparrow': u'\u21d1', # ⇑ UPWARDS DOUBLE ARROW
    'Updownarrow': u'\u21d5', # ⇕ UP DOWN DOUBLE ARROW
    'VDash': u'\u22ab', # ⊫ DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
    'Vdash': u'\u22a9', # ⊩ FORCES
    'Vvdash': u'\u22aa', # ⊪ TRIPLE VERTICAL BAR RIGHT TURNSTILE
    'apprge': u'\u2273', # ≳ GREATER-THAN OR EQUIVALENT TO
    'apprle': u'\u2272', # ≲ LESS-THAN OR EQUIVALENT TO
    'approx': u'\u2248', # ≈ ALMOST EQUAL TO
    'approxeq': u'\u224a', # ≊ ALMOST EQUAL OR EQUAL TO
    'asymp': u'\u224d', # ≍ EQUIVALENT TO
    'backsim': u'\u223d', # ∽ REVERSED TILDE
    'backsimeq': u'\u22cd', # ⋍ REVERSED TILDE EQUALS
    'barin': u'\u22f6', # ⋶ ELEMENT OF WITH OVERBAR
    'barleftharpoon': u'\u296b', # ⥫ LEFTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
    'barrightharpoon': u'\u296d', # ⥭ RIGHTWARDS HARPOON WITH BARB DOWN BELOW LONG DASH
    'between': u'\u226c', # ≬ BETWEEN
    'bowtie': u'\u22c8', # ⋈ BOWTIE
    'bumpeq': u'\u224f', # ≏ DIFFERENCE BETWEEN
    'circeq': u'\u2257', # ≗ RING EQUAL TO
    'coloneq': u'\u2254', # ≔ COLON EQUALS
    'cong': u'\u2245', # ≅ APPROXIMATELY EQUAL TO
    'corresponds': u'\u2259', # ≙ ESTIMATES
    'curlyeqprec': u'\u22de', # ⋞ EQUAL TO OR PRECEDES
    'curlyeqsucc': u'\u22df', # ⋟ EQUAL TO OR SUCCEEDS
    'curvearrowleft': u'\u21b6', # ↶ ANTICLOCKWISE TOP SEMICIRCLE ARROW
    'curvearrowright': u'\u21b7', # ↷ CLOCKWISE TOP SEMICIRCLE ARROW
    'dashv': u'\u22a3', # ⊣ LEFT TACK
    'ddots': u'\u22f1', # ⋱ DOWN RIGHT DIAGONAL ELLIPSIS
    'dlsh': u'\u21b2', # ↲ DOWNWARDS ARROW WITH TIP LEFTWARDS
    'doteq': u'\u2250', # ≐ APPROACHES THE LIMIT
    'doteqdot': u'\u2251', # ≑ GEOMETRICALLY EQUAL TO
    'downarrow': u'\u2193', # ↓ DOWNWARDS ARROW
    'downdownarrows': u'\u21ca', # ⇊ DOWNWARDS PAIRED ARROWS
    'downdownharpoons': u'\u2965', # ⥥ DOWNWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
    'downharpoonleft': u'\u21c3', # ⇃ DOWNWARDS HARPOON WITH BARB LEFTWARDS
    'downharpoonright': u'\u21c2', # ⇂ DOWNWARDS HARPOON WITH BARB RIGHTWARDS
    'downuparrows': u'\u21f5', # ⇵ DOWNWARDS ARROW LEFTWARDS OF UPWARDS ARROW
    'downupharpoons': u'\u296f', # ⥯ DOWNWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
    'drsh': u'\u21b3', # ↳ DOWNWARDS ARROW WITH TIP RIGHTWARDS
    'eqcirc': u'\u2256', # ≖ RING IN EQUAL TO
    'eqcolon': u'\u2255', # ≕ EQUALS COLON
    'eqsim': u'\u2242', # ≂ MINUS TILDE
    'eqslantgtr': u'\u2a96', # ⪖ SLANTED EQUAL TO OR GREATER-THAN
    'eqslantless': u'\u2a95', # ⪕ SLANTED EQUAL TO OR LESS-THAN
    'equiv': u'\u2261', # ≡ IDENTICAL TO
    'fallingdotseq': u'\u2252', # ≒ APPROXIMATELY EQUAL TO OR THE IMAGE OF
    'frown': u'\u2322', # ⌢ FROWN
    'ge': u'\u2265', # ≥ GREATER-THAN OR EQUAL TO
    'geq': u'\u2265', # ≥ GREATER-THAN OR EQUAL TO
    'geqq': u'\u2267', # ≧ GREATER-THAN OVER EQUAL TO
    'geqslant': u'\u2a7e', # ⩾ GREATER-THAN OR SLANTED EQUAL TO
    'gets': u'\u2190', # ← LEFTWARDS ARROW
    'gg': u'\u226b', # ≫ MUCH GREATER-THAN
    'ggcurly': u'\u2abc', # ⪼ DOUBLE SUCCEEDS
    'ggg': u'\u22d9', # ⋙ VERY MUCH GREATER-THAN
    'gnapprox': u'\u2a8a', # ⪊ GREATER-THAN AND NOT APPROXIMATE
    'gneq': u'\u2a88', # ⪈ GREATER-THAN AND SINGLE-LINE NOT EQUAL TO
    'gneqq': u'\u2269', # ≩ GREATER-THAN BUT NOT EQUAL TO
    'gnsim': u'\u22e7', # ⋧ GREATER-THAN BUT NOT EQUIVALENT TO
    'gtrapprox': u'\u2a86', # ⪆ GREATER-THAN OR APPROXIMATE
    'gtrdot': u'\u22d7', # ⋗ GREATER-THAN WITH DOT
    'gtreqless': u'\u22db', # ⋛ GREATER-THAN EQUAL TO OR LESS-THAN
    'gtreqqless': u'\u2a8c', # ⪌ GREATER-THAN ABOVE DOUBLE-LINE EQUAL ABOVE LESS-THAN
    'gtrless': u'\u2277', # ≷ GREATER-THAN OR LESS-THAN
    'gtrsim': u'\u2273', # ≳ GREATER-THAN OR EQUIVALENT TO
    'hash': u'\u22d5', # ⋕ EQUAL AND PARALLEL TO
    'hookleftarrow': u'\u21a9', # ↩ LEFTWARDS ARROW WITH HOOK
    'hookrightarrow': u'\u21aa', # ↪ RIGHTWARDS ARROW WITH HOOK
    'iddots': u'\u22f0', # ⋰ UP RIGHT DIAGONAL ELLIPSIS
    'impliedby': u'\u27f8', # ⟸ LONG LEFTWARDS DOUBLE ARROW
    'implies': u'\u27f9', # ⟹ LONG RIGHTWARDS DOUBLE ARROW
    'in': u'\u2208', # ∈ ELEMENT OF
    'le': u'\u2264', # ≤ LESS-THAN OR EQUAL TO
    'leftarrow': u'\u2190', # ← LEFTWARDS ARROW
    'leftarrowtail': u'\u21a2', # ↢ LEFTWARDS ARROW WITH TAIL
    'leftarrowtriangle': u'\u21fd', # ⇽ LEFTWARDS OPEN-HEADED ARROW
    'leftbarharpoon': u'\u296a', # ⥪ LEFTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
    'leftharpoondown': u'\u21bd', # ↽ LEFTWARDS HARPOON WITH BARB DOWNWARDS
    'leftharpoonup': u'\u21bc', # ↼ LEFTWARDS HARPOON WITH BARB UPWARDS
    'leftleftarrows': u'\u21c7', # ⇇ LEFTWARDS PAIRED ARROWS
    'leftleftharpoons': u'\u2962', # ⥢ LEFTWARDS HARPOON WITH BARB UP ABOVE LEFTWARDS HARPOON WITH BARB DOWN
    'leftrightarrow': u'\u2194', # ↔ LEFT RIGHT ARROW
    'leftrightarrows': u'\u21c6', # ⇆ LEFTWARDS ARROW OVER RIGHTWARDS ARROW
    'leftrightarrowtriangle': u'\u21ff', # ⇿ LEFT RIGHT OPEN-HEADED ARROW
    'leftrightharpoon': u'\u294a', # ⥊ LEFT BARB UP RIGHT BARB DOWN HARPOON
    'leftrightharpoons': u'\u21cb', # ⇋ LEFTWARDS HARPOON OVER RIGHTWARDS HARPOON
    'leftrightsquigarrow': u'\u21ad', # ↭ LEFT RIGHT WAVE ARROW
    'leftslice': u'\u2aa6', # ⪦ LESS-THAN CLOSED BY CURVE
    'leftsquigarrow': u'\u21dc', # ⇜ LEFTWARDS SQUIGGLE ARROW
    'leq': u'\u2264', # ≤ LESS-THAN OR EQUAL TO
    'leqq': u'\u2266', # ≦ LESS-THAN OVER EQUAL TO
    'leqslant': u'\u2a7d', # ⩽ LESS-THAN OR SLANTED EQUAL TO
    'lessapprox': u'\u2a85', # ⪅ LESS-THAN OR APPROXIMATE
    'lessdot': u'\u22d6', # ⋖ LESS-THAN WITH DOT
    'lesseqgtr': u'\u22da', # ⋚ LESS-THAN EQUAL TO OR GREATER-THAN
    'lesseqqgtr': u'\u2a8b', # ⪋ LESS-THAN ABOVE DOUBLE-LINE EQUAL ABOVE GREATER-THAN
    'lessgtr': u'\u2276', # ≶ LESS-THAN OR GREATER-THAN
    'lesssim': u'\u2272', # ≲ LESS-THAN OR EQUIVALENT TO
    'lightning': u'\u21af', # ↯ DOWNWARDS ZIGZAG ARROW
    'll': u'\u226a', # ≪ MUCH LESS-THAN
    'llcurly': u'\u2abb', # ⪻ DOUBLE PRECEDES
    'lll': u'\u22d8', # ⋘ VERY MUCH LESS-THAN
    'lnapprox': u'\u2a89', # ⪉ LESS-THAN AND NOT APPROXIMATE
    'lneq': u'\u2a87', # ⪇ LESS-THAN AND SINGLE-LINE NOT EQUAL TO
    'lneqq': u'\u2268', # ≨ LESS-THAN BUT NOT EQUAL TO
    'lnsim': u'\u22e6', # ⋦ LESS-THAN BUT NOT EQUIVALENT TO
    'longleftarrow': u'\u27f5', # ⟵ LONG LEFTWARDS ARROW
    'longleftrightarrow': u'\u27f7', # ⟷ LONG LEFT RIGHT ARROW
    'longmapsfrom': u'\u27fb', # ⟻ LONG LEFTWARDS ARROW FROM BAR
    'longmapsto': u'\u27fc', # ⟼ LONG RIGHTWARDS ARROW FROM BAR
    'longrightarrow': u'\u27f6', # ⟶ LONG RIGHTWARDS ARROW
    'looparrowleft': u'\u21ab', # ↫ LEFTWARDS ARROW WITH LOOP
    'looparrowright': u'\u21ac', # ↬ RIGHTWARDS ARROW WITH LOOP
    'mapsfrom': u'\u21a4', # ↤ LEFTWARDS ARROW FROM BAR
    'mapsto': u'\u21a6', # ↦ RIGHTWARDS ARROW FROM BAR
    'mid': u'\u2223', # ∣ DIVIDES
    'models': u'\u22a7', # ⊧ MODELS
    'multimap': u'\u22b8', # ⊸ MULTIMAP
    'nLeftarrow': u'\u21cd', # ⇍ LEFTWARDS DOUBLE ARROW WITH STROKE
    'nLeftrightarrow': u'\u21ce', # ⇎ LEFT RIGHT DOUBLE ARROW WITH STROKE
    'nRightarrow': u'\u21cf', # ⇏ RIGHTWARDS DOUBLE ARROW WITH STROKE
    'nVDash': u'\u22af', # ⊯ NEGATED DOUBLE VERTICAL BAR DOUBLE RIGHT TURNSTILE
    'nVdash': u'\u22ae', # ⊮ DOES NOT FORCE
    'ncong': u'\u2247', # ≇ NEITHER APPROXIMATELY NOR ACTUALLY EQUAL TO
    'ne': u'\u2260', # ≠ NOT EQUAL TO
    'nearrow': u'\u2197', # ↗ NORTH EAST ARROW
    'neq': u'\u2260', # ≠ NOT EQUAL TO
    'ngeq': u'\u2271', # ≱ NEITHER GREATER-THAN NOR EQUAL TO
    'ngtr': u'\u226f', # ≯ NOT GREATER-THAN
    'ni': u'\u220b', # ∋ CONTAINS AS MEMBER
    'nleftarrow': u'\u219a', # ↚ LEFTWARDS ARROW WITH STROKE
    'nleftrightarrow': u'\u21ae', # ↮ LEFT RIGHT ARROW WITH STROKE
    'nleq': u'\u2270', # ≰ NEITHER LESS-THAN NOR EQUAL TO
    'nless': u'\u226e', # ≮ NOT LESS-THAN
    'nmid': u'\u2224', # ∤ DOES NOT DIVIDE
    'notasymp': u'\u226d', # ≭ NOT EQUIVALENT TO
    'notin': u'\u2209', # ∉ NOT AN ELEMENT OF
    'notowner': u'\u220c', # ∌ DOES NOT CONTAIN AS MEMBER
    'notslash': u'\u233f', # ⌿ APL FUNCTIONAL SYMBOL SLASH BAR
    'nparallel': u'\u2226', # ∦ NOT PARALLEL TO
    'nprec': u'\u2280', # ⊀ DOES NOT PRECEDE
    'npreceq': u'\u22e0', # ⋠ DOES NOT PRECEDE OR EQUAL
    'nrightarrow': u'\u219b', # ↛ RIGHTWARDS ARROW WITH STROKE
    'nsim': u'\u2241', # ≁ NOT TILDE
    'nsubseteq': u'\u2288', # ⊈ NEITHER A SUBSET OF NOR EQUAL TO
    'nsucc': u'\u2281', # ⊁ DOES NOT SUCCEED
    'nsucceq': u'\u22e1', # ⋡ DOES NOT SUCCEED OR EQUAL
    'nsupseteq': u'\u2289', # ⊉ NEITHER A SUPERSET OF NOR EQUAL TO
    'ntriangleleft': u'\u22ea', # ⋪ NOT NORMAL SUBGROUP OF
    'ntrianglelefteq': u'\u22ec', # ⋬ NOT NORMAL SUBGROUP OF OR EQUAL TO
    'ntriangleright': u'\u22eb', # ⋫ DOES NOT CONTAIN AS NORMAL SUBGROUP
    'ntrianglerighteq': u'\u22ed', # ⋭ DOES NOT CONTAIN AS NORMAL SUBGROUP OR EQUAL
    'nvDash': u'\u22ad', # ⊭ NOT TRUE
    'nvdash': u'\u22ac', # ⊬ DOES NOT PROVE
    'nwarrow': u'\u2196', # ↖ NORTH WEST ARROW
    'owns': u'\u220b', # ∋ CONTAINS AS MEMBER
    'parallel': u'\u2225', # ∥ PARALLEL TO
    'perp': u'\u27c2', # ⟂ PERPENDICULAR
    'pitchfork': u'\u22d4', # ⋔ PITCHFORK
    'prec': u'\u227a', # ≺ PRECEDES
    'precapprox': u'\u2ab7', # ⪷ PRECEDES ABOVE ALMOST EQUAL TO
    'preccurlyeq': u'\u227c', # ≼ PRECEDES OR EQUAL TO
    'preceq': u'\u2aaf', # ⪯ PRECEDES ABOVE SINGLE-LINE EQUALS SIGN
    'precnapprox': u'\u2ab9', # ⪹ PRECEDES ABOVE NOT ALMOST EQUAL TO
    'precnsim': u'\u22e8', # ⋨ PRECEDES BUT NOT EQUIVALENT TO
    'precsim': u'\u227e', # ≾ PRECEDES OR EQUIVALENT TO
    'propto': u'\u221d', # ∝ PROPORTIONAL TO
    'restriction': u'\u21be', # ↾ UPWARDS HARPOON WITH BARB RIGHTWARDS
    'rightarrow': u'\u2192', # → RIGHTWARDS ARROW
    'rightarrowtail': u'\u21a3', # ↣ RIGHTWARDS ARROW WITH TAIL
    'rightarrowtriangle': u'\u21fe', # ⇾ RIGHTWARDS OPEN-HEADED ARROW
    'rightbarharpoon': u'\u296c', # ⥬ RIGHTWARDS HARPOON WITH BARB UP ABOVE LONG DASH
    'rightharpoondown': u'\u21c1', # ⇁ RIGHTWARDS HARPOON WITH BARB DOWNWARDS
    'rightharpoonup': u'\u21c0', # ⇀ RIGHTWARDS HARPOON WITH BARB UPWARDS
    'rightleftarrows': u'\u21c4', # ⇄ RIGHTWARDS ARROW OVER LEFTWARDS ARROW
    'rightleftharpoon': u'\u294b', # ⥋ LEFT BARB DOWN RIGHT BARB UP HARPOON
    'rightleftharpoons': u'\u21cc', # ⇌ RIGHTWARDS HARPOON OVER LEFTWARDS HARPOON
    'rightrightarrows': u'\u21c9', # ⇉ RIGHTWARDS PAIRED ARROWS
    'rightrightharpoons': u'\u2964', # ⥤ RIGHTWARDS HARPOON WITH BARB UP ABOVE RIGHTWARDS HARPOON WITH BARB DOWN
    'rightslice': u'\u2aa7', # ⪧ GREATER-THAN CLOSED BY CURVE
    'rightsquigarrow': u'\u21dd', # ⇝ RIGHTWARDS SQUIGGLE ARROW
    'risingdotseq': u'\u2253', # ≓ IMAGE OF OR APPROXIMATELY EQUAL TO
    'searrow': u'\u2198', # ↘ SOUTH EAST ARROW
    'sim': u'\u223c', # ∼ TILDE OPERATOR
    'simeq': u'\u2243', # ≃ ASYMPTOTICALLY EQUAL TO
    'smallfrown': u'\u2322', # ⌢ FROWN
    'smallsmile': u'\u2323', # ⌣ SMILE
    'smile': u'\u2323', # ⌣ SMILE
    'sqsubset': u'\u228f', # ⊏ SQUARE IMAGE OF
    'sqsubseteq': u'\u2291', # ⊑ SQUARE IMAGE OF OR EQUAL TO
    'sqsupset': u'\u2290', # ⊐ SQUARE ORIGINAL OF
    'sqsupseteq': u'\u2292', # ⊒ SQUARE ORIGINAL OF OR EQUAL TO
    'subset': u'\u2282', # ⊂ SUBSET OF
    'subseteq': u'\u2286', # ⊆ SUBSET OF OR EQUAL TO
    'subseteqq': u'\u2ac5', # ⫅ SUBSET OF ABOVE EQUALS SIGN
    'subsetneq': u'\u228a', # ⊊ SUBSET OF WITH NOT EQUAL TO
    'subsetneqq': u'\u2acb', # ⫋ SUBSET OF ABOVE NOT EQUAL TO
    'succ': u'\u227b', # ≻ SUCCEEDS
    'succapprox': u'\u2ab8', # ⪸ SUCCEEDS ABOVE ALMOST EQUAL TO
    'succcurlyeq': u'\u227d', # ≽ SUCCEEDS OR EQUAL TO
    'succeq': u'\u2ab0', # ⪰ SUCCEEDS ABOVE SINGLE-LINE EQUALS SIGN
    'succnapprox': u'\u2aba', # ⪺ SUCCEEDS ABOVE NOT ALMOST EQUAL TO
    'succnsim': u'\u22e9', # ⋩ SUCCEEDS BUT NOT EQUIVALENT TO
    'succsim': u'\u227f', # ≿ SUCCEEDS OR EQUIVALENT TO
    'supset': u'\u2283', # ⊃ SUPERSET OF
    'supseteq': u'\u2287', # ⊇ SUPERSET OF OR EQUAL TO
    'supseteqq': u'\u2ac6', # ⫆ SUPERSET OF ABOVE EQUALS SIGN
    'supsetneq': u'\u228b', # ⊋ SUPERSET OF WITH NOT EQUAL TO
    'supsetneqq': u'\u2acc', # ⫌ SUPERSET OF ABOVE NOT EQUAL TO
    'swarrow': u'\u2199', # ↙ SOUTH WEST ARROW
    'to': u'\u2192', # → RIGHTWARDS ARROW
    'trianglelefteq': u'\u22b4', # ⊴ NORMAL SUBGROUP OF OR EQUAL TO
    'triangleq': u'\u225c', # ≜ DELTA EQUAL TO
    'trianglerighteq': u'\u22b5', # ⊵ CONTAINS AS NORMAL SUBGROUP OR EQUAL TO
    'twoheadleftarrow': u'\u219e', # ↞ LEFTWARDS TWO HEADED ARROW
    'twoheadrightarrow': u'\u21a0', # ↠ RIGHTWARDS TWO HEADED ARROW
    'uparrow': u'\u2191', # ↑ UPWARDS ARROW
    'updownarrow': u'\u2195', # ↕ UP DOWN ARROW
    'updownarrows': u'\u21c5', # ⇅ UPWARDS ARROW LEFTWARDS OF DOWNWARDS ARROW
    'updownharpoons': u'\u296e', # ⥮ UPWARDS HARPOON WITH BARB LEFT BESIDE DOWNWARDS HARPOON WITH BARB RIGHT
    'upharpoonleft': u'\u21bf', # ↿ UPWARDS HARPOON WITH BARB LEFTWARDS
    'upharpoonright': u'\u21be', # ↾ UPWARDS HARPOON WITH BARB RIGHTWARDS
    'upuparrows': u'\u21c8', # ⇈ UPWARDS PAIRED ARROWS
    'upupharpoons': u'\u2963', # ⥣ UPWARDS HARPOON WITH BARB LEFT BESIDE UPWARDS HARPOON WITH BARB RIGHT
    'vDash': u'\u22a8', # ⊨ TRUE
    'varpropto': u'\u221d', # ∝ PROPORTIONAL TO
    'vartriangleleft': u'\u22b2', # ⊲ NORMAL SUBGROUP OF
    'vartriangleright': u'\u22b3', # ⊳ CONTAINS AS NORMAL SUBGROUP
    'vdash': u'\u22a2', # ⊢ RIGHT TACK
    'vdots': u'\u22ee', # ⋮ VERTICAL ELLIPSIS
    }
mathunder = {
    'underbrace': u'\u23df', # ⏟ BOTTOM CURLY BRACKET
    }
space = {
    ':': u'\u205f', #   MEDIUM MATHEMATICAL SPACE
    'medspace': u'\u205f', #   MEDIUM MATHEMATICAL SPACE
    'quad': u'\u2001', #   EM QUAD
    }
