/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Dimension;

public abstract class Spring {
    public static final int UNSET = Integer.MIN_VALUE;

    protected Spring() {
    }

    public static Spring constant(int val) {
        return new SimpleSpring(val, val, val);
    }

    public static Spring constant(int min, int pref, int max) {
        return new SimpleSpring(min, pref, max);
    }

    public abstract int getMaximumValue();

    public abstract int getMinimumValue();

    public abstract int getPreferredValue();

    public abstract int getValue();

    public static Spring max(Spring s1, Spring s2) {
        return new MaxSpring(s1, s2);
    }

    public static Spring minus(Spring s) {
        return new MinusSpring(s);
    }

    public abstract void setValue(int var1);

    private int getShrinkRange() {
        return this.getPreferredValue() - this.getMinimumValue();
    }

    private int getExpandRange() {
        return this.getMaximumValue() - this.getPreferredValue();
    }

    double getStrain() {
        int p;
        int r;
        int v = this.getValue();
        int n = r = v < (p = this.getPreferredValue()) ? this.getShrinkRange() : this.getExpandRange();
        if (r == 0) {
            r = 1;
        }
        return (double)(v - p) / (double)r;
    }

    void setStrain(double strain) {
        int r = strain < 0.0 ? this.getShrinkRange() : this.getExpandRange();
        int v = this.getPreferredValue() + (int)(strain * (double)r);
        this.setValue(v);
    }

    public static Spring sum(Spring s1, Spring s2) {
        return new AddSpring(s1, s2);
    }

    public static Spring scale(final Spring spring, final float factor) {
        if (spring == null) {
            throw new NullPointerException("spring argument is null");
        }
        return new Spring(){

            public int getMaximumValue() {
                return (int)((float)(factor < 0.0f ? spring.getMinimumValue() : spring.getMaximumValue()) * factor);
            }

            public int getMinimumValue() {
                return (int)((float)(factor < 0.0f ? spring.getMaximumValue() : spring.getMinimumValue()) * factor);
            }

            public int getPreferredValue() {
                return (int)((float)spring.getPreferredValue() * factor);
            }

            public int getValue() {
                return (int)((float)spring.getValue() * factor);
            }

            public void setValue(int value) {
                spring.setValue((int)((float)value / factor));
            }
        };
    }

    public static Spring width(final Component component) {
        return new Spring(){

            public int getMaximumValue() {
                return component.getMaximumSize().width;
            }

            public int getMinimumValue() {
                return component.getMinimumSize().width;
            }

            public int getPreferredValue() {
                return component.getPreferredSize().width;
            }

            public int getValue() {
                return component.getSize().width;
            }

            public void setValue(int value) {
                Dimension d = component.getSize();
                component.setSize(value, d.height);
            }
        };
    }

    public static Spring height(final Component component) {
        return new Spring(){

            public int getMaximumValue() {
                return component.getMaximumSize().height;
            }

            public int getMinimumValue() {
                return component.getMinimumSize().height;
            }

            public int getPreferredValue() {
                return component.getPreferredSize().height;
            }

            public int getValue() {
                return component.getSize().height;
            }

            public void setValue(int value) {
                Dimension d = component.getSize();
                component.setSize(d.width, value);
            }
        };
    }

    private static final class AddSpring
    extends Spring {
        private final Spring s1;
        private final Spring s2;
        private int value;

        public String toString() {
            return "AddSpring of " + this.s1 + " and " + this.s2;
        }

        protected AddSpring(Spring s1, Spring s2) {
            this.s1 = s1;
            this.s2 = s2;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            int max1 = this.s1.getMaximumValue();
            int max2 = this.s2.getMaximumValue();
            return max1 + max2;
        }

        public int getMinimumValue() {
            int min1 = this.s1.getMinimumValue();
            int min2 = this.s2.getMinimumValue();
            return min1 + min2;
        }

        public int getPreferredValue() {
            int pref1 = this.s1.getPreferredValue();
            int pref2 = this.s2.getPreferredValue();
            return pref1 + pref2;
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                int val1 = this.s1.getValue();
                int val2 = this.s2.getValue();
                this.value = val1 + val2;
            }
            return this.value;
        }

        public void setValue(int val) {
            if (val == Integer.MIN_VALUE) {
                if (this.value != Integer.MIN_VALUE) {
                    this.s1.setValue(Integer.MIN_VALUE);
                    this.s2.setValue(Integer.MIN_VALUE);
                }
                this.value = Integer.MIN_VALUE;
                return;
            }
            this.value = val;
            double fStrain = this.getStrain();
            this.s1.setStrain(fStrain);
            int remainder = val - this.s1.getValue();
            this.s2.setValue(remainder);
        }
    }

    private static final class MaxSpring
    extends Spring {
        private final Spring s1;
        private final Spring s2;
        private int value;

        public String toString() {
            return "MaxSpring of " + this.s1 + " and " + this.s2;
        }

        protected MaxSpring(Spring s1, Spring s2) {
            this.s1 = s1;
            this.s2 = s2;
            this.value = Integer.MIN_VALUE;
        }

        public int getMaximumValue() {
            int max1 = this.s1.getMaximumValue();
            int max2 = this.s2.getMaximumValue();
            return Math.max(max1, max2);
        }

        public int getMinimumValue() {
            int min1 = this.s1.getMinimumValue();
            int min2 = this.s2.getMinimumValue();
            return Math.max(min1, min2);
        }

        public int getPreferredValue() {
            int pref1 = this.s1.getPreferredValue();
            int pref2 = this.s2.getPreferredValue();
            return Math.max(pref1, pref2);
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                int val1 = this.s1.getValue();
                int val2 = this.s2.getValue();
                this.value = Math.max(val1, val2);
            }
            return this.value;
        }

        public void setValue(int val) {
            int p2;
            if (val == Integer.MIN_VALUE) {
                if (this.value != Integer.MIN_VALUE) {
                    this.s1.setValue(Integer.MIN_VALUE);
                    this.s2.setValue(Integer.MIN_VALUE);
                }
                this.value = Integer.MIN_VALUE;
                return;
            }
            this.value = val;
            int p1 = this.s1.getPreferredValue();
            if (p1 < (p2 = this.s2.getPreferredValue())) {
                this.s1.setValue(Math.min(val, p1));
                this.s2.setValue(val);
            } else {
                this.s1.setValue(val);
                this.s2.setValue(Math.min(val, p2));
            }
        }
    }

    private static final class MinusSpring
    extends Spring {
        private final Spring s;

        public String toString() {
            return "MinusSpring of " + this.s;
        }

        protected MinusSpring(Spring s) {
            this.s = s;
        }

        public int getMaximumValue() {
            return -this.s.getMinimumValue();
        }

        public int getMinimumValue() {
            return -this.s.getMaximumValue();
        }

        public int getPreferredValue() {
            return -this.s.getPreferredValue();
        }

        public int getValue() {
            return -this.s.getValue();
        }

        public void setValue(int val) {
            if (val == Integer.MIN_VALUE) {
                this.s.setValue(Integer.MIN_VALUE);
            } else {
                this.s.setValue(-val);
            }
        }
    }

    private static final class SimpleSpring
    extends Spring {
        private final int min;
        private final int pref;
        private final int max;
        private int value;

        public String toString() {
            return "SimpleSpring of " + this.value;
        }

        public SimpleSpring(int newMin, int newPref, int newMax) {
            this.min = newMin;
            this.pref = newPref;
            this.max = newMax;
            this.value = newPref;
        }

        public int getMaximumValue() {
            return this.max;
        }

        public int getMinimumValue() {
            return this.min;
        }

        public int getPreferredValue() {
            return this.pref;
        }

        public int getValue() {
            if (this.value == Integer.MIN_VALUE) {
                return this.pref;
            }
            return this.value;
        }

        public void setValue(int val) {
            this.value = val;
        }
    }
}

