/*
 * Decompiled with CFR 0.152.
 */
package java.util.regex;

import gnu.java.lang.CPStringBuilder;
import gnu.java.util.regex.RE;
import gnu.java.util.regex.REException;
import gnu.java.util.regex.RESyntax;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.PatternSyntaxException;

public final class Pattern
implements Serializable {
    private static final long serialVersionUID = 5073258162644648461L;
    public static final int CANON_EQ = 128;
    public static final int CASE_INSENSITIVE = 2;
    public static final int COMMENTS = 4;
    public static final int DOTALL = 32;
    public static final int MULTILINE = 8;
    public static final int UNICODE_CASE = 64;
    public static final int UNIX_LINES = 1;
    private final String regex;
    private final int flags;
    private final RE re;

    private Pattern(String regex, int flags) throws PatternSyntaxException {
        this.regex = regex;
        this.flags = flags;
        RESyntax syntax = RESyntax.RE_SYNTAX_JAVA_1_4;
        int gnuFlags = 0;
        gnuFlags |= 0x800;
        if ((flags & 2) != 0) {
            gnuFlags |= 2;
        }
        if ((flags & 8) != 0) {
            gnuFlags |= 8;
            syntax = new RESyntax(syntax);
            syntax.setLineSeparator(null);
        }
        if ((flags & 0x20) != 0) {
            gnuFlags |= 4;
        }
        if ((flags & 0x40) != 0) {
            gnuFlags &= 0xFFFFF7FF;
        }
        if ((flags & 1) != 0) {
            syntax = new RESyntax(syntax);
            syntax.setLineSeparator("\n");
        }
        if ((flags & 4) != 0) {
            gnuFlags |= 0x400;
        }
        try {
            this.re = new RE(regex, gnuFlags, syntax);
        }
        catch (REException e) {
            PatternSyntaxException pse = new PatternSyntaxException(e.getMessage(), regex, e.getPosition());
            pse.initCause(e);
            throw pse;
        }
    }

    RE getRE() {
        return this.re;
    }

    public static Pattern compile(String regex) throws PatternSyntaxException {
        return Pattern.compile(regex, 0);
    }

    public static Pattern compile(String regex, int flags) throws PatternSyntaxException {
        if ((flags & 0xFFFFFF10) != 0) {
            throw new IllegalArgumentException();
        }
        return new Pattern(regex, flags);
    }

    public int flags() {
        return this.flags;
    }

    public static boolean matches(String regex, CharSequence input) {
        return Pattern.compile(regex).matcher(input).matches();
    }

    public Matcher matcher(CharSequence input) {
        return new Matcher(this, input);
    }

    public String[] split(CharSequence input) {
        return this.split(input, 0);
    }

    /*
     * Unable to fully structure code
     */
    public String[] split(CharSequence input, int limit) {
        matcher = new Matcher(this, input);
        list = new ArrayList<String>();
        empties = 0;
        count = 0;
        start = 0;
        matched = matcher.find();
        while (matched && (limit <= 0 || count < limit - 1)) {
            block7: {
                ++count;
                end = matcher.start();
                if (start != end) ** GOTO lbl16
                ++empties;
                break block7;
lbl-1000:
                // 1 sources

                {
                    list.add("");
                    --empties;
lbl16:
                    // 2 sources

                    ** while (empties > 0)
                }
lbl17:
                // 1 sources

                text = input.subSequence(start, end).toString();
                list.add(text);
            }
            start = matcher.end();
            matched = matcher.find();
        }
        if (!matched && count == 0) {
            return new String[]{input.toString()};
        }
        v0 = emptyLast = start == input.length();
        if (list.size() < limit || limit < 0 || limit == 0 && !emptyLast) {
            if (limit > list.size()) {
                max = limit - list.size();
                empties = empties > max ? max : empties;
            }
            while (empties > 0) {
                list.add("");
                --empties;
            }
        }
        if (!(limit == 0 && (limit != 0 || emptyLast) || "".equals(t = input.subSequence(start, input.length()).toString()) && limit == 0)) {
            list.add(t);
        }
        return list.toArray(new String[list.size()]);
    }

    public String pattern() {
        return this.regex;
    }

    public static String quote(String str) {
        int eInd = str.indexOf("\\E");
        if (eInd < 0) {
            return "\\Q" + str + "\\E";
        }
        CPStringBuilder sb = new CPStringBuilder(str.length() + 16);
        sb.append("\\Q");
        int pos = 0;
        do {
            sb.append(str.substring(pos, eInd)).append("\\E\\\\E\\Q");
        } while ((eInd = str.indexOf("\\E", pos = eInd + 2)) >= 0);
        sb.append(str.substring(pos, str.length())).append("\\E");
        return sb.toString();
    }

    public String toString() {
        return this.regex;
    }
}

