/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.atomic;

import java.util.concurrent.atomic.AtomicReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomicStampedReference<V> {
    private final AtomicReference<ReferenceIntegerPair<V>> atomicRef;

    public AtomicStampedReference(V initialRef, int initialStamp) {
        this.atomicRef = new AtomicReference<ReferenceIntegerPair<ReferenceIntegerPair<V>>>(new ReferenceIntegerPair<V>(initialRef, initialStamp));
    }

    public V getReference() {
        return (V)((ReferenceIntegerPair)this.atomicRef.get()).reference;
    }

    public int getStamp() {
        return ((ReferenceIntegerPair)this.atomicRef.get()).integer;
    }

    public V get(int[] stampHolder) {
        ReferenceIntegerPair<V> p = this.atomicRef.get();
        stampHolder[0] = ((ReferenceIntegerPair)p).integer;
        return (V)((ReferenceIntegerPair)p).reference;
    }

    public boolean weakCompareAndSet(V expectedReference, V newReference, int expectedStamp, int newStamp) {
        ReferenceIntegerPair<V> current = this.atomicRef.get();
        return expectedReference == ((ReferenceIntegerPair)current).reference && expectedStamp == ((ReferenceIntegerPair)current).integer && (newReference == ((ReferenceIntegerPair)current).reference && newStamp == ((ReferenceIntegerPair)current).integer || this.atomicRef.weakCompareAndSet(current, new ReferenceIntegerPair<V>(newReference, newStamp)));
    }

    public boolean compareAndSet(V expectedReference, V newReference, int expectedStamp, int newStamp) {
        ReferenceIntegerPair<V> current = this.atomicRef.get();
        return expectedReference == ((ReferenceIntegerPair)current).reference && expectedStamp == ((ReferenceIntegerPair)current).integer && (newReference == ((ReferenceIntegerPair)current).reference && newStamp == ((ReferenceIntegerPair)current).integer || this.atomicRef.compareAndSet(current, new ReferenceIntegerPair<V>(newReference, newStamp)));
    }

    public void set(V newReference, int newStamp) {
        ReferenceIntegerPair<V> current = this.atomicRef.get();
        if (newReference != ((ReferenceIntegerPair)current).reference || newStamp != ((ReferenceIntegerPair)current).integer) {
            this.atomicRef.set(new ReferenceIntegerPair<V>(newReference, newStamp));
        }
    }

    public boolean attemptStamp(V expectedReference, int newStamp) {
        ReferenceIntegerPair<V> current = this.atomicRef.get();
        return expectedReference == ((ReferenceIntegerPair)current).reference && (newStamp == ((ReferenceIntegerPair)current).integer || this.atomicRef.compareAndSet(current, new ReferenceIntegerPair<V>(expectedReference, newStamp)));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ReferenceIntegerPair<T> {
        private final T reference;
        private final int integer;

        ReferenceIntegerPair(T r, int i) {
            this.reference = r;
            this.integer = i;
        }
    }
}

