/*
 * Decompiled with CFR 0.152.
 */
package gnu.xml.transform;

import gnu.java.lang.CPStringBuilder;
import gnu.xml.transform.AttributeSet;
import gnu.xml.transform.Stylesheet;
import gnu.xml.transform.TemplateNode;
import gnu.xml.xpath.Expr;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.StringTokenizer;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

final class ElementNode
extends TemplateNode {
    final TemplateNode name;
    final TemplateNode namespace;
    final String uas;
    final Node source;
    final Collection elementExcludeResultPrefixes;

    ElementNode(TemplateNode name, TemplateNode namespace, String uas, Node source) {
        this.name = name;
        this.namespace = namespace;
        this.uas = uas;
        this.source = source;
        NamedNodeMap attrs = source.getAttributes();
        Node attr = attrs.getNamedItemNS("http://www.w3.org/1999/XSL/Transform", "exclude-result-prefixes");
        if (attr != null) {
            this.elementExcludeResultPrefixes = new HashSet();
            StringTokenizer st = new StringTokenizer(attr.getNodeValue());
            while (st.hasMoreTokens()) {
                this.elementExcludeResultPrefixes.add(st.nextToken());
            }
        } else {
            this.elementExcludeResultPrefixes = Collections.EMPTY_SET;
        }
    }

    TemplateNode clone(Stylesheet stylesheet) {
        ElementNode ret = new ElementNode(this.name.clone(stylesheet), this.namespace == null ? null : this.namespace.clone(stylesheet), this.uas, this.source);
        if (this.children != null) {
            ret.children = this.children.clone(stylesheet);
        }
        if (this.next != null) {
            ret.next = this.next.clone(stylesheet);
        }
        return ret;
    }

    void doApply(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling) throws TransformerException {
        Element element;
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        DocumentFragment fragment = doc.createDocumentFragment();
        this.name.apply(stylesheet, mode, context, pos, len, fragment, null);
        String nameValue = Expr.stringValue(fragment);
        String namespaceValue = null;
        if (this.namespace != null) {
            fragment = doc.createDocumentFragment();
            this.namespace.apply(stylesheet, mode, context, pos, len, fragment, null);
            namespaceValue = Expr.stringValue(fragment);
            if (namespaceValue.length() == 0) {
                namespaceValue = null;
            }
        } else {
            String prefix = this.getPrefix(nameValue);
            if ("xmlns".equals(prefix)) {
                int ci = nameValue.indexOf(58);
                nameValue = nameValue.substring(ci + 1);
            } else {
                String resultPrefix;
                if (prefix == null) {
                    prefix = "#default";
                }
                if ((resultPrefix = stylesheet.namespaceAliases.get(prefix)) != null) {
                    if ("#default".equals(resultPrefix)) {
                        resultPrefix = null;
                    }
                    namespaceValue = this.source.lookupNamespaceURI(resultPrefix);
                }
                if (prefix == "#default") {
                    prefix = null;
                }
                if (namespaceValue == null) {
                    namespaceValue = "xml".equals(prefix) ? "http://www.w3.org/XML/1998/namespace" : this.source.lookupNamespaceURI(prefix);
                }
            }
        }
        Element element2 = element = namespaceValue != null ? doc.createElementNS(namespaceValue, nameValue) : doc.createElement(nameValue);
        if (nextSibling != null) {
            parent.insertBefore(element, nextSibling);
        } else {
            parent.appendChild(element);
        }
        stylesheet.addNamespaceNodes(this.source, element, doc, this.elementExcludeResultPrefixes);
        if (this.uas != null) {
            StringTokenizer st = new StringTokenizer(this.uas, " ");
            while (st.hasMoreTokens()) {
                this.addAttributeSet(stylesheet, mode, context, pos, len, element, null, st.nextToken());
            }
        }
        if (this.children != null) {
            this.children.apply(stylesheet, mode, context, pos, len, element, null);
        }
        if (this.next != null) {
            this.next.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
    }

    final String getPrefix(String name) {
        int ci = name.indexOf(58);
        return ci == -1 ? null : name.substring(0, ci);
    }

    void addAttributeSet(Stylesheet stylesheet, QName mode, Node context, int pos, int len, Node parent, Node nextSibling, String attributeSet) throws TransformerException {
        stylesheet.bindings.global = true;
        for (AttributeSet as : stylesheet.attributeSets) {
            if (!as.name.equals(attributeSet)) continue;
            if (as.uas != null) {
                StringTokenizer st = new StringTokenizer(as.uas, " ");
                while (st.hasMoreTokens()) {
                    this.addAttributeSet(stylesheet, mode, context, pos, len, parent, nextSibling, st.nextToken());
                }
            }
            if (as.children == null) continue;
            as.children.apply(stylesheet, mode, context, pos, len, parent, nextSibling);
        }
        stylesheet.bindings.global = false;
    }

    public boolean references(QName var) {
        if (this.name != null && this.name.references(var)) {
            return true;
        }
        if (this.namespace != null && this.namespace.references(var)) {
            return true;
        }
        return super.references(var);
    }

    public String toString() {
        CPStringBuilder buf = new CPStringBuilder("element");
        buf.append('[');
        buf.append("name=");
        if (this.namespace != null) {
            buf.append(",namespace=");
            buf.append(this.namespace);
        }
        buf.append(this.name);
        if (this.uas != null) {
            buf.append(",uas=");
            buf.append(this.uas);
        }
        buf.append(']');
        return buf.toString();
    }
}

