/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.print.ipp;

import gnu.javax.print.ipp.attribute.DetailedStatusMessage;
import gnu.javax.print.ipp.attribute.DocumentAccessError;
import gnu.javax.print.ipp.attribute.StatusMessage;
import gnu.javax.print.ipp.attribute.defaults.CopiesDefault;
import gnu.javax.print.ipp.attribute.defaults.FinishingsDefault;
import gnu.javax.print.ipp.attribute.defaults.JobHoldUntilDefault;
import gnu.javax.print.ipp.attribute.defaults.JobPriorityDefault;
import gnu.javax.print.ipp.attribute.defaults.JobSheetsDefault;
import gnu.javax.print.ipp.attribute.defaults.MediaDefault;
import gnu.javax.print.ipp.attribute.defaults.MultipleDocumentHandlingDefault;
import gnu.javax.print.ipp.attribute.defaults.NumberUpDefault;
import gnu.javax.print.ipp.attribute.defaults.OrientationRequestedDefault;
import gnu.javax.print.ipp.attribute.defaults.PrintQualityDefault;
import gnu.javax.print.ipp.attribute.defaults.SidesDefault;
import gnu.javax.print.ipp.attribute.job.JobDetailedStatusMessages;
import gnu.javax.print.ipp.attribute.job.JobDocumentAccessErrors;
import gnu.javax.print.ipp.attribute.job.JobId;
import gnu.javax.print.ipp.attribute.job.JobStateMessage;
import gnu.javax.print.ipp.attribute.printer.MultipleOperationTimeOut;
import gnu.javax.print.ipp.attribute.printer.PrinterStateMessage;
import gnu.javax.print.ipp.attribute.printer.PrinterUpTime;
import gnu.javax.print.ipp.attribute.supported.CompressionSupported;
import gnu.javax.print.ipp.attribute.supported.FinishingsSupported;
import gnu.javax.print.ipp.attribute.supported.IppVersionsSupported;
import gnu.javax.print.ipp.attribute.supported.JobHoldUntilSupported;
import gnu.javax.print.ipp.attribute.supported.JobSheetsSupported;
import gnu.javax.print.ipp.attribute.supported.MediaSupported;
import gnu.javax.print.ipp.attribute.supported.MultipleDocumentHandlingSupported;
import gnu.javax.print.ipp.attribute.supported.MultipleDocumentJobsSupported;
import gnu.javax.print.ipp.attribute.supported.OperationsSupported;
import gnu.javax.print.ipp.attribute.supported.OrientationRequestedSupported;
import gnu.javax.print.ipp.attribute.supported.PageRangesSupported;
import gnu.javax.print.ipp.attribute.supported.PrintQualitySupported;
import gnu.javax.print.ipp.attribute.supported.PrinterResolutionSupported;
import gnu.javax.print.ipp.attribute.supported.SidesSupported;
import gnu.javax.print.ipp.attribute.supported.UriAuthenticationSupported;
import gnu.javax.print.ipp.attribute.supported.UriSecuritySupported;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Locale;
import javax.print.attribute.Attribute;
import javax.print.attribute.EnumSyntax;
import javax.print.attribute.SupportedValuesAttribute;
import javax.print.attribute.standard.Chromaticity;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Compression;
import javax.print.attribute.standard.Copies;
import javax.print.attribute.standard.CopiesSupported;
import javax.print.attribute.standard.Fidelity;
import javax.print.attribute.standard.Finishings;
import javax.print.attribute.standard.JobHoldUntil;
import javax.print.attribute.standard.JobImpressionsCompleted;
import javax.print.attribute.standard.JobKOctetsProcessed;
import javax.print.attribute.standard.JobMediaSheetsCompleted;
import javax.print.attribute.standard.JobMessageFromOperator;
import javax.print.attribute.standard.JobName;
import javax.print.attribute.standard.JobOriginatingUserName;
import javax.print.attribute.standard.JobPriority;
import javax.print.attribute.standard.JobPrioritySupported;
import javax.print.attribute.standard.JobSheets;
import javax.print.attribute.standard.JobState;
import javax.print.attribute.standard.JobStateReason;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.MultipleDocumentHandling;
import javax.print.attribute.standard.NumberOfInterveningJobs;
import javax.print.attribute.standard.NumberUp;
import javax.print.attribute.standard.NumberUpSupported;
import javax.print.attribute.standard.OrientationRequested;
import javax.print.attribute.standard.OutputDeviceAssigned;
import javax.print.attribute.standard.PDLOverrideSupported;
import javax.print.attribute.standard.PageRanges;
import javax.print.attribute.standard.PagesPerMinute;
import javax.print.attribute.standard.PagesPerMinuteColor;
import javax.print.attribute.standard.PresentationDirection;
import javax.print.attribute.standard.PrintQuality;
import javax.print.attribute.standard.PrinterInfo;
import javax.print.attribute.standard.PrinterIsAcceptingJobs;
import javax.print.attribute.standard.PrinterLocation;
import javax.print.attribute.standard.PrinterMakeAndModel;
import javax.print.attribute.standard.PrinterMessageFromOperator;
import javax.print.attribute.standard.PrinterName;
import javax.print.attribute.standard.PrinterResolution;
import javax.print.attribute.standard.PrinterState;
import javax.print.attribute.standard.PrinterStateReason;
import javax.print.attribute.standard.QueuedJobCount;
import javax.print.attribute.standard.ReferenceUriSchemesSupported;
import javax.print.attribute.standard.Severity;
import javax.print.attribute.standard.SheetCollate;
import javax.print.attribute.standard.Sides;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IppUtilities {
    private static Object[] INTEGER_ATT_VALUE = new Object[1];
    private static Class<?>[] INTEGER_CLASS_ARRAY = new Class[]{Integer.TYPE};
    private static Object[] TEXT_ATT_VALUE = new Object[2];
    private static Class<?>[] TEXT_CLASS_ARRAY = new Class[]{String.class, Locale.class};
    private static HashMap<String, Class<? extends Attribute>> classesByName = new HashMap();
    private static HashMap<Class<? extends Attribute>, SupportedValuesAttribute> instanceByClass = new HashMap();

    static {
        classesByName.put(JobState.ABORTED.getName(), JobState.class);
        classesByName.put(Sides.DUPLEX.getName(), Sides.class);
        classesByName.put(SheetCollate.COLLATED.getName(), SheetCollate.class);
        classesByName.put(Severity.ERROR.getName(), Severity.class);
        classesByName.put(JobSheets.NONE.getName(), JobSheets.class);
        classesByName.put(Finishings.BIND.getName(), Finishings.class);
        classesByName.put(Fidelity.FIDELITY_FALSE.getName(), Fidelity.class);
        classesByName.put(Compression.GZIP.getName(), Compression.class);
        classesByName.put(Chromaticity.COLOR.getName(), Chromaticity.class);
        classesByName.put(PrintQuality.DRAFT.getName(), PrintQuality.class);
        classesByName.put(PrinterState.IDLE.getName(), PrinterState.class);
        classesByName.put(SidesDefault.ONE_SIDED.getName(), SidesDefault.class);
        classesByName.put(ReferenceUriSchemesSupported.FILE.getName(), ReferenceUriSchemesSupported.class);
        classesByName.put(PrinterStateReason.DOOR_OPEN.getName(), PrinterStateReason.class);
        classesByName.put(PresentationDirection.TOLEFT_TOTOP.getName(), PresentationDirection.class);
        classesByName.put(PDLOverrideSupported.ATTEMPTED.getName(), PDLOverrideSupported.class);
        classesByName.put(OrientationRequested.PORTRAIT.getName(), OrientationRequested.class);
        classesByName.put(MultipleDocumentHandling.SINGLE_DOCUMENT.getName(), MultipleDocumentHandling.class);
        classesByName.put(JobStateReason.JOB_QUEUED.getName(), JobStateReason.class);
        classesByName.put(UriAuthenticationSupported.NONE.getName(), UriAuthenticationSupported.class);
        classesByName.put(OperationsSupported.GET_JOBS.getName(), OperationsSupported.class);
        classesByName.put(UriSecuritySupported.NONE.getName(), UriSecuritySupported.class);
        classesByName.put(FinishingsSupported.NONE.getName(), FinishingsSupported.class);
        classesByName.put(FinishingsDefault.NONE.getName(), FinishingsDefault.class);
        classesByName.put(IppVersionsSupported.V_1_0.getName(), IppVersionsSupported.class);
        classesByName.put(MultipleDocumentHandlingSupported.SINGLE_DOCUMENT.getName(), MultipleDocumentHandlingSupported.class);
        classesByName.put(MultipleDocumentHandlingDefault.SINGLE_DOCUMENT.getName(), MultipleDocumentHandlingDefault.class);
        classesByName.put(CompressionSupported.NONE.getName(), CompressionSupported.class);
        classesByName.put(OrientationRequestedSupported.PORTRAIT.getName(), OrientationRequestedSupported.class);
        classesByName.put(OrientationRequestedDefault.PORTRAIT.getName(), OrientationRequestedDefault.class);
        classesByName.put(SidesSupported.ONE_SIDED.getName(), SidesSupported.class);
        classesByName.put(PrintQualityDefault.DRAFT.getName(), PrintQualityDefault.class);
        classesByName.put(PrintQualitySupported.DRAFT.getName(), PrintQualitySupported.class);
        classesByName.put(ReferenceUriSchemesSupported.FTP.getName(), ReferenceUriSchemesSupported.class);
        classesByName.put(ColorSupported.SUPPORTED.getName(), ColorSupported.class);
        classesByName.put(PrinterIsAcceptingJobs.ACCEPTING_JOBS.getName(), PrinterIsAcceptingJobs.class);
        classesByName.put(MultipleDocumentJobsSupported.SUPPORTED.getName(), MultipleDocumentJobsSupported.class);
        classesByName.put(PageRangesSupported.SUPPORTED.getName(), PageRangesSupported.class);
        classesByName.put("media-default", MediaDefault.class);
        classesByName.put("media-supported", MediaSupported.class);
        classesByName.put("media", MediaSizeName.class);
        classesByName.put("printer-location", PrinterLocation.class);
        classesByName.put("printer-info", PrinterInfo.class);
        classesByName.put("printer-make-and-model", PrinterMakeAndModel.class);
        classesByName.put("printer-state-message", PrinterStateMessage.class);
        classesByName.put("job-state-message", JobStateMessage.class);
        classesByName.put("job-sheets-default", JobSheetsDefault.class);
        classesByName.put("job-sheets-supported", JobSheetsSupported.class);
        classesByName.put("job-name", JobName.class);
        classesByName.put("printer-name", PrinterName.class);
        classesByName.put("status-message", StatusMessage.class);
        classesByName.put("detailed-status-message", DetailedStatusMessage.class);
        classesByName.put("document-access-error", DocumentAccessError.class);
        classesByName.put("output-device-assigned", OutputDeviceAssigned.class);
        classesByName.put("job-hold-until-default", JobHoldUntilDefault.class);
        classesByName.put("job-originating-user-name", JobOriginatingUserName.class);
        classesByName.put("job-hold-until-supported", JobHoldUntilSupported.class);
        classesByName.put("job-message-from-operator", JobMessageFromOperator.class);
        classesByName.put("printer-message-from-operator", PrinterMessageFromOperator.class);
        classesByName.put("job-detailed-status-messages", JobDetailedStatusMessages.class);
        classesByName.put("job-document-access-errors", JobDocumentAccessErrors.class);
        classesByName.put("copies-default", CopiesDefault.class);
        classesByName.put("job-id", JobId.class);
        classesByName.put("job-priority-supported", JobPrioritySupported.class);
        classesByName.put("job-priority-default", JobPriorityDefault.class);
        classesByName.put("number-up-supported", NumberUpSupported.class);
        classesByName.put("number-up-default", NumberUpDefault.class);
        classesByName.put("queued-job-count", QueuedJobCount.class);
        classesByName.put("printer-up-time", PrinterUpTime.class);
        classesByName.put("pages-per-minute", PagesPerMinute.class);
        classesByName.put("pages-per-minute-color", PagesPerMinuteColor.class);
        classesByName.put("job-k-octets-processed", JobKOctetsProcessed.class);
        classesByName.put("number-of-intervening-jobs", NumberOfInterveningJobs.class);
        classesByName.put("job-impressions-completed", JobImpressionsCompleted.class);
        classesByName.put("job-media-sheets-completed", JobMediaSheetsCompleted.class);
        classesByName.put("multiple-operation-time-out", MultipleOperationTimeOut.class);
        instanceByClass.put(JobPriority.class, new JobPrioritySupported(1));
        instanceByClass.put(JobHoldUntil.class, new JobHoldUntilSupported("", null));
        instanceByClass.put(JobSheets.class, new JobSheetsSupported("", null));
        instanceByClass.put(MultipleDocumentHandling.class, MultipleDocumentHandlingSupported.SINGLE_DOCUMENT);
        instanceByClass.put(Copies.class, new CopiesSupported(1));
        instanceByClass.put(Finishings.class, FinishingsSupported.BIND);
        instanceByClass.put(PageRanges.class, PageRangesSupported.SUPPORTED);
        instanceByClass.put(Sides.class, SidesSupported.DUPLEX);
        instanceByClass.put(NumberUp.class, new NumberUpSupported(1));
        instanceByClass.put(OrientationRequested.class, OrientationRequestedSupported.LANDSCAPE);
        instanceByClass.put(Media.class, new MediaSupported("", null));
        instanceByClass.put(PrinterResolution.class, new PrinterResolutionSupported(1, 1, 1));
        instanceByClass.put(PrintQuality.class, PrintQualitySupported.DRAFT);
        instanceByClass.put(Compression.class, CompressionSupported.COMPRESS);
    }

    private IppUtilities() {
    }

    public static Class<? extends Attribute> getClass(String name) {
        return classesByName.get(name);
    }

    public static String getSupportedAttrName(Class<? extends Attribute> clazz) {
        return instanceByClass.get(clazz).getName();
    }

    public static Class<? extends Attribute> getSupportedCategory(Class<? extends Attribute> clazz) {
        return instanceByClass.get(clazz).getCategory();
    }

    public static int convertToInt(byte[] b) {
        return (b[0] & 0xFF) << 24 | (b[1] & 0xFF) << 16 | (b[2] & 0xFF) << 8 | b[3] & 0xFF;
    }

    public static int convertToInt(byte b1, byte b2, byte b3, byte b4) {
        return (b1 & 0xFF) << 24 | (b2 & 0xFF) << 16 | (b3 & 0xFF) << 8 | b4 & 0xFF;
    }

    public static short convertToShort(byte b1, byte b2) {
        return (short)(b1 << 8 | b2 & 0xFF);
    }

    public static Attribute getEnumAttribute(String name, Object value) {
        Class<? extends Attribute> attrClass = IppUtilities.getClass(name);
        if (attrClass == null) {
            return null;
        }
        try {
            Field[] fields = attrClass.getDeclaredFields();
            int i = 0;
            while (i < fields.length) {
                Field field = fields[i];
                if (field.getType().equals(attrClass)) {
                    EnumSyntax attr = (EnumSyntax)field.get(null);
                    if (value instanceof Integer && attr.getValue() == ((Integer)value).intValue()) {
                        return (Attribute)((Object)attr);
                    }
                    if (value instanceof String && attr.toString().equals(value)) {
                        return (Attribute)((Object)attr);
                    }
                }
                ++i;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return null;
    }

    public static Attribute getIntegerAttribute(String name, int value) {
        Class<? extends Attribute> attrClass = IppUtilities.getClass(name);
        if (attrClass == null) {
            return null;
        }
        try {
            IppUtilities.INTEGER_ATT_VALUE[0] = value;
            Constructor<? extends Attribute> c = attrClass.getDeclaredConstructor(INTEGER_CLASS_ARRAY);
            return c.newInstance(INTEGER_ATT_VALUE);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public static Attribute getTextAttribute(String name, byte tag, byte[] value) {
        if (tag == 66 || tag == 65) {
            IppUtilities.TEXT_ATT_VALUE[0] = new String(value);
            IppUtilities.TEXT_ATT_VALUE[1] = Locale.getDefault();
        } else {
            short langLength = IppUtilities.convertToShort(value[0], value[1]);
            byte[] tmp = new byte[langLength];
            byte[] tmp2 = new byte[value.length - 4 - langLength];
            System.arraycopy(value, 2, tmp, 0, langLength);
            String language = new String(tmp);
            String text = new String(tmp2);
            Locale locale = null;
            locale = language.length() > 2 ? new Locale(language.substring(0, 2), language.substring(3)) : new Locale(language);
            IppUtilities.TEXT_ATT_VALUE[0] = text;
            IppUtilities.TEXT_ATT_VALUE[1] = locale;
        }
        Class<? extends Attribute> attrClass = IppUtilities.getClass(name);
        if (attrClass == null) {
            return null;
        }
        try {
            Constructor<? extends Attribute> c = attrClass.getDeclaredConstructor(TEXT_CLASS_ARRAY);
            return c.newInstance(TEXT_ATT_VALUE);
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }
}

