/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.crypto.jce.prng;

import gnu.java.security.jce.prng.SecureRandomAdapter;
import gnu.java.security.prng.LimitReachedException;
import gnu.javax.crypto.prng.Fortuna;
import java.security.SecureRandomSpi;
import java.util.Collections;

public final class FortunaImpl
extends SecureRandomSpi {
    private boolean virgin = true;
    private final Fortuna adaptee = new Fortuna();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void engineSetSeed(byte[] seed) {
        Fortuna fortuna = this.adaptee;
        synchronized (fortuna) {
            if (this.virgin) {
                this.adaptee.init(Collections.singletonMap("gnu.crypto.prng.fortuna.seed", seed));
                this.virgin = false;
            } else {
                this.adaptee.addRandomBytes(seed);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void engineNextBytes(byte[] buffer) {
        Fortuna fortuna = this.adaptee;
        synchronized (fortuna) {
            if (this.virgin) {
                this.engineSetSeed(this.engineGenerateSeed(32));
            }
            try {
                this.adaptee.nextBytes(buffer);
            }
            catch (LimitReachedException shouldNotHappen) {
                throw new Error(shouldNotHappen);
            }
        }
    }

    protected byte[] engineGenerateSeed(int numBytes) {
        return SecureRandomAdapter.getSeed(numBytes);
    }
}

