/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.security.sig;

import gnu.java.security.hash.HashFactory;
import gnu.java.security.sig.ISignatureCodec;
import gnu.java.security.sig.dss.DSSSignatureRawCodec;
import gnu.java.security.sig.dss.DSSSignatureX509Codec;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5SignatureRawCodec;
import gnu.java.security.sig.rsa.RSAPKCS1V1_5SignatureX509Codec;
import gnu.java.security.sig.rsa.RSAPSSSignatureRawCodec;
import gnu.java.security.util.FormatUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class SignatureCodecFactory {
    private static Set names;

    private SignatureCodecFactory() {
    }

    public static ISignatureCodec getInstance(String name) {
        if (name == null) {
            return null;
        }
        if ((name = name.trim()).length() == 0) {
            return null;
        }
        if (name.startsWith("/")) {
            return null;
        }
        if (name.endsWith("/")) {
            return SignatureCodecFactory.getInstance(name.substring(0, name.length() - 1), 1);
        }
        int i = name.indexOf("/");
        if (i == -1) {
            return SignatureCodecFactory.getInstance(name, 1);
        }
        String sigName = name.substring(0, i);
        String formatName = name.substring(i + 1);
        return SignatureCodecFactory.getInstance(sigName, formatName);
    }

    public static ISignatureCodec getInstance(String name, String format) {
        int formatID = FormatUtil.getFormatID(format);
        if (formatID == 0) {
            return null;
        }
        return SignatureCodecFactory.getInstance(name, formatID);
    }

    public static ISignatureCodec getInstance(String name, int formatID) {
        if (name == null) {
            return null;
        }
        name = name.trim();
        switch (formatID) {
            case 1: {
                return SignatureCodecFactory.getRawCodec(name);
            }
            case 2: {
                return SignatureCodecFactory.getX509Codec(name);
            }
        }
        return null;
    }

    public static final synchronized Set getNames() {
        if (names == null) {
            HashSet<String> hs = new HashSet<String>();
            hs.add("dss/RAW");
            hs.add("dss/X.509");
            Set hashNames = HashFactory.getNames();
            for (String mdName : hashNames) {
                String name = "rsa-pkcs1-v1.5-" + mdName;
                hs.add(String.valueOf(name) + "/" + "RAW");
                hs.add(String.valueOf(name) + "/" + "X.509");
                name = "rsa-pss-" + mdName;
                hs.add(String.valueOf(name) + "/" + "RAW");
            }
            names = Collections.unmodifiableSet(hs);
        }
        return names;
    }

    private static ISignatureCodec getRawCodec(String name) {
        ISignatureCodec result = null;
        if (name.equalsIgnoreCase("dsa") || name.equalsIgnoreCase("dss")) {
            result = new DSSSignatureRawCodec();
        } else if ((name = name.toLowerCase()).startsWith("rsa-pkcs1-v1.5")) {
            result = new RSAPKCS1V1_5SignatureRawCodec();
        } else if (name.startsWith("rsa-pss")) {
            result = new RSAPSSSignatureRawCodec();
        }
        return result;
    }

    private static ISignatureCodec getX509Codec(String name) {
        ISignatureCodec result = null;
        if (name.equalsIgnoreCase("dsa") || name.equalsIgnoreCase("dss")) {
            result = new DSSSignatureX509Codec();
        } else if ((name = name.toLowerCase()).startsWith("rsa-pkcs1-v1.5")) {
            result = new RSAPKCS1V1_5SignatureX509Codec();
        }
        return result;
    }
}

