/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.peer.swing;

import gnu.java.awt.peer.swing.SwingFramePeer;
import gnu.java.awt.peer.swing.SwingMenuPeer;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.peer.MenuBarPeer;
import javax.swing.JMenuBar;

public class SwingMenuBarPeer
implements MenuBarPeer {
    MenuBar awtMenuBar;
    SwingMenuBar menuBar;
    SwingFramePeer framePeer;

    public SwingMenuBarPeer(MenuBar awtMenuBar) {
        this.awtMenuBar = awtMenuBar;
        this.menuBar = new SwingMenuBar();
        this.menuBar.setDoubleBuffered(false);
        int i = 0;
        while (i < awtMenuBar.getMenuCount()) {
            Menu menu = awtMenuBar.getMenu(i);
            menu.addNotify();
            this.addMenu(awtMenuBar.getMenu(i));
            ++i;
        }
    }

    public void setFramePeer(SwingFramePeer peer) {
        this.framePeer = peer;
    }

    public void addMenu(Menu m) {
        SwingMenuPeer menuPeer = (SwingMenuPeer)m.getPeer();
        this.menuBar.add(menuPeer.menu);
    }

    public void addHelpMenu(Menu menu) {
        SwingMenuPeer menuPeer = (SwingMenuPeer)menu.getPeer();
        this.menuBar.add(menuPeer.menu);
    }

    public void delMenu(int index) {
        this.menuBar.remove(index);
    }

    public void dispose() {
        this.menuBar = null;
        this.awtMenuBar = null;
    }

    public void setFont(Font font) {
        this.menuBar.setFont(font);
    }

    public void setWidth(int w) {
        this.menuBar.setSize(w, this.menuBar.getPreferredSize().height);
        this.menuBar.doLayout();
    }

    public void peerPaint(Graphics g) {
        this.menuBar.paint(g);
    }

    public int getHeight() {
        return this.menuBar.getPreferredSize().height;
    }

    public void handleMouseEvent(MouseEvent ev) {
        Point point = ev.getPoint();
        int i = 0;
        while (i < this.awtMenuBar.getMenuCount()) {
            Menu menu = this.awtMenuBar.getMenu(i);
            SwingMenuPeer peer = (SwingMenuPeer)menu.getPeer();
            int x1 = peer.getX();
            int x2 = x1 + peer.getWidth();
            if (point.x >= x1 && point.x <= x2) {
                ev.translatePoint(peer.getX(), peer.getY());
                peer.handleMouseEvent(ev);
                break;
            }
            ++i;
        }
    }

    public void handleMouseMotionEvent(MouseEvent ev) {
        Point point = ev.getPoint();
        int i = 0;
        while (i < this.awtMenuBar.getMenuCount()) {
            Menu menu = this.awtMenuBar.getMenu(i);
            SwingMenuPeer peer = (SwingMenuPeer)menu.getPeer();
            int x1 = peer.getX();
            int x2 = x1 + peer.getWidth();
            if (point.x >= x1 && point.x <= x2) {
                ev.translatePoint(peer.getX(), peer.getY());
                peer.handleMouseMotionEvent(ev);
                break;
            }
            ++i;
        }
    }

    private class SwingMenuBar
    extends JMenuBar {
        private SwingMenuBar() {
        }

        public Container getParent() {
            Container result = null;
            if (SwingMenuBarPeer.this.framePeer != null) {
                result = (Container)SwingMenuBarPeer.this.framePeer.awtComponent;
            }
            return result;
        }

        public boolean isShowing() {
            return true;
        }

        public void handleMouseEvent(MouseEvent ev) {
            ev.setSource(this);
            this.processMouseEvent(ev);
        }

        public Point getLocationOnScreen() {
            return SwingMenuBarPeer.this.framePeer.getMenuLocationOnScreen();
        }
    }
}

