/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.java2d;

import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;

public class ImagePaint
implements Paint {
    RenderedImage image;
    AffineTransform transform;

    ImagePaint(RenderedImage i, AffineTransform t) {
        this.image = i;
        this.transform = t;
    }

    public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
        return new ImagePaintContext();
    }

    public int getTransparency() {
        return 1;
    }

    private class ImagePaintContext
    implements PaintContext {
        private WritableRaster target;

        private ImagePaintContext() {
        }

        public void dispose() {
        }

        public ColorModel getColorModel() {
            return ImagePaint.this.image.getColorModel();
        }

        public Raster getRaster(int x1, int y1, int w, int h) {
            this.ensureRasterSize(w, h);
            int x2 = x1 + w;
            int y2 = y1 + h;
            float[] src = new float[2];
            float[] dest = new float[2];
            Raster source = ImagePaint.this.image.getData();
            int minX = source.getMinX();
            int maxX = source.getWidth() + minX;
            int minY = source.getMinY();
            int maxY = source.getHeight() + minY;
            Object pixel = null;
            int y = y1;
            while (y < y2) {
                int x = x1;
                while (x < x2) {
                    src[0] = x;
                    src[1] = y;
                    ImagePaint.this.transform.transform(src, 0, dest, 0, 1);
                    int dx = (int)dest[0];
                    int dy = (int)dest[1];
                    if (dx >= minX && dx < maxX && dy >= minY && dy < maxY) {
                        pixel = source.getDataElements(dx, dy, pixel);
                        this.target.setDataElements(x - x1, y - y1, pixel);
                    }
                    ++x;
                }
                ++y;
            }
            return this.target;
        }

        private void ensureRasterSize(int w, int h) {
            if (this.target == null || this.target.getWidth() < w || this.target.getHeight() < h) {
                Raster s = ImagePaint.this.image.getData();
                this.target = s.createCompatibleWritableRaster(w, h);
            }
        }
    }
}

