/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype.truetype;

import gnu.java.lang.CPStringBuilder;

public final class Fixed {
    public static final int ONE = 64;

    private Fixed() {
    }

    public static int mul(int a, int b) {
        return (int)((long)a * (long)b >> 6);
    }

    public static int mul16(int a, int b) {
        return (int)((long)a * (long)b >> 16);
    }

    public static int div(int a, int b) {
        return (int)(((long)a << 6) / (long)b);
    }

    public static int div16(int a, int b) {
        return (int)(((long)a << 16) / (long)b);
    }

    public static int ceil(int a) {
        return a + 63 & 0xFFFFFFC0;
    }

    public static int floor(int a) {
        return a & 0xFFFFFFC0;
    }

    public static int vectorLength(int x, int y) {
        if (x == 0) {
            return Math.abs(y);
        }
        if (y == 0) {
            return Math.abs(x);
        }
        float fx = (float)x / 64.0f;
        float fy = (float)y / 64.0f;
        return (int)(Math.sqrt(fx * fx + fy * fy) * 64.0);
    }

    public static int intValue(int f) {
        return f >> 6;
    }

    public static float floatValue(int f) {
        return (float)f / 64.0f;
    }

    public static float floatValue16(int f) {
        return (float)f / 65536.0f;
    }

    public static double doubleValue(int f) {
        return (double)f / 64.0;
    }

    public static int valueOf(float f) {
        return (int)(f * 64.0f);
    }

    public static int valueOf(double d) {
        return (int)(d * 64.0);
    }

    public static int valueOf16(double d) {
        return (int)(d * 65536.0);
    }

    public static String toString(int f) {
        return String.valueOf(Fixed.floatValue(f));
    }

    public static String toString(int x, int y) {
        CPStringBuilder sbuf = new CPStringBuilder(40);
        sbuf.append('(');
        sbuf.append((float)x / 64.0f);
        sbuf.append(", ");
        sbuf.append((float)y / 64.0f);
        sbuf.append(')');
        return sbuf.toString();
    }
}

