/*
 * Decompiled with CFR 0.152.
 */
package gnu.java.awt.font.opentype;

import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Locale;

public class NameDecoder {
    public static final int NAME_COPYRIGHT = 0;
    public static final int NAME_FAMILY = 1;
    public static final int NAME_SUBFAMILY = 2;
    public static final int NAME_UNIQUE = 3;
    public static final int NAME_FULL = 4;
    public static final int NAME_VERSION = 5;
    public static final int NAME_POSTSCRIPT = 6;
    public static final int NAME_TRADEMARK = 7;
    public static final int NAME_MANUFACTURER = 8;
    public static final int NAME_DESIGNER = 9;
    public static final int NAME_DESCRIPTION = 10;
    public static final int NAME_VENDOR_URL = 11;
    public static final int NAME_DESIGNER_URL = 12;
    public static final int NAME_LICENSE = 13;
    public static final int NAME_LICENSE_URL = 14;
    public static final int NAME_PREFERRED_FAMILY = 16;
    public static final int NAME_PREFERRED_SUBFAMILY = 17;
    public static final int NAME_FULL_MACCOMPATIBLE = 18;
    public static final int NAME_SAMPLE_TEXT = 19;
    public static final int NAME_POSTSCRIPT_CID = 20;
    private static final int PLATFORM_MACINTOSH = 1;
    private static final int PLATFORM_MICROSOFT = 3;
    private static final String macLanguageCodes = "enfrdeitnlsvesdaptnoiwjaarfielismttrhrzhurhithkoltplhuetlv  fofaruzhnlgdsqrocssksljisrmkbgukbeuzkkazazhykamokytgtkmnmnpskukssdbonesamrbnasgupaormlkntatesimykmloviintlmsmsamti  soswrwrn  mgeo                                                                  cyeucalaqugnayttugtsjwsuglafbriugdgvgatoelklaz";
    private static final String microsoftLanguageCodes = "  arbgcazhcsdadeelenesfifriwhuisitjakonlnoplptrmrorushsksqsvthtrurinukbesletlvlttgfavihyazeu  mk  ts    xhzuafkafohimt  gajimskkkyswtkuzttbnpaguortateknmlasmrsamnbocykmlomygl    sd  si  iuam  ksnefypstl      ha  yo              omtign  laso";

    public static String getName(ByteBuffer nameTable, int name, Locale locale) {
        if (nameTable == null) {
            return null;
        }
        nameTable.position(0);
        if (nameTable.getShort() != 0) {
            return null;
        }
        int macLanguage = NameDecoder.getMacLanguageCode(locale);
        int msLanguage = NameDecoder.getMicrosoftLanguageCode(locale);
        int numRecords = nameTable.getShort();
        short offset = nameTable.getShort();
        int i = 0;
        while (i < numRecords) {
            short namePlatform = nameTable.getShort();
            short nameEncoding = nameTable.getShort();
            short nameLanguage = nameTable.getShort();
            short nameID = nameTable.getShort();
            short nameLen = nameTable.getShort();
            int nameStart = offset + nameTable.getShort();
            if (nameID == name) {
                String result;
                if (name == 6) {
                    result = nameTable.get(nameStart) == 0 ? NameDecoder.decodeName("UTF-16BE", nameTable, nameStart, nameLen) : NameDecoder.decodeName("ASCII", nameTable, nameStart, nameLen);
                    return result;
                }
                boolean match = false;
                switch (namePlatform) {
                    case 1: {
                        if (nameLanguage == macLanguage || locale == null) {
                            match = true;
                            break;
                        }
                        switch (macLanguage) {
                            case 49: {
                                match = nameLanguage == 50 || nameLanguage == 150;
                                break;
                            }
                            case 57: {
                                match = nameLanguage == 58;
                                break;
                            }
                            case 83: {
                                match = nameLanguage == 84;
                            }
                        }
                        break;
                    }
                    case 3: {
                        if ((nameLanguage & 0xFF) != msLanguage && locale != null) break;
                        match = true;
                    }
                }
                if (match && (result = NameDecoder.decodeName(namePlatform, nameEncoding, nameLanguage, nameTable, nameStart, nameLen)) != null) {
                    return result;
                }
            }
            ++i;
        }
        return null;
    }

    private static int getMacLanguageCode(Locale loc) {
        if (loc == null) {
            return -1;
        }
        int code = NameDecoder.findLanguageCode(loc.getLanguage(), macLanguageCodes);
        switch (code) {
            case 19: {
                if (!loc.equals(Locale.SIMPLIFIED_CHINESE)) break;
                code = 33;
            }
        }
        return code;
    }

    private static int getMicrosoftLanguageCode(Locale locale) {
        if (locale == null) {
            return -1;
        }
        String isoCode = locale.getLanguage();
        int code = NameDecoder.findLanguageCode(isoCode, microsoftLanguageCodes);
        if (code == -1) {
            if (isoCode.equals("hr") || isoCode.equals("sr")) {
                code = 26;
            } else if (isoCode.equals("gd")) {
                code = 60;
            }
        }
        return code;
    }

    private static int findLanguageCode(String lang, String langCodes) {
        if (lang == null) {
            return -1;
        }
        if (lang.length() != 2) {
            return -1;
        }
        int index = 0;
        while ((index = langCodes.indexOf(lang, index)) >= 0 && (index & 1) != 0) {
        }
        if (index < 0) {
            return -1;
        }
        return index /= 2;
    }

    private static String decodeName(int platform, int encoding, int language, ByteBuffer buffer, int offset, int len) {
        String charsetName = NameDecoder.getCharsetName(platform, language, encoding);
        if (charsetName == null) {
            return null;
        }
        return NameDecoder.decodeName(charsetName, buffer, offset, len);
    }

    private static String decodeName(String charsetName, ByteBuffer buffer, int offset, int len) {
        byte[] byteBuf = new byte[len];
        int oldPosition = buffer.position();
        try {
            buffer.position(offset);
            buffer.get(byteBuf);
            try {
                String string = new String(byteBuf, charsetName);
                return string;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
            }
        }
        finally {
            buffer.position(oldPosition);
        }
        return null;
    }

    private static Locale getMacLocale(int macLanguageCode) {
        switch (macLanguageCode) {
            case 0: {
                return Locale.ENGLISH;
            }
            case 1: {
                return Locale.FRENCH;
            }
            case 2: {
                return Locale.GERMAN;
            }
            case 3: {
                return Locale.ITALIAN;
            }
            case 11: {
                return Locale.JAPANESE;
            }
            case 23: {
                return Locale.KOREAN;
            }
            case 19: {
                return Locale.TRADITIONAL_CHINESE;
            }
            case 33: {
                return Locale.SIMPLIFIED_CHINESE;
            }
        }
        if (macLanguageCode < 0 || macLanguageCode > 150) {
            return null;
        }
        String isoCode = macLanguageCodes.substring(macLanguageCode << 1, macLanguageCode + 1 << 1);
        if (isoCode.charAt(0) == ' ') {
            return null;
        }
        return new Locale(isoCode);
    }

    private static Locale getWindowsLocale(int lcid) {
        switch (lcid) {
            case 1031: {
                return Locale.GERMAN;
            }
            case 1032: {
                return new Locale("el", "GR");
            }
            case 1033: {
                return Locale.ENGLISH;
            }
            case 1035: {
                return new Locale("fi");
            }
            case 1036: {
                return Locale.FRENCH;
            }
            case 1046: {
                return new Locale("pt");
            }
            case 2055: {
                return new Locale("de", "CH");
            }
            case 2057: {
                return new Locale("en", "UK");
            }
            case 2060: {
                return new Locale("fr", "BE");
            }
            case 2070: {
                return new Locale("pt", "BR");
            }
            case 3079: {
                return new Locale("de", "AT");
            }
            case 3081: {
                return new Locale("en", "AU");
            }
            case 3084: {
                return new Locale("fr", "CA");
            }
            case 4103: {
                return new Locale("de", "LU");
            }
            case 4105: {
                return new Locale("en", "CA");
            }
            case 4108: {
                return new Locale("fr", "CH");
            }
            case 5127: {
                return new Locale("de", "LI");
            }
            case 5129: {
                return new Locale("en", "NZ");
            }
            case 5132: {
                return new Locale("fr", "LU");
            }
            case 6153: {
                return new Locale("en", "IE");
            }
        }
        return null;
    }

    private static String getMacCharsetName(int macScript) {
        switch (macScript) {
            case 0: {
                return "MacRoman";
            }
            case 1: {
                return "MacJapanese";
            }
            case 2: {
                return "MacKorean";
            }
            case 3: {
                return "MacTradChinese";
            }
            case 4: {
                return "MacArabic";
            }
            case 5: {
                return "MacHebrew";
            }
            case 6: {
                return "MacGreek";
            }
            case 7: {
                return "MacCyrillic";
            }
            case 8: {
                return "MacRSymbol";
            }
            case 9: {
                return "MacDevanagari";
            }
            case 10: {
                return "MacGurmukhi";
            }
            case 11: {
                return "MacGujarati";
            }
            case 12: {
                return "MacOriya";
            }
            case 13: {
                return "MacBengali";
            }
            case 14: {
                return "MacTamil";
            }
            case 15: {
                return "MacTelugu";
            }
            case 16: {
                return "MacKannada";
            }
            case 17: {
                return "MacMalayalam";
            }
            case 18: {
                return "MacSinhalese";
            }
            case 19: {
                return "MacBurmese";
            }
            case 20: {
                return "MacKhmer";
            }
            case 21: {
                return "MacThai";
            }
            case 22: {
                return "MacLao";
            }
            case 23: {
                return "MacGeorgian";
            }
            case 24: {
                return "MacArmenian";
            }
            case 25: {
                return "MacSimpChinese";
            }
            case 26: {
                return "MacTibetan";
            }
            case 27: {
                return "MacMongolian";
            }
            case 28: {
                return "MacEthiopic";
            }
            case 29: {
                return "MacCentralEurope";
            }
            case 30: {
                return "MacVietnamese";
            }
            case 31: {
                return "MacExtArabic";
            }
        }
        return null;
    }

    private static String getMicrosoftCharsetName(int lcid) {
        int codePage = 63;
        int lang = lcid & 0x3FF;
        if (lang < 100) {
            codePage = " 612D022322225022EC2202201?002A462110777 68 ?2 1      2 2     2112 ?1           1     2           2 ".charAt(lang);
        }
        if (codePage == 63) {
            switch (lcid) {
                case 1050: 
                case 2074: {
                    codePage = 48;
                    break;
                }
                case 1068: 
                case 1091: {
                    codePage = 52;
                    break;
                }
                case 2092: 
                case 2115: 
                case 3098: {
                    codePage = 49;
                }
            }
        }
        switch (codePage) {
            case 48: {
                return "windows-1250";
            }
            case 49: {
                return "windows-1251";
            }
            case 50: {
                return "windows-1252";
            }
            case 51: {
                return "windows-1253";
            }
            case 52: {
                return "windows-1254";
            }
            case 53: {
                return "windows-1255";
            }
            case 54: {
                return "windows-1256";
            }
            case 55: {
                return "windows-1257";
            }
            case 56: {
                return "windows-1258";
            }
            case 65: {
                return "windows-874";
            }
            case 66: {
                return "windows-936";
            }
            case 67: {
                return "windows-949";
            }
            case 68: {
                return "windows-950";
            }
            case 69: {
                return "windows-932";
            }
        }
        return null;
    }

    public static Locale getLocale(int platform, int language, int encoding) {
        switch (platform) {
            case 1: {
                return NameDecoder.getMacLocale(language);
            }
            case 3: {
                return NameDecoder.getWindowsLocale(language);
            }
        }
        return null;
    }

    public static String getCharsetName(int platform, int language, int encoding) {
        switch (platform) {
            case 1: {
                return NameDecoder.getMacCharsetName(encoding);
            }
            case 3: {
                return NameDecoder.getMicrosoftCharsetName(language);
            }
        }
        return null;
    }
}

