/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.rmiregistry;

import gnu.classpath.tools.common.Persistent;
import gnu.classpath.tools.rmiregistry.Main;
import java.rmi.AccessException;
import java.rmi.AlreadyBoundException;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.Registry;
import java.util.ArrayList;
import java.util.Map;
import java.util.TimerTask;

public class RegistryImpl
implements Registry {
    Map bindings;

    public RegistryImpl(Map aTable) {
        this.bindings = aTable;
    }

    public Remote lookup(String name) throws RemoteException, NotBoundException, AccessException {
        Object obj = this.bindings.get(name);
        if (obj == null) {
            throw new NotBoundException(name);
        }
        return (Remote)obj;
    }

    public void bind(String name, Remote obj) throws RemoteException, AlreadyBoundException, AccessException {
        if (Main.verbose) {
            System.out.println("Bind " + name);
        }
        if (this.bindings.containsKey(name)) {
            throw new AlreadyBoundException(name);
        }
        this.bindings.put(name, obj);
    }

    public void unbind(String name) throws RemoteException, NotBoundException, AccessException {
        if (name.equals(Main.STOP)) {
            if (this.bindings instanceof Persistent) {
                ((Persistent)((Object)this.bindings)).writeContent();
            }
            System.out.println("Shutdown command received. Will terminate in 10 s");
            Persistent.timer.schedule((TimerTask)new Persistent.ExitTask(), 10000L);
        } else {
            if (Main.verbose) {
                System.out.println("Unbind " + name);
            }
            if (!this.bindings.containsKey(name)) {
                throw new NotBoundException(name);
            }
            this.bindings.remove(name);
        }
    }

    public void rebind(String name, Remote obj) throws RemoteException, AccessException {
        if (Main.verbose) {
            System.out.println("Rebind " + name);
        }
        this.bindings.put(name, obj);
    }

    public String[] list() throws RemoteException, AccessException {
        ArrayList keys = new ArrayList(this.bindings.keySet());
        int n = keys.size();
        String[] rt = new String[n];
        int i = 0;
        while (i < n) {
            rt[i] = (String)keys.get(i);
            ++i;
        }
        return rt;
    }
}

