/*
 * Decompiled with CFR 0.152.
 */
package gnu.classpath.tools.jar;

import gnu.classpath.tools.common.ClasspathToolParser;
import gnu.classpath.tools.getopt.FileArgumentCallback;
import gnu.classpath.tools.getopt.Option;
import gnu.classpath.tools.getopt.OptionException;
import gnu.classpath.tools.getopt.OptionGroup;
import gnu.classpath.tools.jar.Action;
import gnu.classpath.tools.jar.Creator;
import gnu.classpath.tools.jar.Entry;
import gnu.classpath.tools.jar.Extractor;
import gnu.classpath.tools.jar.Indexer;
import gnu.classpath.tools.jar.Lister;
import gnu.classpath.tools.jar.Messages;
import gnu.classpath.tools.jar.Updater;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;

public class Main {
    Class operationMode;
    File archiveFile;
    int storageMode = 8;
    boolean readNamesFromStdin = false;
    boolean verbose = false;
    boolean wantManifest = true;
    File manifestFile;
    ArrayList<Entry> entries = new ArrayList();
    String changedDirectory;

    void setArchiveFile(String filename) throws OptionException {
        if (this.archiveFile != null) {
            String fmt = MessageFormat.format(Messages.getString("Main.ArchiveAlreadySet"), this.archiveFile);
            throw new OptionException(fmt);
        }
        this.archiveFile = new File(filename);
    }

    private ClasspathToolParser initializeParser() {
        JarParser p = new JarParser("jar");
        p.setHeader(Messages.getString("Main.Usage"));
        OptionGroup grp = new OptionGroup(Messages.getString("Main.OpMode"));
        grp.add(new ModeOption('c', Messages.getString("Main.Create"), Creator.class));
        grp.add(new ModeOption('x', Messages.getString("Main.Extract"), Extractor.class));
        grp.add(new ModeOption('t', Messages.getString("Main.List"), Lister.class));
        grp.add(new ModeOption('u', Messages.getString("Main.Update"), Updater.class));
        grp.add(new ModeOption('i', Messages.getString("Main.Index"), Messages.getString("Main.FileArg"), Indexer.class));
        p.add(grp);
        grp = new OptionGroup(Messages.getString("Main.OpMods"));
        grp.add(new Option('f', Messages.getString("Main.ArchiveName"), Messages.getString("Main.FileArg2")){

            public void parsed(String argument) throws OptionException {
                Main.this.setArchiveFile(argument);
            }
        });
        grp.add(new Option('0', Messages.getString("Main.NoZip")){

            public void parsed(String argument) throws OptionException {
                Main.this.storageMode = 0;
            }
        });
        grp.add(new Option('v', Messages.getString("Main.Verbose")){

            public void parsed(String argument) throws OptionException {
                Main.this.verbose = true;
            }
        });
        grp.add(new Option('M', Messages.getString("Main.NoManifest")){

            public void parsed(String argument) throws OptionException {
                Main.this.wantManifest = false;
            }
        });
        grp.add(new Option('m', Messages.getString("Main.ManifestName"), Messages.getString("Main.ManifestArgName")){

            public void parsed(String argument) throws OptionException {
                Main.this.manifestFile = new File(argument);
            }
        });
        p.add(grp);
        grp = new OptionGroup(Messages.getString("Main.FileNameGroup"));
        grp.add(new Option('C', Messages.getString("Main.ChangeDir"), Messages.getString("Main.ChangeDirArg")){

            public void parsed(String argument) throws OptionException {
                Main.this.changedDirectory = argument;
            }
        });
        grp.add(new Option('@', Messages.getString("Main.Stdin")){

            public void parsed(String argument) throws OptionException {
                Main.this.readNamesFromStdin = true;
            }
        });
        p.add(grp);
        return p;
    }

    private void readNames() {
        try {
            String line;
            BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
            while ((line = br.readLine()) != null) {
                this.entries.add(new Entry(new File(line)));
            }
        }
        catch (IOException iOException) {}
    }

    private void run(String[] args) throws InstantiationException, IllegalAccessException, IOException {
        ClasspathToolParser p = this.initializeParser();
        if (args.length > 0 && args[0].charAt(0) != '-') {
            args[0] = String.valueOf('-') + args[0];
        }
        p.parse(args, new HandleFile(), true);
        if (this.readNamesFromStdin) {
            this.readNames();
        }
        Action t = (Action)this.operationMode.newInstance();
        t.run(this);
    }

    public static void main(String[] args) {
        Main jarprogram = new Main();
        try {
            jarprogram.run(args);
        }
        catch (Exception e) {
            System.err.println(Messages.getString("Main.InternalError"));
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }

    class HandleFile
    extends FileArgumentCallback {
        HandleFile() {
        }

        public void notifyFile(String fileArgument) {
            Entry entry;
            if (Main.this.changedDirectory != null) {
                entry = new Entry(new File(Main.this.changedDirectory, fileArgument), fileArgument);
                Main.this.changedDirectory = null;
            } else {
                entry = new Entry(new File(fileArgument));
            }
            Main.this.entries.add(entry);
        }
    }

    private class JarParser
    extends ClasspathToolParser {
        public JarParser(String name) {
            super(name);
        }

        protected void validate() throws OptionException {
            if (Main.this.operationMode == null) {
                throw new OptionException(Messages.getString("Main.MustSpecify"));
            }
            if (Main.this.changedDirectory != null) {
                throw new OptionException(Messages.getString("Main.TwoArgsReqd"));
            }
            if (!Main.this.wantManifest && Main.this.manifestFile != null) {
                throw new OptionException(Messages.getString("Main.CantHaveBoth"));
            }
            if (Main.this.operationMode == Indexer.class) {
                if (!Main.this.entries.isEmpty()) {
                    throw new OptionException(Messages.getString("Main.NoFilesWithi"));
                }
                if (!Main.this.wantManifest) {
                    throw new OptionException(Messages.getString("Main.NoMAndi"));
                }
                if (Main.this.manifestFile != null) {
                    throw new OptionException(Messages.getString("Main.AnotherNomAndi"));
                }
            }
        }
    }

    private class ModeOption
    extends Option {
        private Class mode;

        public ModeOption(char shortName, String description, Class mode) {
            super(shortName, description);
            this.mode = mode;
        }

        public ModeOption(char shortName, String description, String argName, Class mode) {
            super(shortName, description, argName);
            this.mode = mode;
        }

        public void parsed(String argument) throws OptionException {
            if (Main.this.operationMode != null) {
                throw new OptionException(Messages.getString("Main.ModeAlreaySet"));
            }
            Main.this.operationMode = this.mode;
            if (argument != null) {
                Main.this.setArchiveFile(argument);
            }
        }
    }
}

