/*
 * YUI Extensions 0.33 RC2
 * Copyright(c) 2006, Jack Slocum.
 */


YAHOO.ext.grid.Grid=function(container,dataModel,colModel,selectionModel){this.container=YAHOO.ext.Element.get(container);this.container.update('');this.container.setStyle('overflow','hidden');this.id=this.container.id;this.rows=[];this.rowCount=0;this.fieldId=null;this.dataModel=dataModel;this.colModel=colModel;this.selModel=selectionModel;this.activeEditor=null;this.editingCell=null;this.minColumnWidth=25;this.autoSizeColumns=false;this.autoSizeHeaders=false;this.monitorWindowResize=true;this.maxRowsToMeasure=0;this.trackMouseOver=false;this.enableDragDrop=false;this.stripeRows=true;this.autoHeight=false;this.autoWidth=false;this.allowTextSelectionPattern=/INPUT|TEXTAREA|SELECT/i;this.setValueDelegate=this.setCellValue.createDelegate(this);var CE=YAHOO.util.CustomEvent;this.events={'click':new CE('click'),'dblclick':new CE('dblclick'),'mousedown':new CE('mousedown'),'mouseup':new CE('mouseup'),'mouseover':new CE('mouseover'),'mouseout':new CE('mouseout'),'keypress':new CE('keypress'),'keydown':new CE('keydown'),'cellclick':new CE('cellclick'),'celldblclick':new CE('celldblclick'),'rowclick':new CE('rowclick'),'rowdblclick':new CE('rowdblclick'),'headerclick':new CE('headerclick'),'rowcontextmenu':new CE('rowcontextmenu'),'headercontextmenu':new CE('headercontextmenu'),'beforeedit':new CE('beforeedit'),'afteredit':new CE('afteredit'),'bodyscroll':new CE('bodyscroll'),'columnresize':new CE('columnresize'),'startdrag':new CE('startdrag'),'enddrag':new CE('enddrag'),'dragdrop':new CE('dragdrop'),'dragover':new CE('dragover'),'dragenter':new CE('dragenter'),'dragout':new CE('dragout')};};YAHOO.ext.grid.Grid.prototype={render:function(){if((!this.container.dom.offsetHeight||this.container.dom.offsetHeight<20)||this.container.getStyle('height')=='auto'){this.autoHeight=true;}
if((!this.container.dom.offsetWidth||this.container.dom.offsetWidth<20)){this.autoWidth=true;}
if(!this.view){if(this.dataModel.isPaged()){this.view=new YAHOO.ext.grid.PagedGridView();}else{this.view=new YAHOO.ext.grid.GridView();}}
this.view.init(this);this.el=getEl(this.view.render(),true);var c=this.container;c.mon("click",this.onClick,this,true);c.mon("dblclick",this.onDblClick,this,true);c.mon("contextmenu",this.onContextMenu,this,true);c.mon("selectstart",this.cancelTextSelection,this,true);c.mon("mousedown",this.cancelTextSelection,this,true);c.mon("mousedown",this.onMouseDown,this,true);c.mon("mouseup",this.onMouseUp,this,true);if(this.trackMouseOver){this.el.mon("mouseover",this.onMouseOver,this,true);this.el.mon("mouseout",this.onMouseOut,this,true);}
c.mon("keypress",this.onKeyPress,this,true);c.mon("keydown",this.onKeyDown,this,true);this.init();},setDataModel:function(dm,rerender){this.view.unplugDataModel(this.dataModel);this.dataModel=dm;this.view.plugDataModel(dm);if(rerender){dm.fireEvent('datachanged');}},init:function(){this.rows=this.el.dom.rows;if(!this.disableSelection){if(!this.selModel){this.selModel=new YAHOO.ext.grid.DefaultSelectionModel(this);}
this.selModel.init(this);this.selModel.onSelectionChange.subscribe(this.updateField,this,true);}else{this.selModel=new YAHOO.ext.grid.DisableSelectionModel(this);this.selModel.init(this);}
if(this.enableDragDrop){this.dd=new YAHOO.ext.grid.GridDD(this,this.container.dom);}},onMouseDown:function(e){this.fireEvent('mousedown',e);},onMouseUp:function(e){this.fireEvent('mouseup',e);},onMouseOver:function(e){this.fireEvent('mouseover',e);},onMouseOut:function(e){this.fireEvent('mouseout',e);},onKeyPress:function(e){this.fireEvent('keypress',e);},onKeyDown:function(e){this.fireEvent('keydown',e);},fireEvent:YAHOO.ext.util.Observable.prototype.fireEvent,on:YAHOO.ext.util.Observable.prototype.on,addListener:YAHOO.ext.util.Observable.prototype.addListener,delayedListener:YAHOO.ext.util.Observable.prototype.delayedListener,removeListener:YAHOO.ext.util.Observable.prototype.removeListener,purgeListeners:YAHOO.ext.util.Observable.prototype.purgeListeners,onClick:function(e){this.fireEvent('click',e);var target=e.getTarget();var row=this.getRowFromChild(target);var cell=this.getCellFromChild(target);var header=this.getHeaderFromChild(target);if(row){this.fireEvent('rowclick',this,row.rowIndex,e);}
if(cell){this.fireEvent('cellclick',this,row.rowIndex,cell.columnIndex,e);}
if(header){this.fireEvent('headerclick',this,header.columnIndex,e);}},onContextMenu:function(e){var target=e.getTarget();var row=this.getRowFromChild(target);var header=this.getHeaderFromChild(target);if(row){this.fireEvent('rowcontextmenu',this,row.rowIndex,e);}
if(header){this.fireEvent('headercontextmenu',this,header.columnIndex,e);}
e.preventDefault();},onDblClick:function(e){this.fireEvent('dblclick',e);var target=e.getTarget();var row=this.getRowFromChild(target);var cell=this.getCellFromChild(target);if(row){this.fireEvent('rowdblclick',this,row.rowIndex,e);}
if(cell){this.fireEvent('celldblclick',this,row.rowIndex,cell.columnIndex,e);}},startEditing:function(rowIndex,colIndex){var row=this.rows[rowIndex];var cell=row.childNodes[colIndex];this.stopEditing();setTimeout(this.doEdit.createDelegate(this,[row,cell]),10);},stopEditing:function(){if(this.activeEditor){this.activeEditor.stopEditing();}},doEdit:function(row,cell){if(!row||!cell)return;var cm=this.colModel;var dm=this.dataModel;var colIndex=cell.columnIndex;var rowIndex=row.rowIndex;if(cm.isCellEditable(colIndex,rowIndex)){var ed=cm.getCellEditor(colIndex,rowIndex);if(ed){if(this.activeEditor){this.activeEditor.stopEditing();}
this.fireEvent('beforeedit',this,rowIndex,colIndex);this.activeEditor=ed;this.editingCell=cell;this.view.ensureVisible(row,true);try{cell.focus();}catch(e){}
ed.init(this,this.el.dom.parentNode,this.setValueDelegate);var value=dm.getValueAt(rowIndex,cm.getDataIndex(colIndex));setTimeout(ed.startEditing.createDelegate(ed,[value,row,cell]),1);}}},setCellValue:function(value,rowIndex,colIndex){this.dataModel.setValueAt(value,rowIndex,this.colModel.getDataIndex(colIndex));this.fireEvent('afteredit',this,rowIndex,colIndex);},cancelTextSelection:function(e){var target=e.getTarget();if(target&&target!=this.el.dom.parentNode&&!this.allowTextSelectionPattern.test(target.tagName)){e.preventDefault();}},autoSize:function(){this.view.updateWrapHeight();this.view.adjustForScroll();},scrollTo:function(row){if(typeof row=='number'){row=this.rows[row];}
this.view.ensureVisible(row,true);},getEditingCell:function(){return this.editingCell;},bindToField:function(fieldId){this.fieldId=fieldId;this.readField();},updateField:function(){if(this.fieldId){var field=YAHOO.util.Dom.get(this.fieldId);field.value=this.getSelectedRowIds().join(',');}},readField:function(){if(this.fieldId){var field=YAHOO.util.Dom.get(this.fieldId);var values=field.value.split(',');var rows=this.getRowsById(values);this.selModel.selectRows(rows,false);}},getRow:function(index){return this.rows[index];},getRowsById:function(id){var dm=this.dataModel;if(!(id instanceof Array)){for(var i=0;i<this.rows.length;i++){if(dm.getRowId(i)==id){return this.rows[i];}}
return null;}
var found=[];var re="^(?:";for(var i=0;i<id.length;i++){re+=id[i];if(i!=id.length-1)re+="|";}
var regex=new RegExp(re+")$");for(var i=0;i<this.rows.length;i++){if(regex.test(dm.getRowId(i))){found.push(this.rows[i]);}}
return found;},getRowAfter:function(row){return this.getSibling('next',row);},getRowBefore:function(row){return this.getSibling('previous',row);},getCellAfter:function(cell,includeHidden){var next=this.getSibling('next',cell);if(next&&!includeHidden&&this.colModel.isHidden(next.columnIndex)){return this.getCellAfter(next);}
return next;},getCellBefore:function(cell,includeHidden){var prev=this.getSibling('previous',cell);if(prev&&!includeHidden&&this.colModel.isHidden(prev.columnIndex)){return this.getCellBefore(prev);}
return prev;},getLastCell:function(row,includeHidden){var cell=this.getElement('previous',row.lastChild);if(cell&&!includeHidden&&this.colModel.isHidden(cell.columnIndex)){return this.getCellBefore(cell);}
return cell;},getFirstCell:function(row,includeHidden){var cell=this.getElement('next',row.firstChild);if(cell&&!includeHidden&&this.colModel.isHidden(cell.columnIndex)){return this.getCellAfter(cell);}
return cell;},getSibling:function(type,node){if(!node)return null;type+='Sibling';var n=node[type];while(n&&n.nodeType!=1){n=n[type];}
return n;},getElement:function(direction,node){if(!node||node.nodeType==1)return node;else return this.getSibling(direction,node);},getElementFromChild:function(childEl,parentClass){if(!childEl||(YAHOO.util.Dom.hasClass(childEl,parentClass))){return childEl;}
var p=childEl.parentNode;var b=document.body;while(p&&p!=b){if(YAHOO.util.Dom.hasClass(p,parentClass)){return p;}
p=p.parentNode;}
return null;},getRowFromChild:function(childEl){return this.getElementFromChild(childEl,'ygrid-row');},getCellFromChild:function(childEl){return this.getElementFromChild(childEl,'ygrid-col');},getHeaderFromChild:function(childEl){return this.getElementFromChild(childEl,'ygrid-hd');},getSelectedRows:function(){return this.selModel.getSelectedRows();},getSelectedRow:function(){if(this.selModel.hasSelection()){return this.selModel.getSelectedRows()[0];}
return null;},getSelectedRowIndexes:function(){var a=[];var rows=this.selModel.getSelectedRows();for(var i=0;i<rows.length;i++){a[i]=rows[i].rowIndex;}
return a;},getSelectedRowIndex:function(){if(this.selModel.hasSelection()){return this.selModel.getSelectedRows()[0].rowIndex;}
return-1;},getSelectedRowId:function(){if(this.selModel.hasSelection()){return this.selModel.getSelectedRowIds()[0];}
return null;},getSelectedRowIds:function(){return this.selModel.getSelectedRowIds();},clearSelections:function(){this.selModel.clearSelections();},selectAll:function(){this.selModel.selectAll();},getSelectionCount:function(){return this.selModel.getCount();},hasSelection:function(){return this.selModel.hasSelection();},getSelectionModel:function(){if(!this.selModel){this.selModel=new DefaultSelectionModel();}
return this.selModel;},getDataModel:function(){return this.dataModel;},getColumnModel:function(){return this.colModel;},getView:function(){return this.view;},getDragDropText:function(){return this.ddText.replace('%0',this.selModel.getCount());}};YAHOO.ext.grid.Grid.prototype.ddText="%0 selected row(s)";

if(YAHOO.util.DDProxy){YAHOO.ext.grid.GridDD=function(grid,bwrap){this.grid=grid;var ddproxy=document.createElement('div');ddproxy.id=grid.container.id+'-ddproxy';ddproxy.className='ygrid-drag-proxy';document.body.insertBefore(ddproxy,document.body.firstChild);YAHOO.util.Dom.setStyle(ddproxy,'opacity',.80);var ddicon=document.createElement('span');ddicon.className='ygrid-drop-icon ygrid-drop-nodrop';ddproxy.appendChild(ddicon);var ddtext=document.createElement('span');ddtext.className='ygrid-drag-text';ddtext.innerHTML="&#160;";ddproxy.appendChild(ddtext);this.ddproxy=ddproxy;this.ddtext=ddtext;this.ddicon=ddicon;YAHOO.util.Event.on(bwrap,'click',this.handleClick,this,true);YAHOO.ext.grid.GridDD.superclass.constructor.call(this,bwrap.id,'GridDD',{dragElId:ddproxy.id,resizeFrame:false});this.unlockDelegate=grid.selModel.unlock.createDelegate(grid.selModel);};YAHOO.extendX(YAHOO.ext.grid.GridDD,YAHOO.util.DDProxy);YAHOO.ext.grid.GridDD.prototype.handleMouseDown=function(e){var row=this.grid.getRowFromChild(YAHOO.util.Event.getTarget(e));if(!row)return;if(this.grid.selModel.isSelected(row)){YAHOO.ext.grid.GridDD.superclass.handleMouseDown.call(this,e);}else{this.grid.selModel.unlock();YAHOO.ext.EventObject.setEvent(e);this.grid.selModel.rowClick(this.grid,row.rowIndex,YAHOO.ext.EventObject);YAHOO.ext.grid.GridDD.superclass.handleMouseDown.call(this,e);this.grid.selModel.lock();}};YAHOO.ext.grid.GridDD.prototype.handleClick=function(e){if(this.grid.selModel.isLocked()){setTimeout(this.unlockDelegate,1);YAHOO.util.Event.stopEvent(e);}};YAHOO.ext.grid.GridDD.prototype.setDropStatus=function(dropStatus){if(dropStatus===true){YAHOO.util.Dom.replaceClass(this.ddicon,'ygrid-drop-nodrop','ygrid-drop-ok');}else{YAHOO.util.Dom.replaceClass(this.ddicon,'ygrid-drop-ok','ygrid-drop-nodrop');}};YAHOO.ext.grid.GridDD.prototype.startDrag=function(e){this.ddtext.innerHTML=this.grid.getDragDropText();this.setDropStatus(false);this.grid.selModel.lock();this.grid.fireEvent('startdrag',this.grid,this,e);};YAHOO.ext.grid.GridDD.prototype.endDrag=function(e){YAHOO.util.Dom.setStyle(this.ddproxy,'visibility','hidden');this.grid.fireEvent('enddrag',this.grid,this,e);};YAHOO.ext.grid.GridDD.prototype.autoOffset=function(iPageX,iPageY){this.setDelta(-12,-20);};YAHOO.ext.grid.GridDD.prototype.onDragEnter=function(e,id){this.setDropStatus(true);this.grid.fireEvent('dragenter',this.grid,this,id,e);};YAHOO.ext.grid.GridDD.prototype.onDragDrop=function(e,id){this.grid.fireEvent('dragdrop',this.grid,this,id,e);};YAHOO.ext.grid.GridDD.prototype.onDragOver=function(e,id){this.grid.fireEvent('dragover',this.grid,this,id,e);};YAHOO.ext.grid.GridDD.prototype.onDragOut=function(e,id){this.setDropStatus(false);this.grid.fireEvent('dragout',this.grid,this,id,e);};};

if(YAHOO.util.DragDropMgr){YAHOO.util.DragDropMgr.clickTimeThresh=350;}
YAHOO.ext.SplitBar=function(dragElement,resizingElement,orientation,placement){this.el=YAHOO.ext.Element.get(dragElement,true);this.el.dom.unselectable='on';this.resizingEl=YAHOO.ext.Element.get(resizingElement,true);this.orientation=orientation||YAHOO.ext.SplitBar.HORIZONTAL;this.minSize=0;this.maxSize=2000;this.onMoved=new YAHOO.util.CustomEvent("SplitBarMoved",this);this.animate=false;this.useShim=false;this.shim=null;this.proxy=YAHOO.ext.SplitBar.createProxy(this.orientation);this.dd=new YAHOO.util.DDProxy(this.el.dom.id,"SplitBars",{dragElId:this.proxy.id});this.dd.b4StartDrag=this.onStartProxyDrag.createDelegate(this);this.dd.endDrag=this.onEndProxyDrag.createDelegate(this);this.dragSpecs={};this.adapter=new YAHOO.ext.SplitBar.BasicLayoutAdapter();this.adapter.init(this);if(this.orientation==YAHOO.ext.SplitBar.HORIZONTAL){this.placement=placement||(this.el.getX()>this.resizingEl.getX()?YAHOO.ext.SplitBar.LEFT:YAHOO.ext.SplitBar.RIGHT);this.el.setStyle('cursor','e-resize');}else{this.placement=placement||(this.el.getY()>this.resizingEl.getY()?YAHOO.ext.SplitBar.TOP:YAHOO.ext.SplitBar.BOTTOM);this.el.setStyle('cursor','n-resize');}
this.events={'resize':this.onMoved,'moved':this.onMoved,'beforeresize':new YAHOO.util.CustomEvent('beforeresize')}}
YAHOO.extendX(YAHOO.ext.SplitBar,YAHOO.ext.util.Observable,{onStartProxyDrag:function(x,y){this.fireEvent('beforeresize',this);if(this.useShim){if(!this.shim){this.shim=YAHOO.ext.SplitBar.createShim();}
this.shim.setVisible(true);}
YAHOO.util.Dom.setStyle(this.proxy,'display','block');var size=this.adapter.getElementSize(this);this.activeMinSize=this.getMinimumSize();;this.activeMaxSize=this.getMaximumSize();;var c1=size-this.activeMinSize;var c2=Math.max(this.activeMaxSize-size,0);if(this.orientation==YAHOO.ext.SplitBar.HORIZONTAL){this.dd.resetConstraints();this.dd.setXConstraint(this.placement==YAHOO.ext.SplitBar.LEFT?c1:c2,this.placement==YAHOO.ext.SplitBar.LEFT?c2:c1);this.dd.setYConstraint(0,0);}else{this.dd.resetConstraints();this.dd.setXConstraint(0,0);this.dd.setYConstraint(this.placement==YAHOO.ext.SplitBar.TOP?c1:c2,this.placement==YAHOO.ext.SplitBar.TOP?c2:c1);}
this.dragSpecs.startSize=size;this.dragSpecs.startPoint=[x,y];YAHOO.util.DDProxy.prototype.b4StartDrag.call(this.dd,x,y);},onEndProxyDrag:function(e){YAHOO.util.Dom.setStyle(this.proxy,'display','none');var endPoint=YAHOO.util.Event.getXY(e);if(this.useShim){this.shim.setVisible(false);}
var newSize;if(this.orientation==YAHOO.ext.SplitBar.HORIZONTAL){newSize=this.dragSpecs.startSize+
(this.placement==YAHOO.ext.SplitBar.LEFT?endPoint[0]-this.dragSpecs.startPoint[0]:this.dragSpecs.startPoint[0]-endPoint[0]);}else{newSize=this.dragSpecs.startSize+
(this.placement==YAHOO.ext.SplitBar.TOP?endPoint[1]-this.dragSpecs.startPoint[1]:this.dragSpecs.startPoint[1]-endPoint[1]);}
newSize=Math.min(Math.max(newSize,this.activeMinSize),this.activeMaxSize);if(newSize!=this.dragSpecs.startSize){this.adapter.setElementSize(this,newSize);this.onMoved.fireDirect(this,newSize);}},getAdapter:function(){return this.adapter;},setAdapter:function(adapter){this.adapter=adapter;this.adapter.init(this);},getMinimumSize:function(){return this.minSize;},setMinimumSize:function(minSize){this.minSize=minSize;},getMaximumSize:function(){return this.maxSize;},setMaximumSize:function(maxSize){this.maxSize=maxSize;},setCurrentSize:function(size){var oldAnimate=this.animate;this.animate=false;this.adapter.setElementSize(this,size);this.animate=oldAnimate;}});YAHOO.ext.SplitBar.createShim=function(){var shim=document.createElement('div');shim.unselectable='on';YAHOO.util.Dom.generateId(shim,'split-shim');YAHOO.util.Dom.setStyle(shim,'width','100%');YAHOO.util.Dom.setStyle(shim,'height','100%');YAHOO.util.Dom.setStyle(shim,'position','absolute');YAHOO.util.Dom.setStyle(shim,'background','white');YAHOO.util.Dom.setStyle(shim,'z-index',11000);window.document.body.appendChild(shim);var shimEl=YAHOO.ext.Element.get(shim);shimEl.setOpacity(.01);shimEl.setXY([0,0]);return shimEl;};YAHOO.ext.SplitBar.createProxy=function(orientation){var proxy=document.createElement('div');proxy.unselectable='on';YAHOO.util.Dom.generateId(proxy,'split-proxy');YAHOO.util.Dom.setStyle(proxy,'position','absolute');YAHOO.util.Dom.setStyle(proxy,'visibility','hidden');YAHOO.util.Dom.setStyle(proxy,'z-index',11001);YAHOO.util.Dom.setStyle(proxy,'background-color',"#aaa");if(orientation==YAHOO.ext.SplitBar.HORIZONTAL){YAHOO.util.Dom.setStyle(proxy,'cursor','e-resize');}else{YAHOO.util.Dom.setStyle(proxy,'cursor','n-resize');}
YAHOO.util.Dom.setStyle(proxy,'line-height','0px');YAHOO.util.Dom.setStyle(proxy,'font-size','0px');window.document.body.appendChild(proxy);return proxy;};YAHOO.ext.SplitBar.BasicLayoutAdapter=function(){};YAHOO.ext.SplitBar.BasicLayoutAdapter.prototype={init:function(s){},getElementSize:function(s){if(s.orientation==YAHOO.ext.SplitBar.HORIZONTAL){return s.resizingEl.getWidth();}else{return s.resizingEl.getHeight();}},setElementSize:function(s,newSize,onComplete){if(s.orientation==YAHOO.ext.SplitBar.HORIZONTAL){if(!YAHOO.util.Anim||!s.animate){s.resizingEl.setWidth(newSize);if(onComplete){onComplete(s,newSize);}}else{s.resizingEl.setWidth(newSize,true,.1,onComplete,YAHOO.util.Easing.easeOut);}}else{if(!YAHOO.util.Anim||!s.animate){s.resizingEl.setHeight(newSize);if(onComplete){onComplete(s,newSize);}}else{s.resizingEl.setHeight(newSize,true,.1,onComplete,YAHOO.util.Easing.easeOut);}}}};YAHOO.ext.SplitBar.AbsoluteLayoutAdapter=function(container){this.basic=new YAHOO.ext.SplitBar.BasicLayoutAdapter();this.container=getEl(container);}
YAHOO.ext.SplitBar.AbsoluteLayoutAdapter.prototype={init:function(s){this.basic.init(s);},getElementSize:function(s){return this.basic.getElementSize(s);},setElementSize:function(s,newSize,onComplete){this.basic.setElementSize(s,newSize,this.moveSplitter.createDelegate(this,[s]));},moveSplitter:function(s){var yes=YAHOO.ext.SplitBar;switch(s.placement){case yes.LEFT:s.el.setX(s.resizingEl.getRight());break;case yes.RIGHT:s.el.setStyle('right',(this.container.getWidth()-s.resizingEl.getLeft())+'px');break;case yes.TOP:s.el.setY(s.resizingEl.getBottom());break;case yes.BOTTOM:s.el.setY(s.resizingEl.getTop()-s.el.getHeight());break;}}};YAHOO.ext.SplitBar.VERTICAL=1;YAHOO.ext.SplitBar.HORIZONTAL=2;YAHOO.ext.SplitBar.LEFT=1;YAHOO.ext.SplitBar.RIGHT=2;YAHOO.ext.SplitBar.TOP=3;YAHOO.ext.SplitBar.BOTTOM=4;

YAHOO.ext.grid.GridView=function(){this.grid=null;this.lastFocusedRow=null;this.onScroll=new YAHOO.util.CustomEvent('onscroll');this.adjustScrollTask=new YAHOO.ext.util.DelayedTask(this._adjustForScroll,this);this.ensureVisibleTask=new YAHOO.ext.util.DelayedTask();};YAHOO.ext.grid.GridView.prototype={init:function(grid){this.grid=grid;},fireScroll:function(scrollLeft,scrollTop){this.onScroll.fireDirect(this.grid,scrollLeft,scrollTop);},getColumnRenderers:function(){var renderers=[];var cm=this.grid.colModel;var colCount=cm.getColumnCount();for(var i=0;i<colCount;i++){renderers.push(cm.getRenderer(i));}
return renderers;},buildIndexMap:function(){var colToData={};var dataToCol={};var cm=this.grid.colModel;for(var i=0,len=cm.getColumnCount();i<len;i++){var di=cm.getDataIndex(i);colToData[i]=di;dataToCol[di]=i;}
return{'colToData':colToData,'dataToCol':dataToCol};},getDataIndexes:function(){if(!this.indexMap){this.indexMap=this.buildIndexMap();}
return this.indexMap.colToData;},getColumnIndexByDataIndex:function(dataIndex){if(!this.indexMap){this.indexMap=this.buildIndexMap();}
return this.indexMap.dataToCol[dataIndex];},updateHeaders:function(){var colModel=this.grid.colModel;var hcells=this.headers;var colCount=colModel.getColumnCount();for(var i=0;i<colCount;i++){hcells[i].textNode.innerHTML=colModel.getColumnHeader(i);}},adjustForScroll:function(disableDelay){if(!disableDelay){this.adjustScrollTask.delay(50);}else{this._adjustForScroll();}},getCellAtPoint:function(x,y){var colIndex=null;var rowIndex=null;var xy=YAHOO.util.Dom.getXY(this.wrap);x=(x-xy[0])+this.wrap.scrollLeft;y=(y-xy[1])+this.wrap.scrollTop;var colModel=this.grid.colModel;var pos=0;var colCount=colModel.getColumnCount();for(var i=0;i<colCount;i++){if(colModel.isHidden(i))continue;var width=colModel.getColumnWidth(i);if(x>=pos&&x<pos+width){colIndex=i;break;}
pos+=width;}
if(colIndex!=null){rowIndex=(y==0?0:Math.floor(y/this.getRowHeight()));if(rowIndex>=this.grid.dataModel.getRowCount()){return null;}
return[colIndex,rowIndex];}
return null;},_adjustForScroll:function(){this.forceScrollUpdate();if(this.scrollbarMode==YAHOO.ext.grid.GridView.SCROLLBARS_OVERLAP){var adjustment=0;if(this.wrap.clientWidth&&this.wrap.clientWidth!==0){adjustment=this.wrap.offsetWidth-this.wrap.clientWidth;}
this.hwrap.setWidth(this.wrap.offsetWidth-adjustment);}else{this.hwrap.setWidth(this.wrap.offsetWidth);}
this.bwrap.setWidth(Math.max(this.grid.colModel.getTotalWidth(),this.wrap.clientWidth));},focusRow:function(row){if(typeof row=='number'){row=this.getBodyTable().childNodes[row];}
if(!row)return;var left=this.wrap.scrollLeft;try{row.childNodes.item(0).hideFocus=true;row.childNodes.item(0).focus();}catch(e){}
this.ensureVisible(row);this.wrap.scrollLeft=left;this.handleScroll();this.lastFocusedRow=row;},ensureVisible:function(row,disableDelay){if(!disableDelay){this.ensureVisibleTask.delay(50,this._ensureVisible,this,[row]);}else{this._ensureVisible(row);}},_ensureVisible:function(row){if(typeof row=='number'){row=this.getBodyTable().childNodes[row];}
if(!row)return;var left=this.wrap.scrollLeft;var rowTop=parseInt(row.offsetTop,10);var rowBottom=rowTop+row.offsetHeight;var clientTop=parseInt(this.wrap.scrollTop,10);var clientBottom=clientTop+this.wrap.clientHeight;if(rowTop<clientTop){this.wrap.scrollTop=rowTop;}else if(rowBottom>clientBottom){this.wrap.scrollTop=rowBottom-this.wrap.clientHeight;}
this.wrap.scrollLeft=left;this.handleScroll();},updateColumns:function(){this.grid.stopEditing();var colModel=this.grid.colModel;var hcols=this.headers;var colCount=colModel.getColumnCount();var pos=0;var totalWidth=colModel.getTotalWidth();for(var i=0;i<colCount;i++){if(colModel.isHidden(i))continue;var width=colModel.getColumnWidth(i);hcols[i].style.width=width+'px';hcols[i].style.left=pos+'px';hcols[i].split.style.left=(pos+width-3)+'px';this.setCSSWidth(i,width,pos);pos+=width;}
this.lastWidth=totalWidth;if(this.grid.autoWidth){this.grid.container.setWidth(totalWidth+this.grid.container.getBorderWidth('lr'));this.grid.autoSize();}
this.bwrap.setWidth(Math.max(totalWidth,this.wrap.clientWidth));if(!YAHOO.ext.util.Browser.isIE){this.wrap.scrollLeft=this.hwrap.dom.scrollLeft;}
this.syncScroll();this.forceScrollUpdate();if(this.grid.autoHeight){this.autoHeight();this.updateWrapHeight();}},setCSSWidth:function(colIndex,width,pos){var selector=["#"+this.grid.id+" .ygrid-col-"+colIndex,".ygrid-col-"+colIndex];YAHOO.ext.util.CSS.updateRule(selector,'width',width+'px');if(typeof pos=='number'){YAHOO.ext.util.CSS.updateRule(selector,'left',pos+'px');}},setCSSStyle:function(colIndex,name,value){var selector=["#"+this.grid.id+" .ygrid-col-"+colIndex,".ygrid-col-"+colIndex];YAHOO.ext.util.CSS.updateRule(selector,name,value);},handleHiddenChange:function(colModel,colIndex,hidden){if(hidden){this.hideColumn(colIndex);}else{this.unhideColumn(colIndex);}
this.updateColumns();},hideColumn:function(colIndex){var selector=["#"+this.grid.id+" .ygrid-col-"+colIndex,".ygrid-col-"+colIndex];YAHOO.ext.util.CSS.updateRule(selector,'position','absolute');YAHOO.ext.util.CSS.updateRule(selector,'visibility','hidden');this.headers[colIndex].style.display='none';this.headers[colIndex].split.style.display='none';},unhideColumn:function(colIndex){var selector=["#"+this.grid.id+" .ygrid-col-"+colIndex,".ygrid-col-"+colIndex];YAHOO.ext.util.CSS.updateRule(selector,'position','');YAHOO.ext.util.CSS.updateRule(selector,'visibility','visible');this.headers[colIndex].style.display='';this.headers[colIndex].split.style.display='';},getBodyTable:function(){return this.bwrap.dom;},updateRowIndexes:function(firstRow,lastRow){var stripeRows=this.grid.stripeRows;var bt=this.getBodyTable();var nodes=bt.childNodes;firstRow=firstRow||0;lastRow=lastRow||nodes.length-1;var re=/^(?:ygrid-row ygrid-row-alt|ygrid-row)/;for(var rowIndex=firstRow;rowIndex<=lastRow;rowIndex++){var node=nodes[rowIndex];if(stripeRows&&(rowIndex+1)%2==0){node.className=node.className.replace(re,'ygrid-row ygrid-row-alt');}else{node.className=node.className.replace(re,'ygrid-row');}
node.rowIndex=rowIndex;nodes[rowIndex].style.top=(rowIndex*this.rowHeight)+'px';}},insertRows:function(dataModel,firstRow,lastRow){this.updateBodyHeight();this.adjustForScroll(true);var renderers=this.getColumnRenderers();var dindexes=this.getDataIndexes();var colCount=this.grid.colModel.getColumnCount();var beforeRow=null;var bt=this.getBodyTable();if(firstRow<bt.childNodes.length){beforeRow=bt.childNodes[firstRow];}
for(var rowIndex=firstRow;rowIndex<=lastRow;rowIndex++){var row=document.createElement('span');row.className='ygrid-row';row.style.top=(rowIndex*this.rowHeight)+'px';this.renderRow(dataModel,row,rowIndex,colCount,renderers,dindexes);if(beforeRow){bt.insertBefore(row,beforeRow);}else{bt.appendChild(row);}}
this.updateRowIndexes(firstRow);this.adjustForScroll(true);},renderRow:function(dataModel,row,rowIndex,colCount,renderers,dindexes){for(var colIndex=0;colIndex<colCount;colIndex++){var td=document.createElement('span');td.className='ygrid-col ygrid-col-'+colIndex+(colIndex==colCount-1?' ygrid-col-last':'');td.columnIndex=colIndex;td.tabIndex=0;var span=document.createElement('span');span.className='ygrid-cell-text';td.appendChild(span);var val=renderers[colIndex](dataModel.getValueAt(rowIndex,dindexes[colIndex]),rowIndex,colIndex);if(typeof val=='undefined'||val==='')val='&#160;';span.innerHTML=val;row.appendChild(td);}},deleteRows:function(dataModel,firstRow,lastRow){this.updateBodyHeight();this.grid.selModel.deselectRange(firstRow,lastRow);var bt=this.getBodyTable();var rows=[];for(var rowIndex=firstRow;rowIndex<=lastRow;rowIndex++){rows.push(bt.childNodes[rowIndex]);}
for(var i=0;i<rows.length;i++){bt.removeChild(rows[i]);rows[i]=null;}
rows=null;this.updateRowIndexes(firstRow);this.adjustForScroll();},updateRows:function(dataModel,firstRow,lastRow){var bt=this.getBodyTable();var dindexes=this.getDataIndexes();var renderers=this.getColumnRenderers();var colCount=this.grid.colModel.getColumnCount();for(var rowIndex=firstRow;rowIndex<=lastRow;rowIndex++){var row=bt.rows[rowIndex];var cells=row.childNodes;for(var colIndex=0;colIndex<colCount;colIndex++){var td=cells[colIndex];var val=renderers[colIndex](dataModel.getValueAt(rowIndex,dindexes[colIndex]),rowIndex,colIndex);if(typeof val=='undefined'||val==='')val='&#160;';td.firstChild.innerHTML=val;}}},handleSort:function(dataModel,sortColumnIndex,sortDir,noRefresh){this.grid.selModel.syncSelectionsToIds();if(!noRefresh){this.updateRows(dataModel,0,dataModel.getRowCount()-1);}
this.updateHeaderSortState();if(this.lastFocusedRow){this.focusRow(this.lastFocusedRow);}},syncScroll:function(){this.hwrap.dom.scrollLeft=this.wrap.scrollLeft;},handleScroll:function(){this.syncScroll();this.fireScroll(this.wrap.scrollLeft,this.wrap.scrollTop);this.grid.fireEvent('bodyscroll',this.wrap.scrollLeft,this.wrap.scrollTop);},getRowHeight:function(){if(!this.rowHeight){var rule=YAHOO.ext.util.CSS.getRule(["#"+this.grid.id+" .ygrid-row",".ygrid-row"]);if(rule&&rule.style.height){this.rowHeight=parseInt(rule.style.height,10);}else{this.rowHeight=21;}}
return this.rowHeight;},renderRows:function(dataModel){this.grid.stopEditing();if(this.grid.selModel){this.grid.selModel.clearSelections();}
var bt=this.getBodyTable();bt.innerHTML='';this.rowHeight=this.getRowHeight();this.insertRows(dataModel,0,dataModel.getRowCount()-1);},updateCell:function(dataModel,rowIndex,dataIndex){var colIndex=this.getColumnIndexByDataIndex(dataIndex);if(typeof colIndex=='undefined'){return;}
var bt=this.getBodyTable();var row=bt.childNodes[rowIndex];var cell=row.childNodes[colIndex];var renderer=this.grid.colModel.getRenderer(colIndex);var val=renderer(dataModel.getValueAt(rowIndex,dataIndex),rowIndex,colIndex);if(typeof val=='undefined'||val==='')val='&#160;';cell.firstChild.innerHTML=val;},calcColumnWidth:function(colIndex,maxRowsToMeasure){var maxWidth=0;var bt=this.getBodyTable();var rows=bt.childNodes;var stopIndex=Math.min(maxRowsToMeasure||rows.length,rows.length);if(this.grid.autoSizeHeaders){var h=this.headers[colIndex];var curWidth=h.style.width;h.style.width=this.grid.minColumnWidth+'px';maxWidth=Math.max(maxWidth,h.scrollWidth);h.style.width=curWidth;}
for(var i=0;i<stopIndex;i++){var cell=rows[i].childNodes[colIndex].firstChild;maxWidth=Math.max(maxWidth,cell.scrollWidth);}
return maxWidth+5;},autoSizeColumn:function(colIndex,forceMinSize){if(forceMinSize){this.setCSSWidth(colIndex,this.grid.minColumnWidth);}
var newWidth=this.calcColumnWidth(colIndex);this.grid.colModel.setColumnWidth(colIndex,Math.max(this.grid.minColumnWidth,newWidth));this.grid.fireEvent('columnresize',colIndex,newWidth);},autoSizeColumns:function(){var colModel=this.grid.colModel;var colCount=colModel.getColumnCount();var wrap=this.wrap;for(var i=0;i<colCount;i++){this.setCSSWidth(i,this.grid.minColumnWidth);colModel.setColumnWidth(i,this.calcColumnWidth(i,this.grid.maxRowsToMeasure),true);}
if(colModel.getTotalWidth()<wrap.clientWidth){var diff=Math.floor((wrap.clientWidth-colModel.getTotalWidth())/colCount);for(var i=0;i<colCount;i++){colModel.setColumnWidth(i,colModel.getColumnWidth(i)+diff,true);}}
this.updateColumns();},fitColumns:function(){var cm=this.grid.colModel;var colCount=cm.getColumnCount();var cols=[];var width=0;var i,w;for(i=0;i<colCount;i++){if(!cm.isHidden(i)&&!cm.isFixed(i)){w=cm.getColumnWidth(i);cols.push(i);cols.push(w);width+=w;}}
var frac=(this.wrap.clientWidth-cm.getTotalWidth())/width;while(cols.length){w=cols.pop();i=cols.pop();cm.setColumnWidth(i,Math.floor(w+w*frac),true);}
this.updateColumns();},onWindowResize:function(){if(this.grid.monitorWindowResize){this.adjustForScroll();this.updateWrapHeight();this.adjustForScroll();}},updateWrapHeight:function(){this.grid.container.beginMeasure();this.autoHeight();var box=this.grid.container.getSize(true);this.wrapEl.setHeight(box.height-this.footerHeight-parseInt(this.wrap.offsetTop,10));this.pwrap.setSize(box.width,box.height);this.grid.container.endMeasure();},forceScrollUpdate:function(){var wrap=this.wrapEl;wrap.setWidth(wrap.getWidth(true));setTimeout(function(){wrap.setWidth('');},1);},updateHeaderSortState:function(){var state=this.grid.dataModel.getSortState();if(!state||typeof state.column=='undefined')return;var sortColumn=this.getColumnIndexByDataIndex(state.column);var sortDir=state.direction;for(var i=0,len=this.headers.length;i<len;i++){var h=this.headers[i];if(i!=sortColumn){h.sortDesc.style.display='none';h.sortAsc.style.display='none';}else{h.sortDesc.style.display=sortDir=='DESC'?'block':'none';h.sortAsc.style.display=sortDir=='ASC'?'block':'none';}}},unplugDataModel:function(dm){dm.removeListener('cellupdated',this.updateCell,this);dm.removeListener('datachanged',this.renderRows,this);dm.removeListener('rowsdeleted',this.deleteRows,this);dm.removeListener('rowsinserted',this.insertRows,this);dm.removeListener('rowsupdated',this.updateRows,this);dm.removeListener('rowssorted',this.handleSort,this);},plugDataModel:function(dm){dm.on('cellupdated',this.updateCell,this,true);dm.on('datachanged',this.renderRows,this,true);dm.on('rowsdeleted',this.deleteRows,this,true);dm.on('rowsinserted',this.insertRows,this,true);dm.on('rowsupdated',this.updateRows,this,true);dm.on('rowssorted',this.handleSort,this,true);},render:function(){var grid=this.grid;var container=grid.container.dom;var dataModel=grid.dataModel;this.plugDataModel(dataModel);var colModel=grid.colModel;colModel.onWidthChange.subscribe(this.updateColumns,this,true);colModel.onHeaderChange.subscribe(this.updateHeaders,this,true);colModel.onHiddenChange.subscribe(this.handleHiddenChange,this,true);YAHOO.ext.EventManager.onWindowResize(this.onWindowResize,this,true);var autoSizeDelegate=this.autoSizeColumn.createDelegate(this);var colCount=colModel.getColumnCount();var dh=YAHOO.ext.DomHelper;this.pwrap=dh.append(container,{tag:'div',cls:'ygrid-positioner',style:'position:relative;width:100%;height:100%;left:0;top:0;overflow:hidden;'},true);var pos=this.pwrap.dom;var wrap=dh.append(pos,{tag:'div',cls:'ygrid-wrap'});this.wrap=wrap;this.wrapEl=getEl(wrap,true);YAHOO.ext.EventManager.on(wrap,'scroll',this.handleScroll,this,true);var hwrap=dh.append(pos,{tag:'div',cls:'ygrid-wrap-headers'});this.hwrap=getEl(hwrap,true);var bwrap=dh.append(wrap,{tag:'div',cls:'ygrid-wrap-body',id:container.id+'-body'});this.bwrap=getEl(bwrap,true);this.bwrap.setWidth(colModel.getTotalWidth());bwrap.rows=bwrap.childNodes;this.footerHeight=0;var foot=this.appendFooter(this.pwrap.dom);if(foot){this.footer=getEl(foot,true);this.footerHeight=this.footer.getHeight();}
this.updateWrapHeight();var hrow=dh.append(hwrap,{tag:'span',cls:'ygrid-hrow'});this.hrow=hrow;if(!YAHOO.ext.util.Browser.isGecko){var iframe=document.createElement('iframe');iframe.className='ygrid-hrow-frame';iframe.frameBorder=0;iframe.src=YAHOO.ext.SSL_SECURE_URL;hwrap.appendChild(iframe);}
this.headerCtrl=new YAHOO.ext.grid.HeaderController(this.grid);this.headers=[];this.cols=[];var htemplate=dh.createTemplate({tag:'span',cls:'ygrid-hd ygrid-header-{0}',children:[{tag:'span',cls:'ygrid-hd-body',html:'<table border="0" cellpadding="0" cellspacing="0">'+'<tbody><tr><td><span>{1}</span></td>'+'<td><span class="sort-desc"></span><span class="sort-asc"></span></td>'+'</tr></tbody></table>'}]});htemplate.compile();for(var i=0;i<colCount;i++){var hd=htemplate.append(hrow,[i,colModel.getColumnHeader(i)]);var spans=hd.getElementsByTagName('span');hd.textNode=spans[1];hd.sortDesc=spans[2];hd.sortAsc=spans[3];hd.columnIndex=i;this.headers.push(hd);if(colModel.isSortable(i)){this.headerCtrl.register(hd);}
var split=dh.append(hrow,{tag:'span',cls:'ygrid-hd-split'});hd.split=split;if(colModel.isResizable(i)&&!colModel.isFixed(i)){YAHOO.util.Event.on(split,'dblclick',autoSizeDelegate.createCallback(i+0,true));var sb=new YAHOO.ext.SplitBar(split,hd,null,YAHOO.ext.SplitBar.LEFT);sb.columnIndex=i;sb.minSize=grid.minColumnWidth;sb.onMoved.subscribe(this.onColumnSplitterMoved,this,true);YAHOO.util.Dom.addClass(sb.proxy,'ygrid-column-sizer');YAHOO.util.Dom.setStyle(sb.proxy,'background-color','');sb.dd._resizeProxy=function(){var el=this.getDragEl();YAHOO.util.Dom.setStyle(el,'height',(hwrap.clientHeight+wrap.clientHeight-2)+'px');};}else{split.style.cursor='default';}}
if(grid.autoSizeColumns){this.renderRows(dataModel);this.autoSizeColumns();}else{this.updateColumns();this.renderRows(dataModel);}
for(var i=0;i<colCount;i++){if(colModel.isHidden(i)){this.hideColumn(i);}}
this.updateHeaderSortState();return this.bwrap;},onColumnSplitterMoved:function(splitter,newSize){this.grid.colModel.setColumnWidth(splitter.columnIndex,newSize);this.grid.fireEvent('columnresize',splitter.columnIndex,newSize);},appendFooter:function(parentEl){return null;},autoHeight:function(){if(this.grid.autoHeight){var h=this.getBodyHeight();var c=this.grid.container;var total=h+(parseInt(this.wrap.offsetTop,10)||0)+
this.footerHeight+c.getBorderWidth('tb')+c.getPadding('tb')
+(this.wrap.offsetHeight-this.wrap.clientHeight);c.setHeight(total);}},getBodyHeight:function(){return this.grid.dataModel.getRowCount()*this.getRowHeight();;},updateBodyHeight:function(){this.getBodyTable().style.height=this.getBodyHeight()+'px';if(this.grid.autoHeight){this.autoHeight();this.updateWrapHeight();}}};YAHOO.ext.grid.GridView.SCROLLBARS_UNDER=0;YAHOO.ext.grid.GridView.SCROLLBARS_OVERLAP=1;YAHOO.ext.grid.GridView.prototype.scrollbarMode=YAHOO.ext.grid.GridView.SCROLLBARS_UNDER;YAHOO.ext.grid.GridView.prototype.fitColumnsToContainer=YAHOO.ext.grid.GridView.prototype.fitColumns;YAHOO.ext.grid.HeaderController=function(grid){this.grid=grid;this.headers=[];};YAHOO.ext.grid.HeaderController.prototype={register:function(header){this.headers.push(header);YAHOO.ext.EventManager.on(header,'selectstart',this.cancelTextSelection,this,true);YAHOO.ext.EventManager.on(header,'mousedown',this.cancelTextSelection,this,true);YAHOO.ext.EventManager.on(header,'mouseover',this.headerOver,this,true);YAHOO.ext.EventManager.on(header,'mouseout',this.headerOut,this,true);YAHOO.ext.EventManager.on(header,'click',this.headerClick,this,true);},headerClick:function(e){var grid=this.grid,cm=grid.colModel,dm=grid.dataModel;grid.stopEditing();var header=grid.getHeaderFromChild(e.getTarget());var state=dm.getSortState();var direction=header.sortDir||'ASC';if(typeof state.column!='undefined'&&grid.getView().getColumnIndexByDataIndex(state.column)==header.columnIndex){direction=(state.direction=='ASC'?'DESC':'ASC');}
header.sortDir=direction;dm.sort(cm,cm.getDataIndex(header.columnIndex),direction);},headerOver:function(e){var header=this.grid.getHeaderFromChild(e.getTarget());YAHOO.util.Dom.addClass(header,'ygrid-hd-over');},headerOut:function(e){var header=this.grid.getHeaderFromChild(e.getTarget());YAHOO.util.Dom.removeClass(header,'ygrid-hd-over');},cancelTextSelection:function(e){e.preventDefault();}};

YAHOO.ext.Toolbar=function(container){this.el=getEl(container,true);var div=document.createElement('div');div.className='ytoolbar';var tb=document.createElement('table');tb.border=0;tb.cellPadding=0;tb.cellSpacing=0;div.appendChild(tb);var tbody=document.createElement('tbody');tb.appendChild(tbody);var tr=document.createElement('tr');tbody.appendChild(tr);this.el.dom.appendChild(div);this.tr=tr;};YAHOO.ext.Toolbar.prototype={add:function(){for(var i=0;i<arguments.length;i++){var el=arguments[i];var td=document.createElement('td');this.tr.appendChild(td);if(el instanceof YAHOO.ext.ToolbarButton){el.init(td);}else if(el instanceof Array){this.addButton(el);}else if(typeof el=='string'){var span=document.createElement('span');if(el=='separator'){span.className='ytb-sep';}else{span.innerHTML=el;span.className='ytb-text';}
td.appendChild(span);}else if(typeof el=='object'){td.appendChild(el);}}},getEl:function(){return this.el;},addSeparator:function(){var td=document.createElement('td');this.tr.appendChild(td);var span=document.createElement('span');span.className='ytb-sep';td.appendChild(span);},addButton:function(config){if(config instanceof Array){var buttons=[];for(var i=0,len=config.length;i<len;i++){buttons.push(this.addButton(config[i]));}
return buttons;}
var b=config;if(!(config instanceof YAHOO.ext.ToolbarButton)){b=new YAHOO.ext.ToolbarButton(config);}
this.add(b);return b;},addText:function(text){var td=document.createElement('td');this.tr.appendChild(td);var span=document.createElement('span');span.className='ytb-text';span.innerHTML=text;td.appendChild(span);return span;},insertButton:function(index,config){if(config instanceof Array){var buttons=[];for(var i=0,len=config.length;i<len;i++){buttons.push(this.insertButton(index+i,config[i]));}
return buttons;}
var b=new YAHOO.ext.ToolbarButton(config);var td=document.createElement('td');var nextSibling=this.tr.childNodes[index];if(nextSibling)
this.tr.insertBefore(td,nextSibling);else
this.tr.appendChild(td);b.init(td);return b;}};YAHOO.ext.ToolbarButton=function(config){YAHOO.ext.util.Config.apply(this,config);};YAHOO.ext.ToolbarButton.prototype={init:function(appendTo){var element=document.createElement('span');element.className='ytb-button';if(this.id){element.id=this.id;}
this.disabled=(this.disabled===true);var inner=document.createElement('span');inner.className='ytb-button-inner '+this.className;inner.unselectable='on';if(this.tooltip){element.setAttribute('title',this.tooltip);}
if(this.style){YAHOO.ext.DomHelper.applyStyles(inner,this.style);}
element.appendChild(inner);appendTo.appendChild(element);this.el=getEl(element,true);this.el.unselectable();inner.innerHTML=(this.text?this.text:'&#160;');this.inner=inner;this.el.mon('click',this.onClick,this,true);this.el.mon('mouseover',this.onMouseOver,this,true);this.el.mon('mouseout',this.onMouseOut,this,true);},setHandler:function(click,scope){this.click=click;this.scope=scope;},setText:function(text){this.inner.innerHTML=text;},setTooltip:function(text){this.el.dom.title=text;},show:function(){this.el.dom.parentNode.style.display='';},hide:function(){this.el.dom.parentNode.style.display='none';},disable:function(){this.disabled=true;if(this.el){this.el.addClass('ytb-button-disabled');}},enable:function(){this.disabled=false;if(this.el){this.el.removeClass('ytb-button-disabled');}},isDisabled:function(){return this.disabled===true;},setDisabled:function(disabled){if(disabled){this.disable();}else{this.enable();}},onClick:function(){if(!this.disabled&&this.click){this.click.call(this.scope||window,this);}},onMouseOver:function(){if(!this.disabled){this.el.addClass('ytb-button-over');if(this.mouseover){this.mouseover.call(this.scope||window,this);}}},onMouseOut:function(){this.el.removeClass('ytb-button-over');if(!this.disabled){if(this.mouseout){this.mouseout.call(this.scope||window,this);}}}};

YAHOO.ext.grid.PagedGridView=function(){YAHOO.ext.grid.PagedGridView.superclass.constructor.call(this);this.cursor=1;};YAHOO.extendX(YAHOO.ext.grid.PagedGridView,YAHOO.ext.grid.GridView,{appendFooter:function(parentEl){var fwrap=document.createElement('div');fwrap.className='ygrid-wrap-footer';var fbody=document.createElement('span');fbody.className='ygrid-footer';fwrap.appendChild(fbody);parentEl.appendChild(fwrap);this.createPagingToolbar(fbody);return fwrap;},createPagingToolbar:function(container){var tb=new YAHOO.ext.Toolbar(container);this.pageToolbar=tb;this.first=tb.addButton({tooltip:this.firstText,className:'ygrid-page-first',disabled:true,click:this.onClick.createDelegate(this,['first'])});this.prev=tb.addButton({tooltip:this.prevText,className:'ygrid-page-prev',disabled:true,click:this.onClick.createDelegate(this,['prev'])});tb.addSeparator();tb.add(this.beforePageText);var pageBox=document.createElement('input');pageBox.type='text';pageBox.size=3;pageBox.value='1';pageBox.className='ygrid-page-number';tb.add(pageBox);this.field=getEl(pageBox,true);this.field.mon('keydown',this.onEnter,this,true);this.field.on('focus',function(){pageBox.select();});this.afterTextEl=tb.addText(this.afterPageText.replace('%0','1'));this.field.setHeight(18);tb.addSeparator();this.next=tb.addButton({tooltip:this.nextText,className:'ygrid-page-next',disabled:true,click:this.onClick.createDelegate(this,['next'])});this.last=tb.addButton({tooltip:this.lastText,className:'ygrid-page-last',disabled:true,click:this.onClick.createDelegate(this,['last'])});tb.addSeparator();this.loading=tb.addButton({tooltip:this.refreshText,className:'ygrid-loading',disabled:true,click:this.onClick.createDelegate(this,['refresh'])});this.onPageLoaded(1,this.grid.dataModel.getTotalPages());},getPageToolbar:function(){return this.pageToolbar;},onPageLoaded:function(pageNum,totalPages){this.cursor=pageNum;this.lastPage=totalPages;this.afterTextEl.innerHTML=this.afterPageText.replace('%0',totalPages);this.field.dom.value=pageNum;this.first.setDisabled(pageNum==1);this.prev.setDisabled(pageNum==1);this.next.setDisabled(pageNum==totalPages);this.last.setDisabled(pageNum==totalPages);this.loading.enable();},onLoadError:function(){this.loading.enable();},onEnter:function(e){if(e.browserEvent.keyCode==e.RETURN){var v=this.field.dom.value;if(!v){this.field.dom.value=this.cursor;return;}
var pageNum=parseInt(v,10);if(isNaN(pageNum)){this.field.dom.value=this.cursor;return;}
pageNum=Math.min(Math.max(1,pageNum),this.lastPage);this.grid.dataModel.loadPage(pageNum);e.stopEvent();}},beforeLoad:function(){this.grid.stopEditing();if(this.loading){this.loading.disable();}},onClick:function(which){switch(which){case'first':this.grid.dataModel.loadPage(1);break;case'prev':this.grid.dataModel.loadPage(this.cursor-1);break;case'next':this.grid.dataModel.loadPage(this.cursor+1);break;case'last':this.grid.dataModel.loadPage(this.lastPage);break;case'refresh':this.grid.dataModel.loadPage(this.cursor);break;}},unplugDataModel:function(dm){dm.removeListener('beforeload',this.beforeLoad,this);dm.removeListener('load',this.onPageLoaded,this);dm.removeListener('loadexception',this.onLoadError,this);YAHOO.ext.grid.PagedGridView.superclass.unplugDataModel.call(this,dm);},plugDataModel:function(dm){dm.on('beforeload',this.beforeLoad,this,true);dm.on('load',this.onPageLoaded,this,true);dm.on('loadexception',this.onLoadError,this);YAHOO.ext.grid.PagedGridView.superclass.plugDataModel.call(this,dm);},beforePageText:"Page",afterPageText:"of %0",firstText:"First Page",prevText:"Previous Page",nextText:"Next Page",lastText:"Last Page",refreshText:"Refresh"});

YAHOO.ext.grid.EditorGrid=function(container,dataModel,colModel){YAHOO.ext.grid.EditorGrid.superclass.constructor.call(this,container,dataModel,colModel,new YAHOO.ext.grid.EditorSelectionModel());this.container.addClass('yeditgrid');};YAHOO.extendX(YAHOO.ext.grid.EditorGrid,YAHOO.ext.grid.Grid);

YAHOO.ext.grid.AbstractColumnModel=function(){this.onWidthChange=new YAHOO.util.CustomEvent('widthChanged');this.onHeaderChange=new YAHOO.util.CustomEvent('headerChanged');this.onHiddenChange=new YAHOO.util.CustomEvent('hiddenChanged');this.events={'widthchange':this.onWidthChange,'headerchange':this.onHeaderChange,'hiddenchange':this.onHiddenChange};};YAHOO.ext.grid.AbstractColumnModel.prototype={fireEvent:YAHOO.ext.util.Observable.prototype.fireEvent,on:YAHOO.ext.util.Observable.prototype.on,addListener:YAHOO.ext.util.Observable.prototype.addListener,delayedListener:YAHOO.ext.util.Observable.prototype.delayedListener,removeListener:YAHOO.ext.util.Observable.prototype.removeListener,purgeListeners:YAHOO.ext.util.Observable.prototype.purgeListeners,fireWidthChange:function(colIndex,newWidth){this.onWidthChange.fireDirect(this,colIndex,newWidth);},fireHeaderChange:function(colIndex,newHeader){this.onHeaderChange.fireDirect(this,colIndex,newHeader);},fireHiddenChange:function(colIndex,hidden){this.onHiddenChange.fireDirect(this,colIndex,hidden);},getColumnCount:function(){return 0;},isSortable:function(col){return false;},isHidden:function(col){return false;},getSortType:function(col){return YAHOO.ext.grid.DefaultColumnModel.sortTypes.none;},getRenderer:function(col){return YAHOO.ext.grid.DefaultColumnModel.defaultRenderer;},getColumnWidth:function(col){return 0;},getTotalWidth:function(){return 0;},getColumnHeader:function(col){return'';}};

YAHOO.ext.grid.DefaultColumnModel=function(config){YAHOO.ext.grid.DefaultColumnModel.superclass.constructor.call(this);this.config=config;this.defaultWidth=100;this.defaultSortable=false;};YAHOO.extendX(YAHOO.ext.grid.DefaultColumnModel,YAHOO.ext.grid.AbstractColumnModel,{getColumnCount:function(){return this.config.length;},isSortable:function(col){if(typeof this.config[col].sortable=='undefined'){return this.defaultSortable;}
return this.config[col].sortable;},getSortType:function(col){if(!this.dataMap){var map=[];for(var i=0,len=this.config.length;i<len;i++){map[this.getDataIndex(i)]=i;}
this.dataMap=map;}
col=this.dataMap[col];if(!this.config[col].sortType){return YAHOO.ext.grid.DefaultColumnModel.sortTypes.none;}
return this.config[col].sortType;},setSortType:function(col,fn){this.config[col].sortType=fn;},getRenderer:function(col){if(!this.config[col].renderer){return YAHOO.ext.grid.DefaultColumnModel.defaultRenderer;}
return this.config[col].renderer;},setRenderer:function(col,fn){this.config[col].renderer=fn;},getColumnWidth:function(col){return this.config[col].width||this.defaultWidth;},setColumnWidth:function(col,width,suppressEvent){this.config[col].width=width;this.totalWidth=null;if(!suppressEvent){this.onWidthChange.fireDirect(this,col,width);}},getTotalWidth:function(includeHidden){if(!this.totalWidth){this.totalWidth=0;for(var i=0;i<this.config.length;i++){if(includeHidden||!this.isHidden(i)){this.totalWidth+=this.getColumnWidth(i);}}}
return this.totalWidth;},getColumnHeader:function(col){return this.config[col].header;},setColumnHeader:function(col,header){this.config[col].header=header;this.onHeaderChange.fireDirect(this,col,header);},getDataIndex:function(col){if(typeof this.config[col].dataIndex!='number'){return col;}
return this.config[col].dataIndex;},setDataIndex:function(col,dataIndex){this.config[col].dataIndex=dataIndex;},isCellEditable:function(colIndex,rowIndex){return this.config[colIndex].editable||(typeof this.config[colIndex].editable=='undefined'&&this.config[colIndex].editor);},getCellEditor:function(colIndex,rowIndex){return this.config[colIndex].editor;},setEditable:function(col,editable){this.config[col].editable=editable;},isHidden:function(colIndex){return this.config[colIndex].hidden;},isFixed:function(colIndex){return this.config[colIndex].fixed;},isResizable:function(colIndex){return this.config[colIndex].resizable!==false;},setHidden:function(colIndex,hidden){this.config[colIndex].hidden=hidden;this.totalWidth=null;this.fireHiddenChange(colIndex,hidden);},setEditor:function(col,editor){this.config[col].editor=editor;}});YAHOO.ext.grid.DefaultColumnModel.sortTypes={none:function(s){return s;},asUCString:function(s){return String(s).toUpperCase();},asDate:function(s){if(s instanceof Date){return s.getTime();}
return Date.parse(String(s));},asFloat:function(s){var val=parseFloat(String(s).replace(/,/g,''));if(isNaN(val))val=0;return val;},asInt:function(s){var val=parseInt(String(s).replace(/,/g,''));if(isNaN(val))val=0;return val;}};YAHOO.ext.grid.DefaultColumnModel.defaultRenderer=function(value){if(typeof value=='string'&&value.length<1){return'&#160;';}
return value;}

YAHOO.ext.grid.AbstractDataModel=function(){this.onCellUpdated=new YAHOO.util.CustomEvent('onCellUpdated');this.onTableDataChanged=new YAHOO.util.CustomEvent('onTableDataChanged');this.onRowsDeleted=new YAHOO.util.CustomEvent('onRowsDeleted');this.onRowsInserted=new YAHOO.util.CustomEvent('onRowsInserted');this.onRowsUpdated=new YAHOO.util.CustomEvent('onRowsUpdated');this.onRowsSorted=new YAHOO.util.CustomEvent('onRowsSorted');this.events={'cellupdated':this.onCellUpdated,'datachanged':this.onTableDataChanged,'rowsdeleted':this.onRowsDeleted,'rowsinserted':this.onRowsInserted,'rowsupdated':this.onRowsUpdated,'rowssorted':this.onRowsSorted};};YAHOO.ext.grid.AbstractDataModel.prototype={fireEvent:YAHOO.ext.util.Observable.prototype.fireEvent,on:YAHOO.ext.util.Observable.prototype.on,addListener:YAHOO.ext.util.Observable.prototype.addListener,delayedListener:YAHOO.ext.util.Observable.prototype.delayedListener,removeListener:YAHOO.ext.util.Observable.prototype.removeListener,purgeListeners:YAHOO.ext.util.Observable.prototype.purgeListeners,fireCellUpdated:function(row,col){this.onCellUpdated.fireDirect(this,row,col);},fireTableDataChanged:function(){this.onTableDataChanged.fireDirect(this);},fireRowsDeleted:function(firstRow,lastRow){this.onRowsDeleted.fireDirect(this,firstRow,lastRow);},fireRowsInserted:function(firstRow,lastRow){this.onRowsInserted.fireDirect(this,firstRow,lastRow);},fireRowsUpdated:function(firstRow,lastRow){this.onRowsUpdated.fireDirect(this,firstRow,lastRow);},fireRowsSorted:function(sortColumnIndex,sortDir,noRefresh){this.onRowsSorted.fireDirect(this,sortColumnIndex,sortDir,noRefresh);},sort:function(sortInfo,columnIndex,direction,suppressEvent){},getSortState:function(){return{column:this.sortColumn,direction:this.sortDir};},getRowCount:function(){},getTotalRowCount:function(){return this.getRowCount();},getRowId:function(rowIndex){},getValueAt:function(rowIndex,colIndex){},setValueAt:function(value,rowIndex,colIndex){},isPaged:function(){return false;}};

YAHOO.ext.grid.DefaultDataModel=function(data){YAHOO.ext.grid.DefaultDataModel.superclass.constructor.call(this);this.data=data;};YAHOO.extendX(YAHOO.ext.grid.DefaultDataModel,YAHOO.ext.grid.AbstractDataModel,{getRowCount:function(){return this.data.length;},getRowId:function(rowIndex){return this.data[rowIndex][0];},getRow:function(rowIndex){return this.data[rowIndex];},getRows:function(indexes){var data=this.data;var r=[];for(var i=0;i<indexes.length;i++){r.push(data[indexes[i]]);}
return r;},getValueAt:function(rowIndex,colIndex){return this.data[rowIndex][colIndex];},setValueAt:function(value,rowIndex,colIndex){this.data[rowIndex][colIndex]=value;this.fireCellUpdated(rowIndex,colIndex);},removeRows:function(startIndex,endIndex){endIndex=endIndex||startIndex;this.data.splice(startIndex,endIndex-startIndex+1);this.fireRowsDeleted(startIndex,endIndex);},removeRow:function(index){this.data.splice(index,1);this.fireRowsDeleted(index,index);},removeAll:function(){var count=this.getRowCount();if(count>0){this.removeRows(0,count-1);}},query:function(spec,returnUnmatched){var d=this.data;var r=[];for(var i=0;i<d.length;i++){var row=d[i];var isMatch=true;for(var col in spec){if(!isMatch)continue;var filter=spec[col];switch(typeof filter){case'string':case'number':case'boolean':if(row[col]!=filter){isMatch=false;}
break;case'function':if(!filter(row[col],row)){isMatch=false;}
break;case'object':if(filter instanceof RegExp){if(String(row[col]).search(filter)===-1){isMatch=false;}}
break;}}
if(isMatch&&!returnUnmatched){r.push(i);}else if(!isMatch&&returnUnmatched){r.push(i);}}
return r;},filter:function(query){var matches=this.query(query,true);var data=this.data;for(var i=0;i<matches.length;i++){data[matches[i]]._deleted=true;}
for(var i=0;i<data.length;i++){while(data[i]&&data[i]._deleted===true){this.removeRow(i);}}
return matches.length;},addRow:function(cellValues){this.data.push(cellValues);var newIndex=this.data.length-1;this.fireRowsInserted(newIndex,newIndex);this.applySort();return newIndex;},addRows:function(rowData){this.data=this.data.concat(rowData);var firstIndex=this.data.length-rowData.length;this.fireRowsInserted(firstIndex,firstIndex+rowData.length-1);this.applySort();},insertRow:function(index,cellValues){this.data.splice(index,0,cellValues);this.fireRowsInserted(index,index);this.applySort();return index;},insertRows:function(index,rowData){var args=rowData.concat();args.splice(0,0,index,0);this.data.splice.apply(this.data,args);this.fireRowsInserted(index,index+rowData.length-1);this.applySort();},applySort:function(suppressEvent){if(typeof this.sortColumn!='undefined'){this.sort(this.sortInfo,this.sortColumn,this.sortDir,suppressEvent);}},setDefaultSort:function(sortInfo,columnIndex,direction){this.sortInfo=sortInfo;this.sortColumn=columnIndex;this.sortDir=direction;},sort:function(sortInfo,columnIndex,direction,suppressEvent){this.sortInfo=sortInfo;this.sortColumn=columnIndex;this.sortDir=direction;var dsc=(direction&&direction.toUpperCase()=='DESC');var sortType=null;if(sortInfo!=null){if(typeof sortInfo=='function'){sortType=sortInfo;}else if(typeof sortInfo=='object'){sortType=sortInfo.getSortType(columnIndex);;}}
var fn=function(cells,cells2){var v1=sortType?sortType(cells[columnIndex],cells):cells[columnIndex];var v2=sortType?sortType(cells2[columnIndex],cells2):cells2[columnIndex];if(v1<v2)
return dsc?+1:-1;if(v1>v2)
return dsc?-1:+1;return 0;};this.data.sort(fn);if(!suppressEvent){this.fireRowsSorted(columnIndex,direction);}},each:function(fn,scope){var d=this.data;for(var i=0,len=d.length;i<len;i++){if(fn.call(scope||window,d[i],i)===false)break;}}});YAHOO.ext.grid.DefaultDataModel.sortTypes=YAHOO.ext.grid.DefaultColumnModel.sortTypes;

YAHOO.ext.grid.LoadableDataModel=function(dataType){YAHOO.ext.grid.LoadableDataModel.superclass.constructor.call(this,[]);this.onLoad=new YAHOO.util.CustomEvent('load');this.onLoadException=new YAHOO.util.CustomEvent('loadException');this.events['load']=this.onLoad;this.events['beforeload']=new YAHOO.util.CustomEvent('beforeload');this.events['loadexception']=this.onLoadException;this.dataType=dataType;this.preprocessors=[];this.postprocessors=[];this.loadedPage=1;this.remoteSort=false;this.pageSize=0;this.pageUrl=null;this.baseParams={};this.paramMap={'page':'page','pageSize':'pageSize','sortColumn':'sortColumn','sortDir':'sortDir'};};YAHOO.extendX(YAHOO.ext.grid.LoadableDataModel,YAHOO.ext.grid.DefaultDataModel,{setLoadedPage:function(pageNum,userCallback){this.loadedPage=pageNum;if(typeof userCallback=='function'){userCallback();}},isPaged:function(){return this.pageSize>0;},getTotalRowCount:function(){return this.totalCount||this.getRowCount();},getPageSize:function(){return this.pageSize;},getTotalPages:function(){if(this.getPageSize()==0||this.getTotalRowCount()==0){return 1;}
return Math.ceil(this.getTotalRowCount()/this.getPageSize());},initPaging:function(url,pageSize,baseParams){this.pageUrl=url;this.pageSize=pageSize;this.remoteSort=true;if(baseParams)this.baseParams=baseParams;},createParams:function(pageNum,sortColumn,sortDir){var params={},map=this.paramMap;for(var key in this.baseParams){if(typeof this.baseParams[key]!='function'){params[key]=this.baseParams[key];}}
params[map['page']]=pageNum;params[map['pageSize']]=this.getPageSize();params[map['sortColumn']]=(typeof sortColumn=='undefined'?'':sortColumn);params[map['sortDir']]=sortDir||'';return params;},loadPage:function(pageNum,callback,keepExisting){var sort=this.getSortState();var params=this.createParams(pageNum,sort.column,sort.direction);this.load(this.pageUrl,params,this.setLoadedPage.createDelegate(this,[pageNum,callback]),keepExisting?(pageNum-1)*this.pageSize:null);},applySort:function(suppressEvent){if(!this.remoteSort){YAHOO.ext.grid.LoadableDataModel.superclass.applySort.apply(this,arguments);}else if(!suppressEvent){var sort=this.getSortState();if(sort.column){this.fireRowsSorted(sort.column,sort.direction,true);}}},resetPaging:function(){this.loadedPage=1;},sort:function(sortInfo,columnIndex,direction,suppressEvent){if(!this.remoteSort){YAHOO.ext.grid.LoadableDataModel.superclass.sort.apply(this,arguments);}else{this.sortInfo=sortInfo;this.sortColumn=columnIndex;this.sortDir=direction;var params=this.createParams(this.loadedPage,columnIndex,direction);this.load(this.pageUrl,params,this.fireRowsSorted.createDelegate(this,[columnIndex,direction,true]));}},load:function(url,params,callback,insertIndex){this.fireEvent('beforeload',this);if(params&&typeof params!='string'){var buf=[];for(var key in params){if(typeof params[key]!='function'){buf.push(encodeURIComponent(key),'=',encodeURIComponent(params[key]),'&');}}
delete buf[buf.length-1];params=buf.join('');}
var cb={success:this.processResponse,failure:this.processException,scope:this,argument:{callback:callback,insertIndex:insertIndex}};var method=params?'POST':'GET';YAHOO.util.Connect.asyncRequest(method,url,cb,params);},processResponse:function(response){var cb=response.argument.callback;var keepExisting=(typeof response.argument.insertIndex=='number');var insertIndex=response.argument.insertIndex;switch(this.dataType){case YAHOO.ext.grid.LoadableDataModel.XML:this.loadData(response.responseXML,cb,keepExisting,insertIndex);break;case YAHOO.ext.grid.LoadableDataModel.JSON:var rtext=response.responseText;try{while(rtext.substring(0,1)==" "){rtext=rtext.substring(1,rtext.length);}
if(rtext.indexOf("{")<0){throw"Invalid JSON response";}
if(rtext.indexOf("{}")===0){this.loadData({},response.argument.callback);return;}
var jsonObjRaw=eval("("+rtext+")");if(!jsonObjRaw){throw"Error evaling JSON response";}
this.loadData(jsonObjRaw,cb,keepExisting,insertIndex);}catch(e){this.fireLoadException(e,response);if(typeof callback=='function'){callback(this,false);}}
break;case YAHOO.ext.grid.LoadableDataModel.TEXT:this.loadData(response.responseText,cb,keepExisting,insertIndex);break;};},processException:function(response){this.fireLoadException(null,response);if(typeof response.argument.callback=='function'){response.argument.callback(this,false);}},fireLoadException:function(e,responseObj){this.onLoadException.fireDirect(this,e,responseObj);},fireLoadEvent:function(){this.fireEvent('load',this.loadedPage,this.getTotalPages());},addPreprocessor:function(columnIndex,fn){this.preprocessors[columnIndex]=fn;},getPreprocessor:function(columnIndex){return this.preprocessors[columnIndex];},removePreprocessor:function(columnIndex){this.preprocessors[columnIndex]=null;},addPostprocessor:function(columnIndex,fn){this.postprocessors[columnIndex]=fn;},getPostprocessor:function(columnIndex){return this.postprocessors[columnIndex];},removePostprocessor:function(columnIndex){this.postprocessors[columnIndex]=null;},loadData:function(data,callback,keepExisting,insertIndex){}});YAHOO.ext.grid.LoadableDataModel.XML='xml';YAHOO.ext.grid.LoadableDataModel.JSON='json';YAHOO.ext.grid.LoadableDataModel.TEXT='text';

YAHOO.ext.grid.XMLDataModel=function(schema,xml){YAHOO.ext.grid.XMLDataModel.superclass.constructor.call(this,YAHOO.ext.grid.LoadableDataModel.XML);this.schema=schema;this.xml=xml;if(xml){this.loadData(xml);}
this.idSeed=0;};YAHOO.extendX(YAHOO.ext.grid.XMLDataModel,YAHOO.ext.grid.LoadableDataModel,{getDocument:function(){return this.xml;},loadData:function(doc,callback,keepExisting,insertIndex){this.xml=doc;var idField=this.schema.id;var fields=this.schema.fields;if(this.schema.totalTag){this.totalCount=null;var totalNode=doc.getElementsByTagName(this.schema.totalTag);if(totalNode&&totalNode.item(0)&&totalNode.item(0).firstChild){var v=parseInt(totalNode.item(0).firstChild.nodeValue,10);if(!isNaN(v)){this.totalCount=v;}}}
var rowData=[];var nodes=doc.getElementsByTagName(this.schema.tagName);if(nodes&&nodes.length>0){for(var i=0;i<nodes.length;i++){var node=nodes.item(i);var colData=[];colData.node=node;colData.id=this.getNamedValue(node,idField,String(++this.idSeed));for(var j=0;j<fields.length;j++){var val=this.getNamedValue(node,fields[j],"");if(this.preprocessors[j]){val=this.preprocessors[j](val);}
colData.push(val);}
rowData.push(colData);}}
if(keepExisting!==true){YAHOO.ext.grid.XMLDataModel.superclass.removeAll.call(this);}
if(typeof insertIndex!='number'){insertIndex=this.getRowCount();}
YAHOO.ext.grid.XMLDataModel.superclass.insertRows.call(this,insertIndex,rowData);if(typeof callback=='function'){callback(this,true);}
this.fireLoadEvent();},addRow:function(id,cellValues){var node=this.createNode(this.xml,id,cellValues);cellValues.id=id||++this.idSeed;cellValues.node=node;return YAHOO.ext.grid.XMLDataModel.superclass.addRow.call(this,cellValues);},insertRow:function(index,id,cellValues){var node=this.createNode(this.xml,id,cellValues);cellValues.id=id||++this.idSeed;cellValues.node=node;return YAHOO.ext.grid.XMLDataModel.superclass.insertRow.call(this,index,cellValues);},removeRow:function(index){var node=this.data[index].node;node.parentNode.removeChild(node);YAHOO.ext.grid.XMLDataModel.superclass.removeRow.call(this,index,index);},getNode:function(rowIndex){return this.data[rowIndex].node;},createNode:function(xmlDoc,id,colData){var template=this.data[0].node;var newNode=template.cloneNode(true);var fields=this.schema.fields;for(var i=0,len=fields.length;i<len;i++){var nodeValue=colData[i];if(this.postprocessors[i]){nodeValue=this.postprocessors[i](nodeValue);}
this.setNamedValue(newNode,fields[i],nodeValue);}
if(id){this.setNamedValue(newNode,this.schema.idField,id);}
template.parentNode.appendChild(newNode);return newNode;},getNamedValue:function(node,name,defaultValue){if(!node||!name){return defaultValue;}
var nodeValue=defaultValue;var attrNode=node.attributes.getNamedItem(name);if(attrNode){nodeValue=attrNode.value;}else{var childNode=node.getElementsByTagName(name);if(childNode&&childNode.item(0)&&childNode.item(0).firstChild){nodeValue=childNode.item(0).firstChild.nodeValue;}else{var index=name.indexOf(':');if(index>0){return this.getNamedValue(node,name.substr(index+1),defaultValue);}}}
return nodeValue;},setNamedValue:function(node,name,value){if(!node||!name){return;}
var attrNode=node.attributes.getNamedItem(name);if(attrNode){attrNode.value=value;return;}
var childNode=node.getElementsByTagName(name);if(childNode&&childNode.item(0)&&childNode.item(0).firstChild){childNode.item(0).firstChild.nodeValue=value;}else{var index=name.indexOf(':');if(index>0){this.setNamedValue(node,name.substr(index+1),value);}}},setValueAt:function(value,rowIndex,colIndex){var node=this.data[rowIndex].node;if(node){var nodeValue=value;if(this.postprocessors[colIndex]){nodeValue=this.postprocessors[colIndex](value);}
this.setNamedValue(node,this.schema.fields[colIndex],nodeValue);}
YAHOO.ext.grid.XMLDataModel.superclass.setValueAt.call(this,value,rowIndex,colIndex);},getRowId:function(rowIndex){return this.data[rowIndex].id;},addRows:function(rowData){for(var j=0,len=rowData.length;j<len;j++){var cellValues=rowData[j];var id=++this.idSeed;var node=this.createNode(this.xml,id,cellValues);cellValues.node=node;cellValues.id=cellValues.id||id;YAHOO.ext.grid.XMLDataModel.superclass.addRow.call(this,cellValues);}},insertRows:function(index,rowData){rowData=rowData.slice(0).reverse();for(var j=0,len=rowData.length;j<len;j++){var cellValues=rowData[j];var id=++this.idSeed;var node=this.createNode(this.xml,id,cellValues);cellValues.id=cellValues.id||id;cellValues.node=node;YAHOO.ext.grid.XMLDataModel.superclass.insertRow.call(this,index,cellValues);}}});

YAHOO.ext.grid.JSONDataModel=function(schema){YAHOO.ext.grid.JSONDataModel.superclass.constructor.call(this,YAHOO.ext.grid.LoadableDataModel.JSON);this.schema=schema;};YAHOO.extendX(YAHOO.ext.grid.JSONDataModel,YAHOO.ext.grid.LoadableDataModel,{loadData:function(data,callback,keepExisting){var idField=this.schema.id;var fields=this.schema.fields;if(this.schema.totalProperty){var v=parseInt(eval('data.'+this.schema.totalProperty),10);if(!isNaN(v)){this.totalCount=v;}}
var rowData=[];try{var root=eval('data.'+this.schema.root);for(var i=0;i<root.length;i++){var node=root[i];var colData=[];colData.node=node;colData.id=(typeof node[idField]!='undefined'&&node[idField]!==''?node[idField]:String(i));for(var j=0;j<fields.length;j++){var val=node[fields[j]];if(typeof val=='undefined'){val='';}
if(this.preprocessors[j]){val=this.preprocessors[j](val);}
colData.push(val);}
rowData.push(colData);}
if(keepExisting!==true){this.removeAll();}
this.addRows(rowData);if(typeof callback=='function'){callback(this,true);}
this.fireLoadEvent();}catch(e){this.fireLoadException(e,null);if(typeof callback=='function'){callback(this,false);}}},getRowId:function(rowIndex){return this.data[rowIndex].id;}});

YAHOO.ext.grid.DefaultSelectionModel=function(){this.selectedRows=[];this.selectedRowIds=[];this.lastSelectedRow=null;this.onRowSelect=new YAHOO.util.CustomEvent('SelectionTable.rowSelected');this.onSelectionChange=new YAHOO.util.CustomEvent('SelectionTable.selectionChanged');this.events={'selectionchange':this.onSelectionChange,'rowselect':this.onRowSelect};this.locked=false;};YAHOO.ext.grid.DefaultSelectionModel.prototype={init:function(grid){this.grid=grid;this.initEvents();},lock:function(){this.locked=true;},unlock:function(){this.locked=false;},isLocked:function(){return this.locked;},initEvents:function(){if(this.grid.trackMouseOver){this.grid.addListener("mouseover",this.handleOver,this,true);this.grid.addListener("mouseout",this.handleOut,this,true);}
this.grid.addListener("rowclick",this.rowClick,this,true);this.grid.addListener("keydown",this.keyDown,this,true);},fireEvent:YAHOO.ext.util.Observable.prototype.fireEvent,on:YAHOO.ext.util.Observable.prototype.on,addListener:YAHOO.ext.util.Observable.prototype.addListener,delayedListener:YAHOO.ext.util.Observable.prototype.delayedListener,removeListener:YAHOO.ext.util.Observable.prototype.removeListener,purgeListeners:YAHOO.ext.util.Observable.prototype.purgeListeners,syncSelectionsToIds:function(){if(this.getCount()>0){var ids=this.selectedRowIds.concat();this.clearSelections();this.selectRowsById(ids,true);}},selectRowsById:function(id,keepExisting){var rows=this.grid.getRowsById(id);if(!(rows instanceof Array)){this.selectRow(rows,keepExisting);return;}
this.selectRows(rows,keepExisting);},getCount:function(){return this.selectedRows.length;},selectFirstRow:function(){for(var j=0;j<this.grid.rows.length;j++){if(this.isSelectable(this.grid.rows[j])){this.focusRow(this.grid.rows[j]);this.setRowState(this.grid.rows[j],true);return;}}},selectNext:function(keepExisting){if(this.lastSelectedRow){for(var j=(this.lastSelectedRow.rowIndex+1);j<this.grid.rows.length;j++){var row=this.grid.rows[j];if(this.isSelectable(row)){this.focusRow(row);this.setRowState(row,true,keepExisting);return;}}}},selectPrevious:function(keepExisting){if(this.lastSelectedRow){for(var j=(this.lastSelectedRow.rowIndex-1);j>=0;j--){var row=this.grid.rows[j];if(this.isSelectable(row)){this.focusRow(row);this.setRowState(row,true,keepExisting);return;}}}},getSelectedRows:function(){return this.selectedRows;},getSelectedRowIds:function(){return this.selectedRowIds;},clearSelections:function(){if(this.isLocked())return;var oldSelections=this.selectedRows.concat();for(var j=0;j<oldSelections.length;j++){this.setRowState(oldSelections[j],false);}
this.selectedRows=[];this.selectedRowIds=[];},selectAll:function(){if(this.isLocked())return;this.selectedRows=[];this.selectedRowIds=[];for(var j=0,len=this.grid.rows.length;j<len;j++){this.setRowState(this.grid.rows[j],true,true);}},hasSelection:function(){return this.selectedRows.length>0;},isSelected:function(row){return row&&(row.selected===true||row.getAttribute('selected')=='true');},isSelectable:function(row){return row&&row.getAttribute('selectable')!='false';},rowClick:function(grid,rowIndex,e){if(this.isLocked())return;var row=grid.getRow(rowIndex);if(this.isSelectable(row)){if(e.shiftKey&&this.lastSelectedRow){var lastIndex=this.lastSelectedRow.rowIndex;this.selectRange(this.lastSelectedRow,row,e.ctrlKey);this.lastSelectedRow=this.grid.el.dom.rows[lastIndex];}else{this.focusRow(row);var rowState=e.ctrlKey?!this.isSelected(row):true;this.setRowState(row,rowState,e.hasModifier());}}},focusRow:function(row){this.grid.view.focusRow(row);},selectRow:function(row,keepExisting){this.setRowState(this.getRow(row),true,keepExisting);},selectRows:function(rows,keepExisting){if(!keepExisting){this.clearSelections();}
for(var i=0;i<rows.length;i++){this.selectRow(rows[i],true);}},deselectRow:function(row){this.setRowState(this.getRow(row),false);},getRow:function(row){if(typeof row=='number'){row=this.grid.rows[row];}
return row;},selectRange:function(startRow,endRow,keepExisting){startRow=this.getRow(startRow);endRow=this.getRow(endRow);this.setRangeState(startRow,endRow,true,keepExisting);},deselectRange:function(startRow,endRow){startRow=this.getRow(startRow);endRow=this.getRow(endRow);this.setRangeState(startRow,endRow,false,true);},setRowStateFromChild:function(childEl,selected,keepExisting){var row=this.grid.getRowFromChild(childEl);this.setRowState(row,selected,keepExisting);},setRangeState:function(startRow,endRow,selected,keepExisting){if(this.isLocked())return;if(!keepExisting){this.clearSelections();}
var curRow=startRow;while(curRow.rowIndex!=endRow.rowIndex){this.setRowState(curRow,selected,true);curRow=(startRow.rowIndex<endRow.rowIndex?this.grid.getRowAfter(curRow):this.grid.getRowBefore(curRow))}
this.setRowState(endRow,selected,true);},setRowState:function(row,selected,keepExisting){if(this.isLocked())return;if(this.isSelectable(row)){if(selected){if(!keepExisting){this.clearSelections();}
this.setRowClass(row,'selected');row.selected=true;this.selectedRows.push(row);this.selectedRowIds.push(this.grid.dataModel.getRowId(row.rowIndex));this.lastSelectedRow=row;}else{this.setRowClass(row,'');row.selected=false;this._removeSelected(row);}
this.fireEvent('rowselect',this,row,selected);this.fireEvent('selectionchange',this,this.selectedRows,this.selectedRowIds);}},handleOver:function(e){var row=this.grid.getRowFromChild(e.getTarget());if(this.isSelectable(row)&&!this.isSelected(row)){this.setRowClass(row,'over');}},handleOut:function(e){var row=this.grid.getRowFromChild(e.getTarget());if(this.isSelectable(row)&&!this.isSelected(row)){this.setRowClass(row,'');}},keyDown:function(e){if(e.browserEvent.keyCode==e.DOWN){this.selectNext(e.shiftKey);e.preventDefault();}else if(e.browserEvent.keyCode==e.UP){this.selectPrevious(e.shiftKey);e.preventDefault();}},setRowClass:function(row,cssClass){if(this.isSelectable(row)){if(cssClass=='selected'){YAHOO.util.Dom.removeClass(row,'ygrid-row-over');YAHOO.util.Dom.addClass(row,'ygrid-row-selected');}else if(cssClass=='over'){YAHOO.util.Dom.removeClass(row,'ygrid-row-selected');YAHOO.util.Dom.addClass(row,'ygrid-row-over');}else if(cssClass==''){YAHOO.util.Dom.removeClass(row,'ygrid-row-selected');YAHOO.util.Dom.removeClass(row,'ygrid-row-over');}}},_removeSelected:function(row){var sr=this.selectedRows;for(var i=0;i<sr.length;i++){if(sr[i]===row){this.selectedRows.splice(i,1);this.selectedRowIds.splice(i,1);return;}}}};YAHOO.ext.grid.SingleSelectionModel=function(){YAHOO.ext.grid.SingleSelectionModel.superclass.constructor.call(this);};YAHOO.extendX(YAHOO.ext.grid.SingleSelectionModel,YAHOO.ext.grid.DefaultSelectionModel);YAHOO.ext.grid.SingleSelectionModel.prototype.setRowState=function(row,selected){YAHOO.ext.grid.SingleSelectionModel.superclass.setRowState.call(this,row,selected,false);};YAHOO.ext.grid.DisableSelectionModel=function(){YAHOO.ext.grid.DisableSelectionModel.superclass.constructor.call(this);};YAHOO.extendX(YAHOO.ext.grid.DisableSelectionModel,YAHOO.ext.grid.DefaultSelectionModel);YAHOO.ext.grid.DisableSelectionModel.prototype.initEvents=function(){};

YAHOO.ext.grid.EditorSelectionModel=function(){YAHOO.ext.grid.EditorSelectionModel.superclass.constructor.call(this);this.clicksToActivateCell=1;this.events['cellactivate']=new YAHOO.util.CustomEvent('cellactivate');};YAHOO.extendX(YAHOO.ext.grid.EditorSelectionModel,YAHOO.ext.grid.DefaultSelectionModel);YAHOO.ext.grid.EditorSelectionModel.prototype.disableArrowNavigation=false;YAHOO.ext.grid.EditorSelectionModel.prototype.controlForArrowNavigation=false;YAHOO.ext.grid.EditorSelectionModel.prototype.initEvents=function(){this.grid.addListener("cellclick",this.onCellClick,this,true);this.grid.addListener("celldblclick",this.onCellDblClick,this,true);this.grid.addListener("keydown",this.keyDown,this,true);};YAHOO.ext.grid.EditorSelectionModel.prototype.onCellClick=function(grid,rowIndex,colIndex){if(this.clicksToActivateCell==1){var row=this.grid.getRow(rowIndex);var cell=row.childNodes[colIndex];if(cell){this.activate(row,cell);}}};YAHOO.ext.grid.EditorSelectionModel.prototype.activate=function(row,cell){this.fireEvent('cellactivate',this,row,cell);this.grid.doEdit(row,cell);};YAHOO.ext.grid.EditorSelectionModel.prototype.onCellDblClick=function(grid,rowIndex,colIndex){if(this.clicksToActivateCell==2){var row=this.grid.getRow(rowIndex);var cell=row.childNodes[colIndex];if(cell){this.activate(row,cell);}}};YAHOO.ext.grid.EditorSelectionModel.prototype.setRowState=function(row,selected){YAHOO.ext.grid.EditorSelectionModel.superclass.setRowState.call(this,row,false,false);};YAHOO.ext.grid.EditorSelectionModel.prototype.focusRow=function(row,selected){};YAHOO.ext.grid.EditorSelectionModel.prototype.getEditorCellAfter=function(cell,spanRows){var g=this.grid;var next=g.getCellAfter(cell);while(next&&!g.colModel.isCellEditable(next.columnIndex)){next=g.getCellAfter(next);}
if(!next&&spanRows){var row=g.getRowAfter(g.getRowFromChild(cell));if(row){next=g.getFirstCell(row);if(!g.colModel.isCellEditable(next.columnIndex)){next=this.getEditorCellAfter(next);}}}
return next;};YAHOO.ext.grid.EditorSelectionModel.prototype.getEditorCellBefore=function(cell,spanRows){var g=this.grid;var prev=g.getCellBefore(cell);while(prev&&!g.colModel.isCellEditable(prev.columnIndex)){prev=g.getCellBefore(prev);}
if(!prev&&spanRows){var row=g.getRowBefore(g.getRowFromChild(cell));if(row){prev=g.getLastCell(row);if(!g.colModel.isCellEditable(prev.columnIndex)){prev=this.getEditorCellBefore(prev);}}}
return prev;};YAHOO.ext.grid.EditorSelectionModel.prototype.allowArrowNav=function(e){return(!this.disableArrowNavigation&&(!this.controlForArrowNavigation||e.ctrlKey));}
YAHOO.ext.grid.EditorSelectionModel.prototype.keyDown=function(e){var g=this.grid,cm=g.colModel,cell=g.getEditingCell();if(!cell)return;var newCell;switch(e.browserEvent.keyCode){case e.TAB:if(e.shiftKey){newCell=this.getEditorCellBefore(cell,true);}else{newCell=this.getEditorCellAfter(cell,true);}
e.preventDefault();break;case e.DOWN:if(this.allowArrowNav(e)){var next=g.getRowAfter(g.getRowFromChild(cell));if(next){newCell=next.childNodes[cell.columnIndex];}}
break;case e.UP:if(this.allowArrowNav(e)){var prev=g.getRowBefore(g.getRowFromChild(cell));if(prev){newCell=prev.childNodes[cell.columnIndex];}}
break;case e.RETURN:if(e.shiftKey){var prev=g.getRowBefore(g.getRowFromChild(cell));if(prev){newCell=prev.childNodes[cell.columnIndex];}}else{var next=g.getRowAfter(g.getRowFromChild(cell));if(next){newCell=next.childNodes[cell.columnIndex];}}
break;case e.RIGHT:if(this.allowArrowNav(e)){newCell=this.getEditorCellAfter(cell);}
break;case e.LEFT:if(this.allowArrowNav(e)){newCell=this.getEditorCellBefore(cell);}
break;};if(newCell){this.activate(g.getRowFromChild(newCell),newCell);e.stopEvent();}};YAHOO.ext.grid.EditorAndSelectionModel=function(){YAHOO.ext.grid.EditorAndSelectionModel.superclass.constructor.call(this);this.events['cellactivate']=new YAHOO.util.CustomEvent('cellactivate');};YAHOO.extendX(YAHOO.ext.grid.EditorAndSelectionModel,YAHOO.ext.grid.DefaultSelectionModel);YAHOO.ext.grid.EditorAndSelectionModel.prototype.initEvents=function(){YAHOO.ext.grid.EditorAndSelectionModel.superclass.initEvents.call(this);this.grid.addListener("celldblclick",this.onCellDblClick,this,true);};YAHOO.ext.grid.EditorAndSelectionModel.prototype.onCellDblClick=function(grid,rowIndex,colIndex){var row=this.grid.getRow(rowIndex);var cell=row.childNodes[colIndex];if(cell){this.fireEvent('cellactivate',this,row,cell);this.grid.doEdit(row,cell);}};

YAHOO.ext.grid.CellEditor=function(element){this.colIndex=null;this.rowIndex=null;this.grid=null;this.editing=false;this.originalValue=null;this.element=getEl(element,true);this.element.addClass('ygrid-editor');this.element.dom.tabIndex=1;this.initialized=false;this.callback=null;};YAHOO.ext.grid.CellEditor.prototype={init:function(grid,bodyElement,callback){if(this.initialized)return;this.initialized=true;this.callback=callback;this.grid=grid;bodyElement.appendChild(this.element.dom);this.initEvents();},initEvents:function(){var stopOnEnter=function(e){if(e.browserEvent.keyCode==e.RETURN){this.stopEditing(true);}else if(e.browserEvent.keyCode==e.ESC){this.setValue(this.originalValue);this.stopEditing(true);}}
this.element.mon('keydown',stopOnEnter,this,true);this.element.on('blur',this.stopEditing,this,true);},startEditing:function(value,row,cell){this.originalValue=value;this.rowIndex=row.rowIndex;this.colIndex=cell.columnIndex;this.cell=cell;this.setValue(value);var cellbox=getEl(cell,true).getBox();this.fitToCell(cellbox);this.editing=true;this.show();},stopEditing:function(focusCell){if(this.editing){this.editing=false;var newValue=this.getValue();this.hide();if(this.originalValue!=newValue){this.callback(newValue,this.rowIndex,this.colIndex);}}},setValue:function(value){this.element.dom.value=value;},getValue:function(){return this.element.dom.value;},fitToCell:function(box){this.element.setBox(box,true);},show:function(){this.element.show();this.element.focus();},hide:function(){try{this.element.dom.blur();}catch(e){}
this.element.hide();}};

YAHOO.ext.grid.CheckboxEditor=function(){var div=document.createElement('span');div.className='ygrid-editor ygrid-checkbox-editor';var cb=document.createElement('input');cb.type='checkbox';cb.setAttribute('autocomplete','off');div.appendChild(cb);document.body.appendChild(div);YAHOO.ext.grid.CheckboxEditor.superclass.constructor.call(this,div);div.tabIndex='';cb.tabIndex=1;this.cb=getEl(cb,true);};YAHOO.extendX(YAHOO.ext.grid.CheckboxEditor,YAHOO.ext.grid.CellEditor);YAHOO.ext.grid.CheckboxEditor.prototype.fitToCell=function(box){this.element.setBox(box,true);};YAHOO.ext.grid.CheckboxEditor.prototype.setValue=function(value){this.cb.dom.checked=(value===true||value==='true'||value===1||value==='1');};YAHOO.ext.grid.CheckboxEditor.prototype.getValue=function(){return this.cb.dom.checked;};YAHOO.ext.grid.CheckboxEditor.prototype.show=function(){this.element.show();this.cb.focus();};YAHOO.ext.grid.CheckboxEditor.prototype.initEvents=function(){var stopOnEnter=function(e){if(e.browserEvent.keyCode==e.RETURN){this.stopEditing(true);}else if(e.browserEvent.keyCode==e.ESC){this.setValue(this.originalValue);this.stopEditing(true);}}
this.cb.mon('keydown',stopOnEnter,this,true);this.cb.on('blur',this.stopEditing,this,true);};YAHOO.ext.grid.CheckboxEditor.prototype.hide=function(){try{this.cb.dom.blur();}catch(e){}
this.element.hide();};

YAHOO.ext.grid.DateEditor=function(config){var div=document.createElement('span');div.className='ygrid-editor ygrid-editor-container';var element=document.createElement('input');element.type='text';element.tabIndex=1;element.setAttribute('autocomplete','off');div.appendChild(element);var pick=document.createElement('span');pick.className='pick-button';div.appendChild(pick);document.body.appendChild(div);this.div=getEl(div,true);this.element=getEl(element,true);this.pick=getEl(pick,true);this.colIndex=null;this.rowIndex=null;this.grid=null;this.editing=false;this.originalValue=null;this.initialized=false;this.callback=null;this.cal=null;this.mouseDownHandler=YAHOO.ext.EventManager.wrap(this.handleMouseDown,this,true);YAHOO.ext.util.Config.apply(this,config);if(typeof this.minValue=='string')this.minValue=this.parseDate(this.minValue);if(typeof this.maxValue=='string')this.maxValue=this.parseDate(this.maxValue);this.ddMatch=/ddnone/;if(this.disabledDates){var dd=this.disabledDates;var re="(?:";for(var i=0;i<dd.length;i++){re+=dd[i];if(i!=dd.length-1)re+="|";}
this.ddMatch=new RegExp(re+")");}};YAHOO.ext.grid.DateEditor.prototype={init:function(grid,bodyElement,callback){if(this.initialized)return;this.initialized=true;this.callback=callback;this.grid=grid;bodyElement.appendChild(this.div.dom);this.initEvents();},initEvents:function(){var stopOnEnter=function(e){if(e.browserEvent.keyCode==e.RETURN){this.stopEditing(true);}else if(e.browserEvent.keyCode==e.ESC){this.setValue(this.originalValue);this.stopEditing(true);}}
this.element.mon('keydown',stopOnEnter,this,true);var vtask=new YAHOO.ext.util.DelayedTask(this.validate,this);this.element.mon('keyup',vtask.delay.createDelegate(vtask,[this.validationDelay]));this.pick.on('click',this.showCalendar,this,true);},startEditing:function(value,row,cell){this.originalValue=value;this.rowIndex=row.rowIndex;this.colIndex=cell.columnIndex;this.cell=cell;this.setValue(value);this.validate();var cellbox=getEl(cell,true).getBox();this.div.setBox(cellbox,true);this.element.setWidth(cellbox.width-this.pick.getWidth());this.editing=true;YAHOO.util.Event.on(document,"mousedown",this.mouseDownHandler);this.show();},stopEditing:function(focusCell){if(this.editing){YAHOO.util.Event.removeListener(document,"mousedown",this.mouseDownHandler);this.editing=false;var newValue=this.getValue();this.hide();if(this.originalValue!=newValue){this.callback(newValue,this.rowIndex,this.colIndex);}}},setValue:function(value){this.element.dom.value=this.formatDate(value);this.validate();},getValue:function(){if(!this.validate()){return this.originalValue;}else{var value=this.element.dom.value;if(value.length<1){return value;}else{return this.parseDate(value);}}},show:function(){this.div.show();this.element.focus();this.validate();},hide:function(){try{this.element.dom.blur();}catch(e){}
this.div.hide();},validate:function(){var dom=this.element.dom;var value=dom.value;if(value.length<1){if(this.allowBlank){dom.title='';this.element.removeClass('ygrid-editor-invalid');return true;}else{dom.title=this.blankText;this.element.addClass('ygrid-editor-invalid');return false;}}
value=this.parseDate(value);if(!value){dom.title=this.invalidText.replace('%0',dom.value).replace('%1',this.format);this.element.addClass('ygrid-editor-invalid');return false;}
var time=value.getTime();if(this.minValue&&time<this.minValue.getTime()){dom.title=this.minText.replace('%0',this.formatDate(this.minValue));this.element.addClass('ygrid-editor-invalid');return false;}
if(this.maxValue&&time>this.maxValue.getTime()){dom.title=this.maxText.replace('%0',this.formatDate(this.maxValue));this.element.addClass('ygrid-editor-invalid');return false;}
if(this.disabledDays){var day=value.getDay();for(var i=0;i<this.disabledDays.length;i++){if(day===this.disabledDays[i]){dom.title=this.disabledDaysText;this.element.addClass('ygrid-editor-invalid');return false;}}}
var fvalue=this.formatDate(value);if(this.ddMatch.test(fvalue)){dom.title=this.disabledDatesText.replace('%0',fvalue);this.element.addClass('ygrid-editor-invalid');return false;}
var msg=this.validator(value);if(msg!==true){dom.title=msg;this.element.addClass('ygrid-editor-invalid');return false;}
dom.title='';this.element.removeClass('ygrid-editor-invalid');return true;},handleMouseDown:function(e){var t=e.getTarget();var dom=this.div.dom;if(t!=dom&&!YAHOO.util.Dom.isAncestor(dom,t)){this.stopEditing();}},showCalendar:function(value){if(this.cal==null){this.cal=new YAHOO.ext.DatePicker(this.div.dom.parentNode.parentNode);}
this.cal.minDate=this.minValue;this.cal.maxDate=this.maxValue;this.cal.disabledDatesRE=this.ddMatch;this.cal.disabledDatesText=this.disabledDatesText;this.cal.disabledDays=this.disabledDays;this.cal.disabledDaysText=this.disabledDaysText;this.cal.format=this.format;if(this.minValue){this.cal.minText=this.minText.replace('%0',this.formatDate(this.minValue));}
if(this.maxValue){this.cal.maxText=this.maxText.replace('%0',this.formatDate(this.maxValue));}
var r=this.div.getRegion();this.cal.show(r.left,r.bottom,this.getValue(),this.setValue.createDelegate(this));},parseDate:function(value){if(!value||value instanceof Date)return value;return Date.parseDate(value,this.format);},formatDate:function(date){if(!date||!(date instanceof Date))return date;return date.format(this.format);}};YAHOO.ext.grid.DateEditor.prototype.format='m/d/y';YAHOO.ext.grid.DateEditor.prototype.disabledDays=null;YAHOO.ext.grid.DateEditor.prototype.disabledDaysText='';YAHOO.ext.grid.DateEditor.prototype.disabledDates=null;YAHOO.ext.grid.DateEditor.prototype.disabledDatesText='';YAHOO.ext.grid.DateEditor.prototype.allowBlank=true;YAHOO.ext.grid.DateEditor.prototype.minValue=null;YAHOO.ext.grid.DateEditor.prototype.maxValue=null;YAHOO.ext.grid.DateEditor.prototype.minText='The date in this field must be after %0';YAHOO.ext.grid.DateEditor.prototype.maxText='The date in this field must be before %0';YAHOO.ext.grid.DateEditor.prototype.blankText='This field cannot be blank';YAHOO.ext.grid.DateEditor.prototype.invalidText='%0 is not a valid date - it must be in the format %1';YAHOO.ext.grid.DateEditor.prototype.validationDelay=200;YAHOO.ext.grid.DateEditor.prototype.validator=function(){return true;};

YAHOO.ext.grid.NumberEditor=function(config){var element=document.createElement('input');element.type='text';element.className='ygrid-editor ygrid-num-editor';element.setAttribute('autocomplete','off');document.body.appendChild(element);YAHOO.ext.grid.NumberEditor.superclass.constructor.call(this,element);YAHOO.ext.util.Config.apply(this,config);};YAHOO.extendX(YAHOO.ext.grid.NumberEditor,YAHOO.ext.grid.CellEditor);YAHOO.ext.grid.NumberEditor.prototype.initEvents=function(){var stopOnEnter=function(e){if(e.browserEvent.keyCode==e.RETURN){this.stopEditing(true);}else if(e.browserEvent.keyCode==e.ESC){this.setValue(this.originalValue);this.stopEditing(true);}};var allowed="0123456789";if(this.allowDecimals){allowed+=this.decimalSeparator;}
if(this.allowNegative){allowed+='-';}
var keyPress=function(e){var c=e.getCharCode();if(c!=e.BACKSPACE&&allowed.indexOf(String.fromCharCode(c))===-1){e.stopEvent();}};this.element.mon('keydown',stopOnEnter,this,true);var vtask=new YAHOO.ext.util.DelayedTask(this.validate,this);this.element.mon('keyup',vtask.delay.createDelegate(vtask,[this.validationDelay]));this.element.mon('keypress',keyPress,this,true);this.element.on('blur',this.stopEditing,this,true);};YAHOO.ext.grid.NumberEditor.prototype.validate=function(){var dom=this.element.dom;var value=dom.value;if(value.length<1){if(this.allowBlank){dom.title='';this.element.removeClass('ygrid-editor-invalid');return true;}else{dom.title=this.blankText;this.element.addClass('ygrid-editor-invalid');return false;}}
if(value.search(/\d+/)===-1){dom.title=this.nanText.replace('%0',value);this.element.addClass('ygrid-editor-invalid');return false;}
var num=this.parseValue(value);if(num<this.minValue){dom.title=this.minText.replace('%0',this.minValue);this.element.addClass('ygrid-editor-invalid');return false;}
if(num>this.maxValue){dom.title=this.maxText.replace('%0',this.maxValue);this.element.addClass('ygrid-editor-invalid');return false;}
var msg=this.validator(value);if(msg!==true){dom.title=msg;this.element.addClass('ygrid-editor-invalid');return false;}
dom.title='';this.element.removeClass('ygrid-editor-invalid');return true;};YAHOO.ext.grid.NumberEditor.prototype.show=function(){this.element.dom.title='';YAHOO.ext.grid.NumberEditor.superclass.show.call(this);if(this.selectOnFocus){try{this.element.dom.select();}catch(e){}}
this.validate(this.element.dom.value);};YAHOO.ext.grid.NumberEditor.prototype.getValue=function(){if(!this.validate()){return this.originalValue;}else{var value=this.element.dom.value;if(value.length<1){return value;}else{return this.fixPrecision(this.parseValue(value));}}};YAHOO.ext.grid.NumberEditor.prototype.parseValue=function(value){return parseFloat(new String(value).replace(this.decimalSeparator,'.'));};YAHOO.ext.grid.NumberEditor.prototype.fixPrecision=function(value){if(!this.allowDecimals||this.decimalPrecision==-1||isNaN(value)||value==0||!value){return value;}
var scale=Math.pow(10,this.decimalPrecision+1);var fixed=this.decimalPrecisionFcn(value*scale);fixed=this.decimalPrecisionFcn(fixed/10);return fixed/(scale/10);};YAHOO.ext.grid.NumberEditor.prototype.allowBlank=true;YAHOO.ext.grid.NumberEditor.prototype.allowDecimals=true;YAHOO.ext.grid.NumberEditor.prototype.decimalSeparator='.';YAHOO.ext.grid.NumberEditor.prototype.decimalPrecision=2;YAHOO.ext.grid.NumberEditor.prototype.decimalPrecisionFcn=Math.floor;YAHOO.ext.grid.NumberEditor.prototype.allowNegative=true;YAHOO.ext.grid.NumberEditor.prototype.selectOnFocus=true;YAHOO.ext.grid.NumberEditor.prototype.minValue=Number.NEGATIVE_INFINITY;YAHOO.ext.grid.NumberEditor.prototype.maxValue=Number.MAX_VALUE;YAHOO.ext.grid.NumberEditor.prototype.minText='The minimum value for this field is %0';YAHOO.ext.grid.NumberEditor.prototype.maxText='The maximum value for this field is %0';YAHOO.ext.grid.NumberEditor.prototype.blankText='This field cannot be blank';YAHOO.ext.grid.NumberEditor.prototype.nanText='%0 is not a valid number';YAHOO.ext.grid.NumberEditor.prototype.validationDelay=100;YAHOO.ext.grid.NumberEditor.prototype.validator=function(){return true;};

YAHOO.ext.DatePicker=function(id,parentElement){this.id=id;this.selectedDate=new Date();this.visibleDate=new Date();this.element=null;this.shadow=null;this.callback=null;this.buildControl(parentElement||document.body);this.mouseDownHandler=YAHOO.ext.EventManager.wrap(this.handleMouseDown,this,true);this.keyDownHandler=YAHOO.ext.EventManager.wrap(this.handleKeyDown,this,true);this.wheelHandler=YAHOO.ext.EventManager.wrap(this.handleMouseWheel,this,true);};YAHOO.ext.DatePicker.prototype={show:function(x,y,value,callback){this.hide();this.selectedDate=value;this.visibleDate=value;this.callback=callback;this.refresh();this.element.show();this.element.setXY(this.constrainToViewport?this.constrainXY(x,y):[x,y]);this.shadow.show();this.shadow.setRegion(this.element.getRegion());this.element.dom.tabIndex=1;this.element.focus();YAHOO.util.Event.on(document,"mousedown",this.mouseDownHandler);YAHOO.util.Event.on(document,"keydown",this.keyDownHandler);YAHOO.util.Event.on(document,"mousewheel",this.wheelHandler);YAHOO.util.Event.on(document,"DOMMouseScroll",this.wheelHandler);},constrainXY:function(x,y){var w=YAHOO.util.Dom.getViewportWidth();var h=YAHOO.util.Dom.getViewportHeight();var size=this.element.getSize();return[Math.min(w-size.width,x),Math.min(h-size.height,y)];},hide:function(){this.shadow.hide();this.element.hide();YAHOO.util.Event.removeListener(document,"mousedown",this.mouseDownHandler);YAHOO.util.Event.removeListener(document,"keydown",this.keyDownHandler);YAHOO.util.Event.removeListener(document,"mousewheel",this.wheelHandler);YAHOO.util.Event.removeListener(document,"DOMMouseScroll",this.wheelHandler);},setSelectedDate:function(date){this.selectedDate=date;},getSelectedDate:function(){return this.selectedDate;},showPrevMonth:function(){this.visibleDate=this.getPrevMonth(this.visibleDate);this.refresh();},showNextMonth:function(){this.visibleDate=this.getNextMonth(this.visibleDate);this.refresh();},showPrevYear:function(){var d=this.visibleDate;this.visibleDate=new Date(d.getFullYear()-1,d.getMonth(),d.getDate());this.refresh();},showNextYear:function(){var d=this.visibleDate;this.visibleDate=new Date(d.getFullYear()+1,d.getMonth(),d.getDate());this.refresh();},handleMouseDown:function(e){var target=e.getTarget();if(target!=this.element.dom&&!YAHOO.util.Dom.isAncestor(this.element.dom,target)){this.hide();}},handleKeyDown:function(e){switch(e.browserEvent.keyCode){case e.LEFT:this.showPrevMonth();e.stopEvent();break;case e.RIGHT:this.showNextMonth();e.stopEvent();break;case e.DOWN:this.showPrevYear();e.stopEvent();break;case e.UP:this.showNextYear();e.stopEvent();break;}},handleMouseWheel:function(e){var delta=e.getWheelDelta();if(delta>0){this.showPrevMonth();e.stopEvent();}else if(delta<0){this.showNextMonth();e.stopEvent();}},handleClick:function(e){var d=this.visibleDate;var t=e.getTarget();if(t&&t.className){switch(t.className){case'active':this.handleSelection(new Date(d.getFullYear(),d.getMonth(),parseInt(t.innerHTML)));break;case'prevday':var p=this.getPrevMonth(d);this.handleSelection(new Date(p.getFullYear(),p.getMonth(),parseInt(t.innerHTML)));break;case'nextday':var n=this.getNextMonth(d);this.handleSelection(new Date(n.getFullYear(),n.getMonth(),parseInt(t.innerHTML)));break;case'ypopcal-today':this.handleSelection(new Date());break;case'next-month':this.showNextMonth();break;case'prev-month':this.showPrevMonth();break;}}
e.stopEvent();},selectToday:function(){this.handleSelection(new Date());},handleSelection:function(date){this.selectedDate=date;this.callback(date);this.hide();},getPrevMonth:function(d){var m=d.getMonth();var y=d.getFullYear();return(m==0?new Date(--y,11,1):new Date(y,--m,1));},getNextMonth:function(d){var m=d.getMonth();var y=d.getFullYear();return(m==11?new Date(++y,0,1):new Date(y,++m,1));},getDaysInMonth:function(m,y){return(m==1||m==3||m==5||m==7||m==8||m==10||m==12)?31:(m==4||m==6||m==9||m==11)?30:this.isLeapYear(y)?29:28;},isLeapYear:function(y){return(((y%4)==0)&&((y%100)!=0)||((y%400)==0));},clearTime:function(date){if(date){date.setHours(0);date.setMinutes(0);date.setSeconds(0);date.setMilliseconds(0);}
return date;},refresh:function(){var d=this.visibleDate;this.buildInnerCal(d);this.calHead.update(this.monthNames[d.getMonth()]+' '+d.getFullYear());if(this.element.isVisible()){this.shadow.setRegion(this.element.getRegion());}}};YAHOO.ext.DatePicker.prototype.buildControl=function(parentElement){var c=document.createElement('div');c.style.position='absolute';c.style.visibility='hidden';document.body.appendChild(c);var html='<iframe id="'+this.id+'_shdw" frameborder="0" style="position:absolute; z-index:2000; display:none; top:0px; left:0px;" class="ypopcal-shadow"></iframe>'+'<div hidefocus="true" class="ypopcal" id="'+this.id+'" style="-moz-outline:none; position:absolute; z-index:2001; display:none; top:0px; left:0px;">'+'<table class="ypopcal-head" border=0 cellpadding=0 cellspacing=0><tbody><tr><td class="ypopcal-arrow"><div class="prev-month">&#160;</div></td><td class="ypopcal-month">&#160;</td><td class="ypopcal-arrow"><div class="next-month">&#160;</div></td></tr></tbody></table>'+'<center><div class="ypopcal-inner">';html+="<table border=0 cellpadding=2 cellspacing=0 class=\"ypopcal-table\"><thead><tr class=\"ypopcal-daynames\">";var names=this.dayNames;for(var i=0;i<names.length;i++){html+='<td>'+names[i].substr(0,1)+'</td>';}
html+="</tr></thead><tbody><tr>";for(var i=0;i<42;i++){if(i%7==0&&i!=0){html+='</tr><tr>';}
html+="<td>&nbsp;</td>";}
html+="</tr></tbody></table>";html+='</div><button class="ypopcal-today" style="margin-top:2px;">'+this.todayText+'</button></center></div>';c.innerHTML=html;this.shadow=getEl(c.childNodes[0],true);this.shadow.enableDisplayMode();this.element=getEl(c.childNodes[1],true);this.element.enableDisplayMode();document.body.appendChild(this.shadow.dom);document.body.appendChild(this.element.dom);document.body.removeChild(c);this.element.on("selectstart",function(){return false;});var tbody=this.element.dom.getElementsByTagName('tbody')[1];this.cells=tbody.getElementsByTagName('td');this.calHead=this.element.getChildrenByClassName('ypopcal-month','td')[0];this.element.mon('mousedown',this.handleClick,this,true);};YAHOO.ext.DatePicker.prototype.buildInnerCal=function(dateVal){var days=this.getDaysInMonth(dateVal.getMonth()+1,dateVal.getFullYear());var firstOfMonth=new Date(dateVal.getFullYear(),dateVal.getMonth(),1);var startingPos=firstOfMonth.getDay();if(startingPos==0)startingPos=7;var pm=this.getPrevMonth(dateVal);var prevStart=this.getDaysInMonth(pm.getMonth()+1,pm.getFullYear())-startingPos;var cells=this.cells;days+=startingPos;var day=86400000;var date=this.clearTime(new Date(pm.getFullYear(),pm.getMonth(),prevStart));var today=this.clearTime(new Date()).getTime();var sel=this.selectedDate?this.clearTime(this.selectedDate).getTime():today+1;var min=this.minDate?this.clearTime(this.minDate).getTime():Number.NEGATIVE_INFINITY;var max=this.maxDate?this.clearTime(this.maxDate).getTime():Number.POSITIVE_INFINITY;var ddMatch=this.disabledDatesRE;var ddText=this.disabledDatesText;var ddays=this.disabledDays;var ddaysText=this.disabledDaysText;var format=this.format;var setCellClass=function(cal,cell,d){cell.title='';var t=d.getTime();if(t==today){cell.className+=' today';cell.title=cal.todayText;}
if(t==sel){cell.className+=' selected';}
if(t<min){cell.className=' ypopcal-disabled';cell.title=cal.minText;return;}
if(t>max){cell.className=' ypopcal-disabled';cell.title=cal.maxText;return;}
if(ddays){var day=d.getDay();for(var i=0;i<ddays.length;i++){if(day===ddays[i]){cell.title=ddaysText;cell.className=' ypopcal-disabled';return;}}}
if(ddMatch&&format){var fvalue=d.format(format);if(ddMatch.test(fvalue)){cell.title=ddText.replace('%0',fvalue);cell.className=' ypopcal-disabled';return;}}};var i=0;for(;i<startingPos;i++){cells[i].innerHTML=(++prevStart);date.setDate(date.getDate()+1);cells[i].className='prevday';setCellClass(this,cells[i],date);}
for(;i<days;i++){intDay=i-startingPos+1;cells[i].innerHTML=(intDay);date.setDate(date.getDate()+1);cells[i].className='active';setCellClass(this,cells[i],date);}
var extraDays=0;for(;i<42;i++){cells[i].innerHTML=(++extraDays);date.setDate(date.getDate()+1);cells[i].className='nextday';setCellClass(this,cells[i],date);}};YAHOO.ext.DatePicker.prototype.todayText="Today";YAHOO.ext.DatePicker.prototype.minDate=null;YAHOO.ext.DatePicker.prototype.maxDate=null;YAHOO.ext.DatePicker.prototype.minText="This date is before the minimum date";YAHOO.ext.DatePicker.prototype.maxText="This date is after the maximum date";YAHOO.ext.DatePicker.prototype.format='m/d/y';YAHOO.ext.DatePicker.prototype.disabledDays=null;YAHOO.ext.DatePicker.prototype.disabledDaysText='';YAHOO.ext.DatePicker.prototype.disabledDatesRE=null;YAHOO.ext.DatePicker.prototype.disabledDatesText='';YAHOO.ext.DatePicker.prototype.constrainToViewport=true;YAHOO.ext.DatePicker.prototype.monthNames=Date.monthNames;YAHOO.ext.DatePicker.prototype.dayNames=Date.dayNames;

YAHOO.ext.grid.SelectEditor=function(element){element.hideFocus=true;YAHOO.ext.grid.SelectEditor.superclass.constructor.call(this,element);this.element.swallowEvent('click');};YAHOO.extendX(YAHOO.ext.grid.SelectEditor,YAHOO.ext.grid.CellEditor);YAHOO.ext.grid.SelectEditor.prototype.fitToCell=function(box){if(YAHOO.ext.util.Browser.isGecko){box.height-=3;}
this.element.setBox(box,true);};

YAHOO.ext.grid.TextEditor=function(config){var element=document.createElement('input');element.type='text';element.className='ygrid-editor ygrid-text-editor';element.setAttribute('autocomplete','off');document.body.appendChild(element);YAHOO.ext.grid.TextEditor.superclass.constructor.call(this,element);YAHOO.ext.util.Config.apply(this,config);};YAHOO.extendX(YAHOO.ext.grid.TextEditor,YAHOO.ext.grid.CellEditor);YAHOO.ext.grid.TextEditor.prototype.validate=function(){var dom=this.element.dom;var value=dom.value;if(value.length<1){if(this.allowBlank){dom.title='';this.element.removeClass('ygrid-editor-invalid');return true;}else{dom.title=this.blankText;this.element.addClass('ygrid-editor-invalid');return false;}}
if(value.length<this.minLength){dom.title=this.minText.replace('%0',this.minLength);this.element.addClass('ygrid-editor-invalid');return false;}
if(value.length>this.maxLength){dom.title=this.maxText.replace('%0',this.maxLength);this.element.addClass('ygrid-editor-invalid');return false;}
var msg=this.validator(value);if(msg!==true){dom.title=msg;this.element.addClass('ygrid-editor-invalid');return false;}
if(this.regex&&!this.regex.test(value)){dom.title=this.regexText;this.element.addClass('ygrid-editor-invalid');return false;}
dom.title='';this.element.removeClass('ygrid-editor-invalid');return true;};YAHOO.ext.grid.TextEditor.prototype.initEvents=function(){YAHOO.ext.grid.TextEditor.superclass.initEvents.call(this);var vtask=new YAHOO.ext.util.DelayedTask(this.validate,this);this.element.mon('keyup',vtask.delay.createDelegate(vtask,[this.validationDelay]));};YAHOO.ext.grid.TextEditor.prototype.show=function(){this.element.dom.title='';YAHOO.ext.grid.TextEditor.superclass.show.call(this);this.element.focus();if(this.selectOnFocus){try{this.element.dom.select();}catch(e){}}
this.validate(this.element.dom.value);};YAHOO.ext.grid.TextEditor.prototype.getValue=function(){if(!this.validate()){return this.originalValue;}else{return this.element.dom.value;}};YAHOO.ext.grid.TextEditor.prototype.allowBlank=true;YAHOO.ext.grid.TextEditor.prototype.minLength=0;YAHOO.ext.grid.TextEditor.prototype.maxLength=Number.MAX_VALUE;YAHOO.ext.grid.TextEditor.prototype.minText='The minimum length for this field is %0';YAHOO.ext.grid.TextEditor.prototype.maxText='The maximum length for this field is %0';YAHOO.ext.grid.TextEditor.prototype.selectOnFocus=true;YAHOO.ext.grid.TextEditor.prototype.blankText='This field cannot be blank';YAHOO.ext.grid.TextEditor.prototype.validator=function(){return true;};YAHOO.ext.grid.TextEditor.prototype.validationDelay=200;YAHOO.ext.grid.TextEditor.prototype.regex=null;YAHOO.ext.grid.TextEditor.prototype.regexText='';
