#-------------------------------------------------------------------
# WebGUI is Copyright 2001-2006 Plain Black Corporation.
#-------------------------------------------------------------------
# Please read the legal notices (docs/legal.txt) and the license
# (docs/license.txt) that came with this distribution before using
# this software.
#-------------------------------------------------------------------
# http://www.plainblack.com                     info@plainblack.com
#-------------------------------------------------------------------

use lib "../../lib";
use strict;
use Getopt::Long;
use WebGUI::Session;
use WebGUI::Operation::Shared;
use Data::Dumper;

my $toVersion = "7.0.1"; # make this match what version you're going to
my $quiet; # this line required

my $session = start(); # this line required

# upgrade functions go here
i18nDepartmentNames();
addMissingAssets();
addLDAPRecursiveFilter();

finish($session); # this line required

#--------------------------------------------------
sub addMissingAssets {
	print "\tAdding assets to config file that weren't added before.\n" unless ($quiet);
	my $config = $session->config;
	$config->addToArray("assets","WebGUI::Asset::Wobject::TimeTracking");
	$config->addToArray("assets","WebGUI::Asset::Wobject::ProjectManager");
	$config->addToArray("assets","WebGUI::Asset::Wobject::EventManagementSystem");
}

#--------------------------------------------------
sub i18nDepartmentNames {
	print "\tInternationalizing department settings in user profile\n" unless ($quiet);
	$session->db->write(q!update userProfileField set label=? where fieldName='department'!, ["WebGUI::International::get('Department','Asset_InOutBoard')"]);
	my ($codeValues) = $session->db->quickArray(q|select possibleValues from userProfileField where fieldName='department'|);

	my $possibleValues = WebGUI::Operation::Shared::secureEval($session, $codeValues);
	delete $possibleValues->{IT};
	delete $possibleValues->{HR};
	delete $possibleValues->{'Regular Staff'};
	local $Data::Dumper::Terse = 1;
	my $i18nValues = Dumper $possibleValues;
	$i18nValues =~ s/\{/{'IT'=>WebGUI::International::get('IT','Asset_InOutBoard'),'HR'=>WebGUI::International::get('HR','Asset_InOutBoard'),'Regular Staff'=>WebGUI::International::get('Regular Staff','Asset_InOutBoard')/;
	$session->db->write(q!update userProfileField set possibleValues=? where fieldName='department'!, [$i18nValues]);
}

#--------------------------------------------------
sub addLDAPRecursiveFilter() {
   print "\tAdding LDAP recursive filter.\n" unless ($quiet);
   $session->db->write("alter table groups add ldapRecursiveFilter varchar(255) default null");
   $session->db->write("alter table ldapLink add ldapGlobalRecursiveFilter varchar(255) default null");
}




##-------------------------------------------------
#sub exampleFunction {
#	my $session = shift;
#	print "\tWe're doing some stuff here that you should know about.\n" unless ($quiet);
#	# and here's our code
#}



# ---- DO NOT EDIT BELOW THIS LINE ----

#-------------------------------------------------
sub start {
	my $configFile;
	$|=1; #disable output buffering
	GetOptions(
    		'configFile=s'=>\$configFile,
        	'quiet'=>\$quiet
	);
	my $session = WebGUI::Session->open("../..",$configFile);
	$session->user({userId=>3});
	my $versionTag = WebGUI::VersionTag->getWorking($session);
	$versionTag->set({name=>"Upgrade to ".$toVersion});
	$session->db->write("insert into webguiVersion values (".$session->db->quote($toVersion).",'upgrade',".$session->datetime->time().")");
	updateTemplates($session);
	return $session;
}

#-------------------------------------------------
sub finish {
	my $session = shift;
	my $versionTag = WebGUI::VersionTag->getWorking($session);
	$versionTag->commit;
	$session->close();
}

#-------------------------------------------------
sub updateTemplates {
	my $session = shift;
	return undef unless (-d "templates-".$toVersion);
        print "\tUpdating templates.\n" unless ($quiet);
	opendir(DIR,"templates-".$toVersion);
	my @files = readdir(DIR);
	closedir(DIR);
	my $importNode = WebGUI::Asset->getImportNode($session);
	my $newFolder = undef;
	foreach my $file (@files) {
		next unless ($file =~ /\.tmpl$/);
		open(FILE,"<templates-".$toVersion."/".$file);
		my $first = 1;
		my $create = 0;
		my $head = 0;
		my %properties = (className=>"WebGUI::Asset::Template");
		while (my $line = <FILE>) {
			if ($first) {
				$line =~ m/^\#(.*)$/;
				$properties{id} = $1;
				$first = 0;
			} elsif ($line =~ m/^\#create$/) {
				$create = 1;
			} elsif ($line =~ m/^\#(.*):(.*)$/) {
				$properties{$1} = $2;
			} elsif ($line =~ m/^~~~$/) {
				$head = 1;
			} elsif ($head) {
				$properties{headBlock} .= $line;
			} else {
				$properties{template} .= $line;	
			}
		}
		close(FILE);
		if ($create) {
			$newFolder = createNewTemplatesFolder($importNode) unless (defined $newFolder);
			my $template = $newFolder->addChild(\%properties, $properties{id});
		} else {
			my $template = WebGUI::Asset->new($session,$properties{id}, "WebGUI::Asset::Template");
			if (defined $template) {
				my $newRevision = $template->addRevision(\%properties);
			}
		}
	}
}

#-------------------------------------------------
sub createNewTemplatesFolder {
	my $importNode = shift;
	my $newFolder = $importNode->addChild({
		className=>"WebGUI::Asset::Wobject::Folder",
		title => $toVersion." New Templates",
		menuTitle => $toVersion." New Templates",
		url=> $toVersion."_new_templates",
		groupIdView=>"12"
		});
	return $newFolder;
}



