package Date::Manip::TZ::amlos_00;
# Copyright (c) 2008-2013 Sullivan Beck.  All rights reserved.
# This program is free software; you can redistribute it and/or modify it
# under the same terms as Perl itself.

# This file was automatically generated.  Any changes to this file will
# be lost the next time 'tzdata' is run.
#    Generated on: Fri Nov 30 12:39:53 EST 2012
#    Data version: tzdata2012j
#    Code version: tzcode2012j

# This module contains data from the zoneinfo time zone database.  The original
# data was obtained from the URL:
#    ftp://ftp.iana.org/tz

=pod

=head1 NAME

Date::Manip::TZ::amlos_00 - Support for the America/Los_Angeles time zone

=head1 SYNPOSIS

This module contains data describing a time zone.  Most of the time zone
data comes from the Olsen database, but there are a few exceptions.

This module is not intended to be used directly.  Other Date::Manip modules
will load it as needed.

=cut

use strict;
use warnings;
require 5.010000;

our (%Dates,%LastRule);
END {
   undef %Dates;
   undef %LastRule;
}

our ($VERSION);
$VERSION='6.39';
END { undef $VERSION; }

%Dates         = (
   1    =>
     [
        [ [1,1,2,0,0,0],[1,1,1,16,7,2],'-07:52:58',[-7,-52,-58],
          'LMT',0,[1883,11,18,19,59,59],[1883,11,18,12,7,1],
          '0001010200:00:00','0001010116:07:02','1883111819:59:59','1883111812:07:01' ],
     ],
   1883 =>
     [
        [ [1883,11,18,20,0,0],[1883,11,18,12,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1918,3,31,9,59,59],[1918,3,31,1,59,59],
          '1883111820:00:00','1883111812:00:00','1918033109:59:59','1918033101:59:59' ],
     ],
   1918 =>
     [
        [ [1918,3,31,10,0,0],[1918,3,31,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1918,10,27,8,59,59],[1918,10,27,1,59,59],
          '1918033110:00:00','1918033103:00:00','1918102708:59:59','1918102701:59:59' ],
        [ [1918,10,27,9,0,0],[1918,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1919,3,30,9,59,59],[1919,3,30,1,59,59],
          '1918102709:00:00','1918102701:00:00','1919033009:59:59','1919033001:59:59' ],
     ],
   1919 =>
     [
        [ [1919,3,30,10,0,0],[1919,3,30,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1919,10,26,8,59,59],[1919,10,26,1,59,59],
          '1919033010:00:00','1919033003:00:00','1919102608:59:59','1919102601:59:59' ],
        [ [1919,10,26,9,0,0],[1919,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1942,2,9,9,59,59],[1942,2,9,1,59,59],
          '1919102609:00:00','1919102601:00:00','1942020909:59:59','1942020901:59:59' ],
     ],
   1942 =>
     [
        [ [1942,2,9,10,0,0],[1942,2,9,3,0,0],'-07:00:00',[-7,0,0],
          'PWT',1,[1945,8,14,22,59,59],[1945,8,14,15,59,59],
          '1942020910:00:00','1942020903:00:00','1945081422:59:59','1945081415:59:59' ],
     ],
   1945 =>
     [
        [ [1945,8,14,23,0,0],[1945,8,14,16,0,0],'-07:00:00',[-7,0,0],
          'PPT',1,[1945,9,30,8,59,59],[1945,9,30,1,59,59],
          '1945081423:00:00','1945081416:00:00','1945093008:59:59','1945093001:59:59' ],
        [ [1945,9,30,9,0,0],[1945,9,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1948,3,14,9,59,59],[1948,3,14,1,59,59],
          '1945093009:00:00','1945093001:00:00','1948031409:59:59','1948031401:59:59' ],
     ],
   1948 =>
     [
        [ [1948,3,14,10,0,0],[1948,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1949,1,1,8,59,59],[1949,1,1,1,59,59],
          '1948031410:00:00','1948031403:00:00','1949010108:59:59','1949010101:59:59' ],
     ],
   1949 =>
     [
        [ [1949,1,1,9,0,0],[1949,1,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1950,4,30,9,59,59],[1950,4,30,1,59,59],
          '1949010109:00:00','1949010101:00:00','1950043009:59:59','1950043001:59:59' ],
     ],
   1950 =>
     [
        [ [1950,4,30,10,0,0],[1950,4,30,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1950,9,24,8,59,59],[1950,9,24,1,59,59],
          '1950043010:00:00','1950043003:00:00','1950092408:59:59','1950092401:59:59' ],
        [ [1950,9,24,9,0,0],[1950,9,24,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1951,4,29,9,59,59],[1951,4,29,1,59,59],
          '1950092409:00:00','1950092401:00:00','1951042909:59:59','1951042901:59:59' ],
     ],
   1951 =>
     [
        [ [1951,4,29,10,0,0],[1951,4,29,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1951,9,30,8,59,59],[1951,9,30,1,59,59],
          '1951042910:00:00','1951042903:00:00','1951093008:59:59','1951093001:59:59' ],
        [ [1951,9,30,9,0,0],[1951,9,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1952,4,27,9,59,59],[1952,4,27,1,59,59],
          '1951093009:00:00','1951093001:00:00','1952042709:59:59','1952042701:59:59' ],
     ],
   1952 =>
     [
        [ [1952,4,27,10,0,0],[1952,4,27,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1952,9,28,8,59,59],[1952,9,28,1,59,59],
          '1952042710:00:00','1952042703:00:00','1952092808:59:59','1952092801:59:59' ],
        [ [1952,9,28,9,0,0],[1952,9,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1953,4,26,9,59,59],[1953,4,26,1,59,59],
          '1952092809:00:00','1952092801:00:00','1953042609:59:59','1953042601:59:59' ],
     ],
   1953 =>
     [
        [ [1953,4,26,10,0,0],[1953,4,26,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1953,9,27,8,59,59],[1953,9,27,1,59,59],
          '1953042610:00:00','1953042603:00:00','1953092708:59:59','1953092701:59:59' ],
        [ [1953,9,27,9,0,0],[1953,9,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1954,4,25,9,59,59],[1954,4,25,1,59,59],
          '1953092709:00:00','1953092701:00:00','1954042509:59:59','1954042501:59:59' ],
     ],
   1954 =>
     [
        [ [1954,4,25,10,0,0],[1954,4,25,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1954,9,26,8,59,59],[1954,9,26,1,59,59],
          '1954042510:00:00','1954042503:00:00','1954092608:59:59','1954092601:59:59' ],
        [ [1954,9,26,9,0,0],[1954,9,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1955,4,24,9,59,59],[1955,4,24,1,59,59],
          '1954092609:00:00','1954092601:00:00','1955042409:59:59','1955042401:59:59' ],
     ],
   1955 =>
     [
        [ [1955,4,24,10,0,0],[1955,4,24,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1955,9,25,8,59,59],[1955,9,25,1,59,59],
          '1955042410:00:00','1955042403:00:00','1955092508:59:59','1955092501:59:59' ],
        [ [1955,9,25,9,0,0],[1955,9,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1956,4,29,9,59,59],[1956,4,29,1,59,59],
          '1955092509:00:00','1955092501:00:00','1956042909:59:59','1956042901:59:59' ],
     ],
   1956 =>
     [
        [ [1956,4,29,10,0,0],[1956,4,29,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1956,9,30,8,59,59],[1956,9,30,1,59,59],
          '1956042910:00:00','1956042903:00:00','1956093008:59:59','1956093001:59:59' ],
        [ [1956,9,30,9,0,0],[1956,9,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1957,4,28,9,59,59],[1957,4,28,1,59,59],
          '1956093009:00:00','1956093001:00:00','1957042809:59:59','1957042801:59:59' ],
     ],
   1957 =>
     [
        [ [1957,4,28,10,0,0],[1957,4,28,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1957,9,29,8,59,59],[1957,9,29,1,59,59],
          '1957042810:00:00','1957042803:00:00','1957092908:59:59','1957092901:59:59' ],
        [ [1957,9,29,9,0,0],[1957,9,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1958,4,27,9,59,59],[1958,4,27,1,59,59],
          '1957092909:00:00','1957092901:00:00','1958042709:59:59','1958042701:59:59' ],
     ],
   1958 =>
     [
        [ [1958,4,27,10,0,0],[1958,4,27,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1958,9,28,8,59,59],[1958,9,28,1,59,59],
          '1958042710:00:00','1958042703:00:00','1958092808:59:59','1958092801:59:59' ],
        [ [1958,9,28,9,0,0],[1958,9,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1959,4,26,9,59,59],[1959,4,26,1,59,59],
          '1958092809:00:00','1958092801:00:00','1959042609:59:59','1959042601:59:59' ],
     ],
   1959 =>
     [
        [ [1959,4,26,10,0,0],[1959,4,26,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1959,9,27,8,59,59],[1959,9,27,1,59,59],
          '1959042610:00:00','1959042603:00:00','1959092708:59:59','1959092701:59:59' ],
        [ [1959,9,27,9,0,0],[1959,9,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1960,4,24,9,59,59],[1960,4,24,1,59,59],
          '1959092709:00:00','1959092701:00:00','1960042409:59:59','1960042401:59:59' ],
     ],
   1960 =>
     [
        [ [1960,4,24,10,0,0],[1960,4,24,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1960,9,25,8,59,59],[1960,9,25,1,59,59],
          '1960042410:00:00','1960042403:00:00','1960092508:59:59','1960092501:59:59' ],
        [ [1960,9,25,9,0,0],[1960,9,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1961,4,30,9,59,59],[1961,4,30,1,59,59],
          '1960092509:00:00','1960092501:00:00','1961043009:59:59','1961043001:59:59' ],
     ],
   1961 =>
     [
        [ [1961,4,30,10,0,0],[1961,4,30,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1961,9,24,8,59,59],[1961,9,24,1,59,59],
          '1961043010:00:00','1961043003:00:00','1961092408:59:59','1961092401:59:59' ],
        [ [1961,9,24,9,0,0],[1961,9,24,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1962,4,29,9,59,59],[1962,4,29,1,59,59],
          '1961092409:00:00','1961092401:00:00','1962042909:59:59','1962042901:59:59' ],
     ],
   1962 =>
     [
        [ [1962,4,29,10,0,0],[1962,4,29,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1962,10,28,8,59,59],[1962,10,28,1,59,59],
          '1962042910:00:00','1962042903:00:00','1962102808:59:59','1962102801:59:59' ],
        [ [1962,10,28,9,0,0],[1962,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1963,4,28,9,59,59],[1963,4,28,1,59,59],
          '1962102809:00:00','1962102801:00:00','1963042809:59:59','1963042801:59:59' ],
     ],
   1963 =>
     [
        [ [1963,4,28,10,0,0],[1963,4,28,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1963,10,27,8,59,59],[1963,10,27,1,59,59],
          '1963042810:00:00','1963042803:00:00','1963102708:59:59','1963102701:59:59' ],
        [ [1963,10,27,9,0,0],[1963,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1964,4,26,9,59,59],[1964,4,26,1,59,59],
          '1963102709:00:00','1963102701:00:00','1964042609:59:59','1964042601:59:59' ],
     ],
   1964 =>
     [
        [ [1964,4,26,10,0,0],[1964,4,26,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1964,10,25,8,59,59],[1964,10,25,1,59,59],
          '1964042610:00:00','1964042603:00:00','1964102508:59:59','1964102501:59:59' ],
        [ [1964,10,25,9,0,0],[1964,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1965,4,25,9,59,59],[1965,4,25,1,59,59],
          '1964102509:00:00','1964102501:00:00','1965042509:59:59','1965042501:59:59' ],
     ],
   1965 =>
     [
        [ [1965,4,25,10,0,0],[1965,4,25,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1965,10,31,8,59,59],[1965,10,31,1,59,59],
          '1965042510:00:00','1965042503:00:00','1965103108:59:59','1965103101:59:59' ],
        [ [1965,10,31,9,0,0],[1965,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1966,4,24,9,59,59],[1966,4,24,1,59,59],
          '1965103109:00:00','1965103101:00:00','1966042409:59:59','1966042401:59:59' ],
     ],
   1966 =>
     [
        [ [1966,4,24,10,0,0],[1966,4,24,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1966,10,30,8,59,59],[1966,10,30,1,59,59],
          '1966042410:00:00','1966042403:00:00','1966103008:59:59','1966103001:59:59' ],
        [ [1966,10,30,9,0,0],[1966,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1967,4,30,9,59,59],[1967,4,30,1,59,59],
          '1966103009:00:00','1966103001:00:00','1967043009:59:59','1967043001:59:59' ],
     ],
   1967 =>
     [
        [ [1967,4,30,10,0,0],[1967,4,30,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1967,10,29,8,59,59],[1967,10,29,1,59,59],
          '1967043010:00:00','1967043003:00:00','1967102908:59:59','1967102901:59:59' ],
        [ [1967,10,29,9,0,0],[1967,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1968,4,28,9,59,59],[1968,4,28,1,59,59],
          '1967102909:00:00','1967102901:00:00','1968042809:59:59','1968042801:59:59' ],
     ],
   1968 =>
     [
        [ [1968,4,28,10,0,0],[1968,4,28,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1968,10,27,8,59,59],[1968,10,27,1,59,59],
          '1968042810:00:00','1968042803:00:00','1968102708:59:59','1968102701:59:59' ],
        [ [1968,10,27,9,0,0],[1968,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1969,4,27,9,59,59],[1969,4,27,1,59,59],
          '1968102709:00:00','1968102701:00:00','1969042709:59:59','1969042701:59:59' ],
     ],
   1969 =>
     [
        [ [1969,4,27,10,0,0],[1969,4,27,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1969,10,26,8,59,59],[1969,10,26,1,59,59],
          '1969042710:00:00','1969042703:00:00','1969102608:59:59','1969102601:59:59' ],
        [ [1969,10,26,9,0,0],[1969,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1970,4,26,9,59,59],[1970,4,26,1,59,59],
          '1969102609:00:00','1969102601:00:00','1970042609:59:59','1970042601:59:59' ],
     ],
   1970 =>
     [
        [ [1970,4,26,10,0,0],[1970,4,26,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1970,10,25,8,59,59],[1970,10,25,1,59,59],
          '1970042610:00:00','1970042603:00:00','1970102508:59:59','1970102501:59:59' ],
        [ [1970,10,25,9,0,0],[1970,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1971,4,25,9,59,59],[1971,4,25,1,59,59],
          '1970102509:00:00','1970102501:00:00','1971042509:59:59','1971042501:59:59' ],
     ],
   1971 =>
     [
        [ [1971,4,25,10,0,0],[1971,4,25,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1971,10,31,8,59,59],[1971,10,31,1,59,59],
          '1971042510:00:00','1971042503:00:00','1971103108:59:59','1971103101:59:59' ],
        [ [1971,10,31,9,0,0],[1971,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1972,4,30,9,59,59],[1972,4,30,1,59,59],
          '1971103109:00:00','1971103101:00:00','1972043009:59:59','1972043001:59:59' ],
     ],
   1972 =>
     [
        [ [1972,4,30,10,0,0],[1972,4,30,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1972,10,29,8,59,59],[1972,10,29,1,59,59],
          '1972043010:00:00','1972043003:00:00','1972102908:59:59','1972102901:59:59' ],
        [ [1972,10,29,9,0,0],[1972,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1973,4,29,9,59,59],[1973,4,29,1,59,59],
          '1972102909:00:00','1972102901:00:00','1973042909:59:59','1973042901:59:59' ],
     ],
   1973 =>
     [
        [ [1973,4,29,10,0,0],[1973,4,29,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1973,10,28,8,59,59],[1973,10,28,1,59,59],
          '1973042910:00:00','1973042903:00:00','1973102808:59:59','1973102801:59:59' ],
        [ [1973,10,28,9,0,0],[1973,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1974,1,6,9,59,59],[1974,1,6,1,59,59],
          '1973102809:00:00','1973102801:00:00','1974010609:59:59','1974010601:59:59' ],
     ],
   1974 =>
     [
        [ [1974,1,6,10,0,0],[1974,1,6,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1974,10,27,8,59,59],[1974,10,27,1,59,59],
          '1974010610:00:00','1974010603:00:00','1974102708:59:59','1974102701:59:59' ],
        [ [1974,10,27,9,0,0],[1974,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1975,2,23,9,59,59],[1975,2,23,1,59,59],
          '1974102709:00:00','1974102701:00:00','1975022309:59:59','1975022301:59:59' ],
     ],
   1975 =>
     [
        [ [1975,2,23,10,0,0],[1975,2,23,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1975,10,26,8,59,59],[1975,10,26,1,59,59],
          '1975022310:00:00','1975022303:00:00','1975102608:59:59','1975102601:59:59' ],
        [ [1975,10,26,9,0,0],[1975,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1976,4,25,9,59,59],[1976,4,25,1,59,59],
          '1975102609:00:00','1975102601:00:00','1976042509:59:59','1976042501:59:59' ],
     ],
   1976 =>
     [
        [ [1976,4,25,10,0,0],[1976,4,25,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1976,10,31,8,59,59],[1976,10,31,1,59,59],
          '1976042510:00:00','1976042503:00:00','1976103108:59:59','1976103101:59:59' ],
        [ [1976,10,31,9,0,0],[1976,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1977,4,24,9,59,59],[1977,4,24,1,59,59],
          '1976103109:00:00','1976103101:00:00','1977042409:59:59','1977042401:59:59' ],
     ],
   1977 =>
     [
        [ [1977,4,24,10,0,0],[1977,4,24,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1977,10,30,8,59,59],[1977,10,30,1,59,59],
          '1977042410:00:00','1977042403:00:00','1977103008:59:59','1977103001:59:59' ],
        [ [1977,10,30,9,0,0],[1977,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1978,4,30,9,59,59],[1978,4,30,1,59,59],
          '1977103009:00:00','1977103001:00:00','1978043009:59:59','1978043001:59:59' ],
     ],
   1978 =>
     [
        [ [1978,4,30,10,0,0],[1978,4,30,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1978,10,29,8,59,59],[1978,10,29,1,59,59],
          '1978043010:00:00','1978043003:00:00','1978102908:59:59','1978102901:59:59' ],
        [ [1978,10,29,9,0,0],[1978,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1979,4,29,9,59,59],[1979,4,29,1,59,59],
          '1978102909:00:00','1978102901:00:00','1979042909:59:59','1979042901:59:59' ],
     ],
   1979 =>
     [
        [ [1979,4,29,10,0,0],[1979,4,29,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1979,10,28,8,59,59],[1979,10,28,1,59,59],
          '1979042910:00:00','1979042903:00:00','1979102808:59:59','1979102801:59:59' ],
        [ [1979,10,28,9,0,0],[1979,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1980,4,27,9,59,59],[1980,4,27,1,59,59],
          '1979102809:00:00','1979102801:00:00','1980042709:59:59','1980042701:59:59' ],
     ],
   1980 =>
     [
        [ [1980,4,27,10,0,0],[1980,4,27,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1980,10,26,8,59,59],[1980,10,26,1,59,59],
          '1980042710:00:00','1980042703:00:00','1980102608:59:59','1980102601:59:59' ],
        [ [1980,10,26,9,0,0],[1980,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1981,4,26,9,59,59],[1981,4,26,1,59,59],
          '1980102609:00:00','1980102601:00:00','1981042609:59:59','1981042601:59:59' ],
     ],
   1981 =>
     [
        [ [1981,4,26,10,0,0],[1981,4,26,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1981,10,25,8,59,59],[1981,10,25,1,59,59],
          '1981042610:00:00','1981042603:00:00','1981102508:59:59','1981102501:59:59' ],
        [ [1981,10,25,9,0,0],[1981,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1982,4,25,9,59,59],[1982,4,25,1,59,59],
          '1981102509:00:00','1981102501:00:00','1982042509:59:59','1982042501:59:59' ],
     ],
   1982 =>
     [
        [ [1982,4,25,10,0,0],[1982,4,25,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1982,10,31,8,59,59],[1982,10,31,1,59,59],
          '1982042510:00:00','1982042503:00:00','1982103108:59:59','1982103101:59:59' ],
        [ [1982,10,31,9,0,0],[1982,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1983,4,24,9,59,59],[1983,4,24,1,59,59],
          '1982103109:00:00','1982103101:00:00','1983042409:59:59','1983042401:59:59' ],
     ],
   1983 =>
     [
        [ [1983,4,24,10,0,0],[1983,4,24,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1983,10,30,8,59,59],[1983,10,30,1,59,59],
          '1983042410:00:00','1983042403:00:00','1983103008:59:59','1983103001:59:59' ],
        [ [1983,10,30,9,0,0],[1983,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1984,4,29,9,59,59],[1984,4,29,1,59,59],
          '1983103009:00:00','1983103001:00:00','1984042909:59:59','1984042901:59:59' ],
     ],
   1984 =>
     [
        [ [1984,4,29,10,0,0],[1984,4,29,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1984,10,28,8,59,59],[1984,10,28,1,59,59],
          '1984042910:00:00','1984042903:00:00','1984102808:59:59','1984102801:59:59' ],
        [ [1984,10,28,9,0,0],[1984,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1985,4,28,9,59,59],[1985,4,28,1,59,59],
          '1984102809:00:00','1984102801:00:00','1985042809:59:59','1985042801:59:59' ],
     ],
   1985 =>
     [
        [ [1985,4,28,10,0,0],[1985,4,28,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1985,10,27,8,59,59],[1985,10,27,1,59,59],
          '1985042810:00:00','1985042803:00:00','1985102708:59:59','1985102701:59:59' ],
        [ [1985,10,27,9,0,0],[1985,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1986,4,27,9,59,59],[1986,4,27,1,59,59],
          '1985102709:00:00','1985102701:00:00','1986042709:59:59','1986042701:59:59' ],
     ],
   1986 =>
     [
        [ [1986,4,27,10,0,0],[1986,4,27,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1986,10,26,8,59,59],[1986,10,26,1,59,59],
          '1986042710:00:00','1986042703:00:00','1986102608:59:59','1986102601:59:59' ],
        [ [1986,10,26,9,0,0],[1986,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1987,4,5,9,59,59],[1987,4,5,1,59,59],
          '1986102609:00:00','1986102601:00:00','1987040509:59:59','1987040501:59:59' ],
     ],
   1987 =>
     [
        [ [1987,4,5,10,0,0],[1987,4,5,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1987,10,25,8,59,59],[1987,10,25,1,59,59],
          '1987040510:00:00','1987040503:00:00','1987102508:59:59','1987102501:59:59' ],
        [ [1987,10,25,9,0,0],[1987,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1988,4,3,9,59,59],[1988,4,3,1,59,59],
          '1987102509:00:00','1987102501:00:00','1988040309:59:59','1988040301:59:59' ],
     ],
   1988 =>
     [
        [ [1988,4,3,10,0,0],[1988,4,3,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1988,10,30,8,59,59],[1988,10,30,1,59,59],
          '1988040310:00:00','1988040303:00:00','1988103008:59:59','1988103001:59:59' ],
        [ [1988,10,30,9,0,0],[1988,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1989,4,2,9,59,59],[1989,4,2,1,59,59],
          '1988103009:00:00','1988103001:00:00','1989040209:59:59','1989040201:59:59' ],
     ],
   1989 =>
     [
        [ [1989,4,2,10,0,0],[1989,4,2,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1989,10,29,8,59,59],[1989,10,29,1,59,59],
          '1989040210:00:00','1989040203:00:00','1989102908:59:59','1989102901:59:59' ],
        [ [1989,10,29,9,0,0],[1989,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1990,4,1,9,59,59],[1990,4,1,1,59,59],
          '1989102909:00:00','1989102901:00:00','1990040109:59:59','1990040101:59:59' ],
     ],
   1990 =>
     [
        [ [1990,4,1,10,0,0],[1990,4,1,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1990,10,28,8,59,59],[1990,10,28,1,59,59],
          '1990040110:00:00','1990040103:00:00','1990102808:59:59','1990102801:59:59' ],
        [ [1990,10,28,9,0,0],[1990,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1991,4,7,9,59,59],[1991,4,7,1,59,59],
          '1990102809:00:00','1990102801:00:00','1991040709:59:59','1991040701:59:59' ],
     ],
   1991 =>
     [
        [ [1991,4,7,10,0,0],[1991,4,7,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1991,10,27,8,59,59],[1991,10,27,1,59,59],
          '1991040710:00:00','1991040703:00:00','1991102708:59:59','1991102701:59:59' ],
        [ [1991,10,27,9,0,0],[1991,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1992,4,5,9,59,59],[1992,4,5,1,59,59],
          '1991102709:00:00','1991102701:00:00','1992040509:59:59','1992040501:59:59' ],
     ],
   1992 =>
     [
        [ [1992,4,5,10,0,0],[1992,4,5,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1992,10,25,8,59,59],[1992,10,25,1,59,59],
          '1992040510:00:00','1992040503:00:00','1992102508:59:59','1992102501:59:59' ],
        [ [1992,10,25,9,0,0],[1992,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1993,4,4,9,59,59],[1993,4,4,1,59,59],
          '1992102509:00:00','1992102501:00:00','1993040409:59:59','1993040401:59:59' ],
     ],
   1993 =>
     [
        [ [1993,4,4,10,0,0],[1993,4,4,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1993,10,31,8,59,59],[1993,10,31,1,59,59],
          '1993040410:00:00','1993040403:00:00','1993103108:59:59','1993103101:59:59' ],
        [ [1993,10,31,9,0,0],[1993,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1994,4,3,9,59,59],[1994,4,3,1,59,59],
          '1993103109:00:00','1993103101:00:00','1994040309:59:59','1994040301:59:59' ],
     ],
   1994 =>
     [
        [ [1994,4,3,10,0,0],[1994,4,3,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1994,10,30,8,59,59],[1994,10,30,1,59,59],
          '1994040310:00:00','1994040303:00:00','1994103008:59:59','1994103001:59:59' ],
        [ [1994,10,30,9,0,0],[1994,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1995,4,2,9,59,59],[1995,4,2,1,59,59],
          '1994103009:00:00','1994103001:00:00','1995040209:59:59','1995040201:59:59' ],
     ],
   1995 =>
     [
        [ [1995,4,2,10,0,0],[1995,4,2,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1995,10,29,8,59,59],[1995,10,29,1,59,59],
          '1995040210:00:00','1995040203:00:00','1995102908:59:59','1995102901:59:59' ],
        [ [1995,10,29,9,0,0],[1995,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1996,4,7,9,59,59],[1996,4,7,1,59,59],
          '1995102909:00:00','1995102901:00:00','1996040709:59:59','1996040701:59:59' ],
     ],
   1996 =>
     [
        [ [1996,4,7,10,0,0],[1996,4,7,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1996,10,27,8,59,59],[1996,10,27,1,59,59],
          '1996040710:00:00','1996040703:00:00','1996102708:59:59','1996102701:59:59' ],
        [ [1996,10,27,9,0,0],[1996,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1997,4,6,9,59,59],[1997,4,6,1,59,59],
          '1996102709:00:00','1996102701:00:00','1997040609:59:59','1997040601:59:59' ],
     ],
   1997 =>
     [
        [ [1997,4,6,10,0,0],[1997,4,6,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1997,10,26,8,59,59],[1997,10,26,1,59,59],
          '1997040610:00:00','1997040603:00:00','1997102608:59:59','1997102601:59:59' ],
        [ [1997,10,26,9,0,0],[1997,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1998,4,5,9,59,59],[1998,4,5,1,59,59],
          '1997102609:00:00','1997102601:00:00','1998040509:59:59','1998040501:59:59' ],
     ],
   1998 =>
     [
        [ [1998,4,5,10,0,0],[1998,4,5,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1998,10,25,8,59,59],[1998,10,25,1,59,59],
          '1998040510:00:00','1998040503:00:00','1998102508:59:59','1998102501:59:59' ],
        [ [1998,10,25,9,0,0],[1998,10,25,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[1999,4,4,9,59,59],[1999,4,4,1,59,59],
          '1998102509:00:00','1998102501:00:00','1999040409:59:59','1999040401:59:59' ],
     ],
   1999 =>
     [
        [ [1999,4,4,10,0,0],[1999,4,4,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[1999,10,31,8,59,59],[1999,10,31,1,59,59],
          '1999040410:00:00','1999040403:00:00','1999103108:59:59','1999103101:59:59' ],
        [ [1999,10,31,9,0,0],[1999,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2000,4,2,9,59,59],[2000,4,2,1,59,59],
          '1999103109:00:00','1999103101:00:00','2000040209:59:59','2000040201:59:59' ],
     ],
   2000 =>
     [
        [ [2000,4,2,10,0,0],[2000,4,2,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2000,10,29,8,59,59],[2000,10,29,1,59,59],
          '2000040210:00:00','2000040203:00:00','2000102908:59:59','2000102901:59:59' ],
        [ [2000,10,29,9,0,0],[2000,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2001,4,1,9,59,59],[2001,4,1,1,59,59],
          '2000102909:00:00','2000102901:00:00','2001040109:59:59','2001040101:59:59' ],
     ],
   2001 =>
     [
        [ [2001,4,1,10,0,0],[2001,4,1,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2001,10,28,8,59,59],[2001,10,28,1,59,59],
          '2001040110:00:00','2001040103:00:00','2001102808:59:59','2001102801:59:59' ],
        [ [2001,10,28,9,0,0],[2001,10,28,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2002,4,7,9,59,59],[2002,4,7,1,59,59],
          '2001102809:00:00','2001102801:00:00','2002040709:59:59','2002040701:59:59' ],
     ],
   2002 =>
     [
        [ [2002,4,7,10,0,0],[2002,4,7,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2002,10,27,8,59,59],[2002,10,27,1,59,59],
          '2002040710:00:00','2002040703:00:00','2002102708:59:59','2002102701:59:59' ],
        [ [2002,10,27,9,0,0],[2002,10,27,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2003,4,6,9,59,59],[2003,4,6,1,59,59],
          '2002102709:00:00','2002102701:00:00','2003040609:59:59','2003040601:59:59' ],
     ],
   2003 =>
     [
        [ [2003,4,6,10,0,0],[2003,4,6,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2003,10,26,8,59,59],[2003,10,26,1,59,59],
          '2003040610:00:00','2003040603:00:00','2003102608:59:59','2003102601:59:59' ],
        [ [2003,10,26,9,0,0],[2003,10,26,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2004,4,4,9,59,59],[2004,4,4,1,59,59],
          '2003102609:00:00','2003102601:00:00','2004040409:59:59','2004040401:59:59' ],
     ],
   2004 =>
     [
        [ [2004,4,4,10,0,0],[2004,4,4,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2004,10,31,8,59,59],[2004,10,31,1,59,59],
          '2004040410:00:00','2004040403:00:00','2004103108:59:59','2004103101:59:59' ],
        [ [2004,10,31,9,0,0],[2004,10,31,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2005,4,3,9,59,59],[2005,4,3,1,59,59],
          '2004103109:00:00','2004103101:00:00','2005040309:59:59','2005040301:59:59' ],
     ],
   2005 =>
     [
        [ [2005,4,3,10,0,0],[2005,4,3,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2005,10,30,8,59,59],[2005,10,30,1,59,59],
          '2005040310:00:00','2005040303:00:00','2005103008:59:59','2005103001:59:59' ],
        [ [2005,10,30,9,0,0],[2005,10,30,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2006,4,2,9,59,59],[2006,4,2,1,59,59],
          '2005103009:00:00','2005103001:00:00','2006040209:59:59','2006040201:59:59' ],
     ],
   2006 =>
     [
        [ [2006,4,2,10,0,0],[2006,4,2,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2006,10,29,8,59,59],[2006,10,29,1,59,59],
          '2006040210:00:00','2006040203:00:00','2006102908:59:59','2006102901:59:59' ],
        [ [2006,10,29,9,0,0],[2006,10,29,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2007,3,11,9,59,59],[2007,3,11,1,59,59],
          '2006102909:00:00','2006102901:00:00','2007031109:59:59','2007031101:59:59' ],
     ],
   2007 =>
     [
        [ [2007,3,11,10,0,0],[2007,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2007,11,4,8,59,59],[2007,11,4,1,59,59],
          '2007031110:00:00','2007031103:00:00','2007110408:59:59','2007110401:59:59' ],
        [ [2007,11,4,9,0,0],[2007,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2008,3,9,9,59,59],[2008,3,9,1,59,59],
          '2007110409:00:00','2007110401:00:00','2008030909:59:59','2008030901:59:59' ],
     ],
   2008 =>
     [
        [ [2008,3,9,10,0,0],[2008,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2008,11,2,8,59,59],[2008,11,2,1,59,59],
          '2008030910:00:00','2008030903:00:00','2008110208:59:59','2008110201:59:59' ],
        [ [2008,11,2,9,0,0],[2008,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2009,3,8,9,59,59],[2009,3,8,1,59,59],
          '2008110209:00:00','2008110201:00:00','2009030809:59:59','2009030801:59:59' ],
     ],
   2009 =>
     [
        [ [2009,3,8,10,0,0],[2009,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2009,11,1,8,59,59],[2009,11,1,1,59,59],
          '2009030810:00:00','2009030803:00:00','2009110108:59:59','2009110101:59:59' ],
        [ [2009,11,1,9,0,0],[2009,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2010,3,14,9,59,59],[2010,3,14,1,59,59],
          '2009110109:00:00','2009110101:00:00','2010031409:59:59','2010031401:59:59' ],
     ],
   2010 =>
     [
        [ [2010,3,14,10,0,0],[2010,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2010,11,7,8,59,59],[2010,11,7,1,59,59],
          '2010031410:00:00','2010031403:00:00','2010110708:59:59','2010110701:59:59' ],
        [ [2010,11,7,9,0,0],[2010,11,7,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2011,3,13,9,59,59],[2011,3,13,1,59,59],
          '2010110709:00:00','2010110701:00:00','2011031309:59:59','2011031301:59:59' ],
     ],
   2011 =>
     [
        [ [2011,3,13,10,0,0],[2011,3,13,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2011,11,6,8,59,59],[2011,11,6,1,59,59],
          '2011031310:00:00','2011031303:00:00','2011110608:59:59','2011110601:59:59' ],
        [ [2011,11,6,9,0,0],[2011,11,6,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2012,3,11,9,59,59],[2012,3,11,1,59,59],
          '2011110609:00:00','2011110601:00:00','2012031109:59:59','2012031101:59:59' ],
     ],
   2012 =>
     [
        [ [2012,3,11,10,0,0],[2012,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2012,11,4,8,59,59],[2012,11,4,1,59,59],
          '2012031110:00:00','2012031103:00:00','2012110408:59:59','2012110401:59:59' ],
        [ [2012,11,4,9,0,0],[2012,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2013,3,10,9,59,59],[2013,3,10,1,59,59],
          '2012110409:00:00','2012110401:00:00','2013031009:59:59','2013031001:59:59' ],
     ],
   2013 =>
     [
        [ [2013,3,10,10,0,0],[2013,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2013,11,3,8,59,59],[2013,11,3,1,59,59],
          '2013031010:00:00','2013031003:00:00','2013110308:59:59','2013110301:59:59' ],
        [ [2013,11,3,9,0,0],[2013,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2014,3,9,9,59,59],[2014,3,9,1,59,59],
          '2013110309:00:00','2013110301:00:00','2014030909:59:59','2014030901:59:59' ],
     ],
   2014 =>
     [
        [ [2014,3,9,10,0,0],[2014,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2014,11,2,8,59,59],[2014,11,2,1,59,59],
          '2014030910:00:00','2014030903:00:00','2014110208:59:59','2014110201:59:59' ],
        [ [2014,11,2,9,0,0],[2014,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2015,3,8,9,59,59],[2015,3,8,1,59,59],
          '2014110209:00:00','2014110201:00:00','2015030809:59:59','2015030801:59:59' ],
     ],
   2015 =>
     [
        [ [2015,3,8,10,0,0],[2015,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2015,11,1,8,59,59],[2015,11,1,1,59,59],
          '2015030810:00:00','2015030803:00:00','2015110108:59:59','2015110101:59:59' ],
        [ [2015,11,1,9,0,0],[2015,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2016,3,13,9,59,59],[2016,3,13,1,59,59],
          '2015110109:00:00','2015110101:00:00','2016031309:59:59','2016031301:59:59' ],
     ],
   2016 =>
     [
        [ [2016,3,13,10,0,0],[2016,3,13,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2016,11,6,8,59,59],[2016,11,6,1,59,59],
          '2016031310:00:00','2016031303:00:00','2016110608:59:59','2016110601:59:59' ],
        [ [2016,11,6,9,0,0],[2016,11,6,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2017,3,12,9,59,59],[2017,3,12,1,59,59],
          '2016110609:00:00','2016110601:00:00','2017031209:59:59','2017031201:59:59' ],
     ],
   2017 =>
     [
        [ [2017,3,12,10,0,0],[2017,3,12,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2017,11,5,8,59,59],[2017,11,5,1,59,59],
          '2017031210:00:00','2017031203:00:00','2017110508:59:59','2017110501:59:59' ],
        [ [2017,11,5,9,0,0],[2017,11,5,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2018,3,11,9,59,59],[2018,3,11,1,59,59],
          '2017110509:00:00','2017110501:00:00','2018031109:59:59','2018031101:59:59' ],
     ],
   2018 =>
     [
        [ [2018,3,11,10,0,0],[2018,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2018,11,4,8,59,59],[2018,11,4,1,59,59],
          '2018031110:00:00','2018031103:00:00','2018110408:59:59','2018110401:59:59' ],
        [ [2018,11,4,9,0,0],[2018,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2019,3,10,9,59,59],[2019,3,10,1,59,59],
          '2018110409:00:00','2018110401:00:00','2019031009:59:59','2019031001:59:59' ],
     ],
   2019 =>
     [
        [ [2019,3,10,10,0,0],[2019,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2019,11,3,8,59,59],[2019,11,3,1,59,59],
          '2019031010:00:00','2019031003:00:00','2019110308:59:59','2019110301:59:59' ],
        [ [2019,11,3,9,0,0],[2019,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2020,3,8,9,59,59],[2020,3,8,1,59,59],
          '2019110309:00:00','2019110301:00:00','2020030809:59:59','2020030801:59:59' ],
     ],
   2020 =>
     [
        [ [2020,3,8,10,0,0],[2020,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2020,11,1,8,59,59],[2020,11,1,1,59,59],
          '2020030810:00:00','2020030803:00:00','2020110108:59:59','2020110101:59:59' ],
        [ [2020,11,1,9,0,0],[2020,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2021,3,14,9,59,59],[2021,3,14,1,59,59],
          '2020110109:00:00','2020110101:00:00','2021031409:59:59','2021031401:59:59' ],
     ],
   2021 =>
     [
        [ [2021,3,14,10,0,0],[2021,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2021,11,7,8,59,59],[2021,11,7,1,59,59],
          '2021031410:00:00','2021031403:00:00','2021110708:59:59','2021110701:59:59' ],
        [ [2021,11,7,9,0,0],[2021,11,7,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2022,3,13,9,59,59],[2022,3,13,1,59,59],
          '2021110709:00:00','2021110701:00:00','2022031309:59:59','2022031301:59:59' ],
     ],
   2022 =>
     [
        [ [2022,3,13,10,0,0],[2022,3,13,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2022,11,6,8,59,59],[2022,11,6,1,59,59],
          '2022031310:00:00','2022031303:00:00','2022110608:59:59','2022110601:59:59' ],
        [ [2022,11,6,9,0,0],[2022,11,6,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2023,3,12,9,59,59],[2023,3,12,1,59,59],
          '2022110609:00:00','2022110601:00:00','2023031209:59:59','2023031201:59:59' ],
     ],
   2023 =>
     [
        [ [2023,3,12,10,0,0],[2023,3,12,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2023,11,5,8,59,59],[2023,11,5,1,59,59],
          '2023031210:00:00','2023031203:00:00','2023110508:59:59','2023110501:59:59' ],
        [ [2023,11,5,9,0,0],[2023,11,5,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2024,3,10,9,59,59],[2024,3,10,1,59,59],
          '2023110509:00:00','2023110501:00:00','2024031009:59:59','2024031001:59:59' ],
     ],
   2024 =>
     [
        [ [2024,3,10,10,0,0],[2024,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2024,11,3,8,59,59],[2024,11,3,1,59,59],
          '2024031010:00:00','2024031003:00:00','2024110308:59:59','2024110301:59:59' ],
        [ [2024,11,3,9,0,0],[2024,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2025,3,9,9,59,59],[2025,3,9,1,59,59],
          '2024110309:00:00','2024110301:00:00','2025030909:59:59','2025030901:59:59' ],
     ],
   2025 =>
     [
        [ [2025,3,9,10,0,0],[2025,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2025,11,2,8,59,59],[2025,11,2,1,59,59],
          '2025030910:00:00','2025030903:00:00','2025110208:59:59','2025110201:59:59' ],
        [ [2025,11,2,9,0,0],[2025,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2026,3,8,9,59,59],[2026,3,8,1,59,59],
          '2025110209:00:00','2025110201:00:00','2026030809:59:59','2026030801:59:59' ],
     ],
   2026 =>
     [
        [ [2026,3,8,10,0,0],[2026,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2026,11,1,8,59,59],[2026,11,1,1,59,59],
          '2026030810:00:00','2026030803:00:00','2026110108:59:59','2026110101:59:59' ],
        [ [2026,11,1,9,0,0],[2026,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2027,3,14,9,59,59],[2027,3,14,1,59,59],
          '2026110109:00:00','2026110101:00:00','2027031409:59:59','2027031401:59:59' ],
     ],
   2027 =>
     [
        [ [2027,3,14,10,0,0],[2027,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2027,11,7,8,59,59],[2027,11,7,1,59,59],
          '2027031410:00:00','2027031403:00:00','2027110708:59:59','2027110701:59:59' ],
        [ [2027,11,7,9,0,0],[2027,11,7,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2028,3,12,9,59,59],[2028,3,12,1,59,59],
          '2027110709:00:00','2027110701:00:00','2028031209:59:59','2028031201:59:59' ],
     ],
   2028 =>
     [
        [ [2028,3,12,10,0,0],[2028,3,12,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2028,11,5,8,59,59],[2028,11,5,1,59,59],
          '2028031210:00:00','2028031203:00:00','2028110508:59:59','2028110501:59:59' ],
        [ [2028,11,5,9,0,0],[2028,11,5,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2029,3,11,9,59,59],[2029,3,11,1,59,59],
          '2028110509:00:00','2028110501:00:00','2029031109:59:59','2029031101:59:59' ],
     ],
   2029 =>
     [
        [ [2029,3,11,10,0,0],[2029,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2029,11,4,8,59,59],[2029,11,4,1,59,59],
          '2029031110:00:00','2029031103:00:00','2029110408:59:59','2029110401:59:59' ],
        [ [2029,11,4,9,0,0],[2029,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2030,3,10,9,59,59],[2030,3,10,1,59,59],
          '2029110409:00:00','2029110401:00:00','2030031009:59:59','2030031001:59:59' ],
     ],
   2030 =>
     [
        [ [2030,3,10,10,0,0],[2030,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2030,11,3,8,59,59],[2030,11,3,1,59,59],
          '2030031010:00:00','2030031003:00:00','2030110308:59:59','2030110301:59:59' ],
        [ [2030,11,3,9,0,0],[2030,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2031,3,9,9,59,59],[2031,3,9,1,59,59],
          '2030110309:00:00','2030110301:00:00','2031030909:59:59','2031030901:59:59' ],
     ],
   2031 =>
     [
        [ [2031,3,9,10,0,0],[2031,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2031,11,2,8,59,59],[2031,11,2,1,59,59],
          '2031030910:00:00','2031030903:00:00','2031110208:59:59','2031110201:59:59' ],
        [ [2031,11,2,9,0,0],[2031,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2032,3,14,9,59,59],[2032,3,14,1,59,59],
          '2031110209:00:00','2031110201:00:00','2032031409:59:59','2032031401:59:59' ],
     ],
   2032 =>
     [
        [ [2032,3,14,10,0,0],[2032,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2032,11,7,8,59,59],[2032,11,7,1,59,59],
          '2032031410:00:00','2032031403:00:00','2032110708:59:59','2032110701:59:59' ],
        [ [2032,11,7,9,0,0],[2032,11,7,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2033,3,13,9,59,59],[2033,3,13,1,59,59],
          '2032110709:00:00','2032110701:00:00','2033031309:59:59','2033031301:59:59' ],
     ],
   2033 =>
     [
        [ [2033,3,13,10,0,0],[2033,3,13,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2033,11,6,8,59,59],[2033,11,6,1,59,59],
          '2033031310:00:00','2033031303:00:00','2033110608:59:59','2033110601:59:59' ],
        [ [2033,11,6,9,0,0],[2033,11,6,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2034,3,12,9,59,59],[2034,3,12,1,59,59],
          '2033110609:00:00','2033110601:00:00','2034031209:59:59','2034031201:59:59' ],
     ],
   2034 =>
     [
        [ [2034,3,12,10,0,0],[2034,3,12,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2034,11,5,8,59,59],[2034,11,5,1,59,59],
          '2034031210:00:00','2034031203:00:00','2034110508:59:59','2034110501:59:59' ],
        [ [2034,11,5,9,0,0],[2034,11,5,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2035,3,11,9,59,59],[2035,3,11,1,59,59],
          '2034110509:00:00','2034110501:00:00','2035031109:59:59','2035031101:59:59' ],
     ],
   2035 =>
     [
        [ [2035,3,11,10,0,0],[2035,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2035,11,4,8,59,59],[2035,11,4,1,59,59],
          '2035031110:00:00','2035031103:00:00','2035110408:59:59','2035110401:59:59' ],
        [ [2035,11,4,9,0,0],[2035,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2036,3,9,9,59,59],[2036,3,9,1,59,59],
          '2035110409:00:00','2035110401:00:00','2036030909:59:59','2036030901:59:59' ],
     ],
   2036 =>
     [
        [ [2036,3,9,10,0,0],[2036,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2036,11,2,8,59,59],[2036,11,2,1,59,59],
          '2036030910:00:00','2036030903:00:00','2036110208:59:59','2036110201:59:59' ],
        [ [2036,11,2,9,0,0],[2036,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2037,3,8,9,59,59],[2037,3,8,1,59,59],
          '2036110209:00:00','2036110201:00:00','2037030809:59:59','2037030801:59:59' ],
     ],
   2037 =>
     [
        [ [2037,3,8,10,0,0],[2037,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2037,11,1,8,59,59],[2037,11,1,1,59,59],
          '2037030810:00:00','2037030803:00:00','2037110108:59:59','2037110101:59:59' ],
        [ [2037,11,1,9,0,0],[2037,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2038,3,14,9,59,59],[2038,3,14,1,59,59],
          '2037110109:00:00','2037110101:00:00','2038031409:59:59','2038031401:59:59' ],
     ],
   2038 =>
     [
        [ [2038,3,14,10,0,0],[2038,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2038,11,7,8,59,59],[2038,11,7,1,59,59],
          '2038031410:00:00','2038031403:00:00','2038110708:59:59','2038110701:59:59' ],
        [ [2038,11,7,9,0,0],[2038,11,7,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2039,3,13,9,59,59],[2039,3,13,1,59,59],
          '2038110709:00:00','2038110701:00:00','2039031309:59:59','2039031301:59:59' ],
     ],
   2039 =>
     [
        [ [2039,3,13,10,0,0],[2039,3,13,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2039,11,6,8,59,59],[2039,11,6,1,59,59],
          '2039031310:00:00','2039031303:00:00','2039110608:59:59','2039110601:59:59' ],
        [ [2039,11,6,9,0,0],[2039,11,6,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2040,3,11,9,59,59],[2040,3,11,1,59,59],
          '2039110609:00:00','2039110601:00:00','2040031109:59:59','2040031101:59:59' ],
     ],
   2040 =>
     [
        [ [2040,3,11,10,0,0],[2040,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2040,11,4,8,59,59],[2040,11,4,1,59,59],
          '2040031110:00:00','2040031103:00:00','2040110408:59:59','2040110401:59:59' ],
        [ [2040,11,4,9,0,0],[2040,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2041,3,10,9,59,59],[2041,3,10,1,59,59],
          '2040110409:00:00','2040110401:00:00','2041031009:59:59','2041031001:59:59' ],
     ],
   2041 =>
     [
        [ [2041,3,10,10,0,0],[2041,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2041,11,3,8,59,59],[2041,11,3,1,59,59],
          '2041031010:00:00','2041031003:00:00','2041110308:59:59','2041110301:59:59' ],
        [ [2041,11,3,9,0,0],[2041,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2042,3,9,9,59,59],[2042,3,9,1,59,59],
          '2041110309:00:00','2041110301:00:00','2042030909:59:59','2042030901:59:59' ],
     ],
   2042 =>
     [
        [ [2042,3,9,10,0,0],[2042,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2042,11,2,8,59,59],[2042,11,2,1,59,59],
          '2042030910:00:00','2042030903:00:00','2042110208:59:59','2042110201:59:59' ],
        [ [2042,11,2,9,0,0],[2042,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2043,3,8,9,59,59],[2043,3,8,1,59,59],
          '2042110209:00:00','2042110201:00:00','2043030809:59:59','2043030801:59:59' ],
     ],
   2043 =>
     [
        [ [2043,3,8,10,0,0],[2043,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2043,11,1,8,59,59],[2043,11,1,1,59,59],
          '2043030810:00:00','2043030803:00:00','2043110108:59:59','2043110101:59:59' ],
        [ [2043,11,1,9,0,0],[2043,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2044,3,13,9,59,59],[2044,3,13,1,59,59],
          '2043110109:00:00','2043110101:00:00','2044031309:59:59','2044031301:59:59' ],
     ],
   2044 =>
     [
        [ [2044,3,13,10,0,0],[2044,3,13,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2044,11,6,8,59,59],[2044,11,6,1,59,59],
          '2044031310:00:00','2044031303:00:00','2044110608:59:59','2044110601:59:59' ],
        [ [2044,11,6,9,0,0],[2044,11,6,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2045,3,12,9,59,59],[2045,3,12,1,59,59],
          '2044110609:00:00','2044110601:00:00','2045031209:59:59','2045031201:59:59' ],
     ],
   2045 =>
     [
        [ [2045,3,12,10,0,0],[2045,3,12,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2045,11,5,8,59,59],[2045,11,5,1,59,59],
          '2045031210:00:00','2045031203:00:00','2045110508:59:59','2045110501:59:59' ],
        [ [2045,11,5,9,0,0],[2045,11,5,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2046,3,11,9,59,59],[2046,3,11,1,59,59],
          '2045110509:00:00','2045110501:00:00','2046031109:59:59','2046031101:59:59' ],
     ],
   2046 =>
     [
        [ [2046,3,11,10,0,0],[2046,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2046,11,4,8,59,59],[2046,11,4,1,59,59],
          '2046031110:00:00','2046031103:00:00','2046110408:59:59','2046110401:59:59' ],
        [ [2046,11,4,9,0,0],[2046,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2047,3,10,9,59,59],[2047,3,10,1,59,59],
          '2046110409:00:00','2046110401:00:00','2047031009:59:59','2047031001:59:59' ],
     ],
   2047 =>
     [
        [ [2047,3,10,10,0,0],[2047,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2047,11,3,8,59,59],[2047,11,3,1,59,59],
          '2047031010:00:00','2047031003:00:00','2047110308:59:59','2047110301:59:59' ],
        [ [2047,11,3,9,0,0],[2047,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2048,3,8,9,59,59],[2048,3,8,1,59,59],
          '2047110309:00:00','2047110301:00:00','2048030809:59:59','2048030801:59:59' ],
     ],
   2048 =>
     [
        [ [2048,3,8,10,0,0],[2048,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2048,11,1,8,59,59],[2048,11,1,1,59,59],
          '2048030810:00:00','2048030803:00:00','2048110108:59:59','2048110101:59:59' ],
        [ [2048,11,1,9,0,0],[2048,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2049,3,14,9,59,59],[2049,3,14,1,59,59],
          '2048110109:00:00','2048110101:00:00','2049031409:59:59','2049031401:59:59' ],
     ],
   2049 =>
     [
        [ [2049,3,14,10,0,0],[2049,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2049,11,7,8,59,59],[2049,11,7,1,59,59],
          '2049031410:00:00','2049031403:00:00','2049110708:59:59','2049110701:59:59' ],
        [ [2049,11,7,9,0,0],[2049,11,7,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2050,3,13,9,59,59],[2050,3,13,1,59,59],
          '2049110709:00:00','2049110701:00:00','2050031309:59:59','2050031301:59:59' ],
     ],
   2050 =>
     [
        [ [2050,3,13,10,0,0],[2050,3,13,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2050,11,6,8,59,59],[2050,11,6,1,59,59],
          '2050031310:00:00','2050031303:00:00','2050110608:59:59','2050110601:59:59' ],
        [ [2050,11,6,9,0,0],[2050,11,6,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2051,3,12,9,59,59],[2051,3,12,1,59,59],
          '2050110609:00:00','2050110601:00:00','2051031209:59:59','2051031201:59:59' ],
     ],
   2051 =>
     [
        [ [2051,3,12,10,0,0],[2051,3,12,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2051,11,5,8,59,59],[2051,11,5,1,59,59],
          '2051031210:00:00','2051031203:00:00','2051110508:59:59','2051110501:59:59' ],
        [ [2051,11,5,9,0,0],[2051,11,5,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2052,3,10,9,59,59],[2052,3,10,1,59,59],
          '2051110509:00:00','2051110501:00:00','2052031009:59:59','2052031001:59:59' ],
     ],
   2052 =>
     [
        [ [2052,3,10,10,0,0],[2052,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2052,11,3,8,59,59],[2052,11,3,1,59,59],
          '2052031010:00:00','2052031003:00:00','2052110308:59:59','2052110301:59:59' ],
        [ [2052,11,3,9,0,0],[2052,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2053,3,9,9,59,59],[2053,3,9,1,59,59],
          '2052110309:00:00','2052110301:00:00','2053030909:59:59','2053030901:59:59' ],
     ],
   2053 =>
     [
        [ [2053,3,9,10,0,0],[2053,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2053,11,2,8,59,59],[2053,11,2,1,59,59],
          '2053030910:00:00','2053030903:00:00','2053110208:59:59','2053110201:59:59' ],
        [ [2053,11,2,9,0,0],[2053,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2054,3,8,9,59,59],[2054,3,8,1,59,59],
          '2053110209:00:00','2053110201:00:00','2054030809:59:59','2054030801:59:59' ],
     ],
   2054 =>
     [
        [ [2054,3,8,10,0,0],[2054,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2054,11,1,8,59,59],[2054,11,1,1,59,59],
          '2054030810:00:00','2054030803:00:00','2054110108:59:59','2054110101:59:59' ],
        [ [2054,11,1,9,0,0],[2054,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2055,3,14,9,59,59],[2055,3,14,1,59,59],
          '2054110109:00:00','2054110101:00:00','2055031409:59:59','2055031401:59:59' ],
     ],
   2055 =>
     [
        [ [2055,3,14,10,0,0],[2055,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2055,11,7,8,59,59],[2055,11,7,1,59,59],
          '2055031410:00:00','2055031403:00:00','2055110708:59:59','2055110701:59:59' ],
        [ [2055,11,7,9,0,0],[2055,11,7,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2056,3,12,9,59,59],[2056,3,12,1,59,59],
          '2055110709:00:00','2055110701:00:00','2056031209:59:59','2056031201:59:59' ],
     ],
   2056 =>
     [
        [ [2056,3,12,10,0,0],[2056,3,12,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2056,11,5,8,59,59],[2056,11,5,1,59,59],
          '2056031210:00:00','2056031203:00:00','2056110508:59:59','2056110501:59:59' ],
        [ [2056,11,5,9,0,0],[2056,11,5,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2057,3,11,9,59,59],[2057,3,11,1,59,59],
          '2056110509:00:00','2056110501:00:00','2057031109:59:59','2057031101:59:59' ],
     ],
   2057 =>
     [
        [ [2057,3,11,10,0,0],[2057,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2057,11,4,8,59,59],[2057,11,4,1,59,59],
          '2057031110:00:00','2057031103:00:00','2057110408:59:59','2057110401:59:59' ],
        [ [2057,11,4,9,0,0],[2057,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2058,3,10,9,59,59],[2058,3,10,1,59,59],
          '2057110409:00:00','2057110401:00:00','2058031009:59:59','2058031001:59:59' ],
     ],
   2058 =>
     [
        [ [2058,3,10,10,0,0],[2058,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2058,11,3,8,59,59],[2058,11,3,1,59,59],
          '2058031010:00:00','2058031003:00:00','2058110308:59:59','2058110301:59:59' ],
        [ [2058,11,3,9,0,0],[2058,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2059,3,9,9,59,59],[2059,3,9,1,59,59],
          '2058110309:00:00','2058110301:00:00','2059030909:59:59','2059030901:59:59' ],
     ],
   2059 =>
     [
        [ [2059,3,9,10,0,0],[2059,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2059,11,2,8,59,59],[2059,11,2,1,59,59],
          '2059030910:00:00','2059030903:00:00','2059110208:59:59','2059110201:59:59' ],
        [ [2059,11,2,9,0,0],[2059,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2060,3,14,9,59,59],[2060,3,14,1,59,59],
          '2059110209:00:00','2059110201:00:00','2060031409:59:59','2060031401:59:59' ],
     ],
   2060 =>
     [
        [ [2060,3,14,10,0,0],[2060,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2060,11,7,8,59,59],[2060,11,7,1,59,59],
          '2060031410:00:00','2060031403:00:00','2060110708:59:59','2060110701:59:59' ],
        [ [2060,11,7,9,0,0],[2060,11,7,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2061,3,13,9,59,59],[2061,3,13,1,59,59],
          '2060110709:00:00','2060110701:00:00','2061031309:59:59','2061031301:59:59' ],
     ],
   2061 =>
     [
        [ [2061,3,13,10,0,0],[2061,3,13,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2061,11,6,8,59,59],[2061,11,6,1,59,59],
          '2061031310:00:00','2061031303:00:00','2061110608:59:59','2061110601:59:59' ],
        [ [2061,11,6,9,0,0],[2061,11,6,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2062,3,12,9,59,59],[2062,3,12,1,59,59],
          '2061110609:00:00','2061110601:00:00','2062031209:59:59','2062031201:59:59' ],
     ],
   2062 =>
     [
        [ [2062,3,12,10,0,0],[2062,3,12,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2062,11,5,8,59,59],[2062,11,5,1,59,59],
          '2062031210:00:00','2062031203:00:00','2062110508:59:59','2062110501:59:59' ],
        [ [2062,11,5,9,0,0],[2062,11,5,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2063,3,11,9,59,59],[2063,3,11,1,59,59],
          '2062110509:00:00','2062110501:00:00','2063031109:59:59','2063031101:59:59' ],
     ],
   2063 =>
     [
        [ [2063,3,11,10,0,0],[2063,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2063,11,4,8,59,59],[2063,11,4,1,59,59],
          '2063031110:00:00','2063031103:00:00','2063110408:59:59','2063110401:59:59' ],
        [ [2063,11,4,9,0,0],[2063,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2064,3,9,9,59,59],[2064,3,9,1,59,59],
          '2063110409:00:00','2063110401:00:00','2064030909:59:59','2064030901:59:59' ],
     ],
   2064 =>
     [
        [ [2064,3,9,10,0,0],[2064,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2064,11,2,8,59,59],[2064,11,2,1,59,59],
          '2064030910:00:00','2064030903:00:00','2064110208:59:59','2064110201:59:59' ],
        [ [2064,11,2,9,0,0],[2064,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2065,3,8,9,59,59],[2065,3,8,1,59,59],
          '2064110209:00:00','2064110201:00:00','2065030809:59:59','2065030801:59:59' ],
     ],
   2065 =>
     [
        [ [2065,3,8,10,0,0],[2065,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2065,11,1,8,59,59],[2065,11,1,1,59,59],
          '2065030810:00:00','2065030803:00:00','2065110108:59:59','2065110101:59:59' ],
        [ [2065,11,1,9,0,0],[2065,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2066,3,14,9,59,59],[2066,3,14,1,59,59],
          '2065110109:00:00','2065110101:00:00','2066031409:59:59','2066031401:59:59' ],
     ],
   2066 =>
     [
        [ [2066,3,14,10,0,0],[2066,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2066,11,7,8,59,59],[2066,11,7,1,59,59],
          '2066031410:00:00','2066031403:00:00','2066110708:59:59','2066110701:59:59' ],
        [ [2066,11,7,9,0,0],[2066,11,7,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2067,3,13,9,59,59],[2067,3,13,1,59,59],
          '2066110709:00:00','2066110701:00:00','2067031309:59:59','2067031301:59:59' ],
     ],
   2067 =>
     [
        [ [2067,3,13,10,0,0],[2067,3,13,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2067,11,6,8,59,59],[2067,11,6,1,59,59],
          '2067031310:00:00','2067031303:00:00','2067110608:59:59','2067110601:59:59' ],
        [ [2067,11,6,9,0,0],[2067,11,6,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2068,3,11,9,59,59],[2068,3,11,1,59,59],
          '2067110609:00:00','2067110601:00:00','2068031109:59:59','2068031101:59:59' ],
     ],
   2068 =>
     [
        [ [2068,3,11,10,0,0],[2068,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2068,11,4,8,59,59],[2068,11,4,1,59,59],
          '2068031110:00:00','2068031103:00:00','2068110408:59:59','2068110401:59:59' ],
        [ [2068,11,4,9,0,0],[2068,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2069,3,10,9,59,59],[2069,3,10,1,59,59],
          '2068110409:00:00','2068110401:00:00','2069031009:59:59','2069031001:59:59' ],
     ],
   2069 =>
     [
        [ [2069,3,10,10,0,0],[2069,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2069,11,3,8,59,59],[2069,11,3,1,59,59],
          '2069031010:00:00','2069031003:00:00','2069110308:59:59','2069110301:59:59' ],
        [ [2069,11,3,9,0,0],[2069,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2070,3,9,9,59,59],[2070,3,9,1,59,59],
          '2069110309:00:00','2069110301:00:00','2070030909:59:59','2070030901:59:59' ],
     ],
   2070 =>
     [
        [ [2070,3,9,10,0,0],[2070,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2070,11,2,8,59,59],[2070,11,2,1,59,59],
          '2070030910:00:00','2070030903:00:00','2070110208:59:59','2070110201:59:59' ],
        [ [2070,11,2,9,0,0],[2070,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2071,3,8,9,59,59],[2071,3,8,1,59,59],
          '2070110209:00:00','2070110201:00:00','2071030809:59:59','2071030801:59:59' ],
     ],
   2071 =>
     [
        [ [2071,3,8,10,0,0],[2071,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2071,11,1,8,59,59],[2071,11,1,1,59,59],
          '2071030810:00:00','2071030803:00:00','2071110108:59:59','2071110101:59:59' ],
        [ [2071,11,1,9,0,0],[2071,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2072,3,13,9,59,59],[2072,3,13,1,59,59],
          '2071110109:00:00','2071110101:00:00','2072031309:59:59','2072031301:59:59' ],
     ],
   2072 =>
     [
        [ [2072,3,13,10,0,0],[2072,3,13,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2072,11,6,8,59,59],[2072,11,6,1,59,59],
          '2072031310:00:00','2072031303:00:00','2072110608:59:59','2072110601:59:59' ],
        [ [2072,11,6,9,0,0],[2072,11,6,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2073,3,12,9,59,59],[2073,3,12,1,59,59],
          '2072110609:00:00','2072110601:00:00','2073031209:59:59','2073031201:59:59' ],
     ],
   2073 =>
     [
        [ [2073,3,12,10,0,0],[2073,3,12,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2073,11,5,8,59,59],[2073,11,5,1,59,59],
          '2073031210:00:00','2073031203:00:00','2073110508:59:59','2073110501:59:59' ],
        [ [2073,11,5,9,0,0],[2073,11,5,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2074,3,11,9,59,59],[2074,3,11,1,59,59],
          '2073110509:00:00','2073110501:00:00','2074031109:59:59','2074031101:59:59' ],
     ],
   2074 =>
     [
        [ [2074,3,11,10,0,0],[2074,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2074,11,4,8,59,59],[2074,11,4,1,59,59],
          '2074031110:00:00','2074031103:00:00','2074110408:59:59','2074110401:59:59' ],
        [ [2074,11,4,9,0,0],[2074,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2075,3,10,9,59,59],[2075,3,10,1,59,59],
          '2074110409:00:00','2074110401:00:00','2075031009:59:59','2075031001:59:59' ],
     ],
   2075 =>
     [
        [ [2075,3,10,10,0,0],[2075,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2075,11,3,8,59,59],[2075,11,3,1,59,59],
          '2075031010:00:00','2075031003:00:00','2075110308:59:59','2075110301:59:59' ],
        [ [2075,11,3,9,0,0],[2075,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2076,3,8,9,59,59],[2076,3,8,1,59,59],
          '2075110309:00:00','2075110301:00:00','2076030809:59:59','2076030801:59:59' ],
     ],
   2076 =>
     [
        [ [2076,3,8,10,0,0],[2076,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2076,11,1,8,59,59],[2076,11,1,1,59,59],
          '2076030810:00:00','2076030803:00:00','2076110108:59:59','2076110101:59:59' ],
        [ [2076,11,1,9,0,0],[2076,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2077,3,14,9,59,59],[2077,3,14,1,59,59],
          '2076110109:00:00','2076110101:00:00','2077031409:59:59','2077031401:59:59' ],
     ],
   2077 =>
     [
        [ [2077,3,14,10,0,0],[2077,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2077,11,7,8,59,59],[2077,11,7,1,59,59],
          '2077031410:00:00','2077031403:00:00','2077110708:59:59','2077110701:59:59' ],
        [ [2077,11,7,9,0,0],[2077,11,7,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2078,3,13,9,59,59],[2078,3,13,1,59,59],
          '2077110709:00:00','2077110701:00:00','2078031309:59:59','2078031301:59:59' ],
     ],
   2078 =>
     [
        [ [2078,3,13,10,0,0],[2078,3,13,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2078,11,6,8,59,59],[2078,11,6,1,59,59],
          '2078031310:00:00','2078031303:00:00','2078110608:59:59','2078110601:59:59' ],
        [ [2078,11,6,9,0,0],[2078,11,6,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2079,3,12,9,59,59],[2079,3,12,1,59,59],
          '2078110609:00:00','2078110601:00:00','2079031209:59:59','2079031201:59:59' ],
     ],
   2079 =>
     [
        [ [2079,3,12,10,0,0],[2079,3,12,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2079,11,5,8,59,59],[2079,11,5,1,59,59],
          '2079031210:00:00','2079031203:00:00','2079110508:59:59','2079110501:59:59' ],
        [ [2079,11,5,9,0,0],[2079,11,5,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2080,3,10,9,59,59],[2080,3,10,1,59,59],
          '2079110509:00:00','2079110501:00:00','2080031009:59:59','2080031001:59:59' ],
     ],
   2080 =>
     [
        [ [2080,3,10,10,0,0],[2080,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2080,11,3,8,59,59],[2080,11,3,1,59,59],
          '2080031010:00:00','2080031003:00:00','2080110308:59:59','2080110301:59:59' ],
        [ [2080,11,3,9,0,0],[2080,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2081,3,9,9,59,59],[2081,3,9,1,59,59],
          '2080110309:00:00','2080110301:00:00','2081030909:59:59','2081030901:59:59' ],
     ],
   2081 =>
     [
        [ [2081,3,9,10,0,0],[2081,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2081,11,2,8,59,59],[2081,11,2,1,59,59],
          '2081030910:00:00','2081030903:00:00','2081110208:59:59','2081110201:59:59' ],
        [ [2081,11,2,9,0,0],[2081,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2082,3,8,9,59,59],[2082,3,8,1,59,59],
          '2081110209:00:00','2081110201:00:00','2082030809:59:59','2082030801:59:59' ],
     ],
   2082 =>
     [
        [ [2082,3,8,10,0,0],[2082,3,8,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2082,11,1,8,59,59],[2082,11,1,1,59,59],
          '2082030810:00:00','2082030803:00:00','2082110108:59:59','2082110101:59:59' ],
        [ [2082,11,1,9,0,0],[2082,11,1,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2083,3,14,9,59,59],[2083,3,14,1,59,59],
          '2082110109:00:00','2082110101:00:00','2083031409:59:59','2083031401:59:59' ],
     ],
   2083 =>
     [
        [ [2083,3,14,10,0,0],[2083,3,14,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2083,11,7,8,59,59],[2083,11,7,1,59,59],
          '2083031410:00:00','2083031403:00:00','2083110708:59:59','2083110701:59:59' ],
        [ [2083,11,7,9,0,0],[2083,11,7,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2084,3,12,9,59,59],[2084,3,12,1,59,59],
          '2083110709:00:00','2083110701:00:00','2084031209:59:59','2084031201:59:59' ],
     ],
   2084 =>
     [
        [ [2084,3,12,10,0,0],[2084,3,12,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2084,11,5,8,59,59],[2084,11,5,1,59,59],
          '2084031210:00:00','2084031203:00:00','2084110508:59:59','2084110501:59:59' ],
        [ [2084,11,5,9,0,0],[2084,11,5,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2085,3,11,9,59,59],[2085,3,11,1,59,59],
          '2084110509:00:00','2084110501:00:00','2085031109:59:59','2085031101:59:59' ],
     ],
   2085 =>
     [
        [ [2085,3,11,10,0,0],[2085,3,11,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2085,11,4,8,59,59],[2085,11,4,1,59,59],
          '2085031110:00:00','2085031103:00:00','2085110408:59:59','2085110401:59:59' ],
        [ [2085,11,4,9,0,0],[2085,11,4,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2086,3,10,9,59,59],[2086,3,10,1,59,59],
          '2085110409:00:00','2085110401:00:00','2086031009:59:59','2086031001:59:59' ],
     ],
   2086 =>
     [
        [ [2086,3,10,10,0,0],[2086,3,10,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2086,11,3,8,59,59],[2086,11,3,1,59,59],
          '2086031010:00:00','2086031003:00:00','2086110308:59:59','2086110301:59:59' ],
        [ [2086,11,3,9,0,0],[2086,11,3,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2087,3,9,9,59,59],[2087,3,9,1,59,59],
          '2086110309:00:00','2086110301:00:00','2087030909:59:59','2087030901:59:59' ],
     ],
   2087 =>
     [
        [ [2087,3,9,10,0,0],[2087,3,9,3,0,0],'-07:00:00',[-7,0,0],
          'PDT',1,[2087,11,2,8,59,59],[2087,11,2,1,59,59],
          '2087030910:00:00','2087030903:00:00','2087110208:59:59','2087110201:59:59' ],
        [ [2087,11,2,9,0,0],[2087,11,2,1,0,0],'-08:00:00',[-8,0,0],
          'PST',0,[2088,3,14,9,59,59],[2088,3,14,1,59,59],
          '2087110209:00:00','2087110201:00:00','2088031409:59:59','2088031401:59:59' ],
     ],
);

%LastRule      = (
   'zone'   => {
                'dstoff' => '-07:00:00',
                'stdoff' => '-08:00:00',
               },
   'rules'  => {
                '03' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '8',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '1',
                         'abb'     => 'PDT',
                        },
                '11' => {
                         'flag'    => 'ge',
                         'dow'     => '7',
                         'num'     => '1',
                         'type'    => 'w',
                         'time'    => '02:00:00',
                         'isdst'   => '0',
                         'abb'     => 'PST',
                        },
               },
);

1;
