/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.core;

import java.io.IOException;
import javax.servlet.ServletException;
import org.apache.catalina.Host;
import org.apache.catalina.comet.CometEvent;
import org.apache.catalina.connector.Request;
import org.apache.catalina.connector.Response;
import org.apache.catalina.valves.ValveBase;
import org.apache.tomcat.util.res.StringManager;

final class StandardEngineValve
extends ValveBase {
    private static final String info = "org.apache.catalina.core.StandardEngineValve/1.0";
    private static final StringManager sm = StringManager.getManager((String)"org.apache.catalina.core");

    public StandardEngineValve() {
        super(true);
    }

    @Override
    public String getInfo() {
        return info;
    }

    @Override
    public final void invoke(Request request, Response response) throws IOException, ServletException {
        Host host = request.getHost();
        if (host == null) {
            response.sendError(400, sm.getString("standardEngine.noHost", new Object[]{request.getServerName()}));
            return;
        }
        if (request.isAsyncSupported()) {
            request.setAsyncSupported(host.getPipeline().isAsyncSupported());
        }
        host.getPipeline().getFirst().invoke(request, response);
    }

    @Override
    public final void event(Request request, Response response, CometEvent event) throws IOException, ServletException {
        request.getHost().getPipeline().getFirst().event(request, response, event);
    }
}

