/*
 * Decompiled with CFR 0.152.
 */
package groovy.lang;

import [Ljava.lang.Object;;
import groovy.lang.Closure;
import groovy.lang.GroovyObject;
import groovy.lang.GroovyRuntimeException;
import groovy.lang.MetaArrayLengthProperty;
import groovy.lang.MetaBeanProperty;
import groovy.lang.MetaClass;
import groovy.lang.MetaClassRegistry;
import groovy.lang.MetaFieldProperty;
import groovy.lang.MetaMethod;
import groovy.lang.MetaProperty;
import groovy.lang.MissingFieldException;
import groovy.lang.MissingMethodException;
import groovy.lang.MissingPropertyException;
import java.beans.BeanInfo;
import java.beans.EventSetDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.classgen.BytecodeHelper;
import org.codehaus.groovy.runtime.CurriedClosure;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.DefaultMethodKey;
import org.codehaus.groovy.runtime.GroovyCategorySupport;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.MetaClassHelper;
import org.codehaus.groovy.runtime.MethodClosure;
import org.codehaus.groovy.runtime.MethodKey;
import org.codehaus.groovy.runtime.NewInstanceMetaMethod;
import org.codehaus.groovy.runtime.NewStaticMetaMethod;
import org.codehaus.groovy.runtime.ReflectionMetaMethod;
import org.codehaus.groovy.runtime.Reflector;
import org.codehaus.groovy.runtime.TransformMetaMethod;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.wrappers.Wrapper;

public class MetaClassImpl
extends MetaClass {
    protected MetaClassRegistry registry;
    private Map classMethodIndex = new HashMap();
    private Map classMethodIndexForSuper;
    private Map classStaticMethodIndex = new HashMap();
    private Map classPropertyIndex = new HashMap();
    private Map classPropertyIndexForSuper = new HashMap();
    private Map staticPropertyIndex = new HashMap();
    private Map listeners = new HashMap();
    private Map methodCache = Collections.synchronizedMap(new HashMap());
    private Map staticMethodCache = Collections.synchronizedMap(new HashMap());
    private MetaMethod genericGetMethod;
    private MetaMethod genericSetMethod;
    private List constructors;
    private List allMethods = new ArrayList();
    private List interfaceMethods;
    private Reflector reflector;
    private boolean initialized;
    private MetaProperty arrayLengthProperty = new MetaArrayLengthProperty();
    private static final MetaMethod AMBIGOUS_LISTENER_METHOD = new MetaMethod(null, null, new Class[0], null, 0);
    private static final Object[] EMPTY_ARGUMENTS = new Object[0];
    private List newGroovyMethodsList = new LinkedList();
    static /* synthetic */ Class class$java$lang$Void;

    public MetaClassImpl(MetaClassRegistry registry, final Class theClass) {
        super(theClass);
        this.registry = registry;
        this.constructors = (List)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Arrays.asList(theClass.getDeclaredConstructors());
            }
        });
    }

    private void fillMethodIndex() {
        LinkedList superClasses = this.getSuperClasses();
        Iterator iter = superClasses.iterator();
        while (iter.hasNext()) {
            Class c = (Class)iter.next();
            this.addMethods(c);
        }
        HashSet interfaces = new HashSet();
        MetaClassImpl.makeInterfaceSet(this.theClass, interfaces);
        this.inheritMethods(superClasses, this.classMethodIndex);
        this.inheritInterfaceMethods(interfaces);
        this.copyClassMethodIndexForSuper();
        this.connectMultimethods(superClasses);
        this.populateInterfaces(interfaces);
        this.removeMultimethodsOverloadedWithPrivateMethods();
        this.replaceWithMOPCalls();
    }

    private LinkedList getSuperClasses() {
        LinkedList<Class> superClasses = new LinkedList<Class>();
        for (Class c = this.theClass; c != null; c = c.getSuperclass()) {
            superClasses.addFirst(c);
        }
        if (this.theClass.isArray() && this.theClass != Object;.class && !this.theClass.getComponentType().isPrimitive()) {
            superClasses.addFirst(Object;.class);
        }
        return superClasses;
    }

    private void removeMultimethodsOverloadedWithPrivateMethods() {
        HashMap privates = new HashMap();
        MethodIndexAction mia = new MethodIndexAction(){

            public List methodNameAction(Class clazz, String methodName, List methods) {
                boolean hasPrivate = false;
                Iterator iter = methods.iterator();
                while (iter.hasNext()) {
                    MetaMethod method = (MetaMethod)iter.next();
                    if (!method.isPrivate() || clazz != method.getDeclaringClass()) continue;
                    hasPrivate = true;
                    break;
                }
                if (!hasPrivate) {
                    return null;
                }
                methods.clear();
                methods.addAll((Collection)((Map)MetaClassImpl.this.classMethodIndexForSuper.get(clazz)).get(methodName));
                return methods;
            }

            public boolean replaceMethodList() {
                return false;
            }
        };
        mia.iterate(this.classMethodIndex);
    }

    private void replaceWithMOPCalls() {
        if (!GroovyObject.class.isAssignableFrom(this.theClass)) {
            return;
        }
        Map mainClassMethodIndex = (Map)this.classMethodIndex.get(this.theClass);
        class MOPIter
        extends MethodIndexAction {
            boolean useThis;
            private final /* synthetic */ Map val$mainClassMethodIndex;

            MOPIter(Map map) {
                this.val$mainClassMethodIndex = map;
            }

            public boolean skipClass(Class clazz) {
                return !this.useThis && clazz == MetaClassImpl.this.theClass;
            }

            public void methodListAction(Class clazz, String methodName, MetaMethod method, List oldList, List newList) {
                String mopName = MetaClassImpl.this.getMOPMethodName(method.getDeclaringClass(), methodName, this.useThis);
                ArrayList matches = (ArrayList)this.val$mainClassMethodIndex.get(mopName);
                if (matches == null) {
                    newList.add(method);
                    return;
                }
                MetaMethod matchingMethod = MetaClassImpl.this.removeMatchingMethod(matches = new ArrayList(matches), method);
                if (matchingMethod == null) {
                    newList.add(method);
                    return;
                }
                newList.add(matchingMethod);
            }
        }
        MOPIter iter = new MOPIter(mainClassMethodIndex);
        iter.useThis = false;
        iter.iterate(this.classMethodIndexForSuper);
        iter.useThis = true;
        iter.iterate(this.classMethodIndex);
    }

    private String getMOPMethodName(Class declaringClass, String name, boolean useThis) {
        int distance = 0;
        while (declaringClass != null) {
            ++distance;
            declaringClass = declaringClass.getSuperclass();
        }
        return (useThis ? "this" : "super") + "$" + distance + "$" + name;
    }

    private void copyClassMethodIndexForSuper() {
        this.classMethodIndexForSuper = new HashMap(this.classMethodIndex.size());
        Iterator iter = this.classMethodIndex.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry cmiEntry = iter.next();
            Map methodIndex = (Map)cmiEntry.getValue();
            HashMap copy = new HashMap(methodIndex.size());
            Iterator iterator = methodIndex.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry mEntry = iterator.next();
                copy.put(mEntry.getKey(), new ArrayList((List)mEntry.getValue()));
            }
            this.classMethodIndexForSuper.put(cmiEntry.getKey(), copy);
        }
    }

    private void inheritInterfaceMethods(Set interfaces) {
        Class<?> dgmClass;
        Method element;
        List methods = this.registry.getInstanceMethods();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            Map methodIndex;
            ArrayList<NewInstanceMetaMethod> list;
            element = (Method)iter.next();
            dgmClass = element.getParameterTypes()[0];
            if (!interfaces.contains(dgmClass)) continue;
            NewInstanceMetaMethod method = new NewInstanceMetaMethod(this.createMetaMethod(element));
            if (!this.newGroovyMethodsList.contains(method)) {
                this.newGroovyMethodsList.add(method);
            }
            if ((list = (ArrayList<NewInstanceMetaMethod>)(methodIndex = (Map)this.classMethodIndex.get(this.theClass)).get(method.getName())) == null) {
                list = new ArrayList<NewInstanceMetaMethod>();
                methodIndex.put(method.getName(), list);
                list.add(method);
                continue;
            }
            this.addMethodToList(list, method);
        }
        methods = this.registry.getStaticMethods();
        iter = methods.iterator();
        while (iter.hasNext()) {
            element = (Method)iter.next();
            dgmClass = element.getParameterTypes()[0];
            if (!interfaces.contains(dgmClass)) continue;
            this.addNewStaticMethod(element);
        }
    }

    private void populateInterfaces(Set interfaces) {
        Map currentIndex = (Map)this.classMethodIndex.get(this.theClass);
        HashMap index = new HashMap();
        this.copyNonPrivateMethods(currentIndex, index);
        Iterator iter = interfaces.iterator();
        while (iter.hasNext()) {
            Class iClass = (Class)iter.next();
            Map methodIndex = (Map)this.classMethodIndex.get(iClass);
            if (methodIndex == null || methodIndex.size() == 0) {
                this.classMethodIndex.put(iClass, index);
                continue;
            }
            this.copyNonPrivateMethods(currentIndex, methodIndex);
        }
    }

    private static void makeInterfaceSet(Class c, Set s) {
        if (c == null) {
            return;
        }
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (s.contains(interfaces[i])) continue;
            s.add(interfaces[i]);
            MetaClassImpl.makeInterfaceSet(interfaces[i], s);
        }
        MetaClassImpl.makeInterfaceSet(c.getSuperclass(), s);
    }

    private void copyNonPrivateMethods(Map from, Map to) {
        Iterator iterator = from.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element = iterator.next();
            List oldList = (List)element.getValue();
            List newList = (List)to.get(element.getKey());
            if (newList == null) {
                to.put(element.getKey(), new ArrayList(oldList));
                continue;
            }
            this.addNonPrivateMethods(newList, oldList);
        }
    }

    private void connectMultimethods(List superClasses) {
        superClasses = DefaultGroovyMethods.reverse(superClasses);
        Map last = null;
        Iterator iter = superClasses.iterator();
        while (iter.hasNext()) {
            Class c = (Class)iter.next();
            Map methodIndex = (Map)this.classMethodIndex.get(c);
            if (methodIndex == last) continue;
            if (last != null) {
                this.copyNonPrivateMethods(last, methodIndex);
            }
            last = methodIndex;
        }
    }

    private void inheritMethods(Collection superClasses, Map classMethodIndex) {
        Map last = null;
        Iterator iter = superClasses.iterator();
        while (iter.hasNext()) {
            Class c = (Class)iter.next();
            Map methodIndex = (Map)classMethodIndex.get(c);
            if (last != null) {
                if (methodIndex.size() == 0) {
                    classMethodIndex.put(c, last);
                    continue;
                }
                this.copyNonPrivateMethods(last, methodIndex);
            }
            last = methodIndex;
        }
    }

    private void addNonPrivateMethods(List newList, List oldList) {
        Iterator iter = oldList.iterator();
        while (iter.hasNext()) {
            MetaMethod element = (MetaMethod)iter.next();
            if (element.isPrivate()) continue;
            this.addMethodToList(newList, element);
        }
    }

    private List getMethods(Class sender, String name, boolean isCallToSuper) {
        List used;
        List answer;
        Map methodIndex = isCallToSuper ? (Map)this.classMethodIndexForSuper.get(sender) : (Map)this.classMethodIndex.get(sender);
        if (methodIndex != null) {
            answer = (List)methodIndex.get(name);
            if (answer == null) {
                answer = Collections.EMPTY_LIST;
            }
        } else {
            answer = Collections.EMPTY_LIST;
        }
        if (!isCallToSuper && GroovyCategorySupport.hasCategoryInAnyThread() && (used = GroovyCategorySupport.getCategoryMethods(sender, name)) != null) {
            answer = new ArrayList(answer);
            Iterator iter = used.iterator();
            while (iter.hasNext()) {
                MetaMethod element = (MetaMethod)iter.next();
                this.removeMatchingMethod(answer, element);
            }
            answer.addAll(used);
        }
        return answer;
    }

    private List getStaticMethods(Class sender, String name) {
        Map methodIndex = (Map)this.classStaticMethodIndex.get(sender);
        if (methodIndex == null) {
            return Collections.EMPTY_LIST;
        }
        List answer = (List)methodIndex.get(name);
        if (answer == null) {
            return Collections.EMPTY_LIST;
        }
        return answer;
    }

    public void addNewInstanceMethod(Method method) {
        NewInstanceMetaMethod newMethod = new NewInstanceMetaMethod(this.createMetaMethod(method));
        if (!this.newGroovyMethodsList.contains(newMethod)) {
            this.newGroovyMethodsList.add(newMethod);
            this.addMetaMethod(newMethod);
        }
    }

    public void addNewStaticMethod(Method method) {
        NewStaticMetaMethod newMethod = new NewStaticMetaMethod(this.createMetaMethod(method));
        if (!this.newGroovyMethodsList.contains(newMethod)) {
            this.newGroovyMethodsList.add(newMethod);
            this.addMetaMethod(newMethod);
        }
    }

    private void unwrap(Object[] arguments) {
        for (int i = 0; i != arguments.length; ++i) {
            if (!(arguments[i] instanceof Wrapper)) continue;
            arguments[i] = ((Wrapper)arguments[i]).unwrap();
        }
    }

    public Object invokeMethod(Object object, String methodName, Object[] originalArguments) {
        return this.invokeMethod(this.theClass, object, methodName, originalArguments, false, false);
    }

    public Object invokeMethod(Class sender, Object object, String methodName, Object[] originalArguments, boolean isCallToSuper, boolean fromInsideClass) {
        Object[] newArguments;
        Class[] newArgClasses;
        Object[] arguments;
        this.checkInitalised();
        if (object == null) {
            throw new NullPointerException("Cannot invoke method: " + methodName + " on null object");
        }
        if (log.isLoggable(Level.FINER)) {
            MetaClassHelper.logMethodCall(object, methodName, originalArguments);
        }
        if ((arguments = originalArguments) == null) {
            arguments = EMPTY_ARGUMENTS;
        }
        Class[] argClasses = MetaClassHelper.convertToTypeArray(arguments);
        this.unwrap(arguments);
        MetaMethod method = this.getMethodWithCaching(sender, methodName, argClasses, isCallToSuper);
        if (method == null && arguments.length == 1 && arguments[0] instanceof List && (method = this.getMethodWithCaching(sender, methodName, newArgClasses = MetaClassHelper.convertToTypeArray(newArguments = ((List)arguments[0]).toArray()), isCallToSuper)) != null) {
            DefaultMethodKey methodKey = new DefaultMethodKey(sender, methodName, argClasses, isCallToSuper);
            method = new TransformMetaMethod(method){

                public Object invoke(Object object, Object[] arguments) {
                    Object firstArgument = arguments[0];
                    List list = (List)firstArgument;
                    arguments = list.toArray();
                    return super.invoke(object, arguments);
                }
            };
            this.cacheInstanceMethod(methodKey, method);
            return this.invokeMethod(sender, object, methodName, originalArguments, isCallToSuper, fromInsideClass);
        }
        boolean isClosure = object instanceof Closure;
        if (isClosure) {
            Closure closure = (Closure)object;
            Object delegate = closure.getDelegate();
            Object owner = closure.getOwner();
            if ("call".equals(methodName) || "doCall".equals(methodName)) {
                if (object.getClass() == MethodClosure.class) {
                    MethodClosure mc = (MethodClosure)object;
                    methodName = mc.getMethod();
                    Class ownerClass = owner.getClass();
                    if (owner instanceof Class) {
                        ownerClass = (Class)owner;
                    }
                    MetaClass ownerMetaClass = this.registry.getMetaClass(ownerClass);
                    return ownerMetaClass.invokeMethod(ownerClass, owner, methodName, arguments, false, false);
                }
                if (object.getClass() == CurriedClosure.class) {
                    CurriedClosure cc = (CurriedClosure)object;
                    arguments = cc.getUncurriedArguments(arguments);
                    Class ownerClass = owner.getClass();
                    if (owner instanceof Class) {
                        ownerClass = (Class)owner;
                    }
                    MetaClass ownerMetaClass = this.registry.getMetaClass(ownerClass);
                    return ownerMetaClass.invokeMethod(owner, methodName, arguments);
                }
            } else if ("curry".equals(methodName)) {
                return closure.curry(arguments);
            }
            if (method == null && owner != closure) {
                MetaClass ownerMetaClass;
                Class ownerClass = owner.getClass();
                if (owner instanceof Class) {
                    ownerClass = (Class)owner;
                }
                if ((method = (ownerMetaClass = this.registry.getMetaClass(ownerClass)).pickMethod(methodName, argClasses)) != null) {
                    return ownerMetaClass.invokeMethod(owner, methodName, originalArguments);
                }
            }
            if (method == null && delegate != closure && delegate != null) {
                MetaClass delegateMetaClass;
                Class delegateClass = delegate.getClass();
                if (delegate instanceof Class) {
                    delegateClass = (Class)delegate;
                }
                if ((method = (delegateMetaClass = this.registry.getMetaClass(delegateClass)).pickMethod(methodName, argClasses)) != null) {
                    return delegateMetaClass.invokeMethod(delegate, methodName, originalArguments);
                }
            }
            if (method == null) {
                GroovyObject go;
                MissingMethodException last;
                block30: {
                    last = null;
                    if (owner != closure && owner instanceof GroovyObject) {
                        try {
                            go = (GroovyObject)owner;
                            return go.invokeMethod(methodName, originalArguments);
                        }
                        catch (MissingMethodException mme) {
                            if (last != null) break block30;
                            last = mme;
                        }
                    }
                }
                if (delegate != closure && delegate instanceof GroovyObject) {
                    try {
                        go = (GroovyObject)delegate;
                        return go.invokeMethod(methodName, originalArguments);
                    }
                    catch (MissingMethodException mme) {
                        last = mme;
                    }
                }
                if (last != null) {
                    throw last;
                }
            }
        }
        if (method != null) {
            return MetaClassHelper.doMethodInvoke(object, method, arguments);
        }
        try {
            Object value = this.getProperty(object, methodName);
            if (value instanceof Closure) {
                Closure closure = (Closure)value;
                MetaClass delegateMetaClass = closure.getMetaClass();
                return delegateMetaClass.invokeMethod(closure.getClass(), closure, "doCall", originalArguments, false, fromInsideClass);
            }
        }
        catch (MissingPropertyException mpe) {
            // empty catch block
        }
        throw new MissingMethodException(methodName, this.theClass, originalArguments, false);
    }

    public MetaMethod getMethodWithCaching(Class sender, String methodName, Class[] arguments, boolean isCallToSuper) {
        if (GroovyCategorySupport.hasCategoryInAnyThread() && !isCallToSuper) {
            return this.getMethodWithoutCaching(sender, methodName, arguments, isCallToSuper);
        }
        DefaultMethodKey methodKey = new DefaultMethodKey(sender, methodName, arguments, isCallToSuper);
        MetaMethod method = (MetaMethod)this.methodCache.get(methodKey);
        if (method == null) {
            method = this.getMethodWithoutCaching(sender, methodName, arguments, isCallToSuper);
            this.cacheInstanceMethod(methodKey, method);
        }
        return method;
    }

    protected void cacheInstanceMethod(MethodKey key, MetaMethod method) {
        if (method != null && method.isCacheable()) {
            this.methodCache.put(key, method);
        }
    }

    protected void cacheStaticMethod(MethodKey key, MetaMethod method) {
        if (method != null && method.isCacheable()) {
            this.staticMethodCache.put(key, method);
        }
    }

    public MetaMethod getMethodWithoutCaching(Class sender, String methodName, Class[] arguments, boolean isCallToSuper) {
        MetaMethod method = null;
        List methods = this.getMethods(sender, methodName, isCallToSuper);
        if (methods != null && !methods.isEmpty()) {
            method = (MetaMethod)this.chooseMethod(methodName, methods, arguments, false);
        }
        return method;
    }

    public Object invokeStaticMethod(Object object, String methodName, Object[] arguments) {
        this.checkInitalised();
        if (log.isLoggable(Level.FINER)) {
            MetaClassHelper.logMethodCall(object, methodName, arguments);
        }
        Class sender = object.getClass();
        if (object instanceof Class) {
            sender = (Class)object;
        }
        if (sender != this.theClass) {
            MetaClass mc = this.registry.getMetaClass(sender);
            return mc.invokeStaticMethod(sender, methodName, arguments);
        }
        if (sender == Class.class) {
            return this.invokeMethod(object, methodName, arguments);
        }
        if (arguments == null) {
            arguments = EMPTY_ARGUMENTS;
        }
        Class[] argClasses = MetaClassHelper.convertToTypeArray(arguments);
        this.unwrap(arguments);
        DefaultMethodKey methodKey = new DefaultMethodKey(sender, methodName, argClasses, false);
        MetaMethod method = (MetaMethod)this.staticMethodCache.get(methodKey);
        if (method == null) {
            method = this.pickStaticMethod(sender, methodName, argClasses);
            this.cacheStaticMethod(methodKey.createCopy(), method);
        }
        if (method != null) {
            return MetaClassHelper.doMethodInvoke(object, method, arguments);
        }
        throw new MissingMethodException(methodName, sender, arguments, true);
    }

    private MetaMethod pickStaticMethod(Class sender, String methodName, Class[] arguments) {
        MetaMethod method = null;
        List methods = this.getStaticMethods(sender, methodName);
        if (!methods.isEmpty()) {
            method = (MetaMethod)this.chooseMethod(methodName, methods, arguments, false);
        }
        if (method == null && this.theClass != Class.class) {
            MetaClass classMetaClass = this.registry.getMetaClass(Class.class);
            method = classMetaClass.pickMethod(methodName, arguments);
        }
        if (method == null) {
            method = (MetaMethod)this.chooseMethod(methodName, methods, MetaClassHelper.convertToTypeArray(arguments), true);
        }
        return method;
    }

    public Object invokeConstructor(Object[] arguments) {
        return this.invokeConstructor(this.theClass, arguments, false);
    }

    public int selectConstructorAndTransformArguments(int numberOfCosntructors, Object[] arguments) {
        if (numberOfCosntructors != this.constructors.size()) {
            throw new IncompatibleClassChangeError("the number of constructors during runtime and compile time for " + this.theClass.getName() + " do not match. Expected " + numberOfCosntructors + " but got " + this.constructors.size());
        }
        if (arguments == null) {
            arguments = EMPTY_ARGUMENTS;
        }
        Class[] argClasses = MetaClassHelper.convertToTypeArray(arguments);
        this.unwrap(arguments);
        Constructor constructor = (Constructor)this.chooseMethod("<init>", this.constructors, argClasses, false);
        if (constructor == null) {
            constructor = (Constructor)this.chooseMethod("<init>", this.constructors, argClasses, true);
        }
        if (constructor == null) {
            throw new GroovyRuntimeException("Could not find matching constructor for: " + this.theClass.getName() + "(" + InvokerHelper.toTypeString(arguments) + ")");
        }
        ArrayList l = new ArrayList(this.constructors);
        Comparator comp = new Comparator(){

            public int compare(Object arg0, Object arg1) {
                Constructor c0 = (Constructor)arg0;
                Constructor c1 = (Constructor)arg1;
                String descriptor0 = BytecodeHelper.getMethodDescriptor(Void.TYPE, c0.getParameterTypes());
                String descriptor1 = BytecodeHelper.getMethodDescriptor(Void.TYPE, c1.getParameterTypes());
                return descriptor0.compareTo(descriptor1);
            }
        };
        Collections.sort(l, comp);
        int found = -1;
        for (int i = 0; i < l.size(); ++i) {
            if (l.get(i) != constructor) continue;
            found = i;
            break;
        }
        int ret = 0 | found << 8;
        return ret;
    }

    protected void checkInitalised() {
        if (!this.isInitialized()) {
            throw new IllegalStateException("initialize must be called for meta class of " + this.theClass + "(" + this.getClass() + ") " + "to complete initialisation process " + "before any invocation or field/property " + "access can be done");
        }
    }

    private Object invokeConstructor(Class at, Object[] arguments, boolean setAccessible) {
        Object firstArgument;
        this.checkInitalised();
        if (arguments == null) {
            arguments = EMPTY_ARGUMENTS;
        }
        Class[] argClasses = MetaClassHelper.convertToTypeArray(arguments);
        this.unwrap(arguments);
        Constructor constructor = (Constructor)this.chooseMethod("<init>", this.constructors, argClasses, false);
        if (constructor != null) {
            return MetaClassImpl.doConstructorInvoke(at, constructor, arguments, true);
        }
        constructor = (Constructor)this.chooseMethod("<init>", this.constructors, argClasses, true);
        if (constructor != null) {
            return MetaClassImpl.doConstructorInvoke(at, constructor, arguments, true);
        }
        if (arguments.length == 1 && (firstArgument = arguments[0]) instanceof Map && (constructor = (Constructor)this.chooseMethod("<init>", this.constructors, MetaClassHelper.EMPTY_TYPE_ARRAY, false)) != null) {
            Object bean = MetaClassImpl.doConstructorInvoke(at, constructor, MetaClassHelper.EMPTY_ARRAY, true);
            this.setProperties(bean, (Map)firstArgument);
            return bean;
        }
        throw new GroovyRuntimeException("Could not find matching constructor for: " + this.theClass.getName() + "(" + InvokerHelper.toTypeString(arguments) + ")");
    }

    public void setProperties(Object bean, Map map) {
        this.checkInitalised();
        Iterator iter = map.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            String key = entry.getKey().toString();
            Object value = entry.getValue();
            this.setProperty(bean, key, value);
        }
    }

    public Object getProperty(Class sender, Object object, String name, boolean useSuper, boolean fromInsideClass) {
        boolean isStatic;
        this.checkInitalised();
        boolean bl = isStatic = this.theClass != Class.class && object instanceof Class;
        if (isStatic && object != this.theClass) {
            MetaClass mc = this.registry.getMetaClass((Class)object);
            return mc.getProperty(sender, object, name, useSuper, false);
        }
        MetaMethod method = null;
        Object[] arguments = EMPTY_ARGUMENTS;
        MetaProperty mp = this.getMetaProperty(sender, name, useSuper, isStatic);
        if (mp != null && mp instanceof MetaBeanProperty) {
            MetaBeanProperty mbp = (MetaBeanProperty)mp;
            method = mbp.getGetter();
            mp = mbp.getField();
        }
        if (method == null && !useSuper && !isStatic && GroovyCategorySupport.hasCategoryInAnyThread()) {
            String getterName = "get" + MetaClassHelper.capitalize(name);
            method = this.getCategoryMethodGetter(sender, getterName, false);
        }
        if (method == null && mp != null) {
            return mp.getProperty(object);
        }
        if (method == null && !useSuper && !isStatic && GroovyCategorySupport.hasCategoryInAnyThread() && (method = this.getCategoryMethodGetter(sender, "get", true)) != null) {
            arguments = new Object[]{name};
        }
        if (method == null && this.genericGetMethod != null && (this.genericGetMethod.isStatic() || !isStatic)) {
            arguments = new Object[]{name};
            method = this.genericGetMethod;
        }
        if (method == null) {
            if (this.theClass != Class.class && object instanceof Class) {
                MetaClass mc = this.registry.getMetaClass(Class.class);
                return mc.getProperty(Class.class, object, name, useSuper, false);
            }
            if (object instanceof Collection) {
                return DefaultGroovyMethods.getAt((Collection)object, name);
            }
            if (object instanceof Object[]) {
                return DefaultGroovyMethods.getAt(Arrays.asList((Object[])object), name);
            }
            MetaMethod addListenerMethod = (MetaMethod)this.listeners.get(name);
            if (addListenerMethod != null) {
                return null;
            }
        } else {
            return MetaClassHelper.doMethodInvoke(object, method, arguments);
        }
        throw new MissingPropertyException(name, this.theClass);
    }

    private MetaMethod getCategoryMethodGetter(Class sender, String name, boolean useLongVersion) {
        List possibleGenericMethods = GroovyCategorySupport.getCategoryMethods(sender, name);
        if (possibleGenericMethods != null) {
            Iterator iter = possibleGenericMethods.iterator();
            while (iter.hasNext()) {
                MetaMethod mmethod = (MetaMethod)iter.next();
                Class[] paramTypes = mmethod.getParameterTypes();
                if (!(useLongVersion ? paramTypes.length == 1 && paramTypes[0] == (class$java$lang$String == null ? MetaClassImpl.class$("java.lang.String") : class$java$lang$String) : paramTypes.length == 0)) continue;
                return mmethod;
            }
        }
        return null;
    }

    private MetaMethod getCategoryMethodSetter(Class sender, String name, boolean useLongVersion) {
        List possibleGenericMethods = GroovyCategorySupport.getCategoryMethods(sender, name);
        if (possibleGenericMethods != null) {
            Iterator iter = possibleGenericMethods.iterator();
            while (iter.hasNext()) {
                MetaMethod mmethod = (MetaMethod)iter.next();
                Class[] paramTypes = mmethod.getParameterTypes();
                if (!(useLongVersion ? paramTypes.length == 2 && paramTypes[0] == (class$java$lang$String == null ? MetaClassImpl.class$("java.lang.String") : class$java$lang$String) : paramTypes.length == 1)) continue;
                return mmethod;
            }
        }
        return null;
    }

    private MetaMethod findPropertyMethod(List methods, boolean isGetter) {
        LinkedList<MetaMethod> ret = new LinkedList<MetaMethod>();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MetaMethod element = (MetaMethod)iter.next();
            if (!isGetter && element.getParameterTypes().length == 1) {
                ret.add(element);
            }
            if (!isGetter || element.getReturnType() == (class$java$lang$Void == null ? MetaClassImpl.class$("java.lang.Void") : class$java$lang$Void) || element.getReturnType() == Void.TYPE || element.getParameterTypes().length != 0) continue;
            ret.add(element);
        }
        if (ret.size() == 0) {
            return null;
        }
        if (ret.size() == 1) {
            return (MetaMethod)ret.getFirst();
        }
        MetaMethod method = null;
        int distance = -1;
        Iterator iter2 = ret.iterator();
        while (iter2.hasNext()) {
            MetaMethod element = (MetaMethod)iter2.next();
            Class c = isGetter ? element.getReturnType() : element.getParameterTypes()[0];
            int localDistance = MetaClassImpl.distanceToObject(c);
            if (distance != -1 && distance <= localDistance) continue;
            distance = localDistance;
            method = element;
        }
        return method;
    }

    private static int distanceToObject(Class c) {
        int count = 0;
        while (c != null) {
            c = c.getSuperclass();
            ++count;
        }
        return count;
    }

    private void setupProperties(PropertyDescriptor[] propertyDescriptors) {
        LinkedList superClasses = this.getSuperClasses();
        HashSet interfaces = new HashSet();
        MetaClassImpl.makeInterfaceSet(this.theClass, interfaces);
        if (this.theClass.isArray()) {
            HashMap<String, MetaProperty> map = new HashMap<String, MetaProperty>();
            map.put("length", this.arrayLengthProperty);
            this.classPropertyIndex.put(this.theClass, map);
        }
        this.inheritStaticInterfaceFields(superClasses, interfaces);
        this.inheritFields(superClasses);
        this.applyPropertyDescriptors(propertyDescriptors);
        this.applyStrayPropertyMethods(superClasses, this.classMethodIndex, this.classPropertyIndex);
        this.applyStrayPropertyMethods(superClasses, this.classMethodIndexForSuper, this.classPropertyIndexForSuper);
        this.copyClassPropertyIndexForSuper();
        this.makeStaticPropertyIndex();
    }

    private void makeStaticPropertyIndex() {
        Map propertyMap = (Map)this.classPropertyIndex.get(this.theClass);
        Iterator iter = propertyMap.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            MetaProperty mp = (MetaProperty)entry.getValue();
            if (mp instanceof MetaFieldProperty) {
                MetaFieldProperty mfp = (MetaFieldProperty)mp;
                if (!mfp.isStatic()) {
                    continue;
                }
            } else {
                MetaBeanProperty newmp;
                boolean field;
                if (!(mp instanceof MetaBeanProperty)) continue;
                MetaBeanProperty mbp = (MetaBeanProperty)mp;
                boolean getter = mbp.getGetter() == null || mbp.getGetter().isStatic();
                boolean setter = mbp.getSetter() == null || mbp.getSetter().isStatic();
                boolean bl = field = mbp.getField() == null || mbp.getField().isStatic();
                if (!getter && !setter && !field) continue;
                if (setter && getter) {
                    mp = field ? mbp : new MetaBeanProperty(mbp.getName(), mbp.getType(), mbp.getGetter(), mbp.getSetter());
                } else if (getter && !setter) {
                    if (mbp.getGetter() == null) {
                        mp = mbp.getField();
                    } else {
                        newmp = new MetaBeanProperty(mbp.getName(), mbp.getType(), mbp.getGetter(), null);
                        if (field) {
                            newmp.setField(mbp.getField());
                        }
                        mp = newmp;
                    }
                } else if (setter && !getter) {
                    if (mbp.getSetter() == null) {
                        mp = mbp.getField();
                    } else {
                        newmp = new MetaBeanProperty(mbp.getName(), mbp.getType(), null, mbp.getSetter());
                        if (field) {
                            newmp.setField(mbp.getField());
                        }
                        mp = newmp;
                    }
                } else if (field) {
                    mp = mbp.getField();
                }
            }
            if (mp == null) continue;
            this.staticPropertyIndex.put(entry.getKey(), mp);
        }
    }

    private void copyClassPropertyIndexForSuper() {
        Iterator iter = this.classPropertyIndex.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            HashMap newVal = new HashMap((Map)entry.getValue());
            this.classPropertyIndexForSuper.put(entry.getKey(), newVal);
        }
    }

    private Map getMap2MapNotNull(Map m, Object key) {
        HashMap ret = (HashMap)m.get(key);
        if (ret == null) {
            ret = new HashMap();
            m.put(key, ret);
        }
        return ret;
    }

    private void inheritStaticInterfaceFields(LinkedList superClasses, Set interfaces) {
        Iterator interfaceIter = interfaces.iterator();
        while (interfaceIter.hasNext()) {
            Class iclass = (Class)interfaceIter.next();
            Map iPropertyIndex = this.getMap2MapNotNull(this.classPropertyIndex, iclass);
            this.addFields(iclass, iPropertyIndex);
            Iterator classIter = superClasses.iterator();
            while (classIter.hasNext()) {
                Class sclass = (Class)classIter.next();
                if (!iclass.isAssignableFrom(sclass)) continue;
                Map sPropertyIndex = this.getMap2MapNotNull(this.classPropertyIndex, sclass);
                this.copyNonPrivateFields(iPropertyIndex, sPropertyIndex);
            }
        }
    }

    private void inheritFields(LinkedList superClasses) {
        Map last = null;
        Iterator iter = superClasses.iterator();
        while (iter.hasNext()) {
            Class klass = (Class)iter.next();
            Map propertyIndex = this.getMap2MapNotNull(this.classPropertyIndex, klass);
            if (last != null) {
                this.copyNonPrivateFields(last, propertyIndex);
            }
            last = propertyIndex;
            this.addFields(klass, propertyIndex);
        }
    }

    private void addFields(final Class klass, Map propertyIndex) {
        Field[] fields = (Field[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return klass.getDeclaredFields();
            }
        });
        for (int i = 0; i < fields.length; ++i) {
            MetaFieldProperty mfp = new MetaFieldProperty(fields[i]);
            propertyIndex.put(fields[i].getName(), mfp);
        }
    }

    private void copyNonPrivateFields(Map from, Map to) {
        Iterator iter = from.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            MetaFieldProperty mfp = (MetaFieldProperty)entry.getValue();
            if (!Modifier.isPublic(mfp.getModifiers()) && !Modifier.isProtected(mfp.getModifiers())) continue;
            to.put(entry.getKey(), mfp);
        }
    }

    private void applyStrayPropertyMethods(LinkedList superClasses, Map classMethodIndex, Map classPropertyIndex) {
        Iterator iter = superClasses.iterator();
        while (iter.hasNext()) {
            Class klass = (Class)iter.next();
            Map methodIndex = (Map)classMethodIndex.get(klass);
            Map propertyIndex = this.getMap2MapNotNull(classPropertyIndex, klass);
            Iterator nameMethodIterator = methodIndex.entrySet().iterator();
            while (nameMethodIterator.hasNext()) {
                Map.Entry entry = nameMethodIterator.next();
                String methodName = (String)entry.getKey();
                if (methodName.length() < 4) continue;
                boolean isGetter = methodName.startsWith("get");
                boolean isSetter = methodName.startsWith("set");
                if (!isGetter && !isSetter) continue;
                String propName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
                MetaMethod propertyMethod = this.findPropertyMethod((List)entry.getValue(), isGetter);
                if (propertyMethod == null) continue;
                this.createMetaBeanProperty(propertyIndex, propName, isGetter, propertyMethod);
            }
        }
    }

    private void createMetaBeanProperty(Map propertyIndex, String propName, boolean isGetter, MetaMethod propertyMethod) {
        MetaProperty mp = (MetaProperty)propertyIndex.get(propName);
        if (mp == null) {
            mp = isGetter ? new MetaBeanProperty(propName, propertyMethod.getReturnType(), propertyMethod, null) : new MetaBeanProperty(propName, propertyMethod.getParameterTypes()[0], null, propertyMethod);
        } else {
            MetaFieldProperty mfp;
            MetaBeanProperty mbp;
            if (mp instanceof MetaBeanProperty) {
                mbp = (MetaBeanProperty)mp;
                mfp = mbp.getField();
            } else if (mp instanceof MetaFieldProperty) {
                mfp = (MetaFieldProperty)mp;
                mbp = new MetaBeanProperty(propName, mfp.getType(), null, null);
            } else {
                throw new GroovyBugError("unknown MetaProperty class used. Class is " + mp.getClass());
            }
            if (isGetter && mbp.getGetter() == null) {
                mbp.setGetter(propertyMethod);
            } else if (!isGetter && mbp.getSetter() == null) {
                mbp.setSetter(propertyMethod);
            }
            mbp.setField(mfp);
            mp = mbp;
        }
        propertyIndex.put(propName, mp);
    }

    private void applyPropertyDescriptors(PropertyDescriptor[] propertyDescriptors) {
        Map propertyMap = (Map)this.classPropertyIndex.get(this.theClass);
        for (int i = 0; i < propertyDescriptors.length; ++i) {
            PropertyDescriptor pd = propertyDescriptors[i];
            if (pd.getPropertyType() == null) continue;
            Method method = pd.getReadMethod();
            MetaMethod getter = method != null ? this.findMethod(method) : null;
            method = pd.getWriteMethod();
            MetaMethod setter = method != null ? this.findMethod(method) : null;
            MetaBeanProperty mp = new MetaBeanProperty(pd.getName(), pd.getPropertyType(), getter, setter);
            MetaFieldProperty field = null;
            MetaProperty old = (MetaProperty)propertyMap.get(pd.getName());
            if (old != null) {
                field = old instanceof MetaBeanProperty ? ((MetaBeanProperty)old).getField() : (MetaFieldProperty)old;
                mp.setField(field);
            }
            propertyMap.put(pd.getName(), mp);
        }
    }

    public void setProperty(Class sender, Object object, String name, Object newValue, boolean useSuper, boolean fromInsideClass) {
        String getterName;
        boolean isStatic;
        this.checkInitalised();
        boolean bl = isStatic = this.theClass != Class.class && object instanceof Class;
        if (isStatic && object != this.theClass) {
            MetaClass mc = this.registry.getMetaClass((Class)object);
            mc.getProperty(sender, object, name, useSuper, fromInsideClass);
            return;
        }
        if (newValue instanceof Wrapper) {
            newValue = ((Wrapper)newValue).unwrap();
        }
        MetaMethod method = null;
        Object[] arguments = null;
        MetaProperty mp = this.getMetaProperty(sender, name, useSuper, isStatic);
        MetaProperty field = null;
        if (mp != null) {
            if (mp instanceof MetaBeanProperty) {
                MetaBeanProperty mbp = (MetaBeanProperty)mp;
                method = mbp.getSetter();
                if (method != null) {
                    arguments = new Object[]{newValue};
                }
                field = mbp.getField();
            } else {
                field = mp;
            }
        }
        if (!useSuper && !isStatic && GroovyCategorySupport.hasCategoryInAnyThread() && (method = this.getCategoryMethodSetter(sender, getterName = "set" + MetaClassHelper.capitalize(name), false)) != null) {
            arguments = new Object[]{newValue};
        }
        boolean ambigousListener = false;
        boolean usesProxy = false;
        if (method == null) {
            method = (MetaMethod)this.listeners.get(name);
            boolean bl2 = ambigousListener = method == AMBIGOUS_LISTENER_METHOD;
            if (method != null && !ambigousListener && newValue instanceof Closure) {
                Object proxy = MetaClassHelper.createListenerProxy(method.getParameterTypes()[0], name, (Closure)newValue);
                arguments = new Object[]{proxy};
                newValue = proxy;
                usesProxy = true;
            } else {
                method = null;
            }
        }
        if (method == null && field != null) {
            field.setProperty(object, newValue);
            return;
        }
        if (method == null && !useSuper && !isStatic && GroovyCategorySupport.hasCategoryInAnyThread() && (method = this.getCategoryMethodSetter(sender, "set", true)) != null) {
            arguments = new Object[]{name, newValue};
        }
        if (method == null && this.genericSetMethod != null && (this.genericSetMethod.isStatic() || !isStatic)) {
            arguments = new Object[]{name, newValue};
            method = this.genericSetMethod;
        }
        if (method != null) {
            if (arguments.length == 1) {
                arguments[0] = newValue = DefaultTypeTransformation.castToType(newValue, method.getParameterTypes()[0]);
            } else {
                arguments[1] = newValue = DefaultTypeTransformation.castToType(newValue, method.getParameterTypes()[1]);
            }
            MetaClassHelper.doMethodInvoke(object, method, arguments);
            return;
        }
        if (ambigousListener) {
            throw new GroovyRuntimeException("There are multiple listeners for the property " + name + ". Please do not use the bean short form to access this listener.");
        }
        throw new MissingPropertyException(name, this.theClass);
    }

    private MetaProperty getMetaProperty(Class clazz, String name, boolean useSuper, boolean useStatic) {
        Map propertyMap = useStatic ? this.staticPropertyIndex : (useSuper ? (Map)this.classPropertyIndexForSuper.get(clazz) : (Map)this.classPropertyIndex.get(clazz));
        if (propertyMap == null) {
            if (clazz != this.theClass) {
                return this.getMetaProperty(this.theClass, name, useSuper, useStatic);
            }
            return null;
        }
        return (MetaProperty)propertyMap.get(name);
    }

    public Object getAttribute(Class sender, Object object, String attribute, boolean useSuper, boolean fromInsideClass) {
        boolean isStatic;
        this.checkInitalised();
        boolean bl = isStatic = this.theClass != Class.class && object instanceof Class;
        if (isStatic && object != this.theClass) {
            MetaClass mc = this.registry.getMetaClass((Class)object);
            return mc.getAttribute(sender, object, attribute, useSuper);
        }
        MetaProperty mp = this.getMetaProperty(sender, attribute, useSuper, isStatic);
        if (mp != null) {
            if (mp instanceof MetaBeanProperty) {
                MetaBeanProperty mbp = (MetaBeanProperty)mp;
                mp = mbp.getField();
            }
            try {
                if (mp != null) {
                    return mp.getProperty(object);
                }
            }
            catch (Exception e) {
                throw new GroovyRuntimeException("Cannot read field: " + attribute, e);
            }
        }
        throw new MissingFieldException(attribute, this.theClass);
    }

    public void setAttribute(Class sender, Object object, String attribute, Object newValue, boolean useSuper, boolean fromInsideClass) {
        boolean isStatic;
        this.checkInitalised();
        boolean bl = isStatic = this.theClass != Class.class && object instanceof Class;
        if (isStatic && object != this.theClass) {
            MetaClass mc = this.registry.getMetaClass((Class)object);
            mc.setAttribute(sender, object, attribute, newValue, useSuper, fromInsideClass);
            return;
        }
        MetaProperty mp = this.getMetaProperty(sender, attribute, useSuper, isStatic);
        if (mp != null) {
            if (mp instanceof MetaBeanProperty) {
                MetaBeanProperty mbp = (MetaBeanProperty)mp;
                mp = mbp.getField();
            }
            if (mp != null) {
                mp.setProperty(object, newValue);
                return;
            }
        }
        throw new MissingFieldException(attribute, this.theClass);
    }

    public String toString() {
        return super.toString() + "[" + this.theClass + "]";
    }

    private void addMethods(final Class theClass) {
        Method element;
        HashMap methodIndex = (HashMap)this.classMethodIndex.get(theClass);
        if (methodIndex == null) {
            methodIndex = new HashMap();
            this.classMethodIndex.put(theClass, methodIndex);
        }
        Method[] methodArray = (Method[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return theClass.getDeclaredMethods();
            }
        });
        for (int i = 0; i < methodArray.length; ++i) {
            Method reflectionMethod = methodArray[i];
            if (reflectionMethod.getName().indexOf(43) >= 0 || Modifier.isAbstract(reflectionMethod.getModifiers())) continue;
            MetaMethod method = this.createMetaMethod(reflectionMethod);
            this.addMetaMethod(method);
        }
        List methods = this.registry.getInstanceMethods();
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            element = (Method)iter.next();
            if (element.getParameterTypes()[0] != theClass) continue;
            this.addNewInstanceMethod(element);
        }
        methods = this.registry.getStaticMethods();
        iter = methods.iterator();
        while (iter.hasNext()) {
            element = (Method)iter.next();
            if (element.getParameterTypes()[0] != theClass) continue;
            this.addNewStaticMethod(element);
        }
    }

    private void addToClassMethodIndex(MetaMethod method, Map classMethodIndex) {
        String name;
        ArrayList<MetaMethod> list;
        HashMap methodIndex = (HashMap)classMethodIndex.get(method.getDeclaringClass());
        if (methodIndex == null) {
            methodIndex = new HashMap();
            classMethodIndex.put(method.getDeclaringClass(), methodIndex);
        }
        if ((list = (ArrayList<MetaMethod>)methodIndex.get(name = method.getName())) == null) {
            list = new ArrayList<MetaMethod>();
            methodIndex.put(name, list);
            list.add(method);
        } else {
            this.addMethodToList(list, method);
        }
    }

    protected void addMetaMethod(MetaMethod method) {
        if (this.isInitialized()) {
            throw new RuntimeException("Already initialized, cannot add new method: " + method);
        }
        if (this.isGenericGetMethod(method) && this.genericGetMethod == null) {
            this.genericGetMethod = method;
        } else if (MetaClassHelper.isGenericSetMethod(method) && this.genericSetMethod == null) {
            this.genericSetMethod = method;
        }
        if (method.isStatic()) {
            this.addToClassMethodIndex(method, this.classStaticMethodIndex);
        }
        this.addToClassMethodIndex(method, this.classMethodIndex);
    }

    protected boolean isInitialized() {
        return this.initialized;
    }

    private void addMethodToList(List list, MetaMethod method) {
        MetaMethod match = this.removeMatchingMethod(list, method);
        if (match == null) {
            list.add(method);
        } else if (match.isPrivate()) {
            list.add(match);
        } else {
            Class matchC;
            Class methodC = method.getDeclaringClass();
            if (methodC == (matchC = match.getDeclaringClass())) {
                if (method instanceof NewInstanceMetaMethod) {
                    list.add(method);
                } else {
                    list.add(match);
                }
            } else if (MetaClassHelper.isAssignableFrom(methodC, matchC)) {
                list.add(match);
            } else {
                list.add(method);
            }
        }
    }

    private MetaMethod removeMatchingMethod(List list, MetaMethod method) {
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Class[] params2;
            MetaMethod aMethod = (MetaMethod)iter.next();
            Class[] params1 = aMethod.getParameterTypes();
            if (params1.length != (params2 = method.getParameterTypes()).length) continue;
            boolean matches = true;
            for (int i = 0; i < params1.length; ++i) {
                if (params1[i] == params2[i]) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            iter.remove();
            return aMethod;
        }
        return null;
    }

    private MetaMethod findMethod(Method aMethod) {
        List methods = this.getMethods(this.theClass, aMethod.getName(), false);
        Iterator iter = methods.iterator();
        while (iter.hasNext()) {
            MetaMethod method = (MetaMethod)iter.next();
            if (!method.isMethod(aMethod)) continue;
            return method;
        }
        return new ReflectionMetaMethod(aMethod);
    }

    private static Object doConstructorInvoke(Class at, Constructor constructor, Object[] argumentArray, boolean setAccessible) {
        if (log.isLoggable(Level.FINER)) {
            MetaClassHelper.logMethodCall(constructor.getDeclaringClass(), constructor.getName(), argumentArray);
        }
        if (setAccessible) {
            final boolean accessible = MetaClassHelper.accessibleToConstructor(at, constructor);
            final Constructor ctor = constructor;
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    ctor.setAccessible(accessible);
                    return null;
                }
            });
        }
        return MetaClassHelper.doConstructorInvoke(constructor, argumentArray);
    }

    private Object chooseMethod(String methodName, List methods, Class[] arguments, boolean coerce) {
        int methodCount = methods.size();
        if (methodCount <= 0) {
            return null;
        }
        if (methodCount == 1) {
            Object method = methods.get(0);
            if (MetaClassHelper.isValidMethod(method, arguments, coerce)) {
                return method;
            }
            return null;
        }
        Object answer = null;
        if (arguments == null || arguments.length == 0) {
            answer = MetaClassHelper.chooseEmptyMethodParams(methods);
        } else if (arguments.length == 1 && arguments[0] == null) {
            answer = MetaClassHelper.chooseMostGeneralMethodWith1NullParam(methods);
        } else {
            ArrayList matchingMethods = new ArrayList();
            Iterator iter = methods.iterator();
            while (iter.hasNext()) {
                Object method = iter.next();
                if (!MetaClassHelper.isValidMethod(method, arguments, coerce)) continue;
                matchingMethods.add(method);
            }
            if (matchingMethods.isEmpty()) {
                return null;
            }
            if (matchingMethods.size() == 1) {
                return matchingMethods.get(0);
            }
            return this.chooseMostSpecificParams(methodName, matchingMethods, arguments);
        }
        if (answer != null) {
            return answer;
        }
        throw new GroovyRuntimeException("Could not find which method to invoke from this list: " + methods + " for arguments: " + InvokerHelper.toString(arguments));
    }

    private Object chooseMostSpecificParams(String name, List matchingMethods, Class[] arguments) {
        long matchesDistance = -1L;
        LinkedList matches = new LinkedList();
        Iterator iter = matchingMethods.iterator();
        while (iter.hasNext()) {
            Object method = iter.next();
            Class[] paramTypes = MetaClassHelper.getParameterTypes(method);
            if (!MetaClassHelper.parametersAreCompatible(arguments, paramTypes)) continue;
            long dist = MetaClassHelper.calculateParameterDistance(arguments, paramTypes);
            if (dist == 0L) {
                return method;
            }
            if (matches.size() == 0) {
                matches.add(method);
                matchesDistance = dist;
                continue;
            }
            if (dist < matchesDistance) {
                matchesDistance = dist;
                matches.clear();
                matches.add(method);
                continue;
            }
            if (dist != matchesDistance) continue;
            matches.add(method);
        }
        if (matches.size() == 1) {
            return matches.getFirst();
        }
        if (matches.size() == 0) {
            return null;
        }
        String msg = "Ambiguous method overloading for method ";
        msg = msg + this.theClass.getName() + "#" + name;
        msg = msg + ".\nCannot resolve which method to invoke for ";
        msg = msg + InvokerHelper.toString(arguments);
        msg = msg + " due to overlapping prototypes between:";
        Iterator iter2 = matches.iterator();
        while (iter2.hasNext()) {
            Class[] types = MetaClassHelper.getParameterTypes(iter2.next());
            msg = msg + "\n\t" + InvokerHelper.toString(types);
        }
        throw new GroovyRuntimeException(msg);
    }

    private boolean isGenericGetMethod(MetaMethod method) {
        if (method.getName().equals("get")) {
            Class[] parameterTypes = method.getParameterTypes();
            return parameterTypes.length == 1 && parameterTypes[0] == String.class;
        }
        return false;
    }

    public synchronized void initialize() {
        if (!this.isInitialized()) {
            this.fillMethodIndex();
            this.addProperties();
            this.initialized = true;
        }
        if (this.reflector == null) {
            this.generateReflector();
        }
    }

    private void addProperties() {
        BeanInfo info;
        try {
            info = (BeanInfo)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IntrospectionException {
                    return Introspector.getBeanInfo(MetaClassImpl.this.theClass);
                }
            });
        }
        catch (PrivilegedActionException pae) {
            throw new GroovyRuntimeException("exception while bean introspection", pae.getException());
        }
        PropertyDescriptor[] descriptors = info.getPropertyDescriptors();
        this.setupProperties(descriptors);
        EventSetDescriptor[] eventDescriptors = info.getEventSetDescriptors();
        for (int i = 0; i < eventDescriptors.length; ++i) {
            EventSetDescriptor descriptor = eventDescriptors[i];
            Method[] listenerMethods = descriptor.getListenerMethods();
            for (int j = 0; j < listenerMethods.length; ++j) {
                Method listenerMethod = listenerMethods[j];
                MetaMethod metaMethod = this.createMetaMethod(descriptor.getAddListenerMethod());
                String name = listenerMethod.getName();
                if (this.listeners.containsKey(name)) {
                    this.listeners.put(name, AMBIGOUS_LISTENER_METHOD);
                    continue;
                }
                this.listeners.put(name, metaMethod);
            }
        }
    }

    private MetaMethod createMetaMethod(final Method method) {
        MetaMethod answer;
        if (this.registry.useAccessible()) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    method.setAccessible(true);
                    return null;
                }
            });
        }
        if (this.isValidReflectorMethod(answer = new MetaMethod(method))) {
            this.allMethods.add(answer);
            answer.setMethodIndex(this.allMethods.size());
        } else {
            answer = new ReflectionMetaMethod(method);
        }
        if (useReflection) {
            return new ReflectionMetaMethod(method);
        }
        return answer;
    }

    private boolean isValidReflectorMethod(MetaMethod method) {
        Class declaringClass;
        if (!method.isPublic()) {
            return false;
        }
        List interfaceMethods = this.getInterfaceMethods();
        Iterator iter = interfaceMethods.iterator();
        while (iter.hasNext()) {
            MetaMethod aMethod = (MetaMethod)iter.next();
            if (!method.isSame(aMethod)) continue;
            method.setInterfaceClass(aMethod.getCallClass());
            return true;
        }
        for (Class clazz = declaringClass = method.getCallClass(); clazz != null; clazz = clazz.getSuperclass()) {
            try {
                final Class klazz = clazz;
                final String mName = method.getName();
                final Class[] parms = method.getParameterTypes();
                try {
                    Method m = (Method)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        public Object run() throws NoSuchMethodException {
                            return klazz.getDeclaredMethod(mName, parms);
                        }
                    });
                    if (!Modifier.isPublic(clazz.getModifiers()) || !Modifier.isPublic(m.getModifiers())) continue;
                    declaringClass = clazz;
                    continue;
                }
                catch (PrivilegedActionException pae) {
                    if (pae.getException() instanceof NoSuchMethodException) {
                        throw (NoSuchMethodException)pae.getException();
                    }
                    throw new RuntimeException(pae.getException());
                }
            }
            catch (SecurityException e) {
                continue;
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (!Modifier.isPublic(declaringClass.getModifiers())) {
            return false;
        }
        method.setCallClass(declaringClass);
        return true;
    }

    private void generateReflector() {
        this.reflector = this.registry.loadReflector(this.theClass, this.allMethods);
        if (this.reflector == null) {
            throw new RuntimeException("Should have a reflector for " + this.theClass.getName());
        }
        Iterator iter = this.allMethods.iterator();
        while (iter.hasNext()) {
            MetaMethod metaMethod = (MetaMethod)iter.next();
            metaMethod.setReflector(this.reflector);
        }
    }

    private synchronized List getInterfaceMethods() {
        if (this.interfaceMethods == null) {
            this.interfaceMethods = new ArrayList();
            for (Class type = this.theClass; type != null; type = type.getSuperclass()) {
                Class<?>[] interfaces = type.getInterfaces();
                for (int i = 0; i < interfaces.length; ++i) {
                    Class<?> iface = interfaces[i];
                    Method[] methods = iface.getMethods();
                    this.addInterfaceMethods(this.interfaceMethods, methods);
                }
            }
        }
        return this.interfaceMethods;
    }

    private void addInterfaceMethods(List list, Method[] methods) {
        for (int i = 0; i < methods.length; ++i) {
            list.add(this.createMetaMethod(methods[i]));
        }
    }

    public Object getProperty(Object object, String property) {
        return this.getProperty(this.theClass, object, property, false, false);
    }

    public void setProperty(Object object, String property, Object newValue) {
        this.setProperty(this.theClass, object, property, newValue, false, false);
    }

    public Object getAttribute(Object object, String attribute) {
        return this.getAttribute(this.theClass, object, attribute, false, false);
    }

    public void setAttribute(Object object, String attribute, Object newValue) {
        this.setAttribute(this.theClass, object, attribute, newValue, false, false);
    }

    public MetaMethod pickMethod(String methodName, Class[] arguments) {
        return this.getMethodWithoutCaching(this.theClass, methodName, arguments, false);
    }

    private static class MethodIndexAction {
        private MethodIndexAction() {
        }

        public void iterate(Map classMethodIndex) {
            Iterator iter = classMethodIndex.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry classEntry = iter.next();
                Map methodIndex = (Map)classEntry.getValue();
                Class clazz = (Class)classEntry.getKey();
                if (this.skipClass(clazz)) continue;
                Iterator iterator = methodIndex.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry nameEntry = iterator.next();
                    String name = (String)nameEntry.getKey();
                    List oldList = (List)nameEntry.getValue();
                    List newList = this.methodNameAction(clazz, name, oldList);
                    if (!this.replaceMethodList()) continue;
                    nameEntry.setValue(newList);
                }
            }
        }

        public List methodNameAction(Class clazz, String methodName, List methods) {
            ArrayList newList = new ArrayList(methods.size());
            Iterator methodIter = methods.iterator();
            while (methodIter.hasNext()) {
                MetaMethod method = (MetaMethod)methodIter.next();
                this.methodListAction(clazz, methodName, method, methods, newList);
            }
            return newList;
        }

        public boolean skipClass(Class clazz) {
            return false;
        }

        public void methodListAction(Class clazz, String methodName, MetaMethod method, List oldList, List newList) {
        }

        public boolean replaceMethodList() {
            return true;
        }
    }
}

