/*
 * Decompiled with CFR 0.152.
 */
package com.projity.pm.task;

import com.projity.algorithm.ReverseQuery;
import com.projity.algorithm.TimeIteratorGenerator;
import com.projity.algorithm.buffer.CalculatedValues;
import com.projity.association.AssociationList;
import com.projity.field.FieldContext;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.HasAssignments;
import com.projity.pm.assignment.HasAssignmentsImpl;
import com.projity.pm.calendar.WorkCalendar;
import com.projity.pm.criticalpath.TaskSchedule;
import com.projity.pm.resource.Resource;
import com.projity.pm.snapshot.DataSnapshot;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Task;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import org.apache.commons.collections.Closure;

public class TaskSnapshot
implements DataSnapshot,
HasAssignments,
Cloneable {
    TaskSchedule currentSchedule;
    HasAssignments hasAssignments = null;
    double fixedCost = 0.0;
    int fixedCostAccrual = 2;
    boolean ignoreResourceCalendar = false;

    public long getEarliestAssignmentStart() {
        return this.hasAssignments.getEarliestAssignmentStart();
    }

    public boolean hasActiveAssignment(long l, long l2) {
        return this.hasAssignments.hasActiveAssignment(l, l2);
    }

    public void updateAssignment(Assignment assignment) {
        this.hasAssignments.updateAssignment(assignment);
    }

    public TaskSchedule getCurrentSchedule() {
        return this.currentSchedule;
    }

    public void setCurrentSchedule(TaskSchedule taskSchedule) {
        this.currentSchedule = taskSchedule;
    }

    public HasAssignments getHasAssignments() {
        if (this.hasAssignments == null) {
            this.hasAssignments = new HasAssignmentsImpl();
        }
        return this.hasAssignments;
    }

    public TaskSnapshot() {
    }

    public TaskSnapshot(Collection collection) {
        this.hasAssignments = new HasAssignmentsImpl(collection);
    }

    public Object clone() {
        TaskSnapshot taskSnapshot = null;
        try {
            taskSnapshot = (TaskSnapshot)super.clone();
            taskSnapshot.currentSchedule = (TaskSchedule)this.currentSchedule.clone();
            taskSnapshot.hasAssignments = ((HasAssignmentsImpl)this.hasAssignments).cloneWithSchedule(taskSnapshot.currentSchedule);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return taskSnapshot;
    }

    public Object deepCloneWithTask(Task task) {
        TaskSnapshot taskSnapshot = null;
        try {
            taskSnapshot = (TaskSnapshot)super.clone();
            taskSnapshot.currentSchedule = (TaskSchedule)this.currentSchedule.cloneWithTask(task);
            taskSnapshot.hasAssignments = ((HasAssignmentsImpl)this.hasAssignments).deepCloneWithTask(task);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            cloneNotSupportedException.printStackTrace();
        }
        return taskSnapshot;
    }

    public void addAssignment(Assignment assignment) {
        this.getHasAssignments().addAssignment(assignment);
    }

    public Assignment findAssignment(Resource resource) {
        return this.getHasAssignments().findAssignment(resource);
    }

    public Assignment findAssignment(Task task) {
        return this.getHasAssignments().findAssignment(task);
    }

    public void removeAssignment(Assignment assignment) {
        this.getHasAssignments().removeAssignment(assignment);
    }

    public AssociationList getAssignments() {
        return this.getHasAssignments().getAssignments();
    }

    public int getSchedulingType() {
        return this.getHasAssignments().getSchedulingType();
    }

    public void setSchedulingType(int n) {
        this.getHasAssignments().setSchedulingType(n);
    }

    public boolean isEffortDriven() {
        return this.getHasAssignments().isEffortDriven();
    }

    public void setEffortDriven(boolean bl) {
        this.getHasAssignments().setEffortDriven(bl);
    }

    public void buildReverseQuery(ReverseQuery reverseQuery) {
        this.getHasAssignments().buildReverseQuery(reverseQuery);
    }

    public static Closure forAllAssignments(Closure closure) {
        return HasAssignmentsImpl.forAllAssignments(closure);
    }

    public void forEachWorkingInterval(Closure closure, boolean bl, WorkCalendar workCalendar) {
        this.hasAssignments.forEachWorkingInterval(closure, bl, workCalendar);
    }

    public boolean isReadOnlyEffortDriven(FieldContext fieldContext) {
        return this.hasAssignments.isReadOnlyEffortDriven(fieldContext);
    }

    public double actualCost(long l, long l2) {
        return this.hasAssignments.actualCost(l, l2);
    }

    public long actualWork(long l, long l2) {
        return this.hasAssignments.actualWork(l, l2);
    }

    public long remainingWork(long l, long l2) {
        return this.hasAssignments.remainingWork(l, l2);
    }

    public double acwp(long l, long l2) {
        return this.hasAssignments.acwp(l, l2);
    }

    public double bac(long l, long l2) {
        return this.hasAssignments.bac(l, l2);
    }

    public double bcwp(long l, long l2) {
        return this.hasAssignments.bcwp(l, l2);
    }

    public double bcws(long l, long l2) {
        return this.hasAssignments.bcws(l, l2);
    }

    public double cost(long l, long l2) {
        return this.hasAssignments.cost(l, l2);
    }

    public long work(long l, long l2) {
        return this.hasAssignments.work(l, l2);
    }

    public void calcDataBetween(Object object, TimeIteratorGenerator timeIteratorGenerator, CalculatedValues calculatedValues) {
        this.hasAssignments.calcDataBetween(object, timeIteratorGenerator, calculatedValues);
    }

    public Collection childrenToRollup() {
        return this.hasAssignments.childrenToRollup();
    }

    public double baselineCost(long l, long l2) {
        return this.hasAssignments.baselineCost(l, l2);
    }

    public long baselineWork(long l, long l2) {
        return this.hasAssignments.baselineWork(l, l2);
    }

    public long calcActiveAssignmentDuration(WorkCalendar workCalendar) {
        return this.hasAssignments.calcActiveAssignmentDuration(workCalendar);
    }

    public double fixedCost(long l, long l2) {
        return 0.0;
    }

    public double actualFixedCost(long l, long l2) {
        return 0.0;
    }

    public final double getFixedCost() {
        return this.fixedCost;
    }

    public final void setFixedCost(double d) {
        this.fixedCost = d;
    }

    public final int getFixedCostAccrual() {
        return this.fixedCostAccrual;
    }

    public final void setFixedCostAccrual(int n) {
        this.fixedCostAccrual = n;
    }

    public final boolean isIgnoreResourceCalendar() {
        return this.ignoreResourceCalendar;
    }

    public final void setIgnoreResourceCalendar(boolean bl) {
        this.ignoreResourceCalendar = bl;
    }

    public boolean isLabor() {
        return true;
    }

    public boolean hasLaborAssignment() {
        return this.hasAssignments.hasLaborAssignment();
    }

    public void invalidateAssignmentCalendars() {
        this.hasAssignments.invalidateAssignmentCalendars();
    }

    public void serialize(ObjectOutputStream objectOutputStream) throws IOException {
        this.currentSchedule.serialize(objectOutputStream);
        objectOutputStream.writeDouble(this.fixedCost);
        objectOutputStream.writeInt(this.fixedCostAccrual);
        objectOutputStream.writeBoolean(this.ignoreResourceCalendar);
        objectOutputStream.writeInt(this.hasAssignments.getSchedulingType());
        objectOutputStream.writeBoolean(this.hasAssignments.isEffortDriven());
    }

    public static TaskSnapshot deserialize(ObjectInputStream objectInputStream, NormalTask normalTask) throws IOException, ClassNotFoundException {
        TaskSnapshot taskSnapshot = new TaskSnapshot();
        TaskSchedule taskSchedule = TaskSchedule.deserialize(objectInputStream);
        taskSchedule.setTask(normalTask);
        taskSnapshot.setCurrentSchedule(taskSchedule);
        taskSnapshot.hasAssignments = new HasAssignmentsImpl();
        taskSnapshot.setFixedCost(objectInputStream.readDouble());
        taskSnapshot.setFixedCostAccrual(objectInputStream.readInt());
        taskSnapshot.setIgnoreResourceCalendar(objectInputStream.readBoolean());
        if (normalTask.getVersion() >= 2) {
            taskSnapshot.hasAssignments.setSchedulingType(objectInputStream.readInt());
            taskSnapshot.hasAssignments.setEffortDriven(objectInputStream.readBoolean());
        }
        return taskSnapshot;
    }
}

