/*
 * Decompiled with CFR 0.152.
 */
package com.projity.grouping.core.model;

import com.projity.document.Document;
import com.projity.document.ObjectEvent;
import com.projity.grouping.core.Node;
import com.projity.grouping.core.NodeFactory;
import com.projity.grouping.core.hierarchy.HierarchyUtils;
import com.projity.grouping.core.hierarchy.MutableNodeHierarchy;
import com.projity.grouping.core.model.DefaultNodeModel;
import com.projity.grouping.core.model.NodeModelDataFactory;
import com.projity.pm.assignment.Assignment;
import com.projity.pm.assignment.AssignmentService;
import com.projity.pm.assignment.HasAssignments;
import com.projity.pm.task.NormalTask;
import com.projity.pm.task.Project;
import com.projity.undo.AssignmentCreationEdit;
import com.projity.undo.AssignmentDeletionEdit;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.tree.TreeNode;
import javax.swing.undo.UndoableEditSupport;
import org.apache.commons.collections.Closure;

public class AssignmentNodeModel
extends DefaultNodeModel
implements ObjectEvent.Listener {
    protected Document document;
    protected boolean containsLeftObjects;

    public AssignmentNodeModel(Document document, boolean bl) {
        this.containsLeftObjects = bl;
        this.setDocument(document);
    }

    public AssignmentNodeModel(NodeModelDataFactory nodeModelDataFactory) {
        this(nodeModelDataFactory, null, false);
    }

    public AssignmentNodeModel(NodeModelDataFactory nodeModelDataFactory, Document document, boolean bl) {
        super(nodeModelDataFactory);
        this.containsLeftObjects = bl;
        this.setDocument(document);
    }

    AssignmentNodeModel(MutableNodeHierarchy mutableNodeHierarchy, NodeModelDataFactory nodeModelDataFactory, Document document, boolean bl) {
        super(mutableNodeHierarchy, nodeModelDataFactory);
        this.containsLeftObjects = bl;
        this.setDocument(document);
    }

    public void objectChanged(ObjectEvent objectEvent) {
        if (objectEvent.getObject() instanceof Assignment) {
            Assignment assignment = (Assignment)objectEvent.getObject();
            if (assignment.isDefault()) {
                return;
            }
            if (assignment.getDocument(this.containsLeftObjects) == this.document) {
                Node node;
                if (objectEvent.isCreate()) {
                    Object object = this.containsLeftObjects ? assignment.getLeft() : assignment.getRight();
                    Node node2 = this.search(object);
                    if (node2 != null) {
                        Object object2;
                        Object object3 = null;
                        if (objectEvent.getInfo() != null && this.dataFactory instanceof Project) {
                            object3 = objectEvent.getInfo().getNode() != null ? objectEvent.getInfo().getNode() : NodeFactory.getInstance().createNode(assignment);
                        } else {
                            Enumeration<? extends TreeNode> enumeration = node2.children();
                            while (enumeration.hasMoreElements()) {
                                object2 = (Node)enumeration.nextElement();
                                if (object2.getImpl() != assignment) continue;
                                object3 = object2;
                                break;
                            }
                            if (object3 == null) {
                                object3 = NodeFactory.getInstance().createNode(assignment);
                            }
                        }
                        int n = 0;
                        object2 = node2.children();
                        while (object2.hasMoreElements() && ((Node)object2.nextElement()).getImpl() instanceof Assignment) {
                            ++n;
                        }
                        this.add(node2, (Node)object3, n, 1);
                        if ((objectEvent.getInfo() == null || objectEvent.getInfo() != null && objectEvent.getInfo().isUndo()) && this.dataFactory instanceof Project && (object2 = this.getUndoableEditSupport()) != null) {
                            ((UndoableEditSupport)object2).postEdit(new AssignmentCreationEdit((Node)object3));
                        }
                    }
                } else if (objectEvent.isDelete() && (node = this.search(assignment)) != null) {
                    UndoableEditSupport undoableEditSupport;
                    this.remove(node, 1, false, false);
                    if ((objectEvent.getInfo() == null || objectEvent.getInfo() != null && objectEvent.getInfo().isUndo()) && this.dataFactory instanceof Project && (undoableEditSupport = this.getUndoableEditSupport()) != null) {
                        undoableEditSupport.postEdit(new AssignmentDeletionEdit(node));
                    }
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.document.removeObjectListener(this);
    }

    public boolean isContainsLeftObjects() {
        return this.containsLeftObjects;
    }

    public void setContainsLeftObjects(boolean bl) {
        this.containsLeftObjects = bl;
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        if (this.document != null) {
            this.document.removeObjectListener(this);
        }
        this.document = document;
        if (document != null) {
            document.addObjectListener(this);
        }
    }

    public void addAssignments() {
        this.addAssignments(this.iterator());
    }

    public void addAssignments(Iterator iterator) {
        Node node;
        HashMap<Node, Node> hashMap = new HashMap<Node, Node>();
        while (iterator.hasNext()) {
            node = (Node)iterator.next();
            if (!(node.getImpl() instanceof HasAssignments)) continue;
            HasAssignments hasAssignments = (HasAssignments)node.getImpl();
            for (Object object : hasAssignments.getAssignments()) {
                if (((Assignment)object).isDefault()) continue;
                Node node2 = NodeFactory.getInstance().createNode(object);
                hashMap.put(node2, node);
            }
        }
        for (Node node2 : hashMap.keySet()) {
            node = (Node)hashMap.get(node2);
            boolean bl = false;
            Enumeration<? extends TreeNode> enumeration = node.children();
            while (enumeration.hasMoreElements()) {
                Node node3 = (Node)enumeration.nextElement();
                if (node3.getImpl() != node2.getImpl()) continue;
                node2 = node3;
                bl = true;
                break;
            }
            if (bl) continue;
            this.add(node, node2, 0);
        }
    }

    public boolean confirmRemove(List list) {
        return true;
    }

    public void paste(Node node, List list, int n, int n2) {
        super.paste(node, list, n, n2);
        ArrayList arrayList = new ArrayList();
        HierarchyUtils.extractParents(list, arrayList);
        final ArrayList arrayList2 = new ArrayList();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.hierarchy.visitLeaves((Node)iterator.next(), new Closure(){

                public void execute(Object object) {
                    Node node = (Node)object;
                    if (node.getImpl() instanceof Assignment) {
                        NormalTask normalTask;
                        Assignment assignment = (Assignment)node.getImpl();
                        Node node2 = (Node)node.getParent();
                        if (node2.getImpl() instanceof NormalTask && (normalTask = (NormalTask)node2.getImpl()).findAssignment(assignment.getResource()) == null) {
                            arrayList2.add(node);
                        }
                    }
                }
            });
        }
        for (Node node2 : arrayList2) {
            node2.removeFromParent();
            System.out.println("restoring assignment: " + node2.getImpl());
            AssignmentService.getInstance().connect(node2, (Object)this, AssignmentNodeModel.isUndo(n2));
        }
    }
}

