/*
 * Decompiled with CFR 0.152.
 */
package net.sf.nachocalendar.model;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.sf.nachocalendar.event.DataChangeEvent;
import net.sf.nachocalendar.event.DataModelListener;
import net.sf.nachocalendar.model.DataModel;

public class DefaultDataModel
implements DataModel {
    private HashMap data;
    private HashMap mindata;
    private Calendar cal = Calendar.getInstance();
    private Calendar check = Calendar.getInstance();
    private int currentmonth;
    private transient ArrayList dataModelListenerList;

    public DefaultDataModel() {
        this.data = new HashMap();
        this.mindata = new HashMap();
    }

    private void changeMonth(int month) {
        this.currentmonth = month;
        this.mindata.clear();
        Iterator it = this.data.keySet().iterator();
        while (it.hasNext()) {
            Date d = (Date)it.next();
            this.check.setTime(d);
            if (this.check.get(2) != month) continue;
            this.mindata.put(d, this.data.get(d));
        }
    }

    public void addData(Date date, Object o) {
        this.data.put(date, o);
        this.fireDataModelListenerDataChanged(new DataChangeEvent(o, date));
        this.currentmonth = -1;
    }

    public void removeData(Date date) {
        Object o = this.data.remove(date);
        this.currentmonth = -1;
        if (o != null) {
            this.fireDataModelListenerDataChanged(new DataChangeEvent(o, date));
        }
    }

    public int getSize() {
        return this.data.size();
    }

    public Map getAll() {
        return (Map)this.data.clone();
    }

    public void clear() {
        this.data.clear();
    }

    public Object getData(Date date) {
        this.cal.setTime(date);
        int month = this.cal.get(2);
        if (month != this.currentmonth) {
            this.changeMonth(month);
        }
        int year = this.cal.get(1);
        int day = this.cal.get(5);
        Iterator it = this.mindata.keySet().iterator();
        while (it.hasNext()) {
            Date d = (Date)it.next();
            if (!this.compareDates(year, month, day, d)) continue;
            return this.mindata.get(d);
        }
        return null;
    }

    private boolean compareDates(int year, int month, int day, Date d) {
        this.check.setTime(d);
        if (day != this.check.get(5)) {
            return false;
        }
        if (month != this.check.get(2)) {
            return false;
        }
        return year == this.check.get(1);
    }

    public synchronized void addDataModelListener(DataModelListener listener) {
        if (this.dataModelListenerList == null) {
            this.dataModelListenerList = new ArrayList();
        }
        this.dataModelListenerList.add(listener);
    }

    public synchronized void removeDataModelListener(DataModelListener listener) {
        if (this.dataModelListenerList != null) {
            this.dataModelListenerList.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireDataModelListenerDataChanged(DataChangeEvent event) {
        ArrayList list;
        DefaultDataModel defaultDataModel = this;
        synchronized (defaultDataModel) {
            if (this.dataModelListenerList == null) {
                return;
            }
            list = (ArrayList)this.dataModelListenerList.clone();
        }
        for (int i = 0; i < list.size(); ++i) {
            ((DataModelListener)list.get(i)).dataChanged(event);
        }
    }
}

