/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.sessions;

import java.util.Enumeration;
import java.util.Vector;
import oracle.toplink.essentials.descriptors.ClassDescriptor;
import oracle.toplink.essentials.descriptors.InheritancePolicy;
import oracle.toplink.essentials.exceptions.DescriptorException;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.localization.ToStringLocalization;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.internal.sessions.CommitOrderCalculator;
import oracle.toplink.essentials.mappings.DatabaseMapping;
import oracle.toplink.essentials.mappings.ForeignReferenceMapping;

public class CommitOrderDependencyNode {
    protected CommitOrderCalculator owner;
    protected ClassDescriptor descriptor;
    protected AbstractSession session;
    protected Vector relatedNodes;
    protected CommitOrderDependencyNode predecessor;
    protected int traversalState;
    public static int NotVisited = 1;
    public static int InProgress = 2;
    public static int Visited = 3;
    protected int discoveryTime;
    protected int finishingTime;

    public CommitOrderDependencyNode(CommitOrderCalculator calculator, ClassDescriptor descriptor, AbstractSession session) {
        this.owner = calculator;
        this.descriptor = descriptor;
        this.relatedNodes = new Vector();
        this.session = session;
    }

    public ClassDescriptor getDescriptor() {
        return this.descriptor;
    }

    public int getFinishingTime() {
        return this.finishingTime;
    }

    public CommitOrderCalculator getOwner() {
        return this.owner;
    }

    public CommitOrderDependencyNode getPredecessor() {
        return this.predecessor;
    }

    public Vector getRelatedNodes() {
        return this.relatedNodes;
    }

    public boolean hasBeenVisited() {
        return this.traversalState == Visited;
    }

    public boolean hasNotBeenVisited() {
        return this.traversalState == NotVisited;
    }

    public void markInProgress() {
        this.traversalState = InProgress;
    }

    public void markNotVisited() {
        this.traversalState = NotVisited;
    }

    public void markVisited() {
        this.traversalState = Visited;
    }

    public void recordMappingDependencies() {
        Enumeration<DatabaseMapping> mappings = this.getDescriptor().getMappings().elements();
        while (mappings.hasMoreElements()) {
            Class ownerClass;
            Vector ownedNodes;
            ClassDescriptor refDescriptor;
            DatabaseMapping mapping = mappings.nextElement();
            if (!mapping.isForeignReferenceMapping()) continue;
            if (((ForeignReferenceMapping)mapping).hasConstraintDependency()) {
                Class ownedClass;
                refDescriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor();
                if (refDescriptor == null) {
                    refDescriptor = this.session.getDescriptor(((ForeignReferenceMapping)mapping).getReferenceClass());
                }
                if ((ownedClass = refDescriptor.getJavaClass()) == null) {
                    throw DescriptorException.referenceClassNotSpecified(mapping);
                }
                CommitOrderDependencyNode node = this.getOwner().nodeFor(ownedClass);
                ownedNodes = this.withAllSubclasses(node);
                Helper.addAllToVector(this.relatedNodes, ownedNodes);
                continue;
            }
            if (!((ForeignReferenceMapping)mapping).hasInverseConstraintDependency()) continue;
            refDescriptor = ((ForeignReferenceMapping)mapping).getReferenceDescriptor();
            if (refDescriptor == null) {
                refDescriptor = this.session.getDescriptor(((ForeignReferenceMapping)mapping).getReferenceClass());
            }
            if ((ownerClass = refDescriptor.getJavaClass()) == null) {
                throw DescriptorException.referenceClassNotSpecified(mapping);
            }
            CommitOrderDependencyNode ownerNode = this.getOwner().nodeFor(ownerClass);
            ownedNodes = this.withAllSubclasses(this);
            Helper.addAllToVector(ownerNode.getRelatedNodes(), ownedNodes);
        }
    }

    public void recordSpecifiedDependencies() {
        Enumeration constraintsEnum = this.getDescriptor().getConstraintDependencies().elements();
        while (constraintsEnum.hasMoreElements()) {
            Class ownedClass = (Class)constraintsEnum.nextElement();
            CommitOrderDependencyNode node = this.getOwner().nodeFor(ownedClass);
            Vector ownedNodes = this.withAllSubclasses(node);
            Helper.addAllToVector(this.relatedNodes, ownedNodes);
        }
    }

    public void setDiscoveryTime(int time) {
        this.discoveryTime = time;
    }

    public void setFinishingTime(int time) {
        this.finishingTime = time;
    }

    public void setPredecessor(CommitOrderDependencyNode n) {
        this.predecessor = n;
    }

    public String toString() {
        if (this.descriptor == null) {
            return ToStringLocalization.buildMessage("empty_commit_order_dependency_node", null);
        }
        Object[] args = new Object[]{this.descriptor};
        return ToStringLocalization.buildMessage("node", args);
    }

    public void visit() {
        this.markInProgress();
        int startTime = this.getOwner().getNextTime();
        this.setDiscoveryTime(startTime);
        Enumeration e = this.getRelatedNodes().elements();
        while (e.hasMoreElements()) {
            CommitOrderDependencyNode node = (CommitOrderDependencyNode)e.nextElement();
            if (node.hasNotBeenVisited()) {
                node.setPredecessor(this);
                node.visit();
            }
            if (node.getPredecessor() != null) continue;
            node.setPredecessor(this);
        }
        this.markVisited();
        this.setFinishingTime(this.getOwner().getNextTime());
    }

    public Vector withAllSubclasses(CommitOrderDependencyNode node) {
        Vector<CommitOrderDependencyNode> results = new Vector<CommitOrderDependencyNode>();
        results.addElement(node);
        if (node.getDescriptor().hasInheritance()) {
            InheritancePolicy p = node.getDescriptor().getInheritancePolicy();
            Enumeration e = p.getAllChildDescriptors().elements();
            while (e.hasMoreElements()) {
                results.addElement(this.getOwner().nodeFor((ClassDescriptor)e.nextElement()));
            }
        }
        return results;
    }
}

