/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.debugger;

import java.io.IOException;
import javax.swing.JEditorPane;
import javax.swing.text.Element;
import javax.swing.text.StyledDocument;
import org.jrubyparser.ast.INameNode;
import org.jrubyparser.ast.Node;
import org.jrubyparser.ast.NodeType;
import org.netbeans.modules.ruby.AstUtilities;
import org.netbeans.modules.ruby.debugger.RubySession;
import org.netbeans.modules.ruby.debugger.Util;
import org.netbeans.spi.debugger.ui.EditorContextDispatcher;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Annotation;
import org.openide.text.DataEditorSupport;
import org.openide.text.Line;
import org.openide.text.NbDocument;
import org.openide.util.RequestProcessor;
import org.rubyforge.debugcommons.model.RubyValue;
import org.rubyforge.debugcommons.model.RubyVariable;

public final class ToolTipAnnotation
extends Annotation
implements Runnable {
    private static final Boolean SKIP_BALLOON_EVAL = Boolean.getBoolean("ruby.debugger.skip.balloon.evaluation");
    private static final RequestProcessor requestProcessor = new RequestProcessor("Ruby tooltip annotations");
    private Line.Part lp;
    private EditorCookie ec;

    public String getShortDescription() {
        RubySession session = Util.getCurrentSession();
        if (session == null) {
            return null;
        }
        Line.Part _lp = (Line.Part)this.getAttachedAnnotatable();
        if (_lp == null) {
            return null;
        }
        Line line = _lp.getLine();
        DataObject dob = DataEditorSupport.findDataObject((Line)line);
        if (dob == null) {
            return null;
        }
        EditorCookie _ec = (EditorCookie)dob.getCookie(EditorCookie.class);
        if (_ec == null) {
            return null;
        }
        this.lp = _lp;
        this.ec = _ec;
        requestProcessor.post((Runnable)this);
        return null;
    }

    @Override
    public void run() {
        StyledDocument doc;
        if (SKIP_BALLOON_EVAL.booleanValue()) {
            return;
        }
        if (this.lp == null || this.ec == null) {
            return;
        }
        try {
            doc = this.ec.openDocument();
        }
        catch (IOException ex) {
            return;
        }
        JEditorPane ep = EditorContextDispatcher.getDefault().getCurrentEditor();
        if (ep == null) {
            return;
        }
        String expression = ToolTipAnnotation.getIdentifier(doc, ep, NbDocument.findLineOffset((StyledDocument)doc, (int)this.lp.getLine().getLineNumber()) + this.lp.getColumn());
        if (expression == null) {
            return;
        }
        RubySession session = Util.getCurrentSession();
        if (session == null) {
            return;
        }
        RubyVariable var = session.inspectExpression(expression);
        if (var == null) {
            return;
        }
        RubyValue value = var.getValue();
        if (value == null) {
            return;
        }
        String stringVal = value.getValueString();
        if (stringVal == null || stringVal.equals(expression)) {
            return;
        }
        String toolTipText = expression + " = " + stringVal;
        this.firePropertyChange("shortDescription", null, toolTipText);
    }

    public String getAnnotationType() {
        return null;
    }

    private static String getIdentifier(StyledDocument doc, JEditorPane ep, int offset) {
        if (ep.getSelectionStart() <= offset && offset <= ep.getSelectionEnd()) {
            return ep.getSelectedText();
        }
        int line = NbDocument.findLineNumber((StyledDocument)doc, (int)offset);
        int col = NbDocument.findLineColumn((StyledDocument)doc, (int)offset);
        Element lineElem = NbDocument.findLineRootElement((StyledDocument)doc).getElement(line);
        if (lineElem == null) {
            return null;
        }
        int lineStartOffset = lineElem.getStartOffset();
        int lineLen = lineElem.getEndOffset() - lineStartOffset;
        if (col + 1 >= lineLen) {
            return null;
        }
        FileObject fo = EditorContextDispatcher.getDefault().getCurrentFile();
        if (fo == null) {
            return null;
        }
        return ToolTipAnnotation.getExpressionToEvaluate(fo, offset);
    }

    static String getExpressionToEvaluate(FileObject fo, int offset) {
        Node root = AstUtilities.getRoot((FileObject)fo);
        if (root == null) {
            return null;
        }
        Node node = AstUtilities.findNodeAtOffset((Node)root, (int)offset);
        if (node == null) {
            return null;
        }
        if (node.getNodeType() == NodeType.NEWLINENODE) {
            node = AstUtilities.findNodeAtOffset((Node)root, (int)(offset + 1));
        }
        if (ToolTipAnnotation.shouldEvaluate(node) && node instanceof INameNode) {
            return AstUtilities.getName((Node)node);
        }
        return null;
    }

    private static boolean shouldEvaluate(Node node) {
        if (node.getNodeType() == null) {
            return false;
        }
        switch (node.getNodeType()) {
            case ARGUMENTNODE: 
            case DVARNODE: 
            case DASGNNODE: 
            case SELFNODE: 
            case LOCALVARNODE: 
            case LOCALASGNNODE: 
            case INSTVARNODE: 
            case INSTASGNNODE: 
            case GLOBALVARNODE: 
            case GLOBALASGNNODE: 
            case CONSTNODE: 
            case CONSTDECLNODE: 
            case CLASSVARNODE: 
            case CLASSVARASGNNODE: 
            case NILNODE: 
            case TRUENODE: 
            case FALSENODE: {
                return true;
            }
        }
        return false;
    }
}

