/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.monitor;

import org.netbeans.lib.profiler.client.MonitoredData;
import org.netbeans.lib.profiler.results.DataManager;

public class VMTelemetryDataManager
extends DataManager {
    public long[] freeMemory;
    public long[] lastGCPauseInMS;
    public long[] loadedClassesCount;
    public long[] nSurvivingGenerations;
    public long[] nSystemThreads;
    public long[] nTotalThreads;
    public long[] nUserThreads;
    public long[] relativeGCTimeInPerMil;
    public long[] timeStamps;
    public long[] totalMemory;
    public long[] usedMemory;
    public long[][] gcFinishs;
    public long[][] gcStarts;
    public long maxHeapSize = Long.MAX_VALUE;
    private MonitoredData lastData = null;
    private boolean firstStart;
    private int lastUnpairedStart;
    private int arrayBufferSize;
    private int currentArraysSize;
    private int itemCount;

    public VMTelemetryDataManager() {
        this(50);
    }

    public VMTelemetryDataManager(int arrayBufferSize) {
        this.arrayBufferSize = arrayBufferSize;
        this.reset();
    }

    public synchronized void setArrayBufferSize(int arrayBufferSize) {
        this.arrayBufferSize = arrayBufferSize;
    }

    public synchronized int getArrayBufferSize() {
        return this.arrayBufferSize;
    }

    public synchronized int getItemCount() {
        return this.itemCount;
    }

    public synchronized MonitoredData getLastData() {
        return this.lastData;
    }

    public synchronized void processData(MonitoredData data) {
        this.addValuesInternal(data.getTimestamp(), data.getFreeMemory(), data.getTotalMemory(), data.getNUserThreads(), data.getNSystemThreads(), data.getNSurvivingGenerations(), data.getRelativeGCTimeInPerMil(), data.getLastGCPauseInMS(), data.getLoadedClassesCount(), data.getGCStarts(), data.getGCFinishs());
        this.lastData = data;
    }

    public synchronized void reset() {
        this.lastData = null;
        this.itemCount = 0;
        this.timeStamps = new long[this.arrayBufferSize];
        this.freeMemory = new long[this.arrayBufferSize];
        this.totalMemory = new long[this.arrayBufferSize];
        this.usedMemory = new long[this.arrayBufferSize];
        this.nUserThreads = new long[this.arrayBufferSize];
        this.nSystemThreads = new long[this.arrayBufferSize];
        this.nTotalThreads = new long[this.arrayBufferSize];
        this.nSurvivingGenerations = new long[this.arrayBufferSize];
        this.relativeGCTimeInPerMil = new long[this.arrayBufferSize];
        this.lastGCPauseInMS = new long[this.arrayBufferSize];
        this.loadedClassesCount = new long[this.arrayBufferSize];
        this.currentArraysSize = this.arrayBufferSize;
        this.gcStarts = new long[this.arrayBufferSize][];
        this.gcFinishs = new long[this.arrayBufferSize][];
        this.firstStart = true;
        this.lastUnpairedStart = -1;
        this.fireDataReset();
    }

    private void addValuesInternal(long timeStamp, long freeMemory, long totalMemory, long nUserThreads, long nSystemThreads, long nSurvivingGenerations, long relativeGCTimeInPerMil, long lastGCPauseInMS, long loadedClassesCount, long[] gcStarts, long[] gcFinishs) {
        this.checkArraysSize();
        this.timeStamps[this.itemCount] = timeStamp;
        this.freeMemory[this.itemCount] = freeMemory;
        this.totalMemory[this.itemCount] = totalMemory;
        this.usedMemory[this.itemCount] = totalMemory - freeMemory;
        this.nUserThreads[this.itemCount] = nUserThreads;
        this.nSystemThreads[this.itemCount] = nSystemThreads;
        this.nTotalThreads[this.itemCount] = nSystemThreads + nUserThreads;
        this.nSurvivingGenerations[this.itemCount] = nSurvivingGenerations;
        this.relativeGCTimeInPerMil[this.itemCount] = relativeGCTimeInPerMil;
        this.lastGCPauseInMS[this.itemCount] = lastGCPauseInMS;
        this.loadedClassesCount[this.itemCount] = loadedClassesCount;
        if (gcStarts.length > 0 || gcFinishs.length > 0) {
            if (this.firstStart && gcStarts.length > 0) {
                if (gcFinishs.length > 0 && gcStarts[0] > gcFinishs[0]) {
                    long[] gcFinishs2 = new long[gcFinishs.length - 1];
                    if (gcFinishs2.length > 0) {
                        System.arraycopy(gcFinishs, 1, gcFinishs2, 0, gcFinishs2.length);
                    }
                    gcFinishs = gcFinishs2;
                }
                this.firstStart = false;
            }
            boolean sameStartsFinishsCount = gcStarts.length == gcFinishs.length;
            boolean thisItemsPaired = sameStartsFinishsCount && this.lastUnpairedStart == -1 || !sameStartsFinishsCount && this.lastUnpairedStart != -1;
            int extraItemsBuffer = thisItemsPaired ? 0 : 1;
            int newItemsLength = Math.max(gcStarts.length, gcFinishs.length) + extraItemsBuffer;
            if (gcStarts.length == newItemsLength) {
                this.gcStarts[this.itemCount] = gcStarts;
            } else {
                this.gcStarts[this.itemCount] = new long[newItemsLength];
                System.arraycopy(gcStarts, 0, this.gcStarts[this.itemCount], extraItemsBuffer, gcStarts.length);
            }
            if (gcFinishs.length == newItemsLength) {
                this.gcFinishs[this.itemCount] = gcFinishs;
            } else {
                this.gcFinishs[this.itemCount] = new long[newItemsLength];
                System.arraycopy(gcFinishs, 0, this.gcFinishs[this.itemCount], 0, gcFinishs.length);
            }
            if (!thisItemsPaired) {
                this.gcFinishs[this.itemCount][newItemsLength - 1] = -1L;
            }
            if (this.lastUnpairedStart != -1) {
                long[] unpairedStarts = this.gcStarts[this.lastUnpairedStart];
                long[] unpairedFinishs = this.gcFinishs[this.lastUnpairedStart];
                unpairedFinishs[unpairedFinishs.length - 1] = gcFinishs[0];
                this.gcStarts[this.itemCount][0] = unpairedStarts[unpairedStarts.length - 1];
            }
            this.lastUnpairedStart = !thisItemsPaired ? this.itemCount : -1;
        } else {
            this.gcStarts[this.itemCount] = gcStarts;
            this.gcFinishs[this.itemCount] = gcFinishs;
        }
        ++this.itemCount;
        this.fireDataChanged();
    }

    private void checkArraysSize() {
        if (this.currentArraysSize == this.itemCount) {
            this.timeStamps = VMTelemetryDataManager.extendArray(this.timeStamps, this.arrayBufferSize);
            this.freeMemory = VMTelemetryDataManager.extendArray(this.freeMemory, this.arrayBufferSize);
            this.totalMemory = VMTelemetryDataManager.extendArray(this.totalMemory, this.arrayBufferSize);
            this.usedMemory = VMTelemetryDataManager.extendArray(this.usedMemory, this.arrayBufferSize);
            this.nUserThreads = VMTelemetryDataManager.extendArray(this.nUserThreads, this.arrayBufferSize);
            this.nSystemThreads = VMTelemetryDataManager.extendArray(this.nSystemThreads, this.arrayBufferSize);
            this.nTotalThreads = VMTelemetryDataManager.extendArray(this.nTotalThreads, this.arrayBufferSize);
            this.nSurvivingGenerations = VMTelemetryDataManager.extendArray(this.nSurvivingGenerations, this.arrayBufferSize);
            this.relativeGCTimeInPerMil = VMTelemetryDataManager.extendArray(this.relativeGCTimeInPerMil, this.arrayBufferSize);
            this.lastGCPauseInMS = VMTelemetryDataManager.extendArray(this.lastGCPauseInMS, this.arrayBufferSize);
            this.loadedClassesCount = VMTelemetryDataManager.extendArray(this.loadedClassesCount, this.arrayBufferSize);
            this.gcStarts = VMTelemetryDataManager.extendArray(this.gcStarts, this.arrayBufferSize);
            this.gcFinishs = VMTelemetryDataManager.extendArray(this.gcFinishs, this.arrayBufferSize);
            this.currentArraysSize += this.arrayBufferSize;
        }
    }

    private static long[] extendArray(long[] array, int extraLength) {
        int originalLength = array.length;
        long[] newArray = new long[originalLength + extraLength];
        System.arraycopy(array, 0, newArray, 0, originalLength);
        return newArray;
    }

    private static long[][] extendArray(long[][] array, int extraLength) {
        int originalLength = array.length;
        long[][] newArray = new long[originalLength + extraLength][];
        System.arraycopy(array, 0, newArray, 0, originalLength);
        return newArray;
    }
}

