/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.PipedInputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import org.jruby.nb.Ruby;
import org.jruby.nb.RubyInstanceConfig;
import org.jruby.nb.demo.TextAreaReadline;
import org.jruby.nb.internal.runtime.ValueAccessor;
import org.jruby.nb.runtime.IAccessor;
import org.jruby.nb.runtime.builtin.IRubyObject;
import org.netbeans.api.ruby.platform.RubyInstallation;
import org.openide.ErrorManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class IrbTopComponent
extends TopComponent {
    private boolean finished = true;
    private JTextPane text;
    private static IrbTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/ruby/rubyproject/jruby.png";
    private static final String PREFERRED_ID = "IrbTopComponent";

    private IrbTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(IrbTopComponent.class, (String)"CTL_IrbTopComponent"));
        this.setToolTipText(NbBundle.getMessage(IrbTopComponent.class, (String)"HINT_IrbTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
    }

    public static synchronized IrbTopComponent getDefault() {
        if (instance == null) {
            instance = new IrbTopComponent();
        }
        return instance;
    }

    public static synchronized IrbTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            ErrorManager.getDefault().log(16, "Cannot find MyWindow component. It will not be located properly in the window system.");
            return IrbTopComponent.getDefault();
        }
        if (win instanceof IrbTopComponent) {
            return (IrbTopComponent)win;
        }
        ErrorManager.getDefault().log(16, "There seem to be multiple components with the 'IrbTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return IrbTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
        if (this.finished) {
            this.finished = false;
            this.removeAll();
            this.createTerminal();
        }
    }

    public void componentClosed() {
    }

    public void componentActivated() {
        Caret caret;
        if (this.text != null && (caret = this.text.getCaret()) != null) {
            caret.setVisible(true);
        }
    }

    public void componentDeactivated() {
        Caret caret;
        if (this.text != null && (caret = this.text.getCaret()) != null) {
            caret.setVisible(false);
        }
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void createTerminal() {
        Font f;
        this.text = new JTextPane();
        this.text.setMargin(new Insets(8, 8, 8, 8));
        this.text.setCaretColor(new Color(164, 0, 0));
        this.text.setBackground(new Color(242, 242, 242));
        this.text.setForeground(new Color(164, 0, 0));
        Integer i = (Integer)UIManager.get("customFontSize");
        int size = i != null ? i : ((f = (Font)UIManager.get("controlFont")) != null ? f.getSize() : 11);
        this.text.setFont(new Font("Monospaced", 0, size));
        this.setBorder(BorderFactory.createEmptyBorder());
        Color c = UIManager.getColor("nb.output.selectionBackground");
        if (c != null) {
            this.text.setSelectionColor(c);
        }
        JScrollPane pane = new JScrollPane();
        pane.setViewportView(this.text);
        pane.setBorder(BorderFactory.createLineBorder(Color.darkGray));
        this.add(pane);
        this.validate();
        final Ruby runtime = IrbTopComponent.getRuntime(this.text);
        RequestProcessor.Task task = RequestProcessor.getDefault().create(new Runnable(){

            @Override
            public void run() {
                IrbTopComponent.startIRB(runtime);
            }
        });
        task.addTaskListener(new TaskListener(){

            public void taskFinished(Task task) {
                IrbTopComponent.this.finished = true;
                IrbTopComponent.this.text.setEditable(false);
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        IrbTopComponent.this.close();
                        IrbTopComponent.this.removeAll();
                        IrbTopComponent.this.text = null;
                    }
                });
            }
        });
        task.schedule(10);
        this.text.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent ev) {
                final int mouseX = ev.getX();
                final int mouseY = ev.getY();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        int pos = IrbTopComponent.this.text.getDocument().getEndPosition().getOffset() - 1;
                        if (pos == -1) {
                            return;
                        }
                        try {
                            Rectangle r = IrbTopComponent.this.text.modelToView(pos);
                            if (mouseY >= r.y) {
                                r.x = mouseX;
                                pos = IrbTopComponent.this.text.viewToModel(r.getLocation());
                            }
                            IrbTopComponent.this.text.getCaret().setDot(pos);
                        }
                        catch (BadLocationException badLocationException) {
                            // empty catch block
                        }
                    }
                });
            }
        });
    }

    static Ruby getRuntime(JTextComponent text) {
        final TextAreaReadline tar = new TextAreaReadline(text, " " + NbBundle.getMessage(IrbTopComponent.class, (String)"IrbWelcome") + " \n\n");
        RubyInstallation.getInstance().setJRubyLoadPaths();
        final PipedInputStream pipeIn = new PipedInputStream();
        RubyInstanceConfig config = new RubyInstanceConfig(){
            {
                this.setInput(pipeIn);
                this.setOutput(new PrintStream(tar.getOutputStream()));
                this.setError(new PrintStream(tar.getOutputStream()));
                this.setObjectSpaceEnabled(false);
            }
        };
        Ruby runtime = Ruby.newInstance((RubyInstanceConfig)config);
        runtime.getGlobalVariables().defineReadonly("$$", (IAccessor)new ValueAccessor((IRubyObject)runtime.newFixnum(System.identityHashCode(runtime))));
        runtime.getLoadService().init(new ArrayList());
        tar.hookIntoRuntime(runtime);
        return runtime;
    }

    private static void startIRB(Ruby runtime) {
        runtime.evalScriptlet("require 'irb'; require 'irb/completion'; IRB.start");
    }

    public void requestFocus() {
        if (this.text != null) {
            this.text.requestFocus();
        }
    }

    public boolean requestFocusInWindow() {
        if (this.text != null) {
            return this.text.requestFocusInWindow();
        }
        return false;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return IrbTopComponent.getDefault();
        }
    }
}

