/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.rubyproject;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.ruby.rubyproject.RakeParameters;
import org.netbeans.modules.ruby.rubyproject.rake.RakeTask;
import org.openide.filesystems.FileObject;

public final class Fixtures {
    private static final Logger LOGGER = Logger.getLogger(Fixtures.class.getName());
    private static final List<String> FIXTURE_TASKS = Arrays.asList("db:fixtures:load");

    private Fixtures() {
    }

    static boolean isFixtureTask(RakeTask task) {
        if (task == null) {
            return false;
        }
        return FIXTURE_TASKS.contains(task.getTask());
    }

    public static List<Fixture> getFixtures(Project project) {
        FileObject projectDir = project.getProjectDirectory();
        FileObject fixturesDir = projectDir.getFileObject("test/fixtures");
        if (fixturesDir == null) {
            return Collections.emptyList();
        }
        ArrayList<Fixture> fixtures = new ArrayList<Fixture>();
        for (FileObject fo : fixturesDir.getChildren()) {
            String name = fo.getName();
            if (!fo.getMIMEType().equals("text/x-yaml") && !fo.isFolder()) continue;
            fixtures.add(new Fixture(name, fo.isFolder()));
        }
        Collections.sort(fixtures);
        return fixtures;
    }

    public static class Fixture
    implements RakeParameters.RakeParameter,
    Comparable<Fixture> {
        private final String name;
        private final boolean dir;

        public Fixture(String name, boolean dir) {
            this.name = name;
            this.dir = dir;
        }

        @Override
        public String toRakeParam() {
            return this.dir ? "FIXTURES_DIR=" + this.name : "FIXTURES=" + this.name;
        }

        @Override
        public int compareTo(Fixture o) {
            return this.toRakeParam().compareTo(o.toRakeParam());
        }

        public String toString() {
            return this.toRakeParam();
        }
    }
}

