/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.weblogic9.config;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.netbeans.modules.j2ee.deployment.common.api.ConfigurationException;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.DeploymentPlanConfiguration;
import org.netbeans.modules.j2ee.deployment.plugins.spi.config.ModuleConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.ConfigUtil;
import org.netbeans.modules.j2ee.weblogic9.config.WLDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.WarDeploymentConfiguration;
import org.netbeans.modules.j2ee.weblogic9.config.gen.WeblogicApplication;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class EarDeploymentConfiguration
extends WLDeploymentConfiguration
implements ModuleConfiguration,
DeploymentPlanConfiguration {
    private final File file;
    private final J2eeModule j2eeModule;
    private final DataObject dataObject;
    private WeblogicApplication weblogicApplication;

    public EarDeploymentConfiguration(J2eeModule j2eeModule) {
        super(j2eeModule);
        this.j2eeModule = j2eeModule;
        this.file = j2eeModule.getDeploymentConfigurationFile("META-INF/weblogic-application.xml");
        this.getWeblogicApplication();
        DataObject dataObject = null;
        try {
            dataObject = DataObject.find((FileObject)FileUtil.toFileObject((File)this.file));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            Exceptions.printStackTrace((Throwable)dataObjectNotFoundException);
        }
        this.dataObject = dataObject;
    }

    public synchronized WeblogicApplication getWeblogicApplication() {
        if (this.weblogicApplication == null) {
            try {
                if (this.file.exists()) {
                    try {
                        this.weblogicApplication = WeblogicApplication.createGraph(this.file);
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    catch (RuntimeException runtimeException) {}
                } else {
                    this.weblogicApplication = this.genereateweblogicApplication();
                    ConfigUtil.writefile(this.file, this.weblogicApplication);
                }
            }
            catch (ConfigurationException configurationException) {
                Exceptions.printStackTrace((Throwable)configurationException);
            }
        }
        return this.weblogicApplication;
    }

    public Lookup getLookup() {
        return Lookups.fixed((Object[])new Object[]{this});
    }

    public J2eeModule getJ2eeModule() {
        return this.j2eeModule;
    }

    public void dispose() {
    }

    public void save(OutputStream outputStream) throws ConfigurationException {
        WeblogicApplication weblogicApplication = this.getWeblogicApplication();
        if (weblogicApplication == null) {
            String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_cannotSaveNotParseableConfFile", (Object)this.file.getPath());
            throw new ConfigurationException(string);
        }
        try {
            weblogicApplication.write(outputStream);
        }
        catch (IOException iOException) {
            String string = NbBundle.getMessage(WarDeploymentConfiguration.class, (String)"MSG_CannotUpdateFile", (Object)this.file.getPath());
            throw new ConfigurationException(string, (Throwable)iOException);
        }
    }

    private WeblogicApplication genereateweblogicApplication() {
        return new WeblogicApplication();
    }
}

