/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.svgcore.composer;

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import org.netbeans.modules.mobility.svgcore.composer.SceneManager;

public final class InputControlManager {
    private final SceneManager m_sceneMgr;
    private final MouseController m_mouseCtrl;
    private final KeyboardController m_keyCtrl;

    public InputControlManager(SceneManager sceneMgr) {
        this.m_sceneMgr = sceneMgr;
        this.m_mouseCtrl = new MouseController();
        this.m_keyCtrl = new KeyboardController();
    }

    void initialize() {
        this.m_sceneMgr.getScreenManager().registerMouseController(this.m_mouseCtrl);
        this.m_sceneMgr.getScreenManager().registerKeyController(this.m_keyCtrl);
    }

    private class KeyboardController
    implements KeyListener {
        private KeyboardController() {
        }

        @Override
        public void keyTyped(KeyEvent e) {
            InputControlManager.this.m_sceneMgr.processEvent(e);
        }

        @Override
        public void keyPressed(KeyEvent e) {
            InputControlManager.this.m_sceneMgr.processEvent(e);
        }

        @Override
        public void keyReleased(KeyEvent e) {
            InputControlManager.this.m_sceneMgr.processEvent(e);
        }
    }

    class MouseController
    implements MouseListener,
    MouseMotionListener {
        MouseController() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            InputControlManager.this.m_sceneMgr.processEvent(e);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            InputControlManager.this.m_sceneMgr.processEvent(e);
        }

        @Override
        public void mouseEntered(MouseEvent e) {
            InputControlManager.this.m_sceneMgr.processEvent(e);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            InputControlManager.this.m_sceneMgr.processEvent(e);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            InputControlManager.this.m_sceneMgr.processEvent(e);
        }

        @Override
        public void mousePressed(MouseEvent e) {
            InputControlManager.this.m_sceneMgr.processEvent(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            InputControlManager.this.m_sceneMgr.processEvent(e);
        }
    }
}

