/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.queue;

import java.io.IOException;
import java.util.concurrent.locks.ReadWriteLock;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.queue.KeyValueQueue;
import org.netbeans.modules.cnd.repository.queue.RepositoryQueue;
import org.netbeans.modules.cnd.repository.queue.RepositoryThreadManager;
import org.netbeans.modules.cnd.repository.queue.RepositoryWriter;
import org.netbeans.modules.cnd.repository.queue.TickingRepositoryQueue;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.testbench.Stats;
import org.netbeans.modules.cnd.repository.util.RepositoryListenersManager;

public class RepositoryWritingThread
implements Runnable {
    private RepositoryWriter writer;
    private RepositoryQueue queue;
    private ReadWriteLock rwLock;
    private static final int NUM_SPARE_TIMES_TO_ALLOW_MAINTENANCE = TickingRepositoryQueue.queueTickShift * 3;
    private int numOfSpareCycles = 0;
    private boolean maintenanceIsNeeded = true;

    public RepositoryWritingThread(RepositoryWriter writer, RepositoryQueue queue, ReadWriteLock rwLock) {
        this.writer = writer;
        this.queue = queue;
        this.rwLock = rwLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitReady() throws InterruptedException {
        if (Stats.maintenanceInterval > 0) {
            if (Stats.allowMaintenance && ++this.numOfSpareCycles >= NUM_SPARE_TIMES_TO_ALLOW_MAINTENANCE && this.maintenanceIsNeeded) {
                if (Stats.queueTrace) {
                    System.err.printf("%s: maintenance %d ms...\n", this.getName(), Stats.maintenanceInterval);
                }
                long time = System.currentTimeMillis();
                try {
                    this.rwLock.readLock().lock();
                    try {
                        this.maintenanceIsNeeded = this.writer.maintenance(Stats.maintenanceInterval);
                    }
                    catch (IOException ex) {
                        ex.printStackTrace();
                    }
                }
                finally {
                    this.rwLock.readLock().unlock();
                }
                time = System.currentTimeMillis() - time;
                if (time < (long)Stats.maintenanceInterval) {
                    Thread.sleep((long)Stats.maintenanceInterval - time);
                }
            } else {
                if (Stats.queueTrace) {
                    System.err.printf("%s: sleeping %d ms...\n", this.getName(), Stats.maintenanceInterval);
                }
                Thread.sleep(Stats.maintenanceInterval);
            }
            this.queue.onIdle();
        } else {
            if (Stats.queueTrace) {
                System.err.printf("%s: waiting...\n", this.getName());
            }
            this.queue.waitReady();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Stats.queueTrace) {
            System.err.printf("%s: started.\n", this.getName());
        }
        while (true) {
            try {
                while (true) {
                    try {
                        this.rwLock.readLock().lock();
                        while (this.queue.isReady()) {
                            KeyValueQueue.Entry entry = this.queue.poll();
                            this.numOfSpareCycles = 0;
                            this.maintenanceIsNeeded = true;
                            if (Stats.queueTrace) {
                                System.err.printf("%s: writing %s\n", this.getName(), entry.getKey());
                            }
                            this.writer.write((Key)entry.getKey(), (Persistent)entry.getValue());
                        }
                    }
                    finally {
                        this.rwLock.readLock().unlock();
                    }
                    if (!RepositoryThreadManager.proceed()) break;
                    this.waitReady();
                }
                if (!Stats.queueTrace) break;
                System.err.printf("%s: exiting\n", this.getName());
            }
            catch (Throwable e) {
                RepositoryListenersManager.getInstance().fireAnException(null, new RepositoryException(e));
                continue;
            }
            break;
        }
    }

    private String getName() {
        return Thread.currentThread().getName();
    }
}

