/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.ruby.railsprojects.ui.wizards;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import javax.swing.AbstractButton;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.api.ruby.platform.RubyPlatform;
import org.netbeans.modules.ruby.platform.PlatformComponentFactory;
import org.netbeans.modules.ruby.platform.RubyPlatformCustomizer;
import org.netbeans.modules.ruby.platform.gems.GemManager;
import org.netbeans.modules.ruby.railsprojects.server.RailsServerUiUtils;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.ruby.railsprojects.ui.wizards.SettingsPanel;
import org.netbeans.modules.ruby.rubyproject.Util;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class PanelOptionsVisual
extends SettingsPanel
implements PropertyChangeListener {
    private final PanelConfigureProject panel;
    private final Set<RubyPlatform> reloaded = new HashSet<RubyPlatform>();
    private JButton manageButton;
    private JComboBox platforms;
    private JLabel rubyPlatformLabel;
    private JComboBox serverComboBox;
    private JLabel serverLabel;
    private JCheckBox warCheckBox;

    public PanelOptionsVisual(PanelConfigureProject panel) {
        this.panel = panel;
        this.initComponents();
        PlatformComponentFactory.addPlatformChangeListener((JComboBox)this.platforms, (PlatformComponentFactory.PlatformChangeListener)new PlatformComponentFactory.PlatformChangeListener(){

            public void platformChanged() {
                PanelOptionsVisual.this.initServerComboBox();
                PanelOptionsVisual.this.fireChangeEvent();
                PanelOptionsVisual.this.initWarCheckBox();
                PanelOptionsVisual.this.reloadLocalGems();
            }
        });
        Util.preselectWizardPlatform((JComboBox)this.platforms);
        this.fireChangeEvent();
        this.initWarCheckBox();
        this.initServerComboBox();
        this.reloadLocalGems();
    }

    @Override
    public void removeNotify() {
        Util.storeWizardPlatform((JComboBox)this.platforms);
        super.removeNotify();
    }

    private void reloadLocalGems() {
        GemManager gemManager;
        RubyPlatform platform = this.getPlatform();
        if (platform != null && !this.reloaded.contains(platform) && (gemManager = platform.getGemManager()) != null) {
            gemManager.reloadLocalGems(true);
            this.reloaded.add(platform);
        }
    }

    private void initWarCheckBox() {
        this.warCheckBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanelOptionsVisual.this.fireChangeEvent();
            }
        });
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if ("roots".equals(event.getPropertyName())) {
            this.fireChangeEvent();
        }
    }

    private void initComponents() {
        this.warCheckBox = new JCheckBox();
        this.rubyPlatformLabel = new JLabel();
        this.manageButton = new JButton();
        this.platforms = PlatformComponentFactory.getRubyPlatformsComboxBox();
        this.serverLabel = new JLabel();
        this.serverComboBox = RailsServerUiUtils.getServerComboBox(this.getPlatform());
        this.setPreferredSize(new Dimension(226, 100));
        Mnemonics.setLocalizedText((AbstractButton)this.warCheckBox, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"WarFile"));
        this.rubyPlatformLabel.setLabelFor(this.platforms);
        Mnemonics.setLocalizedText((JLabel)this.rubyPlatformLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"RubyPlatformLabel"));
        Mnemonics.setLocalizedText((AbstractButton)this.manageButton, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"RubyHomeBrowse"));
        this.manageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.manageButtonActionPerformed(evt);
            }
        });
        this.platforms.setMinimumSize(new Dimension(27, 19));
        this.platforms.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.platformsActionPerformed(evt);
            }
        });
        this.serverLabel.setLabelFor(this.serverComboBox);
        Mnemonics.setLocalizedText((JLabel)this.serverLabel, (String)NbBundle.getMessage(PanelOptionsVisual.class, (String)"PanelOptionsVisual.Server"));
        this.serverComboBox.setMinimumSize(new Dimension(27, 19));
        this.serverComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PanelOptionsVisual.this.serverComboBoxActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.serverLabel).add((Component)this.rubyPlatformLabel)).add(20, 20, 20).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.serverComboBox, 0, 223, Short.MAX_VALUE).add((Component)this.platforms, 0, 223, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.manageButton).add(0, 0, 0)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.warCheckBox).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.rubyPlatformLabel).add((Component)this.manageButton).add((Component)this.platforms, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.serverLabel).add((Component)this.serverComboBox, -2, 22, -2)).add(18, 18, 18).add((Component)this.warCheckBox).addContainerGap()));
        this.warCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_WarFile"));
        this.rubyPlatformLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_RubyPlatformLabel"));
        this.manageButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ASCN_RubyHomeBrowse"));
        this.manageButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ASCD_RubyHomeBrowse"));
        this.serverLabel.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_Server"));
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSN_PanelOptionsVisual"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(PanelOptionsVisual.class, (String)"ACSD_PanelOptionsVisual"));
    }

    private void manageButtonActionPerformed(ActionEvent evt) {
        RubyPlatformCustomizer.manage((JComboBox)this.platforms);
    }

    private void serverComboBoxActionPerformed(ActionEvent evt) {
    }

    private void platformsActionPerformed(ActionEvent evt) {
    }

    private void initServerComboBox() {
        RubyPlatform platform = this.getPlatform();
        if (platform != null) {
            RailsServerUiUtils.ServerListModel model = new RailsServerUiUtils.ServerListModel(this.getPlatform());
            RailsServerUiUtils.addDefaultGlassFishGem(model, platform);
            this.serverComboBox.setModel(model);
        } else {
            this.serverComboBox.setModel(new DefaultComboBoxModel<Object>(new Object[0]));
        }
        this.serverComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                PanelOptionsVisual.this.fireChangeEvent();
            }
        });
    }

    RubyPlatform getPlatform() {
        return PlatformComponentFactory.getPlatform((JComboBox)this.platforms);
    }

    boolean needWarSupport() {
        return this.warCheckBox.isSelected();
    }

    Object getServer() {
        return this.serverComboBox.getSelectedItem();
    }

    @Override
    boolean valid(WizardDescriptor settings) {
        settings.putProperty("WizardPanel_errorMessage", (Object)"");
        if (this.warCheckBox.isSelected() && !this.isJdk()) {
            settings.putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"MSG_NoJDK"));
        }
        if (RailsServerUiUtils.isGlassFishGem(this.getServer()) && !this.isJdk6()) {
            settings.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(PanelOptionsVisual.class, (String)"MSG_GfGemRequiresJDK6"));
            return false;
        }
        return PlatformComponentFactory.getPlatform((JComboBox)this.platforms) != null;
    }

    @Override
    void read(WizardDescriptor d) {
    }

    @Override
    void validate(WizardDescriptor d) throws WizardValidationException {
    }

    @Override
    void store(WizardDescriptor d) {
        d.putProperty("setAsMain", (Object)Boolean.FALSE);
        d.putProperty("warSupport", (Object)(this.warCheckBox.isSelected() && this.warCheckBox.isVisible() ? Boolean.TRUE : Boolean.FALSE));
        d.putProperty("platform", this.platforms.getModel().getSelectedItem());
        d.putProperty("serverInstance", this.serverComboBox.getModel().getSelectedItem());
    }

    private void fireChangeEvent() {
        this.panel.fireChangeEvent();
    }

    private boolean isJdk6() {
        String javaVersion = System.getProperty("java.version");
        return this.isJdk() && javaVersion.startsWith("1.6");
    }

    private boolean isJdk() {
        String jdkHome = System.getProperty("jdk.home");
        if (Utilities.isMac()) {
            return true;
        }
        File jreDir = new File(jdkHome, "jre");
        return jreDir.exists() && jreDir.isDirectory();
    }
}

