/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.projects;

import java.io.IOException;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotatable;
import org.openide.text.Annotation;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class DebuggerAnnotation
extends Annotation
implements Lookup.Provider {
    private final Line line;
    private final String type;
    private final JPDAThread thread;

    DebuggerAnnotation(String string, Line line, JPDAThread jPDAThread) {
        this.type = string;
        this.line = line;
        this.thread = jPDAThread;
        if ("Breakpoint".equals(string)) {
            Exceptions.printStackTrace((Throwable)new IllegalStateException("Wrong annotation type: " + string + ". Please report to bug #169096."));
        }
        this.attach((Annotatable)line);
    }

    DebuggerAnnotation(String string, Line.Part part) {
        this.type = string;
        this.line = part.getLine();
        this.thread = null;
        if ("Breakpoint".equals(string)) {
            Exceptions.printStackTrace((Throwable)new IllegalStateException("Wrong annotation type: " + string + ". Please report to bug #169096."));
        }
        this.attach((Annotatable)part);
    }

    DebuggerAnnotation(String string, AttributeSet attributeSet, int n, int n2, FileObject fileObject) {
        this.type = string;
        this.line = null;
        this.thread = null;
        if ("Breakpoint".equals(string)) {
            Exceptions.printStackTrace((Throwable)new IllegalStateException("Wrong annotation type: " + string + ". Please report to bug #169096."));
        }
        this.attach(new HighlightAnnotatable(attributeSet, n, n2, fileObject));
    }

    public String getAnnotationType() {
        return this.type;
    }

    Line getLine() {
        return this.line;
    }

    public String getShortDescription() {
        if (this.type == "CurrentPC") {
            return NbBundle.getMessage(DebuggerAnnotation.class, (String)"TOOLTIP_CURRENT_PC");
        }
        if (this.type == "CurrentExpressionLine") {
            return NbBundle.getMessage(DebuggerAnnotation.class, (String)"TOOLTIP_CURRENT_EXP_LINE");
        }
        if (this.type == "CallSite") {
            return NbBundle.getBundle(DebuggerAnnotation.class).getString("TOOLTIP_CALLSITE");
        }
        if (this.type == "OtherThread") {
            return NbBundle.getMessage(DebuggerAnnotation.class, (String)"TOOLTIP_OTHER_THREAD", (Object)this.thread.getName());
        }
        ErrorManager.getDefault().notify(1, (Throwable)new IllegalStateException("Unknown annotation type '" + this.type + "'."));
        return null;
    }

    static synchronized OffsetsBag getHighlightsBag(Document document) {
        OffsetsBag offsetsBag = (OffsetsBag)document.getProperty(DebuggerAnnotation.class);
        if (offsetsBag == null) {
            offsetsBag = new OffsetsBag(document, true);
            document.putProperty(DebuggerAnnotation.class, offsetsBag);
        }
        return offsetsBag;
    }

    public Lookup getLookup() {
        if (this.thread == null) {
            return Lookup.EMPTY;
        }
        return Lookups.singleton((Object)this.thread);
    }

    private static final class HighlightAnnotatable
    extends Annotatable {
        private AttributeSet attrs;
        private int start;
        private int end;
        private Document doc;

        public HighlightAnnotatable(AttributeSet attributeSet, int n, int n2, FileObject fileObject) {
            this.attrs = attributeSet;
            this.start = n;
            this.end = n2;
            try {
                DataObject dataObject = DataObject.find((FileObject)fileObject);
                EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
                this.doc = editorCookie.getDocument();
                if (this.doc == null) {
                    try {
                        this.doc = editorCookie.openDocument();
                    }
                    catch (IOException iOException) {}
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }

        public String getText() {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void addAnnotation(Annotation annotation) {
            Class<DebuggerAnnotation> clazz = DebuggerAnnotation.class;
            synchronized (DebuggerAnnotation.class) {
                if (this.doc != null) {
                    OffsetsBag offsetsBag = DebuggerAnnotation.getHighlightsBag(this.doc);
                    offsetsBag.addHighlight(this.start, this.end, this.attrs);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void removeAnnotation(Annotation annotation) {
            Class<DebuggerAnnotation> clazz = DebuggerAnnotation.class;
            synchronized (DebuggerAnnotation.class) {
                if (this.doc != null) {
                    OffsetsBag offsetsBag = DebuggerAnnotation.getHighlightsBag(this.doc);
                    offsetsBag.removeHighlights(this.start, this.end, false);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
                return;
            }
        }
    }
}

