/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.system.cvss.ui.actions.commit;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.table.AbstractTableModel;
import org.netbeans.lib.cvsclient.command.KeywordSubstitutionOptions;
import org.netbeans.modules.versioning.system.cvss.CvsFileNode;
import org.netbeans.modules.versioning.system.cvss.CvsModuleConfig;
import org.netbeans.modules.versioning.system.cvss.CvsVersioningSystem;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitOptions;
import org.netbeans.modules.versioning.system.cvss.ui.actions.commit.CommitSettings;
import org.netbeans.modules.versioning.system.cvss.util.Utils;
import org.openide.util.NbBundle;

class CommitTableModel
extends AbstractTableModel {
    private final Map<String, String[]> columnLabels = new HashMap<String, String[]>(5);
    private CommitOptions[] commitOptions;
    private CvsFileNode[] nodes;
    private String[] columns;

    public CommitTableModel() {
        ResourceBundle loc = NbBundle.getBundle(CommitTableModel.class);
        this.columnLabels.put("commit", new String[]{loc.getString("CTL_CommitTable_Column_Commit"), loc.getString("CTL_CommitTable_Column_Description")});
        this.columnLabels.put("name", new String[]{loc.getString("CTL_CommitTable_Column_File"), loc.getString("CTL_CommitTable_Column_File")});
        this.columnLabels.put("sticky", new String[]{loc.getString("CTL_CommitTable_Column_Sticky"), loc.getString("CTL_CommitTable_Column_Sticky")});
        this.columnLabels.put("status", new String[]{loc.getString("CTL_CommitTable_Column_Status"), loc.getString("CTL_CommitTable_Column_Status")});
        this.columnLabels.put("action", new String[]{loc.getString("CTL_CommitTable_Column_Action"), loc.getString("CTL_CommitTable_Column_Action")});
        this.columnLabels.put("path", new String[]{loc.getString("CTL_CommitTable_Column_Folder"), loc.getString("CTL_CommitTable_Column_Folder")});
        this.setColumns(new String[0]);
        this.setNodes(new CvsFileNode[0]);
    }

    void setNodes(CvsFileNode[] nodes) {
        this.nodes = nodes;
        this.createCommitOptions();
        this.fireTableDataChanged();
    }

    void setColumns(String[] cols) {
        if (Arrays.equals(cols, this.columns)) {
            return;
        }
        this.columns = cols;
        this.fireTableStructureChanged();
    }

    public CommitSettings.CommitFile[] getCommitFiles() {
        CommitSettings.CommitFile[] files = new CommitSettings.CommitFile[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            files[i] = new CommitSettings.CommitFile(this.nodes[i], this.commitOptions[i]);
        }
        return files;
    }

    @Override
    public String getColumnName(int column) {
        return this.columnLabels.get(this.columns[column])[0];
    }

    @Override
    public int getColumnCount() {
        return this.columns.length;
    }

    @Override
    public int getRowCount() {
        return this.nodes.length;
    }

    public Class getColumnClass(int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals("commit")) {
            return Boolean.class;
        }
        if (col.equals("action")) {
            return CommitOptions.class;
        }
        return String.class;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        return col.equals("commit");
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals("commit")) {
            return this.commitOptions[rowIndex] != CommitOptions.EXCLUDE;
        }
        if (col.equals("name")) {
            return this.nodes[rowIndex].getName();
        }
        if (col.equals("sticky")) {
            String sticky = Utils.getSticky(this.nodes[rowIndex].getFile());
            return sticky == null ? "" : sticky;
        }
        if (col.equals("status")) {
            return this.nodes[rowIndex].getInformation().getStatusText();
        }
        if (col.equals("action")) {
            return this.commitOptions[rowIndex];
        }
        if (col.equals("path")) {
            return Utils.getRelativePath(this.nodes[rowIndex].getFile());
        }
        throw new IllegalArgumentException("Column index out of range: " + columnIndex);
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        String col = this.columns[columnIndex];
        if (col.equals("action")) {
            this.commitOptions[rowIndex] = (CommitOptions)aValue;
        } else if (col.equals("commit")) {
            this.commitOptions[rowIndex] = (Boolean)aValue != false ? this.getCommitOptions(rowIndex) : CommitOptions.EXCLUDE;
        } else {
            throw new IllegalArgumentException("Column index out of range: " + columnIndex);
        }
        this.fireTableRowsUpdated(rowIndex, rowIndex);
    }

    private void createCommitOptions() {
        boolean excludeNew = CvsModuleConfig.getDefault().getPreferences().getBoolean("excludeNewFiles", false);
        this.commitOptions = new CommitOptions[this.nodes.length];
        for (int i = 0; i < this.nodes.length; ++i) {
            CvsFileNode node = this.nodes[i];
            this.commitOptions[i] = CvsModuleConfig.getDefault().isExcludedFromCommit(node.getFile()) ? CommitOptions.EXCLUDE : this.getCommitOptions(node, excludeNew);
        }
    }

    CommitSettings.CommitFile getCommitFile(int row) {
        return new CommitSettings.CommitFile(this.nodes[row], this.commitOptions[row]);
    }

    CvsFileNode getNode(int row) {
        return this.nodes[row];
    }

    CommitOptions getOptions(int row) {
        return this.commitOptions[row];
    }

    private CommitOptions getDefaultCommitOptions(File file) {
        KeywordSubstitutionOptions options = CvsVersioningSystem.getInstance().getDefaultKeywordSubstitution(file);
        return options == KeywordSubstitutionOptions.BINARY ? CommitOptions.ADD_BINARY : CommitOptions.ADD_TEXT;
    }

    void setIncluded(int[] rows, boolean include) {
        for (int rowIndex : rows) {
            if (include && !CommitOptions.EXCLUDE.equals(this.commitOptions[rowIndex])) continue;
            this.commitOptions[rowIndex] = include ? this.getCommitOptions(rowIndex) : CommitOptions.EXCLUDE;
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    void setAdded(int[] rows, CommitOptions addOption) {
        for (int rowIndex : rows) {
            this.commitOptions[rowIndex] = addOption;
        }
        this.fireTableRowsUpdated(0, this.getRowCount() - 1);
    }

    private CommitOptions getCommitOptions(int rowIndex) {
        CvsFileNode node = this.nodes[rowIndex];
        return this.getCommitOptions(node, false);
    }

    private CommitOptions getCommitOptions(CvsFileNode node, boolean excludeNew) {
        CommitOptions options;
        switch (node.getInformation().getStatus()) {
            case 4: {
                options = excludeNew ? CommitOptions.EXCLUDE : this.getDefaultCommitOptions(node.getFile());
                break;
            }
            case 256: 
            case 2048: {
                options = CommitOptions.COMMIT_REMOVE;
                break;
            }
            default: {
                options = CommitOptions.COMMIT;
            }
        }
        return options;
    }
}

