/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.jaxws;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.dd.api.common.NameAlreadyUsedException;
import org.netbeans.modules.j2ee.dd.api.web.DDProvider;
import org.netbeans.modules.j2ee.dd.api.web.Listener;
import org.netbeans.modules.j2ee.dd.api.web.Servlet;
import org.netbeans.modules.j2ee.dd.api.web.ServletMapping;
import org.netbeans.modules.j2ee.dd.api.web.WebApp;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.jaxws.ConfirmationPanel;
import org.netbeans.modules.maven.jaxws.MavenJAXWSSupportImpl;
import org.netbeans.modules.maven.jaxws.MavenModelUtils;
import org.netbeans.modules.maven.jaxws.MavenWebService;
import org.netbeans.modules.maven.jaxws.WSStackUtils;
import org.netbeans.modules.maven.jaxws.WsimportPomInfo;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoint;
import org.netbeans.modules.websvc.api.jaxws.project.config.Endpoints;
import org.netbeans.modules.websvc.api.jaxws.project.config.EndpointsProvider;
import org.netbeans.modules.websvc.api.jaxws.wsdlmodel.WsdlModel;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.wsstack.api.WSStack;
import org.netbeans.modules.websvc.wsstack.jaxws.JaxWs;
import org.netbeans.modules.xml.retriever.RetrieveEntry;
import org.netbeans.modules.xml.retriever.Retriever;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.NbBundle;

public class WSUtils {
    public static final String NON_JSR109_DONT_ASK = "dont_ask_for_nonjsr109_config";
    private static final String SERVLET_CLASS_NAME = "com.sun.xml.ws.transport.http.servlet.WSServlet";
    private static final String SERVLET_LISTENER = "com.sun.xml.ws.transport.http.servlet.WSServletContextListener";
    private static final String DEFAULT_PACKAGE_NAME = "org.netbeans.ws";

    public static FileObject retrieveResource(FileObject fileObject, URI uRI, URI uRI2) throws UnknownHostException, URISyntaxException, IOException {
        try {
            Map map;
            Retriever retriever = Retriever.getDefault();
            FileObject fileObject2 = retriever.retrieveResource(fileObject, uRI, uRI2);
            if (fileObject2 == null && (map = retriever.getRetrievedResourceExceptionMap()) != null) {
                Set set = map.keySet();
                for (RetrieveEntry retrieveEntry : set) {
                    Object v = map.get(retrieveEntry);
                    if (v instanceof IOException) {
                        throw (IOException)v;
                    }
                    if (v instanceof URISyntaxException) {
                        throw (URISyntaxException)v;
                    }
                    if (!(v instanceof Exception)) continue;
                    IOException iOException = new IOException(NbBundle.getMessage(WSUtils.class, (String)"ERR_retrieveResource", (Object)retrieveEntry.getCurrentAddress()));
                    iOException.initCause((Exception)v);
                    throw iOException;
                }
            }
            return fileObject2;
        }
        catch (RuntimeException runtimeException) {
            throw (IOException)new IOException(runtimeException.getLocalizedMessage()).initCause(runtimeException);
        }
    }

    public static void generateSunJaxwsFile(final FileObject fileObject) throws IOException {
        final String string = WSUtils.readResource(WsdlModel.class.getResourceAsStream("/org/netbeans/modules/websvc/jaxwsmodel/resources/sun-jaxws.xml"));
        FileSystem fileSystem = fileObject.getFileSystem();
        fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() throws IOException {
                FileObject fileObject2 = FileUtil.createData((FileObject)fileObject, (String)"sun-jaxws.xml");
                FileLock fileLock = fileObject2.lock();
                BufferedWriter bufferedWriter = null;
                OutputStream outputStream = null;
                OutputStreamWriter outputStreamWriter = null;
                try {
                    outputStream = fileObject2.getOutputStream(fileLock);
                    outputStreamWriter = new OutputStreamWriter(outputStream);
                    bufferedWriter = new BufferedWriter(outputStreamWriter);
                    bufferedWriter.write(string);
                }
                finally {
                    if (bufferedWriter != null) {
                        bufferedWriter.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                }
            }
        });
    }

    private static String readResource(InputStream inputStream) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            stringBuffer.append(string2);
            stringBuffer.append(string);
            string2 = bufferedReader.readLine();
        }
        bufferedReader.close();
        return stringBuffer.toString();
    }

    public static void removeImplClass(Project project, String string) {
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        String string2 = string.replace('.', '/') + ".java";
        if (sources != null) {
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                FileObject fileObject = sourceGroupArray[i].getRootFolder();
                final FileObject fileObject2 = fileObject.getFileObject(string2);
                if (fileObject2 == null) continue;
                try {
                    FileSystem fileSystem = fileObject2.getFileSystem();
                    fileSystem.runAtomicAction(new FileSystem.AtomicAction(){

                        public void run() {
                            WSUtils.deleteFile(fileObject2);
                        }
                    });
                }
                catch (IOException iOException) {
                    ErrorManager.getDefault().notify((Throwable)iOException);
                }
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void deleteFile(FileObject fileObject) {
        FileLock fileLock = null;
        try {
            SaveCookie saveCookie;
            DataObject dataObject = DataObject.find((FileObject)fileObject);
            if (dataObject != null && (saveCookie = (SaveCookie)dataObject.getCookie(SaveCookie.class)) != null) {
                saveCookie.save();
            }
            fileLock = fileObject.lock();
            fileObject.delete(fileLock);
        }
        catch (IOException iOException) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(WSUtils.class, (String)"MSG_Unable_Delete_File", (Object)fileObject.getNameExt()), 0);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        finally {
            if (fileLock != null) {
                fileLock.releaseLock();
            }
        }
    }

    public static void copyFiles(FileObject fileObject, FileObject fileObject2) throws IOException {
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            if (fileObjectArray[i].isFolder()) {
                FileObject fileObject3 = fileObject2.createFolder(fileObjectArray[i].getNameExt());
                WSUtils.copyFiles(fileObjectArray[i], fileObject3);
                continue;
            }
            fileObjectArray[i].copy(fileObject2, fileObjectArray[i].getName(), fileObjectArray[i].getExt());
        }
    }

    public static FileObject findJaxWsFileObject(Project project) {
        return project.getProjectDirectory().getFileObject("nbproject/jax-ws.xml");
    }

    private static String getPackageNameFromNamespace(String string) {
        String string2 = string;
        int n = string.indexOf("//");
        if (n >= 0) {
            string2 = string.substring(n + 2);
        } else {
            int n2 = string.indexOf(":");
            if (n2 >= 0) {
                string2 = string.substring(n2 + 1);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string2, "/");
        if (stringTokenizer.countTokens() > 0) {
            Object object;
            ArrayList<String> arrayList = new ArrayList<String>();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            while (stringTokenizer.hasMoreTokens()) {
                object = stringTokenizer.nextToken();
                if (((String)object).length() < 0) continue;
                arrayList2.add((String)object);
            }
            if (arrayList2.size() > 0) {
                int n3;
                object = new StringTokenizer((String)arrayList2.get(0), ".");
                int n4 = ((StringTokenizer)object).countTokens();
                if (n4 > 0) {
                    ArrayList<String> arrayList3 = new ArrayList<String>();
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        arrayList3.add(((StringTokenizer)object).nextToken());
                    }
                    for (n3 = n4 - 1; n3 >= 0; --n3) {
                        String string3 = (String)arrayList3.get(n3);
                        if (n3 <= 0 && "www".equals(string3)) continue;
                        arrayList.add(((String)arrayList3.get(n3)).toLowerCase());
                    }
                } else {
                    return DEFAULT_PACKAGE_NAME;
                }
                for (int i = 1; i < arrayList2.size(); ++i) {
                    arrayList.add(((String)arrayList2.get(i)).toLowerCase());
                }
                StringBuffer stringBuffer = new StringBuffer((String)arrayList.get(0));
                for (n3 = 1; n3 < arrayList.size(); ++n3) {
                    stringBuffer.append("." + (String)arrayList.get(n3));
                }
                return stringBuffer.toString();
            }
        }
        return DEFAULT_PACKAGE_NAME;
    }

    public static boolean isProjectReferenceable(Project project, Project project2) {
        if (project == project2) {
            return true;
        }
        NbMavenProject nbMavenProject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        return nbMavenProject != null && "jar".equals(nbMavenProject.getPackagingType());
    }

    public static boolean isEJB(Project project) {
        J2eeModule.Type type;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        return j2eeModuleProvider != null && J2eeModule.Type.EJB.equals(type = j2eeModuleProvider.getJ2eeModule().getType());
    }

    public static boolean isWeb(Project project) {
        J2eeModule.Type type;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        return j2eeModuleProvider != null && J2eeModule.Type.WAR.equals(type = j2eeModuleProvider.getJ2eeModule().getType());
    }

    public static void updateClients(Project project, JAXWSLightSupport jAXWSLightSupport) {
        ArrayList<JaxWsService> arrayList = new ArrayList<JaxWsService>();
        HashSet<String> hashSet = new HashSet<String>();
        for (Object object : jAXWSLightSupport.getServices()) {
            if (object.isServiceProvider()) continue;
            arrayList.add((JaxWsService)object);
            hashSet.add(object.getId());
        }
        FileObject fileObject = jAXWSLightSupport.getWsdlFolder(false);
        if (fileObject != null) {
            JaxWsService jaxWsService2;
            Object object;
            object = WSUtils.getJaxWsClients(project);
            HashSet<String> hashSet2 = new HashSet<String>();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                jaxWsService2 = (JaxWsService)iterator.next();
                String string = jaxWsService2.getId();
                if (!hashSet.contains(string)) continue;
                hashSet2.add(string);
            }
            for (JaxWsService jaxWsService2 : arrayList) {
                if (hashSet2.contains(jaxWsService2.getId())) continue;
                jAXWSLightSupport.removeService(jaxWsService2);
            }
            iterator = object.iterator();
            while (iterator.hasNext()) {
                jaxWsService2 = (JaxWsService)iterator.next();
                if (hashSet2.contains(jaxWsService2.getId())) continue;
                jaxWsService2.setWsdlUrl(WSUtils.getOriginalWsdlUrl(project, jaxWsService2.getId(), false));
                jAXWSLightSupport.addService(jaxWsService2);
            }
        } else {
            for (JaxWsService jaxWsService : arrayList) {
                jAXWSLightSupport.removeService(jaxWsService);
            }
        }
    }

    public static void detectWsdlClients(Project project, JAXWSLightSupport jAXWSLightSupport) {
        List<WsimportPomInfo> list = MavenModelUtils.getWsdlFiles(project);
        if (list.size() > 0) {
            for (WsimportPomInfo wsimportPomInfo : list) {
                if (!WSUtils.isClient(project, wsimportPomInfo)) continue;
                String string = wsimportPomInfo.getWsdlPath();
                JaxWsService jaxWsService = new JaxWsService(string, false);
                if (wsimportPomInfo.getHandlerFile() != null) {
                    jaxWsService.setHandlerBindingFile(wsimportPomInfo.getHandlerFile());
                }
                jaxWsService.setId(wsimportPomInfo.getId());
                jaxWsService.setWsdlUrl(WSUtils.getOriginalWsdlUrl(project, jaxWsService.getId(), false));
                jAXWSLightSupport.addService(jaxWsService);
            }
        }
    }

    private static List<JaxWsService> getJaxWsClients(Project project) {
        List<WsimportPomInfo> list = MavenModelUtils.getWsdlFiles(project);
        ArrayList<JaxWsService> arrayList = new ArrayList<JaxWsService>();
        for (WsimportPomInfo wsimportPomInfo : list) {
            if (!WSUtils.isClient(project, wsimportPomInfo)) continue;
            String string = wsimportPomInfo.getWsdlPath();
            JaxWsService jaxWsService = new JaxWsService(string, false);
            jaxWsService.setId(wsimportPomInfo.getId());
            if (wsimportPomInfo.getHandlerFile() != null) {
                jaxWsService.setHandlerBindingFile(wsimportPomInfo.getHandlerFile());
            }
            arrayList.add(jaxWsService);
        }
        return arrayList;
    }

    private static boolean isClient(Project project, WsimportPomInfo wsimportPomInfo) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, MavenWebService.class, (boolean)true);
        return preferences == null || preferences.get("_S_" + wsimportPomInfo.getId(), null) == null;
    }

    static FileObject getLocalWsdl(JAXWSLightSupport jAXWSLightSupport, String string) {
        FileObject fileObject = jAXWSLightSupport.getWsdlFolder(false);
        if (fileObject != null) {
            return fileObject.getFileObject(string);
        }
        return null;
    }

    public static String getOriginalWsdlUrl(Project project, String string, boolean bl) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, MavenWebService.class, (boolean)true);
        if (preferences != null) {
            if (bl) {
                return preferences.get("_S_" + string, null);
            }
            return preferences.get("_C_" + string, null);
        }
        return null;
    }

    private static boolean webAppHasListener(WebApp webApp, String string) {
        Listener[] listenerArray = webApp.getListener();
        for (int i = 0; i < listenerArray.length; ++i) {
            Listener listener = listenerArray[i];
            if (!string.equals(listener.getListenerClass())) continue;
            return true;
        }
        return false;
    }

    private static WebApp getWebApp(Project project) {
        try {
            FileObject fileObject = WSUtils.getDeploymentDescriptor(project);
            if (fileObject != null) {
                return DDProvider.getDefault().getDDRoot(fileObject);
            }
        }
        catch (IOException iOException) {
            Logger.getLogger("global").log(Level.INFO, iOException.getLocalizedMessage());
        }
        return null;
    }

    private static FileObject getDeploymentDescriptor(Project project) {
        File file;
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider != null && (file = j2eeModuleProvider.getJ2eeModule().getDeploymentConfigurationFile("WEB-INF/web.xml")) != null && file.exists()) {
            return FileUtil.toFileObject((File)file);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addSunJaxWsEntry(FileObject fileObject, JaxWsService jaxWsService) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject("sun-jaxws.xml");
        if (fileObject2 == null) {
            WSUtils.generateSunJaxwsFile(fileObject);
        }
        fileObject2 = fileObject.getFileObject("sun-jaxws.xml");
        Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(fileObject2);
        String string = jaxWsService.getServiceName();
        Endpoint endpoint = endpoints.findEndpointByName(jaxWsService.getServiceName());
        if (endpoint == null) {
            WSUtils.addService(endpoints, jaxWsService);
            FileLock fileLock = null;
            OutputStream outputStream = null;
            FileObject fileObject3 = fileObject2;
            synchronized (fileObject3) {
                try {
                    fileLock = fileObject2.lock();
                    outputStream = fileObject2.getOutputStream(fileLock);
                    endpoints.write(outputStream);
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void addJaxWsEntries(FileObject fileObject, JAXWSLightSupport jAXWSLightSupport) throws IOException {
        Object object2;
        WSUtils.generateSunJaxwsFile(fileObject);
        FileObject fileObject2 = fileObject.getFileObject("sun-jaxws.xml");
        Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(fileObject2);
        for (Object object2 : jAXWSLightSupport.getServices()) {
            if (!object2.isServiceProvider()) continue;
            WSUtils.addService(endpoints, (JaxWsService)object2);
        }
        FileLock fileLock = null;
        object2 = null;
        FileObject fileObject3 = fileObject2;
        synchronized (fileObject3) {
            try {
                fileLock = fileObject2.lock();
                object2 = fileObject2.getOutputStream(fileLock);
                endpoints.write((OutputStream)object2);
            }
            finally {
                if (fileLock != null) {
                    fileLock.releaseLock();
                }
                if (object2 != null) {
                    ((OutputStream)object2).close();
                }
            }
        }
    }

    private static void addService(Endpoints endpoints, JaxWsService jaxWsService) {
        Endpoint endpoint = endpoints.newEndpoint();
        endpoint.setEndpointName(jaxWsService.getServiceName());
        endpoint.setImplementation(jaxWsService.getImplementationClass());
        endpoint.setUrlPattern("/" + jaxWsService.getServiceName());
        endpoints.addEnpoint(endpoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSunJaxWsEntry(FileObject fileObject, JaxWsService jaxWsService) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject("sun-jaxws.xml");
        if (fileObject2 != null) {
            Endpoints endpoints = EndpointsProvider.getDefault().getEndpoints(fileObject2);
            String string = jaxWsService.getServiceName();
            Endpoint endpoint = endpoints.findEndpointByName(jaxWsService.getServiceName());
            if (endpoint != null) {
                endpoints.removeEndpoint(endpoint);
                FileLock fileLock = null;
                OutputStream outputStream = null;
                FileObject fileObject3 = fileObject2;
                synchronized (fileObject3) {
                    try {
                        fileLock = fileObject2.lock();
                        outputStream = fileObject2.getOutputStream(fileLock);
                        endpoints.write(outputStream);
                    }
                    finally {
                        if (fileLock != null) {
                            fileLock.releaseLock();
                        }
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                }
            }
        }
    }

    private static void removeSunJaxWs(FileObject fileObject) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject("sun-jaxws.xml");
        if (fileObject2 != null) {
            fileObject2.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void replaceSunJaxWsEntries(FileObject fileObject, String string, String string2) throws IOException {
        Endpoints endpoints;
        Endpoint endpoint;
        FileObject fileObject2 = fileObject.getFileObject("sun-jaxws.xml");
        if (fileObject2 != null && (endpoint = (endpoints = EndpointsProvider.getDefault().getEndpoints(fileObject2)).findEndpointByName(string)) != null) {
            endpoint.setEndpointName(string2);
            endpoint.setUrlPattern("/" + string2);
            FileLock fileLock = null;
            OutputStream outputStream = null;
            FileObject fileObject3 = fileObject2;
            synchronized (fileObject3) {
                try {
                    fileLock = fileObject2.lock();
                    outputStream = fileObject2.getOutputStream(fileLock);
                    endpoints.write(outputStream);
                }
                finally {
                    if (fileLock != null) {
                        fileLock.releaseLock();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
            }
        }
    }

    public static boolean generateNonJsr109Artifacts(Project project) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, MavenWebService.class, (boolean)true);
        if (preferences == null || preferences.get(NON_JSR109_DONT_ASK, null) == null) {
            ConfirmationPanel confirmationPanel = new ConfirmationPanel(NbBundle.getMessage(WSUtils.class, (String)"MSG_GenerateDDEntries", (Object)project.getProjectDirectory().getName()));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)confirmationPanel, NbBundle.getMessage(WSUtils.class, (String)"TTL_GenerateDDEntries"), true, 0, null, null);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (confirmationPanel.notAskAgain() && preferences != null) {
                preferences.put(NON_JSR109_DONT_ASK, "true");
            }
            return NotifyDescriptor.YES_OPTION.equals(object);
        }
        return false;
    }

    private static boolean removeNonJsr109Artifacts(Project project) {
        Preferences preferences = ProjectUtils.getPreferences((Project)project, MavenWebService.class, (boolean)true);
        if (preferences == null || preferences.get(NON_JSR109_DONT_ASK, null) == null) {
            ConfirmationPanel confirmationPanel = new ConfirmationPanel(NbBundle.getMessage(WSUtils.class, (String)"MSG_RemoveDDEntries"));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)confirmationPanel, NbBundle.getMessage(WSUtils.class, (String)"TTL_RemoveDDEntries"), true, 0, null, null);
            Object object = DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
            if (confirmationPanel.notAskAgain() && preferences != null) {
                preferences.put(NON_JSR109_DONT_ASK, "true");
            }
            return NotifyDescriptor.YES_OPTION.equals(object);
        }
        return false;
    }

    public static boolean isJsr109Supported(Project project) {
        J2eeModuleProvider j2eeModuleProvider = (J2eeModuleProvider)project.getLookup().lookup(J2eeModuleProvider.class);
        if (j2eeModuleProvider == null) {
            return true;
        }
        WSStackUtils wSStackUtils = new WSStackUtils(project);
        return wSStackUtils.isJsr109Supported();
    }

    public static void addServiceToDD(Project project, JaxWsService jaxWsService) throws IOException {
        WebApp webApp = WSUtils.getWebApp(project);
        if (webApp != null) {
            try {
                WSUtils.addServlet(webApp, jaxWsService);
                if (!WSUtils.webAppHasListener(webApp, SERVLET_LISTENER)) {
                    webApp.addBean("Listener", new String[]{"ListenerClass"}, new Object[]{SERVLET_LISTENER}, "ListenerClass");
                }
                webApp.write(WSUtils.getDeploymentDescriptor(project));
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger("global").log(Level.INFO, classNotFoundException.getLocalizedMessage());
            }
            catch (NameAlreadyUsedException nameAlreadyUsedException) {
                Logger.getLogger(WSUtils.class.getName()).log(Level.INFO, nameAlreadyUsedException.getLocalizedMessage());
            }
        }
    }

    private static void addServicesToDD(Project project, JAXWSLightSupport jAXWSLightSupport) throws IOException {
        WebApp webApp = WSUtils.getWebApp(project);
        if (webApp != null) {
            try {
                if (!WSUtils.webAppHasListener(webApp, SERVLET_LISTENER)) {
                    webApp.addBean("Listener", new String[]{"ListenerClass"}, new Object[]{SERVLET_LISTENER}, "ListenerClass");
                }
                for (JaxWsService jaxWsService : jAXWSLightSupport.getServices()) {
                    if (!jaxWsService.isServiceProvider()) continue;
                    WSUtils.addServlet(webApp, jaxWsService);
                }
            }
            catch (NameAlreadyUsedException nameAlreadyUsedException) {
                Logger.getLogger(WSUtils.class.getName()).log(Level.INFO, nameAlreadyUsedException.getLocalizedMessage());
            }
            catch (ClassNotFoundException classNotFoundException) {
                Logger.getLogger(WSUtils.class.getName()).log(Level.INFO, classNotFoundException.getLocalizedMessage());
            }
            webApp.write(WSUtils.getDeploymentDescriptor(project));
        }
    }

    private static void addServlet(WebApp webApp, JaxWsService jaxWsService) throws ClassNotFoundException, NameAlreadyUsedException {
        String string = jaxWsService.getServiceName();
        Servlet servlet = (Servlet)webApp.addBean("Servlet", new String[]{"ServletName", "ServletClass"}, new Object[]{string, SERVLET_CLASS_NAME}, "ServletName");
        servlet.setLoadOnStartup(new BigInteger("1"));
        webApp.addBean("ServletMapping", new String[]{"ServletName", "UrlPattern"}, new Object[]{string, "/" + string}, "ServletName");
    }

    public static void removeServiceFromDD(Project project, JaxWsService jaxWsService) throws IOException {
        WebApp webApp = WSUtils.getWebApp(project);
        if (webApp != null) {
            boolean bl = WSUtils.removeServiceFromDD(webApp, jaxWsService.getServiceName());
            boolean bl2 = false;
            Servlet[] servletArray = webApp.getServlet();
            for (int i = 0; i < servletArray.length; ++i) {
                if (!SERVLET_CLASS_NAME.equals(servletArray[i].getServletClass())) continue;
                bl2 = true;
                break;
            }
            if (!bl2) {
                Listener[] listenerArray = webApp.getListener();
                for (int i = 0; i < listenerArray.length; ++i) {
                    Listener listener = listenerArray[i];
                    if (!SERVLET_LISTENER.equals(listener.getListenerClass())) continue;
                    webApp.removeListener(listener);
                    bl = true;
                    break;
                }
            }
            if (bl) {
                webApp.write(WSUtils.getDeploymentDescriptor(project));
            }
        }
    }

    private static void removeServicesFromDD(Project project, JAXWSLightSupport jAXWSLightSupport) throws IOException {
        WebApp webApp = WSUtils.getWebApp(project);
        if (webApp != null) {
            boolean bl = false;
            for (JaxWsService jaxWsService : jAXWSLightSupport.getServices()) {
                bl = WSUtils.removeServiceFromDD(webApp, jaxWsService.getServiceName());
            }
            Listener[] listenerArray = webApp.getListener();
            for (int i = 0; i < listenerArray.length; ++i) {
                Listener listener = listenerArray[i];
                if (!SERVLET_LISTENER.equals(listener.getListenerClass())) continue;
                webApp.removeListener(listener);
                bl = true;
                break;
            }
            if (bl) {
                webApp.write(WSUtils.getDeploymentDescriptor(project));
            }
        }
    }

    private static boolean removeServiceFromDD(WebApp webApp, String string) {
        boolean bl = false;
        Servlet[] servletArray = webApp.getServlet();
        for (int i = 0; i < servletArray.length; ++i) {
            Servlet servlet = servletArray[i];
            if (!servlet.getServletName().equals(string)) continue;
            webApp.removeServlet(servlet);
            bl = true;
            break;
        }
        ServletMapping[] servletMappingArray = webApp.getServletMapping();
        for (int i = 0; i < servletMappingArray.length; ++i) {
            ServletMapping servletMapping = servletMappingArray[i];
            if (!servletMapping.getServletName().equals(string)) continue;
            webApp.removeServletMapping(servletMapping);
            bl = true;
            break;
        }
        return bl;
    }

    public static void replaceServiceEntriesFromDD(Project project, String string, String string2) throws IOException {
        boolean bl;
        WebApp webApp = WSUtils.getWebApp(project);
        if (webApp != null && (bl = WSUtils.replaceServiceInDD(webApp, string, string2))) {
            webApp.write(WSUtils.getDeploymentDescriptor(project));
        }
    }

    private static boolean replaceServiceInDD(WebApp webApp, String string, String string2) {
        boolean bl = false;
        Servlet[] servletArray = webApp.getServlet();
        for (int i = 0; i < servletArray.length; ++i) {
            Servlet servlet = servletArray[i];
            if (!servlet.getServletName().equals(string)) continue;
            servlet.setServletName(string2);
            bl = true;
            break;
        }
        ServletMapping[] servletMappingArray = webApp.getServletMapping();
        for (int i = 0; i < servletMappingArray.length; ++i) {
            ServletMapping servletMapping = servletMappingArray[i];
            if (!servletMapping.getServletName().equals(string)) continue;
            servletMapping.setServletName(string2);
            servletMapping.setUrlPattern("/" + string2);
            break;
        }
        return bl;
    }

    public static void checkNonJSR109Entries(Project project) {
        WSStack<JaxWs> wSStack;
        JAXWSLightSupport jAXWSLightSupport = JAXWSLightSupport.getJAXWSLightSupport((FileObject)project.getProjectDirectory());
        if (jAXWSLightSupport != null && (wSStack = new WSStackUtils(project).getWsStack(JaxWs.class)) != null) {
            FileObject fileObject = jAXWSLightSupport.getDeploymentDescriptorFolder();
            if (wSStack.isFeatureSupported((WSStack.Feature)JaxWs.Feature.JSR109)) {
                if (fileObject != null && fileObject.getFileObject("sun-jaxws.xml") != null && WSUtils.removeNonJsr109Artifacts(project)) {
                    try {
                        WSUtils.removeSunJaxWs(fileObject);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(WSUtils.class.getName()).log(Level.WARNING, "Cannot remove sun-jaxws.xml file.", iOException);
                    }
                    try {
                        WSUtils.removeServicesFromDD(project, jAXWSLightSupport);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(WSUtils.class.getName()).log(Level.WARNING, "Cannot remove services from web.xml.", iOException);
                    }
                }
            } else if ((fileObject == null || fileObject.getFileObject("sun-jaxws.xml") == null) && WSUtils.generateNonJsr109Artifacts(project)) {
                if (fileObject != null) {
                    try {
                        WSUtils.addJaxWsEntries(fileObject, jAXWSLightSupport);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(WSUtils.class.getName()).log(Level.WARNING, "Cannot modify sun-jaxws.xml file", iOException);
                    }
                    try {
                        WSUtils.addServicesToDD(project, jAXWSLightSupport);
                    }
                    catch (IOException iOException) {
                        Logger.getLogger(WSUtils.class.getName()).log(Level.WARNING, "Cannot modify web.xml file", iOException);
                    }
                } else {
                    String string = NbBundle.getMessage(MavenJAXWSSupportImpl.class, (String)"MSG_CannotFindWEB-INF");
                    NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                    DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                }
            }
        }
    }

    public static String getUniqueId(String string, List<JaxWsService> list) {
        String string2 = string;
        HashSet<String> hashSet = new HashSet<String>();
        for (JaxWsService jaxWsService : list) {
            String string3 = jaxWsService.getId();
            if (string3 == null) continue;
            hashSet.add(string3);
        }
        int n = 1;
        while (hashSet.contains(string2)) {
            string2 = string + "_" + String.valueOf(n++);
        }
        return string2;
    }

    static boolean isInSourceGroup(Project project, String string) {
        SourceGroup[] sourceGroupArray;
        for (SourceGroup sourceGroup : sourceGroupArray = ProjectUtils.getSources((Project)project).getSourceGroups("java")) {
            String string2 = string.replace('.', '/') + ".java";
            if (sourceGroup.getRootFolder().getFileObject(string2) == null) continue;
            return true;
        }
        return false;
    }
}

