/*
 * Decompiled with CFR 0.152.
 */
package proguard.optimize;

import java.io.IOException;
import java.util.ArrayList;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.editor.AccessFixer;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.editor.MethodInvocationFixer;
import proguard.classfile.editor.StackSizeUpdater;
import proguard.classfile.editor.VariableCleaner;
import proguard.classfile.instruction.visitor.AllInstructionVisitor;
import proguard.classfile.instruction.visitor.InstructionCounter;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassForNameClassVisitor;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.DotClassClassVisitor;
import proguard.classfile.visitor.ExceptionCounter;
import proguard.classfile.visitor.ExceptionHandlerConstantVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberCounter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.evaluation.InvocationUnit;
import proguard.evaluation.value.IdentifiedValueFactory;
import proguard.evaluation.value.ValueFactory;
import proguard.optimize.ConstantMemberFilter;
import proguard.optimize.ConstantParameterFilter;
import proguard.optimize.DuplicateInitializerFixer;
import proguard.optimize.DuplicateInitializerInvocationFixer;
import proguard.optimize.KeepMarker;
import proguard.optimize.MethodDescriptorShrinker;
import proguard.optimize.MethodStaticizer;
import proguard.optimize.OptimizationInfoMemberFilter;
import proguard.optimize.ParameterShrinker;
import proguard.optimize.TailRecursionSimplifier;
import proguard.optimize.WriteOnlyFieldFilter;
import proguard.optimize.evaluation.EvaluationShrinker;
import proguard.optimize.evaluation.EvaluationSimplifier;
import proguard.optimize.evaluation.LoadingInvocationUnit;
import proguard.optimize.evaluation.PartialEvaluator;
import proguard.optimize.evaluation.StoringInvocationUnit;
import proguard.optimize.evaluation.VariableOptimizer;
import proguard.optimize.info.AccessMethodMarker;
import proguard.optimize.info.BackwardBranchMarker;
import proguard.optimize.info.CatchExceptionMarker;
import proguard.optimize.info.CaughtClassMarker;
import proguard.optimize.info.ClassOptimizationInfoSetter;
import proguard.optimize.info.DotClassMarker;
import proguard.optimize.info.InstanceofClassMarker;
import proguard.optimize.info.InstantiationClassMarker;
import proguard.optimize.info.MemberOptimizationInfoSetter;
import proguard.optimize.info.MethodInvocationMarker;
import proguard.optimize.info.NoSideEffectMethodMarker;
import proguard.optimize.info.NonPrivateMemberMarker;
import proguard.optimize.info.PackageVisibleMemberContainingClassMarker;
import proguard.optimize.info.PackageVisibleMemberInvokingClassMarker;
import proguard.optimize.info.ParameterUsageMarker;
import proguard.optimize.info.ReadWriteFieldMarker;
import proguard.optimize.info.SideEffectMethodMarker;
import proguard.optimize.info.SuperInvocationMarker;
import proguard.optimize.peephole.BranchTargetFinder;
import proguard.optimize.peephole.ClassFinalizer;
import proguard.optimize.peephole.GotoCommonCodeReplacer;
import proguard.optimize.peephole.GotoGotoReplacer;
import proguard.optimize.peephole.GotoReturnReplacer;
import proguard.optimize.peephole.HorizontalClassMerger;
import proguard.optimize.peephole.InstructionSequenceConstants;
import proguard.optimize.peephole.InstructionSequencesReplacer;
import proguard.optimize.peephole.MemberPrivatizer;
import proguard.optimize.peephole.MethodFinalizer;
import proguard.optimize.peephole.MethodInliner;
import proguard.optimize.peephole.PeepholeOptimizer;
import proguard.optimize.peephole.RetargetedInnerClassAttributeRemover;
import proguard.optimize.peephole.TargetClassChanger;
import proguard.optimize.peephole.UnreachableCodeRemover;
import proguard.optimize.peephole.UnreachableExceptionRemover;
import proguard.optimize.peephole.VariableShrinker;
import proguard.optimize.peephole.VerticalClassMerger;
import proguard.util.ConstantMatcher;
import proguard.util.ListParser;
import proguard.util.NameParser;

public class Optimizer {
    private static final String CLASS_MARKING_FINAL = "class/marking/final";
    private static final String CLASS_MERGING_VERTICAL = "class/merging/vertical";
    private static final String CLASS_MERGING_HORIZONTAL = "class/merging/horizontal";
    private static final String FIELD_REMOVAL_WRITEONLY = "field/removal/writeonly";
    private static final String FIELD_MARKING_PRIVATE = "field/marking/private";
    private static final String FIELD_PROPAGATION_VALUE = "field/propagation/value";
    private static final String METHOD_MARKING_PRIVATE = "method/marking/private";
    private static final String METHOD_MARKING_STATIC = "method/marking/static";
    private static final String METHOD_MARKING_FINAL = "method/marking/final";
    private static final String METHOD_REMOVAL_PARAMETER = "method/removal/parameter";
    private static final String METHOD_PROPAGATION_PARAMETER = "method/propagation/parameter";
    private static final String METHOD_PROPAGATION_RETURNVALUE = "method/propagation/returnvalue";
    private static final String METHOD_INLINING_SHORT = "method/inlining/short";
    private static final String METHOD_INLINING_UNIQUE = "method/inlining/unique";
    private static final String METHOD_INLINING_TAILRECURSION = "method/inlining/tailrecursion";
    private static final String CODE_MERGING = "code/merging";
    private static final String CODE_SIMPLIFICATION_VARIABLE = "code/simplification/variable";
    private static final String CODE_SIMPLIFICATION_ARITHMETIC = "code/simplification/arithmetic";
    private static final String CODE_SIMPLIFICATION_CAST = "code/simplification/cast";
    private static final String CODE_SIMPLIFICATION_FIELD = "code/simplification/field";
    private static final String CODE_SIMPLIFICATION_BRANCH = "code/simplification/branch";
    private static final String CODE_SIMPLIFICATION_ADVANCED = "code/simplification/advanced";
    private static final String CODE_REMOVAL_ADVANCED = "code/removal/advanced";
    private static final String CODE_REMOVAL_SIMPLE = "code/removal/simple";
    private static final String CODE_REMOVAL_VARIABLE = "code/removal/variable";
    private static final String CODE_REMOVAL_EXCEPTION = "code/removal/exception";
    private static final String CODE_ALLOCATION_VARIABLE = "code/allocation/variable";
    public static final String[] OPTIMIZATION_NAMES = new String[]{"class/marking/final", "class/merging/vertical", "class/merging/horizontal", "field/removal/writeonly", "field/propagation/value", "method/marking/private", "method/marking/static", "method/marking/final", "method/removal/parameter", "method/propagation/parameter", "method/propagation/returnvalue", "method/inlining/short", "method/inlining/unique", "method/inlining/tailrecursion", "code/merging", "code/simplification/variable", "code/simplification/arithmetic", "code/simplification/cast", "code/simplification/field", "code/simplification/branch", "code/simplification/advanced", "code/removal/advanced", "code/removal/simple", "code/removal/variable", "code/removal/exception", "code/allocation/variable"};
    private final Configuration configuration;

    public Optimizer(Configuration configuration) {
        this.configuration = configuration;
    }

    public boolean execute(ClassPool classPool, ClassPool classPool2) throws IOException {
        Object object;
        Object object2;
        if (this.configuration.keep == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the optimization step.");
        }
        ConstantMatcher constantMatcher = this.configuration.optimizations != null ? new ListParser(new NameParser()).parse(this.configuration.optimizations) : new ConstantMatcher(true);
        boolean bl = constantMatcher.matches(CLASS_MARKING_FINAL);
        boolean bl2 = constantMatcher.matches(CLASS_MERGING_VERTICAL);
        boolean bl3 = constantMatcher.matches(CLASS_MERGING_HORIZONTAL);
        boolean bl4 = constantMatcher.matches(FIELD_REMOVAL_WRITEONLY);
        boolean bl5 = constantMatcher.matches(FIELD_MARKING_PRIVATE);
        boolean bl6 = constantMatcher.matches(FIELD_PROPAGATION_VALUE);
        boolean bl7 = constantMatcher.matches(METHOD_MARKING_PRIVATE);
        boolean bl8 = constantMatcher.matches(METHOD_MARKING_STATIC);
        boolean bl9 = constantMatcher.matches(METHOD_MARKING_FINAL);
        boolean bl10 = constantMatcher.matches(METHOD_REMOVAL_PARAMETER);
        boolean bl11 = constantMatcher.matches(METHOD_PROPAGATION_PARAMETER);
        boolean bl12 = constantMatcher.matches(METHOD_PROPAGATION_RETURNVALUE);
        boolean bl13 = constantMatcher.matches(METHOD_INLINING_SHORT);
        boolean bl14 = constantMatcher.matches(METHOD_INLINING_UNIQUE);
        boolean bl15 = constantMatcher.matches(METHOD_INLINING_TAILRECURSION);
        boolean bl16 = constantMatcher.matches(CODE_MERGING);
        boolean bl17 = constantMatcher.matches(CODE_SIMPLIFICATION_VARIABLE);
        boolean bl18 = constantMatcher.matches(CODE_SIMPLIFICATION_ARITHMETIC);
        boolean bl19 = constantMatcher.matches(CODE_SIMPLIFICATION_CAST);
        boolean bl20 = constantMatcher.matches(CODE_SIMPLIFICATION_FIELD);
        boolean bl21 = constantMatcher.matches(CODE_SIMPLIFICATION_BRANCH);
        boolean bl22 = constantMatcher.matches(CODE_SIMPLIFICATION_ADVANCED);
        boolean bl23 = constantMatcher.matches(CODE_REMOVAL_ADVANCED);
        boolean bl24 = constantMatcher.matches(CODE_REMOVAL_SIMPLE);
        boolean bl25 = constantMatcher.matches(CODE_REMOVAL_VARIABLE);
        boolean bl26 = constantMatcher.matches(CODE_REMOVAL_EXCEPTION);
        boolean bl27 = constantMatcher.matches(CODE_ALLOCATION_VARIABLE);
        ClassCounter classCounter = new ClassCounter();
        ClassCounter classCounter2 = new ClassCounter();
        ClassCounter classCounter3 = new ClassCounter();
        MemberCounter memberCounter = new MemberCounter();
        MemberCounter memberCounter2 = new MemberCounter();
        MemberCounter memberCounter3 = new MemberCounter();
        MemberCounter memberCounter4 = new MemberCounter();
        MemberCounter memberCounter5 = new MemberCounter();
        MemberCounter memberCounter6 = new MemberCounter();
        MemberCounter memberCounter7 = new MemberCounter();
        MemberCounter memberCounter8 = new MemberCounter();
        MemberCounter memberCounter9 = new MemberCounter();
        InstructionCounter instructionCounter = new InstructionCounter();
        InstructionCounter instructionCounter2 = new InstructionCounter();
        InstructionCounter instructionCounter3 = new InstructionCounter();
        InstructionCounter instructionCounter4 = new InstructionCounter();
        InstructionCounter instructionCounter5 = new InstructionCounter();
        InstructionCounter instructionCounter6 = new InstructionCounter();
        InstructionCounter instructionCounter7 = new InstructionCounter();
        InstructionCounter instructionCounter8 = new InstructionCounter();
        InstructionCounter instructionCounter9 = new InstructionCounter();
        InstructionCounter instructionCounter10 = new InstructionCounter();
        InstructionCounter instructionCounter11 = new InstructionCounter();
        InstructionCounter instructionCounter12 = new InstructionCounter();
        MemberCounter memberCounter10 = new MemberCounter();
        ExceptionCounter exceptionCounter = new ExceptionCounter();
        MemberCounter memberCounter11 = new MemberCounter();
        MemberCounter memberCounter12 = new MemberCounter();
        bl22 = bl22 || bl6 || bl11 || bl12;
        bl23 = bl23 || bl4 || bl8 || bl10;
        bl24 = bl24 || bl21;
        bl26 = bl26 || bl23 || bl24;
        classPool.classesAccept(new ClassCleaner());
        classPool2.classesAccept(new ClassCleaner());
        classPool.classesAccept(new BottomClassFilter(new MethodLinker()));
        classPool2.classesAccept(new BottomClassFilter(new MethodLinker()));
        KeepMarker keepMarker = new KeepMarker();
        ClassPoolVisitor classPoolVisitor = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.keep, keepMarker, keepMarker, false, true, false);
        classPool.accept(classPoolVisitor);
        classPool2.accept(classPoolVisitor);
        classPool2.classesAccept(keepMarker);
        classPool2.classesAccept(new AllMemberVisitor(keepMarker));
        classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new DotClassClassVisitor(keepMarker)))));
        classPool.classesAccept(new AllConstantVisitor(new ClassForNameClassVisitor(keepMarker)));
        classPool.classesAccept(new ClassOptimizationInfoSetter());
        classPool.classesAccept(new AllMemberVisitor(new MemberOptimizationInfoSetter()));
        if (this.configuration.assumeNoSideEffects != null) {
            object2 = new NoSideEffectMethodMarker();
            object = ClassSpecificationVisitorFactory.createClassPoolVisitor(this.configuration.assumeNoSideEffects, null, (MemberVisitor)object2);
            classPool.accept((ClassPoolVisitor)object);
            classPool2.accept((ClassPoolVisitor)object);
        }
        if (bl) {
            classPool.classesAccept(new ClassFinalizer(classCounter));
        }
        if (bl9) {
            classPool.classesAccept(new AllMethodVisitor(new MethodFinalizer(memberCounter6)));
        }
        if (bl4) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new AllInstructionVisitor(new ReadWriteFieldMarker()))));
            classPool.classesAccept(new AllFieldVisitor(new WriteOnlyFieldFilter(memberCounter)));
        } else {
            classPool.classesAccept(new AllFieldVisitor(new ReadWriteFieldMarker()));
        }
        classPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new ParameterUsageMarker(!bl8, !bl10))));
        classPool.accept(new SideEffectMethodMarker());
        object2 = new IdentifiedValueFactory();
        if (bl6 || bl11 || bl12) {
            object = new StoringInvocationUnit((ValueFactory)object2, bl6, bl11, bl12);
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new PartialEvaluator((ValueFactory)object2, (InvocationUnit)object, false))));
            classPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new AllFieldVisitor(new ConstantMemberFilter(memberCounter3)), new AllMethodVisitor(new ConstantParameterFilter(memberCounter8)), new AllMethodVisitor(new ConstantMemberFilter(memberCounter9))}));
        }
        object = new LoadingInvocationUnit((ValueFactory)object2, bl6, bl11, bl12);
        if (bl22) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new EvaluationSimplifier(new PartialEvaluator((ValueFactory)object2, (InvocationUnit)object, false), instructionCounter10))));
        }
        if (bl23) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new EvaluationShrinker(new PartialEvaluator((ValueFactory)object2, (InvocationUnit)object, !bl22), instructionCounter11, instructionCounter12))));
        }
        if (bl10) {
            classPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MethodDescriptorShrinker())));
        }
        if (bl8) {
            classPool.classesAccept(new AllMethodVisitor(new OptimizationInfoMemberFilter(new MemberAccessFilter(0, 8, new MethodStaticizer(memberCounter5)))));
        }
        if (bl10) {
            classPool.classesAccept(new MemberReferenceFixer());
        }
        if (bl10 || bl7 || bl8) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new ParameterShrinker(memberCounter7))));
        } else if (bl23) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new StackSizeUpdater())));
        }
        classPool.classesAccept(new MultiClassVisitor(new ClassVisitor[]{new AllConstantVisitor(new PackageVisibleMemberInvokingClassMarker()), new AllMethodVisitor(new MultiMemberVisitor(new MemberVisitor[]{new PackageVisibleMemberContainingClassMarker(), new AllAttributeVisitor(new MultiAttributeVisitor(new AttributeVisitor[]{new CatchExceptionMarker(), new AllInstructionVisitor(new MultiInstructionVisitor(new InstructionVisitor[]{new InstantiationClassMarker(), new InstanceofClassMarker(), new DotClassMarker(), new MethodInvocationMarker(), new SuperInvocationMarker(), new BackwardBranchMarker(), new AccessMethodMarker()})), new AllExceptionInfoVisitor(new ExceptionHandlerConstantVisitor(new ReferencedClassVisitor(new CaughtClassMarker())))}))}))}));
        if (bl2) {
            classPool.classesAccept(new VerticalClassMerger(this.configuration.allowAccessModification, this.configuration.mergeInterfacesAggressively, classCounter2));
        }
        if (bl3) {
            classPool.classesAccept(new HorizontalClassMerger(this.configuration.allowAccessModification, this.configuration.mergeInterfacesAggressively, classCounter3));
        }
        if (bl2 || bl3) {
            classPool.classesAccept(new RetargetedInnerClassAttributeRemover());
            classPool.classesAccept(new TargetClassChanger());
            classPool.classesAccept(new ClassReferenceFixer(true));
            classPool.classesAccept(new MemberReferenceFixer());
            if (this.configuration.allowAccessModification) {
                classPool.classesAccept(new AllConstantVisitor(new AccessFixer()));
            }
        }
        if (bl10 || bl2 || bl3) {
            classPool.classesAccept(new AllMethodVisitor(new DuplicateInitializerFixer(memberCounter12)));
            if (memberCounter12.getCount() > 0) {
                classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new DuplicateInitializerInvocationFixer(instructionCounter12))));
                classPool.classesAccept(new MemberReferenceFixer());
            }
        }
        if (bl14) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new MethodInliner(this.configuration.microEdition, this.configuration.allowAccessModification, true, instructionCounter2))));
        }
        if (bl13) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new MethodInliner(this.configuration.microEdition, this.configuration.allowAccessModification, false, instructionCounter))));
        }
        if (bl15) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new TailRecursionSimplifier(instructionCounter3))));
        }
        if (bl5 || bl7) {
            classPool.classesAccept(new NonPrivateMemberMarker());
        }
        if (bl5 || bl7) {
            classPool.classesAccept(new AllFieldVisitor(new MemberAccessFilter(0, 2, new MemberPrivatizer(memberCounter2))));
        }
        if (bl7) {
            classPool.classesAccept(new ClassAccessFilter(0, 512, new AllMethodVisitor(new MemberAccessFilter(0, 2, new MemberPrivatizer(memberCounter4)))));
        }
        if ((bl14 || bl13 || bl15) && this.configuration.allowAccessModification) {
            classPool.classesAccept(new AllConstantVisitor(new AccessFixer()));
        }
        if (bl10 || bl2 || bl3 || bl7) {
            classPool.classesAccept(new AllMemberVisitor(new AllAttributeVisitor(new MethodInvocationFixer())));
        }
        if (bl16) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new GotoCommonCodeReplacer(instructionCounter4))));
        }
        BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        ArrayList<InstructionVisitor> arrayList = new ArrayList<InstructionVisitor>();
        if (bl17) {
            arrayList.add(new InstructionSequencesReplacer(InstructionSequenceConstants.CONSTANTS, InstructionSequenceConstants.VARIABLE, branchTargetFinder, codeAttributeEditor, instructionCounter5));
        }
        if (bl18) {
            arrayList.add(new InstructionSequencesReplacer(InstructionSequenceConstants.CONSTANTS, InstructionSequenceConstants.ARITHMETIC, branchTargetFinder, codeAttributeEditor, instructionCounter6));
        }
        if (bl19) {
            arrayList.add(new InstructionSequencesReplacer(InstructionSequenceConstants.CONSTANTS, InstructionSequenceConstants.CAST, branchTargetFinder, codeAttributeEditor, instructionCounter7));
        }
        if (bl20) {
            arrayList.add(new InstructionSequencesReplacer(InstructionSequenceConstants.CONSTANTS, InstructionSequenceConstants.FIELD, branchTargetFinder, codeAttributeEditor, instructionCounter8));
        }
        if (bl21) {
            arrayList.add(new InstructionSequencesReplacer(InstructionSequenceConstants.CONSTANTS, InstructionSequenceConstants.BRANCH, branchTargetFinder, codeAttributeEditor, instructionCounter9));
            arrayList.add(new GotoGotoReplacer(codeAttributeEditor, instructionCounter9));
            arrayList.add(new GotoReturnReplacer(codeAttributeEditor, instructionCounter9));
        }
        if (!arrayList.isEmpty()) {
            InstructionVisitor[] instructionVisitorArray = new InstructionVisitor[arrayList.size()];
            arrayList.toArray(instructionVisitorArray);
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new PeepholeOptimizer(branchTargetFinder, codeAttributeEditor, new MultiInstructionVisitor(instructionVisitorArray)))));
        }
        if (bl26) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new UnreachableExceptionRemover(exceptionCounter))));
        }
        if (bl24) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new UnreachableCodeRemover(instructionCounter11))));
        }
        if (bl25) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new VariableShrinker(memberCounter10))));
        } else {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new VariableCleaner())));
        }
        if (bl27) {
            classPool.classesAccept(new AllMethodVisitor(new AllAttributeVisitor(new VariableOptimizer(false, memberCounter11))));
        }
        int n = classCounter.getCount();
        int n2 = classCounter2.getCount();
        int n3 = classCounter3.getCount();
        int n4 = memberCounter.getCount();
        int n5 = memberCounter2.getCount();
        int n6 = memberCounter3.getCount();
        int n7 = memberCounter4.getCount();
        int n8 = memberCounter5.getCount();
        int n9 = memberCounter6.getCount();
        int n10 = memberCounter7.getCount() - memberCounter5.getCount() - memberCounter12.getCount();
        int n11 = memberCounter8.getCount();
        int n12 = memberCounter9.getCount();
        int n13 = instructionCounter.getCount();
        int n14 = instructionCounter2.getCount();
        int n15 = instructionCounter3.getCount();
        int n16 = instructionCounter4.getCount();
        int n17 = instructionCounter5.getCount();
        int n18 = instructionCounter6.getCount();
        int n19 = instructionCounter7.getCount();
        int n20 = instructionCounter8.getCount();
        int n21 = instructionCounter9.getCount();
        int n22 = instructionCounter10.getCount();
        int n23 = instructionCounter11.getCount() - instructionCounter12.getCount();
        int n24 = memberCounter10.getCount();
        int n25 = exceptionCounter.getCount();
        int n26 = memberCounter11.getCount();
        if (this.configuration.verbose) {
            System.out.println("  Number of finalized classes:                 " + n + this.disabled(bl));
            System.out.println("  Number of vertically merged classes:         " + n2 + this.disabled(bl2));
            System.out.println("  Number of horizontally merged classes:       " + n3 + this.disabled(bl3));
            System.out.println("  Number of removed write-only fields:         " + n4 + this.disabled(bl4));
            System.out.println("  Number of privatized fields:                 " + n5 + this.disabled(bl5));
            System.out.println("  Number of inlined constant fields:           " + n6 + this.disabled(bl6));
            System.out.println("  Number of privatized methods:                " + n7 + this.disabled(bl7));
            System.out.println("  Number of staticized methods:                " + n8 + this.disabled(bl8));
            System.out.println("  Number of finalized methods:                 " + n9 + this.disabled(bl9));
            System.out.println("  Number of removed method parameters:         " + n10 + this.disabled(bl10));
            System.out.println("  Number of inlined constant parameters:       " + n11 + this.disabled(bl11));
            System.out.println("  Number of inlined constant return values:    " + n12 + this.disabled(bl12));
            System.out.println("  Number of inlined short method calls:        " + n13 + this.disabled(bl13));
            System.out.println("  Number of inlined unique method calls:       " + n14 + this.disabled(bl14));
            System.out.println("  Number of inlined tail recursion calls:      " + n15 + this.disabled(bl15));
            System.out.println("  Number of merged code blocks:                " + n16 + this.disabled(bl16));
            System.out.println("  Number of variable peephole optimizations:   " + n17 + this.disabled(bl17));
            System.out.println("  Number of arithmetic peephole optimizations: " + n18 + this.disabled(bl18));
            System.out.println("  Number of cast peephole optimizations:       " + n19 + this.disabled(bl19));
            System.out.println("  Number of field peephole optimizations:      " + n20 + this.disabled(bl20));
            System.out.println("  Number of branch peephole optimizations:     " + n21 + this.disabled(bl21));
            System.out.println("  Number of simplified instructions:           " + n22 + this.disabled(bl22));
            System.out.println("  Number of removed instructions:              " + n23 + this.disabled(bl23));
            System.out.println("  Number of removed local variables:           " + n24 + this.disabled(bl25));
            System.out.println("  Number of removed exception blocks:          " + n25 + this.disabled(bl26));
            System.out.println("  Number of optimized local variable frames:   " + n26 + this.disabled(bl27));
        }
        return n > 0 || n2 > 0 || n3 > 0 || n4 > 0 || n5 > 0 || n7 > 0 || n8 > 0 || n9 > 0 || n6 > 0 || n10 > 0 || n11 > 0 || n12 > 0 || n13 > 0 || n14 > 0 || n15 > 0 || n16 > 0 || n17 > 0 || n18 > 0 || n19 > 0 || n20 > 0 || n21 > 0 || n22 > 0 || n23 > 0 || n24 > 0 || n25 > 0 || n26 > 0;
    }

    private String disabled(boolean bl) {
        return bl ? "" : "   (disabled)";
    }

    private String disabled(boolean bl, boolean bl2) {
        return bl && bl2 ? "" : (bl || bl2 ? "   (partially disabled)" : "   (disabled)");
    }
}

