/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.napi.gsfret.source;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import javax.swing.text.Document;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.modules.gsf.Language;
import org.netbeans.modules.gsf.api.EditHistory;
import org.netbeans.modules.gsf.api.Error;
import org.netbeans.modules.gsf.api.Index;
import org.netbeans.modules.gsf.api.ParserResult;
import org.netbeans.napi.gsfret.source.ClasspathInfo;
import org.netbeans.napi.gsfret.source.CompilationInfo;
import org.netbeans.napi.gsfret.source.ParserTaskImpl;
import org.netbeans.napi.gsfret.source.Phase;
import org.netbeans.napi.gsfret.source.Source;
import org.openide.filesystems.FileObject;

public class CompilationController
extends CompilationInfo {
    final CompilationInfo delegate;

    CompilationController(CompilationInfo delegate) throws IOException {
        assert (delegate != null);
        this.delegate = delegate;
    }

    public Phase toPhase(Phase phase) throws IOException {
        if (phase == Phase.MODIFIED) {
            throw new IllegalArgumentException("Wrong phase" + (Object)((Object)phase));
        }
        if (this.delegate.jfo == null) {
            Phase currentPhase = this.delegate.getPhase();
            if (currentPhase.compareTo(phase) < 0) {
                this.delegate.setPhase(phase);
            }
            return this.delegate.getPhase();
        }
        Phase currentPhase = Source.moveToPhase(phase, this.delegate, false);
        return currentPhase.compareTo(phase) < 0 ? currentPhase : phase;
    }

    @Override
    public Phase getPhase() {
        return this.delegate.getPhase();
    }

    @Override
    public String getText() {
        return this.delegate.getText();
    }

    @Override
    public TokenHierarchy<?> getTokenHierarchy() {
        return this.delegate.getTokenHierarchy();
    }

    @Override
    public Source getSource() {
        return this.delegate.getSource();
    }

    @Override
    public ClasspathInfo getClasspathInfo() {
        return this.delegate.getClasspathInfo();
    }

    public FileObject getFileObject() {
        return this.delegate.getFileObject();
    }

    public Document getDocument() {
        return this.delegate.getDocument();
    }

    @Override
    void setPhase(Phase phase) {
        throw new UnsupportedOperationException("CompilationController supports only read interface");
    }

    @Override
    public void setLanguage(Language language) {
        throw new UnsupportedOperationException("CompilationController supports only read interface");
    }

    @Override
    public Language getLanguage() {
        return this.delegate.getLanguage();
    }

    @Override
    ParserTaskImpl getParserTask() {
        return this.delegate.getParserTask();
    }

    @Override
    public Index getIndex(String mimeType) {
        return this.delegate.getIndex(mimeType);
    }

    @Override
    public Collection<? extends ParserResult> getEmbeddedResults(String mimeType) {
        return this.delegate.getEmbeddedResults(mimeType);
    }

    @Override
    public ParserResult getEmbeddedResult(String mimeType, int offset) {
        return this.delegate.getEmbeddedResult(mimeType, offset);
    }

    @Override
    public List<Error> getErrors() {
        return this.delegate.getErrors();
    }

    @Override
    public void addEmbeddingResult(String mimeType, ParserResult result) {
        this.delegate.addEmbeddingResult(mimeType, result);
    }

    @Override
    public Set<String> getEmbeddedMimeTypes() {
        return this.delegate.getEmbeddedMimeTypes();
    }

    @Override
    public EditHistory getHistory() {
        return this.delegate.getHistory();
    }

    @Override
    public void setHistory(EditHistory history) {
        this.delegate.setHistory(history);
    }

    @Override
    public boolean hasUnchangedResults() {
        return this.delegate.hasUnchangedResults();
    }
}

