/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.heapwalk.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import org.netbeans.modules.profiler.heapwalk.HeapWalker;
import org.netbeans.modules.profiler.heapwalk.HeapWalkerManager;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class HeapWalkerUI
extends TopComponent {
    private static final String COMPONENT_DESCR = NbBundle.getMessage(HeapWalkerUI.class, (String)"HeapWalkerUI_ComponentDescr");
    private HeapWalker heapWalker;
    private Component lastFocusOwner;

    public HeapWalkerUI(HeapWalker heapWalker) {
        this.heapWalker = heapWalker;
        this.initDefaults();
        this.initComponents();
    }

    public void componentActivated() {
        if (this.lastFocusOwner != null) {
            this.lastFocusOwner.requestFocus();
        } else {
            this.heapWalker.getMainHeapWalker().getPanel().requestFocus();
        }
    }

    public void componentDeactivated() {
        this.lastFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
    }

    public int getPersistenceType() {
        return 2;
    }

    protected void componentClosed() {
        HeapWalkerManager.getDefault().heapWalkerClosed(this.heapWalker);
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void initComponents() {
        this.setLayout(new BorderLayout());
        this.add(this.heapWalker.getMainHeapWalker().getPanel(), "Center");
    }

    private void initDefaults() {
        this.setName(this.heapWalker.getName());
        this.setIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/profiler/resources/memory.png"));
        this.getAccessibleContext().setAccessibleDescription(COMPONENT_DESCR);
    }
}

