/*
 * Decompiled with CFR 0.152.
 */
package org.openide.util.actions;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.SwingUtilities;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Mutex;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;
import org.openide.util.actions.ActionInvoker;
import org.openide.util.actions.ActionPerformer;
import org.openide.util.actions.ActionPresenterProvider;
import org.openide.util.actions.CallableSystemAction;
import org.openide.util.actions.Presenter;
import org.openide.util.actions.SystemAction;

public abstract class CallbackSystemAction
extends CallableSystemAction
implements ContextAwareAction {
    private static final String PROP_ACTION_PERFORMER = "actionPerformer";
    private static final WeakSet<Class<? extends CallbackSystemAction>> notSurviving = new WeakSet(37);
    private static final WeakSet<Class<? extends CallbackSystemAction>> surviving = new WeakSet(37);
    private static final Object LISTENER = new Object();
    static final long serialVersionUID = -6305817805474624653L;
    private static final Logger err = Logger.getLogger("org.openide.util.actions.CallbackSystemAction");

    @Override
    protected void initialize() {
        super.initialize();
        this.updateEnabled();
        this.setSurviveFocusChange(false);
    }

    @Deprecated
    public ActionPerformer getActionPerformer() {
        return (ActionPerformer)this.getProperty(PROP_ACTION_PERFORMER);
    }

    @Deprecated
    public void setActionPerformer(ActionPerformer performer) {
        this.putProperty(PROP_ACTION_PERFORMER, performer);
        this.updateEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateEnabled() {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            this.setEnabled(action.isEnabled());
            Object object = LISTENER;
            synchronized (object) {
                ActionDelegateListener l = (ActionDelegateListener)this.getProperty(LISTENER);
                if (l == null || l.get() != this) {
                    l = new ActionDelegateListener(this, action);
                    this.putProperty(LISTENER, l);
                } else {
                    l.attach(action);
                }
            }
        } else {
            if (this.getActionPerformer() != null) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
            this.clearListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearListener() {
        Object object = LISTENER;
        synchronized (object) {
            ActionDelegateListener l = (ActionDelegateListener)this.getProperty(LISTENER);
            if (l != null) {
                l.clear();
                this.putProperty(LISTENER, null);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        Action action = GlobalManager.getDefault().findGlobalAction(this.getActionMapKey(), this.getSurviveFocusChange());
        if (action != null) {
            if (action.isEnabled()) {
                action.actionPerformed(ev);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
            return;
        }
        final ActionPerformer ap = this.getActionPerformer();
        if (ap != null) {
            ActionInvoker.invokeAction(this, ev, this.asynchronous(), new Runnable(){

                @Override
                public void run() {
                    if (ap == CallbackSystemAction.this.getActionPerformer()) {
                        CallbackSystemAction.this.getActionPerformer().performAction(CallbackSystemAction.this);
                    }
                }
            });
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    @Override
    @Deprecated
    public void performAction() {
        ActionPerformer ap = this.getActionPerformer();
        if (ap != null) {
            ap.performAction(this);
        }
    }

    public Object getActionMapKey() {
        return this.getClass().getName();
    }

    public boolean getSurviveFocusChange() {
        this.getProperty(null);
        return !notSurviving.contains(this.getClass());
    }

    @Override
    public Action createContextAwareInstance(Lookup actionContext) {
        return new DelegateAction(this, actionContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSurviveFocusChange(boolean b) {
        WeakSet<Class<? extends CallbackSystemAction>> weakSet = notSurviving;
        synchronized (weakSet) {
            if (b) {
                notSurviving.remove(this.getClass());
                surviving.add(this.getClass());
            } else {
                notSurviving.add(this.getClass());
                surviving.remove(this.getClass());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<CallbackSystemAction> toInstances(Set<Class<? extends CallbackSystemAction>> s) {
        ArrayList<CallbackSystemAction> actions;
        WeakSet<Class<? extends CallbackSystemAction>> weakSet = notSurviving;
        synchronized (weakSet) {
            actions = new ArrayList<CallbackSystemAction>(s.size());
            for (Class<? extends CallbackSystemAction> c : s) {
                CallbackSystemAction a = SystemAction.findObject(c, false);
                if (a == null) continue;
                actions.add(a);
            }
        }
        return actions;
    }

    private static void clearActionPerformers() {
        List<CallbackSystemAction> actions = CallbackSystemAction.toInstances(notSurviving);
        for (CallbackSystemAction a : actions) {
            a.setActionPerformer(null);
        }
        actions = CallbackSystemAction.toInstances(surviving);
        for (CallbackSystemAction a : actions) {
            if (err.isLoggable(Level.FINE)) {
                err.fine("updateEnabled: " + a);
            }
            a.updateEnabled();
        }
    }

    private static final class DelegateAction
    implements Action,
    LookupListener,
    Presenter.Menu,
    Presenter.Popup,
    Presenter.Toolbar,
    PropertyChangeListener {
        private CallbackSystemAction delegate;
        private Lookup.Result<ActionMap> result;
        private boolean enabled;
        private PropertyChangeSupport support = new PropertyChangeSupport(this);
        private PropertyChangeListener weakL;
        private Reference<Action> lastRef;

        public DelegateAction(CallbackSystemAction a, Lookup actionContext) {
            this.delegate = a;
            this.weakL = WeakListeners.propertyChange(this, null);
            this.enabled = a.getActionPerformer() != null;
            this.result = actionContext.lookup(new Lookup.Template(ActionMap.class));
            this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, this, this.result));
            this.resultChanged(null);
        }

        public String toString() {
            return super.toString() + "[delegate=" + this.delegate + "]";
        }

        @Override
        public void actionPerformed(final ActionEvent e) {
            final Action a = this.findAction();
            if (a != null) {
                Runnable run = new Runnable(){

                    @Override
                    public void run() {
                        a.actionPerformed(e);
                    }
                };
                ActionInvoker.invokeAction(this.delegate, e, this.delegate.asynchronous(), run);
            } else {
                Object value;
                Object source = e.getSource();
                if (source instanceof Component && SwingUtilities.getWindowAncestor((Component)source) instanceof Dialog && !Boolean.TRUE.equals(value = this.delegate.getValue("OpenIDE-Transmodal-Action"))) {
                    return;
                }
                this.delegate.actionPerformed(e);
            }
        }

        @Override
        public boolean isEnabled() {
            Action last;
            Action a = this.findAction();
            if (a == null) {
                a = this.delegate;
            }
            Action action = last = this.lastRef == null ? null : this.lastRef.get();
            if (a != last) {
                if (last != null) {
                    last.removePropertyChangeListener(this.weakL);
                }
                this.lastRef = new WeakReference<Action>(a);
                a.addPropertyChangeListener(this.weakL);
            }
            return a.isEnabled();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            this.support.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            this.support.removePropertyChangeListener(listener);
        }

        @Override
        public void putValue(String key, Object o) {
        }

        @Override
        public Object getValue(String key) {
            return this.delegate.getValue(key);
        }

        @Override
        public void setEnabled(boolean b) {
        }

        public void resultChanged(LookupEvent ev) {
            boolean newEnabled = this.isEnabled();
            if (newEnabled != this.enabled) {
                this.support.firePropertyChange("enabled", this.enabled, newEnabled);
                this.enabled = newEnabled;
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            this.resultChanged(null);
        }

        private Action findAction() {
            Set<ActionMap> c;
            Collection<ActionMap> collection = c = this.result != null ? this.result.allInstances() : Collections.emptySet();
            if (!c.isEmpty()) {
                Object key = this.delegate.getActionMapKey();
                for (ActionMap map : c) {
                    Action action = map.get(key);
                    if (action == null) continue;
                    return action;
                }
            }
            return null;
        }

        @Override
        public JMenuItem getMenuPresenter() {
            if (this.isMethodOverridden(this.delegate, "getMenuPresenter")) {
                return this.delegate.getMenuPresenter();
            }
            return ActionPresenterProvider.getDefault().createMenuPresenter(this);
        }

        @Override
        public JMenuItem getPopupPresenter() {
            if (this.isMethodOverridden(this.delegate, "getPopupPresenter")) {
                return this.delegate.getPopupPresenter();
            }
            return ActionPresenterProvider.getDefault().createPopupPresenter(this);
        }

        @Override
        public Component getToolbarPresenter() {
            if (this.isMethodOverridden(this.delegate, "getToolbarPresenter")) {
                return this.delegate.getToolbarPresenter();
            }
            return ActionPresenterProvider.getDefault().createToolbarPresenter(this);
        }

        private boolean isMethodOverridden(CallableSystemAction d, String name) {
            try {
                Method m = d.getClass().getMethod(name, new Class[0]);
                return m.getDeclaringClass() != CallableSystemAction.class;
            }
            catch (NoSuchMethodException ex) {
                ex.printStackTrace();
                throw new IllegalStateException("Error searching for method " + name + " in " + d);
            }
        }

        protected void finalize() {
            Action last;
            Action action = last = this.lastRef == null ? null : this.lastRef.get();
            if (last != null) {
                last.removePropertyChangeListener(this.weakL);
            }
        }
    }

    private static final class ActionDelegateListener
    extends WeakReference<CallbackSystemAction>
    implements PropertyChangeListener {
        private Reference<Action> delegate;

        public ActionDelegateListener(CallbackSystemAction c, Action delegate) {
            super(c);
            this.delegate = new WeakReference<Action>(delegate);
            delegate.addPropertyChangeListener(this);
        }

        @Override
        public void clear() {
            Action a;
            Reference<Action> d = this.delegate;
            Action action = a = d == null ? null : d.get();
            if (a == null) {
                return;
            }
            this.delegate = null;
            a.removePropertyChangeListener(this);
        }

        public void attach(Action action) {
            Reference<Action> d = this.delegate;
            if (d != null && d.get() == action) {
                return;
            }
            Action prev = d.get();
            if (prev != null) {
                prev.removePropertyChangeListener(this);
            }
            this.delegate = new WeakReference<Action>(action);
            action.addPropertyChangeListener(this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            Object object = LISTENER;
            synchronized (object) {
                Reference<Action> d = this.delegate;
                if (d == null || d.get() == null) {
                    return;
                }
            }
            CallbackSystemAction c = (CallbackSystemAction)this.get();
            if (c != null) {
                c.updateEnabled();
            }
        }
    }

    private static final class WeakAction
    extends WeakReference<Action>
    implements Action {
        public WeakAction(Action delegate) {
            super(delegate);
        }

        public Action getDelegate() {
            return (Action)this.get();
        }

        @Override
        public Object getValue(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putValue(String key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setEnabled(boolean b) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isEnabled() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class GlobalManager
    implements LookupListener {
        private static GlobalManager instance;
        private Lookup.Result<ActionMap> result;
        private List<Reference<ActionMap>> actionMaps = new ArrayList<Reference<ActionMap>>(2);
        private final ActionMap survive = new ActionMap();

        private GlobalManager() {
            this.result = Utilities.actionsGlobalContext().lookup(new Lookup.Template(ActionMap.class));
            this.result.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }

        public static synchronized GlobalManager getDefault() {
            if (instance != null) {
                return instance;
            }
            instance = new GlobalManager();
            return instance;
        }

        public Action findGlobalAction(Object key, boolean surviveFocusChange) {
            Reference<ActionMap> ref;
            ActionMap am;
            Action a = null;
            Iterator<Reference<ActionMap>> i$ = this.actionMaps.iterator();
            while (i$.hasNext() && (a = (am = (ref = i$.next()).get()) == null ? null : am.get(key)) == null) {
            }
            if (surviveFocusChange) {
                if (a == null) {
                    a = this.survive.get(key);
                    if (a != null) {
                        a = ((WeakAction)a).getDelegate();
                    }
                    if (err.isLoggable(Level.FINE)) {
                        err.fine("No action for key: " + key + " using delegate: " + a);
                    }
                } else {
                    if (err.isLoggable(Level.FINE)) {
                        err.fine("New action for key: " + key + " put: " + a);
                    }
                    this.survive.put(key, new WeakAction(a));
                }
            }
            if (err.isLoggable(Level.FINE)) {
                err.fine("Action for key: " + key + " is: " + a);
            }
            return a;
        }

        public void resultChanged(LookupEvent ev) {
            Collection ams = this.result.allInstances();
            if (err.isLoggable(Level.FINE)) {
                err.fine("changed maps : " + ams);
                err.fine("previous maps: " + this.actionMaps);
            }
            if (ams.size() == this.actionMaps.size()) {
                boolean theSame = true;
                int i = 0;
                Iterator newMaps = ams.iterator();
                while (newMaps.hasNext()) {
                    ActionMap oldMap = this.actionMaps.get(i).get();
                    if (oldMap == null || oldMap != newMaps.next()) {
                        theSame = false;
                        break;
                    }
                    ++i;
                }
                if (theSame) {
                    return;
                }
            }
            ArrayList<Reference<ActionMap>> tempActionMaps = new ArrayList<Reference<ActionMap>>(2);
            for (ActionMap actionMap : ams) {
                tempActionMaps.add(new WeakReference<ActionMap>(actionMap));
            }
            this.actionMaps = tempActionMaps;
            if (err.isLoggable(Level.FINE)) {
                err.fine("clearActionPerformers");
            }
            Mutex.EVENT.readAccess(new Runnable(){

                @Override
                public void run() {
                    CallbackSystemAction.clearActionPerformers();
                }
            });
        }
    }
}

