/*
 * Decompiled with CFR 0.152.
 */
package org.codeviation.pojson;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.codeviation.pojson.PojsonSave;

public class ZipSaver {
    private PojsonSave save;
    private ZipOutputStream zos;
    private Writer writer;

    public ZipSaver(ZipOutputStream zos) {
        this(PojsonSave.create(), zos);
    }

    public ZipSaver(PojsonSave save, ZipOutputStream zos) {
        this.save = save;
        this.zos = zos;
        this.writer = new BufferedWriter(new OutputStreamWriter(zos));
    }

    public void save(String entryName, Object object) throws IOException {
        this.zos.putNextEntry(new ZipEntry(entryName));
        this.save.save(this.writer, object);
        this.writer.flush();
    }

    public void save(String entryName, Object[] array) throws IOException {
        this.zos.putNextEntry(new ZipEntry(entryName));
        this.save.save(this.writer, array);
        this.writer.flush();
    }

    public void save(String entryName, Object firstObject, Object ... array) throws IOException {
        this.zos.putNextEntry(new ZipEntry(entryName));
        this.save.save(this.writer, firstObject, array);
        this.writer.flush();
    }

    public void save(String entryName, Iterable iterable) throws IOException {
        this.zos.putNextEntry(new ZipEntry(entryName));
        this.save.save(this.writer, iterable);
        this.writer.flush();
    }
}

