/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.debugger.gdb.GdbCallStackFrame;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.GdbVariable;
import org.netbeans.modules.cnd.debugger.gdb.LocalVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;

public class GdbLocalVariable
extends AbstractVariable
implements LocalVariable,
PropertyChangeListener {
    private final String name;
    private final String type;

    public GdbLocalVariable(GdbDebugger debugger, GdbVariable var) {
        super(debugger, var.getValue());
        assert (!SwingUtilities.isEventDispatchThread());
        this.name = var.getName();
        this.type = this.getDebugger().requestWhatis(this.name);
        debugger.addPropertyChangeListener("valueChanged", this);
    }

    public GdbLocalVariable(GdbDebugger debugger, String name) {
        super(debugger, null);
        assert (!SwingUtilities.isEventDispatchThread());
        this.name = name;
        this.type = this.getDebugger().requestWhatis(name);
        String expr = name;
        if (GdbCallStackFrame.enableMacros && !GdbWatchVariable.disableMacros) {
            expr = GdbWatchVariable.expandMacro(this.getDebugger(), expr);
        }
        this.value = this.getDebugger().evaluate(expr);
        debugger.addPropertyChangeListener("valueChanged", this);
    }

    @Override
    protected void selfDestroy() {
        this.getDebugger().removePropertyChangeListener("valueChanged", this);
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        this.onValueChange(evt);
    }

    @Override
    public String getName() {
        return this.name;
    }
}

