/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.parsing.spi.indexing.support.IndexResult;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.editor.index.CompositeComponentModel;
import org.netbeans.modules.web.jsf.editor.index.JsfPageModelFactory;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public class JsfIndex {
    private final FileObject[] sourceRoots;
    private final FileObject[] binaryRoots;

    public static JsfIndex create(WebModule wm) {
        return new JsfIndex(wm);
    }

    private JsfIndex(WebModule wm) {
        this.sourceRoots = ClassPath.getClassPath((FileObject)wm.getDocumentBase(), (String)"classpath/source").getRoots();
        HashSet<FileObject> roots = new HashSet<FileObject>();
        roots.addAll(Arrays.asList(ClassPath.getClassPath((FileObject)wm.getDocumentBase(), (String)"classpath/compile").getRoots()));
        roots.addAll(Arrays.asList(ClassPath.getClassPath((FileObject)wm.getDocumentBase(), (String)"classpath/execute").getRoots()));
        this.binaryRoots = roots.toArray(new FileObject[0]);
    }

    private QuerySupport createEmbeddingIndex() throws IOException {
        return QuerySupport.forRoots((String)"jsf", (int)1, (FileObject[])this.sourceRoots);
    }

    private QuerySupport createBinaryIndex() throws IOException {
        return QuerySupport.forRoots((String)"jsfBinary", (int)5, (FileObject[])this.binaryRoots);
    }

    public Collection<String> getAllCompositeLibraryNames() {
        ArrayList<String> col = new ArrayList<String>();
        try {
            col.addAll(this.getAllCompositeLibraryNames(this.createBinaryIndex()));
            col.addAll(this.getAllCompositeLibraryNames(this.createEmbeddingIndex()));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return col;
    }

    private Collection<String> getAllCompositeLibraryNames(QuerySupport index) {
        ArrayList<String> libNames = new ArrayList<String>();
        try {
            Collection results = index.query("library", "", QuerySupport.Kind.PREFIX, new String[]{"library"});
            for (IndexResult result : results) {
                String libraryName = result.getValue("library");
                if (libraryName == null) continue;
                libNames.add(libraryName);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return libNames;
    }

    public Collection<String> getCompositeLibraryComponents(String libraryName) {
        ArrayList<String> col = new ArrayList<String>();
        try {
            col.addAll(this.getCompositeLibraryComponents(this.createBinaryIndex(), libraryName));
            col.addAll(this.getCompositeLibraryComponents(this.createEmbeddingIndex(), libraryName));
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return col;
    }

    private Collection<String> getCompositeLibraryComponents(QuerySupport index, String libraryName) {
        ArrayList<String> components = new ArrayList<String>();
        try {
            Collection results = index.query("library", libraryName, QuerySupport.Kind.EXACT, new String[]{"library"});
            for (IndexResult result : results) {
                FileObject file = result.getFile();
                if (file == null) continue;
                components.add(file.getName());
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return components;
    }

    public CompositeComponentModel getCompositeComponentModel(String libraryName, String componentName) {
        try {
            CompositeComponentModel model = this.getCompositeComponentModel(this.createEmbeddingIndex(), libraryName, componentName);
            return model != null ? model : this.getCompositeComponentModel(this.createBinaryIndex(), libraryName, componentName);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return null;
        }
    }

    private CompositeComponentModel getCompositeComponentModel(QuerySupport index, String libraryName, String componentName) {
        try {
            Collection results = index.query("library", libraryName, QuerySupport.Kind.EXACT, new String[]{"library", "interface_attributes", "has_implementation"});
            for (IndexResult result : results) {
                String fileName;
                FileObject file = result.getFile();
                if (file == null || !(fileName = file.getName()).equals(componentName)) continue;
                return (CompositeComponentModel)JsfPageModelFactory.getFactory(CompositeComponentModel.Factory.class).loadFromIndex(result);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public Map<String, FileObject> getAllTldLibraries() {
        HashMap<String, FileObject> map = new HashMap<String, FileObject>();
        try {
            Collection results = this.createBinaryIndex().query("tagLibraryDescriptor", "true", QuerySupport.Kind.EXACT, new String[]{"tagLibraryDescriptor", "namespace"});
            for (IndexResult result : results) {
                FileObject file = result.getFile();
                if (file == null) continue;
                map.put(result.getValue("namespace"), file);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return map;
    }

    public FileObject getTldFile(String namespace) {
        try {
            Collection results = this.createBinaryIndex().query("namespace", namespace, QuerySupport.Kind.EXACT, new String[]{"tagLibraryDescriptor", "namespace"});
            for (IndexResult result : results) {
                if (result.getValue("tagLibraryDescriptor") == null) continue;
                return result.getFile();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }

    public Collection<FileObject> getAllFaceletsLibraryDescriptors() {
        ArrayList<FileObject> files = new ArrayList<FileObject>();
        try {
            Collection results = this.createBinaryIndex().query("faceletsLibraryDescriptor", "true", QuerySupport.Kind.EXACT, new String[]{"faceletsLibraryDescriptor"});
            for (IndexResult result : results) {
                FileObject file = result.getFile();
                if (file == null) continue;
                files.add(file);
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return files;
    }

    public FileObject getFaceletsLibaryDescriptorFile(String namespace) {
        try {
            Collection results = this.createBinaryIndex().query("namespace", namespace, QuerySupport.Kind.EXACT, new String[]{"faceletsLibraryDescriptor", "namespace"});
            for (IndexResult result : results) {
                if (result.getValue("faceletsLibraryDescriptor") == null) continue;
                return result.getFile();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return null;
    }
}

