/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.editor.facelets;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.web.jsf.editor.facelets.FaceletsLibraryDescriptor;
import org.netbeans.modules.web.jsf.editor.index.JsfBinaryIndexer;
import org.netbeans.modules.web.jsf.editor.tld.LibraryDescriptorException;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;

public class DefaultFaceletLibraries {
    public static DefaultFaceletLibraries INSTANCE;
    private Collection<FileObject> libraryDescriptorsFiles;
    private Map<String, FaceletsLibraryDescriptor> librariesDescriptors;
    private static Map<String, LibraryInfo> LIBRARY_INFOS;

    public static synchronized DefaultFaceletLibraries getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DefaultFaceletLibraries();
        }
        return INSTANCE;
    }

    public DefaultFaceletLibraries() {
        this.init();
    }

    private void init() {
        File jsfImplJar = InstalledFileLocator.getDefault().locate("modules/ext/jsf-2_0/jsf-impl.jar", "org.netbeans.modules.web.jsf20", false);
        assert (jsfImplJar != null);
        FileObject jsfImplJarFo = FileUtil.getArchiveRoot((FileObject)FileUtil.toFileObject((File)jsfImplJar));
        this.libraryDescriptorsFiles = JsfBinaryIndexer.findLibraryDescriptors(jsfImplJarFo, ".taglib.xml");
    }

    public Collection<FileObject> getLibrariesDescriptorsFiles() {
        return this.libraryDescriptorsFiles;
    }

    public synchronized Map<String, FaceletsLibraryDescriptor> getLibrariesDescriptors() {
        if (this.librariesDescriptors == null) {
            this.librariesDescriptors = new HashMap<String, FaceletsLibraryDescriptor>();
            this.parseLibraries();
        }
        return this.librariesDescriptors;
    }

    private void parseLibraries() {
        for (FileObject lfo : this.getLibrariesDescriptorsFiles()) {
            try {
                FaceletsLibraryDescriptor descritor = FaceletsLibraryDescriptor.create(lfo);
                this.librariesDescriptors.put(descritor.getURI(), descritor);
            }
            catch (LibraryDescriptorException ex) {
                Logger.global.log(Level.WARNING, "Error parsing facelets library " + FileUtil.getFileDisplayName((FileObject)lfo) + " in jsf-impl.jar from bundled web.jsf20 library", ex);
            }
        }
    }

    private static synchronized LibraryInfo getLibraryInfo(String libraryUri) {
        if (LIBRARY_INFOS == null) {
            LIBRARY_INFOS = new HashMap<String, LibraryInfo>();
            LIBRARY_INFOS.put("http://java.sun.com/jsf/facelets", new LibraryInfo("Facelets", "ui"));
            LIBRARY_INFOS.put("http://mojarra.dev.java.net/mojarra_ext", new LibraryInfo("Mojarra Extensions", "mj"));
            LIBRARY_INFOS.put("http://java.sun.com/jsf/composite", new LibraryInfo("Composite Components", "cc"));
            LIBRARY_INFOS.put("http://java.sun.com/jsf/html", new LibraryInfo("Html Basic", "h"));
            LIBRARY_INFOS.put("http://java.sun.com/jsf/core", new LibraryInfo("Jsf Core", "f"));
            LIBRARY_INFOS.put("http://java.sun.com/jsp/jstl/core", new LibraryInfo("Jstl Core", "c"));
        }
        return LIBRARY_INFOS.get(libraryUri);
    }

    public static String getLibraryDisplayName(String uri) {
        LibraryInfo li = DefaultFaceletLibraries.getLibraryInfo(uri);
        return li != null ? li.getDisplayName() : null;
    }

    public static String getLibraryDefaultPrefix(String uri) {
        LibraryInfo li = DefaultFaceletLibraries.getLibraryInfo(uri);
        return li != null ? li.getDefaultPrefix() : null;
    }

    private static class LibraryInfo {
        public String displayName;
        public String defaultPrefix;

        public LibraryInfo(String displayName, String defaultPrefix) {
            this.displayName = displayName;
            this.defaultPrefix = defaultPrefix;
        }

        public String getDefaultPrefix() {
            return this.defaultPrefix;
        }

        public String getDisplayName() {
            return this.displayName;
        }
    }
}

