/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.nb.ast;

import java.util.List;
import org.jruby.nb.Ruby;
import org.jruby.nb.ast.AssignableNode;
import org.jruby.nb.ast.Colon2Node;
import org.jruby.nb.ast.Node;
import org.jruby.nb.ast.NodeType;
import org.jruby.nb.ast.types.INameNode;
import org.jruby.nb.ast.visitor.NodeVisitor;
import org.jruby.nb.evaluator.Instruction;
import org.jruby.nb.lexer.yacc.ISourcePosition;
import org.jruby.nb.runtime.Block;
import org.jruby.nb.runtime.ThreadContext;
import org.jruby.nb.runtime.builtin.IRubyObject;

public class ConstDeclNode
extends AssignableNode
implements INameNode {
    private final String name;
    private final INameNode constNode;

    public ConstDeclNode(ISourcePosition position, String name, INameNode constNode, Node valueNode) {
        super(position, NodeType.CONSTDECLNODE, valueNode);
        this.name = name;
        this.constNode = constNode;
    }

    @Override
    public Instruction accept(NodeVisitor iVisitor) {
        return iVisitor.visitConstDeclNode(this);
    }

    @Override
    public String getName() {
        return this.name == null ? this.constNode.getName() : this.name;
    }

    public Node getConstNode() {
        return (Node)((Object)this.constNode);
    }

    @Override
    public List<Node> childNodes() {
        return ConstDeclNode.createList(this.getValueNode());
    }

    @Override
    public IRubyObject interpret(Ruby runtime, ThreadContext context, IRubyObject self, Block aBlock) {
        IRubyObject result = this.getValueNode().interpret(runtime, context, self, aBlock);
        if (this.constNode == null) {
            return context.setConstantInCurrent(this.name, result);
        }
        if (((Node)((Object)this.constNode)).nodeId == NodeType.COLON2NODE) {
            Node leftNode = ((Colon2Node)this.constNode).getLeftNode();
            assert (leftNode != null) : "leftNode is not null";
            IRubyObject obj = leftNode.interpret(runtime, context, self, aBlock);
            return context.setConstantInModule(this.constNode.getName(), obj, result);
        }
        return context.setConstantInObject(this.constNode.getName(), result);
    }

    @Override
    public IRubyObject assign(Ruby runtime, ThreadContext context, IRubyObject self, IRubyObject value, Block block, boolean checkArity) {
        IRubyObject module;
        if (this.constNode == null) {
            module = context.getCurrentScope().getStaticScope().getModule();
            if (module == null) {
                throw runtime.newTypeError("no class/module to define constant");
            }
        } else {
            Node leftNode;
            module = this.constNode instanceof Colon2Node ? ((leftNode = ((Colon2Node)this.constNode).getLeftNode()) == null ? runtime.getNil() : leftNode.interpret(runtime, context, self, block)) : runtime.getObject();
        }
        module.fastSetConstant(this.getName(), value);
        return runtime.getNil();
    }
}

